/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import libcore.util.Cleaner;
import libcore.util.NativeAllocationRegistry;

public class NativeAllocationRegistry_Delegate {
    private static final DelegateManager<NativeAllocationRegistry_Delegate> sManager = new DelegateManager<NativeAllocationRegistry_Delegate>(NativeAllocationRegistry_Delegate.class);
    private final FreeFunction mFinalizer;

    private NativeAllocationRegistry_Delegate(FreeFunction finalizer) {
        this.mFinalizer = finalizer;
    }

    public static long createFinalizer(FreeFunction finalizer) {
        return sManager.addNewDelegate(new NativeAllocationRegistry_Delegate(finalizer));
    }

    @LayoutlibDelegate
    static void registerNativeAllocation(long size) {
        NativeAllocationRegistry.registerNativeAllocation_Original(size);
    }

    @LayoutlibDelegate
    static Runnable registerNativeAllocation(NativeAllocationRegistry registry, Object referent, long nativePtr) {
        NativeAllocationRegistry.CleanerRunner result;
        NativeAllocationRegistry.CleanerThunk thunk;
        sManager.markAsNativeAllocation(referent, nativePtr);
        if (referent == null) {
            throw new IllegalArgumentException("referent is null");
        }
        if (nativePtr == 0L) {
            throw new IllegalArgumentException("nativePtr is null");
        }
        try {
            thunk = registry.new NativeAllocationRegistry.CleanerThunk();
            Cleaner cleaner = Cleaner.create(referent, thunk);
            result = new NativeAllocationRegistry.CleanerRunner(cleaner);
            NativeAllocationRegistry_Delegate.registerNativeAllocation(registry.size);
        }
        catch (VirtualMachineError vme) {
            NativeAllocationRegistry_Delegate.applyFreeFunction(registry.freeFunction, nativePtr);
            throw vme;
        }
        thunk.setNativePtr(nativePtr);
        return result;
    }

    @LayoutlibDelegate
    static void applyFreeFunction(long freeFunction, long nativePtr) {
        try {
            NativeAllocationRegistry_Delegate delegate = sManager.getDelegate(freeFunction);
            if (delegate != null) {
                delegate.mFinalizer.free(nativePtr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface FreeFunction {
        public void free(long var1);
    }
}

