/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

public abstract class Cleaner {
    public static Cleaner create(Object obj, Runnable action) {
        return CleanerFactoryInstance.INST.create(obj, action);
    }

    public abstract void clean();

    private static class CleanerFactoryInstance {
        private static final CleanerFactory INST;

        private CleanerFactoryInstance() {
        }

        private static boolean hasSunMiscCleaner() {
            try {
                Class.forName("sun.misc.Cleaner");
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        static {
            try {
                INST = CleanerFactoryInstance.hasSunMiscCleaner() ? (CleanerFactory)Class.forName("libcore.util.CleanerFactoryJava8").newInstance() : (CleanerFactory)Class.forName("libcore.util.CleanerFactoryJava9").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("No implementation found for libcore.util.Cleaner");
            }
        }
    }

    public static interface CleanerFactory {
        public Cleaner create(Object var1, Runnable var2);
    }
}

