/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.textclassifier;

import com.android.tools.layoutlib.create.OverrideMethod;
import com.google.android.textclassifier.NamedVariant;
import com.google.android.textclassifier.RemoteActionTemplate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public class AnnotatorModel
implements AutoCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    static final String TYPE_UNKNOWN = "";
    static final String TYPE_OTHER = "other";
    static final String TYPE_EMAIL = "email";
    static final String TYPE_PHONE = "phone";
    static final String TYPE_ADDRESS = "address";
    static final String TYPE_URL = "url";
    static final String TYPE_DATE = "date";
    static final String TYPE_DATE_TIME = "datetime";
    static final String TYPE_FLIGHT_NUMBER = "flight";
    private long annotatorPtr;

    public AnnotatorModel(int fileDescriptor) {
        this.annotatorPtr = AnnotatorModel.nativeNewAnnotator(fileDescriptor);
        if (this.annotatorPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize TC from file descriptor.");
        }
    }

    public AnnotatorModel(String path) {
        this.annotatorPtr = AnnotatorModel.nativeNewAnnotatorFromPath(path);
        if (this.annotatorPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize TC from given file.");
        }
    }

    public void initializeKnowledgeEngine(byte[] serializedConfig) {
        if (!this.nativeInitializeKnowledgeEngine(this.annotatorPtr, serializedConfig)) {
            throw new IllegalArgumentException("Couldn't initialize the KG engine");
        }
    }

    public void initializeContactEngine(byte[] serializedConfig) {
        if (!this.nativeInitializeContactEngine(this.annotatorPtr, serializedConfig)) {
            throw new IllegalArgumentException("Couldn't initialize the contact engine");
        }
    }

    public void initializeInstalledAppEngine(byte[] serializedConfig) {
        if (!this.nativeInitializeInstalledAppEngine(this.annotatorPtr, serializedConfig)) {
            throw new IllegalArgumentException("Couldn't initialize the installed app engine");
        }
    }

    public int[] suggestSelection(String context, int selectionBegin, int selectionEnd, SelectionOptions options) {
        return this.nativeSuggestSelection(this.annotatorPtr, context, selectionBegin, selectionEnd, options);
    }

    public ClassificationResult[] classifyText(String context, int selectionBegin, int selectionEnd, ClassificationOptions options) {
        return this.classifyText(context, selectionBegin, selectionEnd, options, null, null);
    }

    public ClassificationResult[] classifyText(String context, int selectionBegin, int selectionEnd, ClassificationOptions options, Object appContext, String deviceLocales) {
        return this.nativeClassifyText(this.annotatorPtr, context, selectionBegin, selectionEnd, options, appContext, deviceLocales);
    }

    public AnnotatedSpan[] annotate(String text, AnnotationOptions options) {
        return this.nativeAnnotate(this.annotatorPtr, text, options);
    }

    public byte[] lookUpKnowledgeEntity(String id2) {
        return this.nativeLookUpKnowledgeEntity(this.annotatorPtr, id2);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.nativeCloseAnnotator(this.annotatorPtr);
            this.annotatorPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static String getLocales(int fd) {
        return AnnotatorModel.nativeGetLocales(fd);
    }

    public static int getVersion(int fd) {
        return AnnotatorModel.nativeGetVersion(fd);
    }

    public static String getName(int fd) {
        return AnnotatorModel.nativeGetName(fd);
    }

    long getNativeAnnotator() {
        return this.nativeGetNativeModelPtr(this.annotatorPtr);
    }

    private static long nativeNewAnnotator(int n) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.AnnotatorModel#nativeNewAnnotator(I)J", true, null);
    }

    private static long nativeNewAnnotatorFromPath(String string2) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.AnnotatorModel#nativeNewAnnotatorFromPath(Ljava/lang/String;)J", true, null);
    }

    private static String nativeGetLocales(int n) {
        return (String)OverrideMethod.invokeA("com.google.android.textclassifier.AnnotatorModel#nativeGetLocales(I)Ljava/lang/String;", true, null);
    }

    private static int nativeGetVersion(int n) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.AnnotatorModel#nativeGetVersion(I)I", true, null);
    }

    private static String nativeGetName(int n) {
        return (String)OverrideMethod.invokeA("com.google.android.textclassifier.AnnotatorModel#nativeGetName(I)Ljava/lang/String;", true, null);
    }

    private long nativeGetNativeModelPtr(long l) {
        return OverrideMethod.invokeL("com.google.android.textclassifier.AnnotatorModel#nativeGetNativeModelPtr(J)J", true, this);
    }

    private boolean nativeInitializeKnowledgeEngine(long l, byte[] byArray) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.AnnotatorModel#nativeInitializeKnowledgeEngine(J[B)Z", true, this) != 0;
    }

    private boolean nativeInitializeContactEngine(long l, byte[] byArray) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.AnnotatorModel#nativeInitializeContactEngine(J[B)Z", true, this) != 0;
    }

    private boolean nativeInitializeInstalledAppEngine(long l, byte[] byArray) {
        return OverrideMethod.invokeI("com.google.android.textclassifier.AnnotatorModel#nativeInitializeInstalledAppEngine(J[B)Z", true, this) != 0;
    }

    private int[] nativeSuggestSelection(long l, String string2, int n, int n2, SelectionOptions selectionOptions) {
        return (int[])OverrideMethod.invokeA("com.google.android.textclassifier.AnnotatorModel#nativeSuggestSelection(JLjava/lang/String;IILcom/google/android/textclassifier/AnnotatorModel$SelectionOptions;)[I", true, this);
    }

    private ClassificationResult[] nativeClassifyText(long l, String string2, int n, int n2, ClassificationOptions classificationOptions, Object object, String string3) {
        return (ClassificationResult[])OverrideMethod.invokeA("com.google.android.textclassifier.AnnotatorModel#nativeClassifyText(JLjava/lang/String;IILcom/google/android/textclassifier/AnnotatorModel$ClassificationOptions;Ljava/lang/Object;Ljava/lang/String;)[Lcom/google/android/textclassifier/AnnotatorModel$ClassificationResult;", true, this);
    }

    private AnnotatedSpan[] nativeAnnotate(long l, String string2, AnnotationOptions annotationOptions) {
        return (AnnotatedSpan[])OverrideMethod.invokeA("com.google.android.textclassifier.AnnotatorModel#nativeAnnotate(JLjava/lang/String;Lcom/google/android/textclassifier/AnnotatorModel$AnnotationOptions;)[Lcom/google/android/textclassifier/AnnotatorModel$AnnotatedSpan;", true, this);
    }

    private byte[] nativeLookUpKnowledgeEntity(long l, String string2) {
        return (byte[])OverrideMethod.invokeA("com.google.android.textclassifier.AnnotatorModel#nativeLookUpKnowledgeEntity(JLjava/lang/String;)[B", true, this);
    }

    private void nativeCloseAnnotator(long l) {
        OverrideMethod.invokeV("com.google.android.textclassifier.AnnotatorModel#nativeCloseAnnotator(J)V", true, this);
    }

    static {
        System.loadLibrary("textclassifier");
    }

    public static class AnnotationOptions {
        private final long referenceTimeMsUtc;
        private final String referenceTimezone;
        private final String locales;
        private final String detectedTextLanguageTags;
        private final String[] entityTypes;
        private final int annotationUsecase;
        private final boolean isSerializedEntityDataEnabled;

        public AnnotationOptions(long referenceTimeMsUtc, String referenceTimezone, String locales, String detectedTextLanguageTags, Collection<String> entityTypes, int annotationUsecase, boolean isSerializedEntityDataEnabled) {
            this.referenceTimeMsUtc = referenceTimeMsUtc;
            this.referenceTimezone = referenceTimezone;
            this.locales = locales;
            this.detectedTextLanguageTags = detectedTextLanguageTags;
            this.entityTypes = entityTypes == null ? new String[]{} : entityTypes.toArray(new String[0]);
            this.annotationUsecase = annotationUsecase;
            this.isSerializedEntityDataEnabled = isSerializedEntityDataEnabled;
        }

        public AnnotationOptions(long referenceTimeMsUtc, String referenceTimezone, String locales, String detectedTextLanguageTags) {
            this(referenceTimeMsUtc, referenceTimezone, locales, detectedTextLanguageTags, null, AnnotationUsecase.SMART.getValue(), false);
        }

        public long getReferenceTimeMsUtc() {
            return this.referenceTimeMsUtc;
        }

        public String getReferenceTimezone() {
            return this.referenceTimezone;
        }

        public String getLocale() {
            return this.locales;
        }

        public String getDetectedTextLanguageTags() {
            return this.detectedTextLanguageTags;
        }

        public String[] getEntityTypes() {
            return this.entityTypes;
        }

        public int getAnnotationUsecase() {
            return this.annotationUsecase;
        }

        public boolean isSerializedEntityDataEnabled() {
            return this.isSerializedEntityDataEnabled;
        }
    }

    public static class ClassificationOptions {
        private final long referenceTimeMsUtc;
        private final String referenceTimezone;
        private final String locales;
        private final String detectedTextLanguageTags;
        private final int annotationUsecase;

        public ClassificationOptions(long referenceTimeMsUtc, String referenceTimezone, String locales, String detectedTextLanguageTags, int annotationUsecase) {
            this.referenceTimeMsUtc = referenceTimeMsUtc;
            this.referenceTimezone = referenceTimezone;
            this.locales = locales;
            this.detectedTextLanguageTags = detectedTextLanguageTags;
            this.annotationUsecase = annotationUsecase;
        }

        public ClassificationOptions(long referenceTimeMsUtc, String referenceTimezone, String locales, String detectedTextLanguageTags) {
            this(referenceTimeMsUtc, referenceTimezone, locales, detectedTextLanguageTags, AnnotationUsecase.SMART.getValue());
        }

        public long getReferenceTimeMsUtc() {
            return this.referenceTimeMsUtc;
        }

        public String getReferenceTimezone() {
            return this.referenceTimezone;
        }

        public String getLocale() {
            return this.locales;
        }

        public String getDetectedTextLanguageTags() {
            return this.detectedTextLanguageTags;
        }

        public int getAnnotationUsecase() {
            return this.annotationUsecase;
        }
    }

    public static class SelectionOptions {
        private final String locales;
        private final String detectedTextLanguageTags;
        private final int annotationUsecase;

        public SelectionOptions(String locales, String detectedTextLanguageTags, int annotationUsecase) {
            this.locales = locales;
            this.detectedTextLanguageTags = detectedTextLanguageTags;
            this.annotationUsecase = annotationUsecase;
        }

        public SelectionOptions(String locales, String detectedTextLanguageTags) {
            this(locales, detectedTextLanguageTags, AnnotationUsecase.SMART.getValue());
        }

        public String getLocales() {
            return this.locales;
        }

        public String getDetectedTextLanguageTags() {
            return this.detectedTextLanguageTags;
        }

        public int getAnnotationUsecase() {
            return this.annotationUsecase;
        }
    }

    public static class AnnotatedSpan {
        private final int startIndex;
        private final int endIndex;
        private final ClassificationResult[] classification;

        AnnotatedSpan(int startIndex, int endIndex, ClassificationResult[] classification) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.classification = classification;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public ClassificationResult[] getClassification() {
            return this.classification;
        }
    }

    public static class ClassificationResult {
        private final String collection;
        private final float score;
        private final DatetimeResult datetimeResult;
        private final byte[] serializedKnowledgeResult;
        private final String contactName;
        private final String contactGivenName;
        private final String contactNickname;
        private final String contactEmailAddress;
        private final String contactPhoneNumber;
        private final String contactId;
        private final String appName;
        private final String appPackageName;
        private final NamedVariant[] entityData;
        private final byte[] serializedEntityData;
        private final RemoteActionTemplate[] remoteActionTemplates;
        private final long durationMs;
        private final long numericValue;

        public ClassificationResult(String collection, float score, DatetimeResult datetimeResult, byte[] serializedKnowledgeResult, String contactName, String contactGivenName, String contactNickname, String contactEmailAddress, String contactPhoneNumber, String contactId, String appName, String appPackageName, NamedVariant[] entityData, byte[] serializedEntityData, RemoteActionTemplate[] remoteActionTemplates, long durationMs, long numericValue) {
            this.collection = collection;
            this.score = score;
            this.datetimeResult = datetimeResult;
            this.serializedKnowledgeResult = serializedKnowledgeResult;
            this.contactName = contactName;
            this.contactGivenName = contactGivenName;
            this.contactNickname = contactNickname;
            this.contactEmailAddress = contactEmailAddress;
            this.contactPhoneNumber = contactPhoneNumber;
            this.contactId = contactId;
            this.appName = appName;
            this.appPackageName = appPackageName;
            this.entityData = entityData;
            this.serializedEntityData = serializedEntityData;
            this.remoteActionTemplates = remoteActionTemplates;
            this.durationMs = durationMs;
            this.numericValue = numericValue;
        }

        public String getCollection() {
            return this.collection;
        }

        public float getScore() {
            return this.score;
        }

        public DatetimeResult getDatetimeResult() {
            return this.datetimeResult;
        }

        public byte[] getSerializedKnowledgeResult() {
            return this.serializedKnowledgeResult;
        }

        public String getContactName() {
            return this.contactName;
        }

        public String getContactGivenName() {
            return this.contactGivenName;
        }

        public String getContactNickname() {
            return this.contactNickname;
        }

        public String getContactEmailAddress() {
            return this.contactEmailAddress;
        }

        public String getContactPhoneNumber() {
            return this.contactPhoneNumber;
        }

        public String getContactId() {
            return this.contactId;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getAppPackageName() {
            return this.appPackageName;
        }

        public NamedVariant[] getEntityData() {
            return this.entityData;
        }

        public byte[] getSerializedEntityData() {
            return this.serializedEntityData;
        }

        public RemoteActionTemplate[] getRemoteActionTemplates() {
            return this.remoteActionTemplates;
        }

        public long getDurationMs() {
            return this.durationMs;
        }

        public long getNumericValue() {
            return this.numericValue;
        }
    }

    public static class DatetimeResult {
        public static final int GRANULARITY_YEAR = 0;
        public static final int GRANULARITY_MONTH = 1;
        public static final int GRANULARITY_WEEK = 2;
        public static final int GRANULARITY_DAY = 3;
        public static final int GRANULARITY_HOUR = 4;
        public static final int GRANULARITY_MINUTE = 5;
        public static final int GRANULARITY_SECOND = 6;
        private final long timeMsUtc;
        private final int granularity;

        public DatetimeResult(long timeMsUtc, int granularity) {
            this.timeMsUtc = timeMsUtc;
            this.granularity = granularity;
        }

        public long getTimeMsUtc() {
            return this.timeMsUtc;
        }

        public int getGranularity() {
            return this.granularity;
        }
    }

    public static enum AnnotationUsecase {
        SMART(0),
        RAW(1);

        private final int value;

        private AnnotationUsecase(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

