/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.res.BridgeAssetManager;
import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.ComplexColor_Accessor;
import android.content.res.GradientColor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.NinePatch_Delegate;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Typeface_Accessor;
import android.graphics.Typeface_Delegate;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.util.TypedValue;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.ninepatch.NinePatch;
import com.android.ninepatch.NinePatchChunk;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourceHelper {
    private static final BridgeContext.Key<Set<ResourceValue>> KEY_GET_DRAWABLE = BridgeContext.Key.create("ResourceHelper.getDrawable");
    private static final Pattern sFloatPattern = Pattern.compile("(-?[0-9]+(?:\\.[0-9]+)?)(.*)");
    private static final float[] sFloatOut = new float[1];
    private static final TypedValue mValue = new TypedValue();
    private static final UnitEntry[] sUnitNames = new UnitEntry[]{new UnitEntry("px", 5, 0, 1.0f), new UnitEntry("dip", 5, 1, 1.0f), new UnitEntry("dp", 5, 1, 1.0f), new UnitEntry("sp", 5, 2, 1.0f), new UnitEntry("pt", 5, 3, 1.0f), new UnitEntry("in", 5, 4, 1.0f), new UnitEntry("mm", 5, 5, 1.0f), new UnitEntry("%", 6, 0, 0.01f), new UnitEntry("%p", 6, 1, 0.01f)};

    public static int getColor(String value) {
        if (value == null) {
            throw new NumberFormatException("null value");
        }
        int len = (value = value.trim()).length();
        if (len < 2 || len > 9) {
            throw new NumberFormatException(String.format("Color value '%s' has wrong size. Format is either#AARRGGBB, #RRGGBB, #RGB, or #ARGB", value));
        }
        if (value.charAt(0) != '#') {
            if (value.startsWith("?")) {
                throw new NumberFormatException(String.format("Attribute '%s' not found. Are you using the right theme?", value));
            }
            throw new NumberFormatException(String.format("Color value '%s' must start with #", value));
        }
        value = value.substring(1);
        if (len == 4) {
            char[] color2 = new char[8];
            color2[1] = 70;
            color2[0] = 70;
            color2[2] = color2[3] = value.charAt(0);
            color2[4] = color2[5] = value.charAt(1);
            color2[6] = color2[7] = value.charAt(2);
            value = new String(color2);
        } else if (len == 5) {
            char[] color3 = new char[8];
            color3[0] = color3[1] = value.charAt(0);
            color3[2] = color3[3] = value.charAt(1);
            color3[4] = color3[5] = value.charAt(2);
            color3[6] = color3[7] = value.charAt(3);
            value = new String(color3);
        } else if (len == 7) {
            value = "FF" + value;
        }
        return (int)Long.parseLong(value, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ComplexColor getInternalComplexColor(ResourceValue resValue, BridgeContext context, Resources.Theme theme, boolean allowGradients) {
        String value = resValue.getValue();
        if (value == null) return null;
        if ("@null".equals(value)) {
            return null;
        }
        try {
            int color2 = ResourceHelper.getColor(value);
            return ColorStateList.valueOf(color2);
        }
        catch (NumberFormatException color2) {
            try {
                BridgeXmlBlockParser blockParser = ResourceHelper.getXmlBlockParser(context, resValue);
                if (blockParser == null) return null;
                try {
                    int type;
                    while ((type = blockParser.next()) != 2 && type != 1) {
                    }
                    if (type != 2) {
                        assert (false) : "No start tag found";
                        ComplexColor complexColor = null;
                        return complexColor;
                    }
                    String name = blockParser.getName();
                    if (allowGradients && "gradient".equals(name)) {
                        GradientColor gradientColor = ComplexColor_Accessor.createGradientColorFromXmlInner(context.getResources(), blockParser, blockParser, theme);
                        return gradientColor;
                    }
                    if (!"selector".equals(name)) return null;
                    ColorStateList colorStateList = ComplexColor_Accessor.createColorStateListFromXmlInner(context.getResources(), blockParser, blockParser, theme);
                    return colorStateList;
                }
                finally {
                    blockParser.ensurePopped();
                }
            }
            catch (XmlPullParserException e) {
                Bridge.getLog().error("broken", "Failed to configure parser for " + value, (Throwable)e, null);
                return null;
            }
            catch (Exception e) {
                Bridge.getLog().error("resources.read", "Failed to parse file " + value, (Throwable)e, null);
                return null;
            }
        }
    }

    public static ColorStateList getColorStateList(ResourceValue resValue, BridgeContext context, Resources.Theme theme) {
        return (ColorStateList)ResourceHelper.getInternalComplexColor(resValue, context, theme != null ? theme : context.getTheme(), false);
    }

    public static ComplexColor getComplexColor(ResourceValue resValue, BridgeContext context, Resources.Theme theme) {
        return ResourceHelper.getInternalComplexColor(resValue, context, theme != null ? theme : context.getTheme(), true);
    }

    public static Drawable getDrawable(ResourceValue value, BridgeContext context) {
        return ResourceHelper.getDrawable(value, context, null);
    }

    public static BridgeXmlBlockParser getXmlBlockParser(BridgeContext context, ResourceValue value) throws XmlPullParserException {
        ResourceNamespace namespace;
        String stringValue = value.getValue();
        if ("@null".equals(stringValue)) {
            return null;
        }
        ILayoutPullParser parser = null;
        LayoutlibCallback layoutlibCallback = context.getLayoutlibCallback();
        if (!value.isFramework()) {
            parser = layoutlibCallback.getParser(value);
        }
        if (parser != null) {
            namespace = parser.getLayoutNamespace();
        } else {
            parser = ParserFactory.create(stringValue);
            namespace = value.getNamespace();
        }
        return parser == null ? null : new BridgeXmlBlockParser((XmlPullParser)parser, context, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(ResourceValue value, BridgeContext context, Resources.Theme theme) {
        if (value == null) {
            return null;
        }
        String stringValue = value.getValue();
        if ("@null".equals(stringValue)) {
            return null;
        }
        String lowerCaseValue = stringValue.toLowerCase();
        try {
            int color2 = ResourceHelper.getColor(stringValue);
            return new ColorDrawable(color2);
        }
        catch (NumberFormatException color2) {
            Density density = Density.MEDIUM;
            if (value instanceof DensityBasedResourceValue && ((density = ((DensityBasedResourceValue)value).getResourceDensity()) == Density.NODPI || density == Density.ANYDPI)) {
                density = Density.getEnum((int)context.getConfiguration().densityDpi);
            }
            if (lowerCaseValue.endsWith(".9.png")) {
                try {
                    return ResourceHelper.getNinePatchDrawable(density, value.isFramework(), stringValue, context);
                }
                catch (IOException e) {
                    Bridge.getLog().error("resources.read", "Failed to load " + stringValue, (Throwable)e, null);
                    return null;
                }
            }
            if (lowerCaseValue.endsWith(".xml") || value.getResourceType() == ResourceType.AAPT) {
                block22: {
                    Drawable drawable2;
                    BridgeXmlBlockParser blockParser = ResourceHelper.getXmlBlockParser(context, value);
                    if (blockParser == null) break block22;
                    Set<ResourceValue> visitedValues = context.getUserData(KEY_GET_DRAWABLE);
                    if (visitedValues == null) {
                        visitedValues = new HashSet<ResourceValue>();
                        context.putUserData(KEY_GET_DRAWABLE, visitedValues);
                    }
                    if (!visitedValues.add(value)) {
                        Bridge.getLog().error(null, "Cyclic dependency in " + stringValue, null);
                        return null;
                    }
                    try {
                        drawable2 = Drawable.createFromXml(context.getResources(), blockParser, theme);
                        visitedValues.remove(value);
                    }
                    catch (Throwable throwable) {
                        try {
                            visitedValues.remove(value);
                            blockParser.ensurePopped();
                            throw throwable;
                        }
                        catch (Exception e) {
                            Bridge.getLog().error(null, "Failed to parse file " + stringValue, (Throwable)e, null);
                        }
                    }
                    blockParser.ensurePopped();
                    return drawable2;
                }
                return null;
            }
            AssetRepository repository = ResourceHelper.getAssetRepository(context);
            if (repository.isFileResource(stringValue)) {
                try {
                    Bitmap bitmap = Bridge.getCachedBitmap(stringValue, value.isFramework() ? null : context.getProjectKey());
                    if (bitmap == null) {
                        InputStream stream;
                        try {
                            stream = repository.openNonAsset(0, stringValue, 2);
                        }
                        catch (FileNotFoundException e) {
                            stream = null;
                        }
                        bitmap = Bitmap_Delegate.createBitmap(stream, false, density);
                        Bridge.setCachedBitmap(stringValue, bitmap, value.isFramework() ? null : context.getProjectKey());
                    }
                    return new BitmapDrawable(context.getResources(), bitmap);
                }
                catch (IOException e) {
                    Bridge.getLog().error("resources.read", "Failed to load " + stringValue, (Throwable)e, null);
                }
            }
            return null;
        }
    }

    private static AssetRepository getAssetRepository(BridgeContext context) {
        BridgeAssetManager assetManager = context.getAssets();
        return assetManager.getAssetRepository();
    }

    public static Typeface getFont(String fontName, BridgeContext context, Resources.Theme theme, boolean isFramework) {
        if (fontName == null) {
            return null;
        }
        if (Typeface_Accessor.isSystemFont(fontName)) {
            return null;
        }
        return Typeface_Delegate.createFromDisk(context, fontName, isFramework);
    }

    public static Typeface getFont(ResourceValue value, BridgeContext context, Resources.Theme theme) {
        if (value == null) {
            return null;
        }
        return ResourceHelper.getFont(value.getValue(), context, theme, value.isFramework());
    }

    private static Drawable getNinePatchDrawable(Density density, boolean isFramework, String path, BridgeContext context) throws IOException {
        NinePatchChunk chunk = Bridge.getCached9Patch(path, isFramework ? null : context.getProjectKey());
        Bitmap bitmap = Bridge.getCachedBitmap(path, isFramework ? null : context.getProjectKey());
        if (chunk == null || bitmap == null) {
            try {
                AssetRepository repository = ResourceHelper.getAssetRepository(context);
                if (!repository.isFileResource(path)) {
                    return null;
                }
                InputStream stream = repository.openNonAsset(0, path, 2);
                NinePatch ninePatch = NinePatch.load(stream, true, false);
                if (ninePatch != null) {
                    if (chunk == null) {
                        chunk = ninePatch.getChunk();
                        Bridge.setCached9Patch(path, chunk, isFramework ? null : context.getProjectKey());
                    }
                    if (bitmap == null) {
                        bitmap = Bitmap_Delegate.createBitmap(ninePatch.getImage(), false, density);
                        Bridge.setCachedBitmap(path, bitmap, isFramework ? null : context.getProjectKey());
                    }
                }
            }
            catch (MalformedURLException repository) {
                // empty catch block
            }
        }
        if (chunk != null && bitmap != null) {
            int[] padding = chunk.getPadding();
            Rect paddingRect = new Rect(padding[0], padding[1], padding[2], padding[3]);
            return new NinePatchDrawable(context.getResources(), bitmap, NinePatch_Delegate.serialize(chunk), paddingRect, null);
        }
        return null;
    }

    public static boolean getBooleanThemeValue(RenderResources resources, ResourceReference attr2, boolean defaultValue) {
        ResourceValue value = resources.findItemInTheme(attr2);
        if ((value = resources.resolveResValue(value)) == null) {
            return defaultValue;
        }
        return XmlUtils.convertValueToBoolean(value.getValue(), defaultValue);
    }

    public static boolean getBooleanThemeFrameworkAttrValue(RenderResources resources, String name, boolean defaultValue) {
        ResourceReference attrRef = BridgeContext.createFrameworkAttrReference(name);
        return ResourceHelper.getBooleanThemeValue(resources, attrRef, defaultValue);
    }

    public static TypedValue getValue(String attribute, String value, boolean requireUnit) {
        if (ResourceHelper.parseFloatAttribute(attribute, value, mValue, requireUnit)) {
            return mValue;
        }
        return null;
    }

    public static boolean parseFloatAttribute(String attribute, String value, TypedValue outValue, boolean requireUnit) {
        assert (!requireUnit || attribute != null);
        int len = (value = value.trim()).length();
        if (len <= 0) {
            return false;
        }
        char[] buf = value.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= '\u00ff') continue;
            return false;
        }
        if ((buf[0] < '0' || buf[0] > '9') && buf[0] != '.' && buf[0] != '-' && buf[0] != '+') {
            return false;
        }
        Matcher m = sFloatPattern.matcher(value);
        if (m.matches()) {
            float f;
            String f_str = m.group(1);
            String end = m.group(2);
            try {
                f = Float.parseFloat(f_str);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (end.length() > 0 && end.charAt(0) != ' ') {
                if (ResourceHelper.parseUnit(end, outValue, sFloatOut)) {
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    return true;
                }
                return false;
            }
            if ((end = end.trim()).length() == 0 && outValue != null) {
                if (!requireUnit) {
                    outValue.type = 4;
                    outValue.data = Float.floatToIntBits(f);
                } else {
                    ResourceHelper.applyUnit(sUnitNames[1], outValue, sFloatOut);
                    ResourceHelper.computeTypedValue(outValue, f, sFloatOut[0]);
                    Bridge.getLog().error("resources.resolve", String.format("Dimension \"%1$s\" in attribute \"%2$s\" is missing unit!", value, attribute), null);
                }
                return true;
            }
        }
        return false;
    }

    private static void computeTypedValue(TypedValue outValue, float value, float scale) {
        int shift;
        int radix;
        long bits;
        boolean neg;
        boolean bl = neg = (value *= scale) < 0.0f;
        if (neg) {
            value = -value;
        }
        if (((bits = (long)(value * 8388608.0f + 0.5f)) & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((bits & Integer.MIN_VALUE) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((bits & 0xFFFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(bits >> shift & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        outValue.data |= radix << 4 | mantissa << 8;
    }

    private static boolean parseUnit(String str, TypedValue outValue, float[] outScale) {
        str = str.trim();
        for (UnitEntry unit : sUnitNames) {
            if (!unit.name.equals(str)) continue;
            ResourceHelper.applyUnit(unit, outValue, outScale);
            return true;
        }
        return false;
    }

    private static void applyUnit(UnitEntry unit, TypedValue outValue, float[] outScale) {
        outValue.type = unit.type;
        outValue.data = unit.unit << 0;
        outScale[0] = unit.scale;
    }

    private static final class UnitEntry {
        String name;
        int type;
        int unit;
        float scale;

        UnitEntry(String name, int type, int unit, float scale) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.scale = scale;
        }
    }
}

