/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.ide.common.rendering.api.XmlParserFactory;
import com.android.layoutlib.bridge.impl.LayoutParserWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserFactory {
    public static final boolean LOG_PARSER = false;
    private static XmlParserFactory sParserFactory;

    public static void setParserFactory(XmlParserFactory parserFactory) {
        sParserFactory = parserFactory;
    }

    public static XmlPullParser create(String filePath) throws XmlPullParserException {
        return ParserFactory.create(filePath, false);
    }

    public static XmlPullParser create(String filePath, boolean isLayout) throws XmlPullParserException {
        XmlPullParser parser = sParserFactory.createXmlParserForFile(filePath);
        if (parser != null && isLayout) {
            try {
                return new LayoutParserWrapper(parser).peekTillLayoutStart();
            }
            catch (IOException e) {
                throw new XmlPullParserException(null, parser, (Throwable)e);
            }
        }
        return parser;
    }

    public static XmlPullParser create(InputStream stream, String name) throws XmlPullParserException {
        XmlPullParser parser = ParserFactory.create();
        stream = ParserFactory.readAndClose(stream, name);
        parser.setInput(stream, null);
        return parser;
    }

    public static XmlPullParser create() throws XmlPullParserException {
        if (sParserFactory == null) {
            throw new XmlPullParserException("ParserFactory not initialized.");
        }
        XmlPullParser parser = sParserFactory.createXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream readAndClose(InputStream stream, String name) throws XmlPullParserException {
        try (BufferedInputStream bufferedStream = new BufferedInputStream(stream);){
            int avail = bufferedStream.available();
            byte[] buffer = new byte[avail];
            int read = stream.read(buffer);
            while ((avail = bufferedStream.available()) > 0) {
                if (read + avail > buffer.length) {
                    byte[] moreBuffer = new byte[read + avail];
                    System.arraycopy(buffer, 0, moreBuffer, 0, read);
                    buffer = moreBuffer;
                }
                read += stream.read(buffer, read, avail);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new XmlPullParserException("Failed to read " + name, null, (Throwable)e);
        }
    }
}

