/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.Bitmap_Delegate;
import android.graphics.ColorFilter_Delegate;
import android.graphics.Paint_Delegate;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Region_Delegate;
import android.graphics.Shader_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.PorterDuffUtility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class GcSnapshot {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private final GcSnapshot mPrevious;
    private final int mFlags;
    private final ArrayList<Layer> mLayers = new ArrayList();
    private AffineTransform mTransform = null;
    private Area mClip = null;
    private final Layer mLocalLayer;
    private final Paint_Delegate mLocalLayerPaint;
    private final Rect mLayerBounds;

    public static GcSnapshot createDefaultSnapshot(Bitmap_Delegate bitmap) {
        GcSnapshot snapshot = new GcSnapshot();
        if (bitmap != null) {
            snapshot.setBitmap(bitmap);
        }
        return snapshot;
    }

    public GcSnapshot save(int flags) {
        return new GcSnapshot(this, null, null, flags);
    }

    public GcSnapshot saveLayer(RectF layerBounds, Paint_Delegate paint, int flags) {
        return new GcSnapshot(this, layerBounds, paint, flags);
    }

    private GcSnapshot() {
        this.mPrevious = null;
        this.mFlags = 0;
        this.mLocalLayer = null;
        this.mLocalLayerPaint = null;
        this.mLayerBounds = null;
    }

    private GcSnapshot(GcSnapshot previous, RectF layerBounds, Paint_Delegate paint, int flags) {
        assert (previous != null);
        this.mPrevious = previous;
        this.mFlags = flags;
        for (Layer layer : this.mPrevious.mLayers) {
            this.mLayers.add(layer.makeCopy());
        }
        if (layerBounds != null) {
            AffineTransform matrix = this.mLayers.get(0).getGraphics().getTransform();
            RectF rect2 = new RectF();
            this.mapRect(matrix, rect2, layerBounds);
            this.mLayerBounds = new Rect();
            rect2.round(this.mLayerBounds);
            Layer baseLayer = this.mLayers.get(0);
            BufferedImage layerImage = new BufferedImage(baseLayer.getImage().getWidth(), baseLayer.getImage().getHeight(), (this.mFlags & 4) != 0 ? 2 : 1);
            Graphics2D layerGraphics = layerImage.createGraphics();
            AffineTransform currentMtx = baseLayer.getGraphics().getTransform();
            layerGraphics.setTransform(currentMtx);
            this.mLocalLayer = new Layer(layerGraphics, layerImage, flags);
            this.mLayers.add(this.mLocalLayer);
            Shape currentClip = baseLayer.getGraphics().getClip();
            this.mLocalLayer.setClip(currentClip);
            if ((this.mFlags & 0x10) == 0) {
                int w = this.mLayerBounds.width();
                int h = this.mLayerBounds.height();
                for (int i = 0; i < this.mLayers.size() - 1; ++i) {
                    Layer layer = this.mLayers.get(i);
                    BufferedImage image = new BufferedImage(w, h, 2);
                    Graphics2D graphics = image.createGraphics();
                    graphics.drawImage(layer.getImage(), 0, 0, w, h, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, null);
                    graphics.dispose();
                    layer.setOriginalCopy(image);
                }
            }
        } else {
            this.mLocalLayer = null;
            this.mLayerBounds = null;
        }
        this.mLocalLayerPaint = paint;
    }

    public void dispose() {
        for (Layer layer : this.mLayers) {
            layer.getGraphics().dispose();
        }
        if (this.mPrevious != null) {
            this.mPrevious.dispose();
        }
    }

    public GcSnapshot restore() {
        return this.doRestore();
    }

    public GcSnapshot restoreTo(int saveCount) {
        return this.doRestoreTo(this.size(), saveCount);
    }

    public int size() {
        if (this.mPrevious != null) {
            return this.mPrevious.size() + 1;
        }
        return 1;
    }

    public void setBitmap(Bitmap_Delegate bitmap) {
        Graphics2D graphics2D = bitmap.getImage().createGraphics();
        Layer baseLayer = new Layer(graphics2D, bitmap);
        graphics2D.setTransform(this.getTransform());
        this.mTransform = null;
        baseLayer.setClip(this.getClip());
        this.mClip = null;
        this.mLayers.clear();
        this.mLayers.add(baseLayer);
    }

    public void translate(float dx, float dy) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().translate(dx, dy);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.translate(dx, dy);
        }
    }

    public void rotate(double radians) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().rotate(radians);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.rotate(radians);
        }
    }

    public void scale(float sx, float sy) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().scale(sx, sy);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.scale(sx, sy);
        }
    }

    public AffineTransform getTransform() {
        if (this.mLayers.size() > 0) {
            return this.mLayers.get(0).getGraphics().getTransform();
        }
        if (this.mTransform == null) {
            this.mTransform = new AffineTransform();
        }
        return this.mTransform;
    }

    public void setTransform(AffineTransform transform) {
        if (this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.getGraphics().setTransform(transform);
            }
        } else {
            if (this.mTransform == null) {
                this.mTransform = new AffineTransform();
            }
            this.mTransform.setTransform(transform);
        }
    }

    public boolean clip(Shape shape, int regionOp) {
        if (regionOp == Region.Op.INTERSECT.nativeInt && this.mLayers.size() > 0) {
            for (Layer layer : this.mLayers) {
                layer.clip(shape);
            }
            Shape currentClip = this.getClip();
            return currentClip != null && !currentClip.getBounds().isEmpty();
        }
        Area area = null;
        area = regionOp == Region.Op.REPLACE.nativeInt ? new Area(shape) : Region_Delegate.combineShapes(this.getClip(), shape, regionOp);
        if (this.mLayers.size() > 0) {
            Shape currentClip;
            if (area != null) {
                for (Layer layer : this.mLayers) {
                    layer.setClip(area);
                }
            }
            return (currentClip = this.getClip()) != null && !currentClip.getBounds().isEmpty();
        }
        this.mClip = area != null ? area : new Area();
        return !this.mClip.getBounds().isEmpty();
    }

    public boolean clipRect(float left, float top, float right, float bottom, int regionOp) {
        return this.clip(new Rectangle2D.Float(left, top, right - left, bottom - top), regionOp);
    }

    public Shape getClip() {
        if (this.mLayers.size() > 0) {
            return this.mLayers.get(0).getGraphics().getClip();
        }
        return this.mClip;
    }

    private GcSnapshot doRestoreTo(int size, int saveCount) {
        if (size <= saveCount) {
            return this;
        }
        GcSnapshot previous = this.doRestore();
        if (size == saveCount + 1) {
            return previous;
        }
        return previous.doRestoreTo(size - 1, saveCount);
    }

    public void draw(Drawable drawable2) {
        this.draw(drawable2, null, false, false);
    }

    public void draw(Drawable drawable2, Paint_Delegate paint, boolean compositeOnly, boolean forceSrcMode) {
        int forceMode;
        int n = forceMode = forceSrcMode ? 2 : 0;
        if (this.mLayers.size() == 1) {
            this.drawInLayer(this.mLayers.get(0), drawable2, paint, compositeOnly, forceMode);
        } else {
            int flags;
            int i = this.mLayers.size() - 1;
            do {
                Layer layer = this.mLayers.get(i);
                this.drawInLayer(layer, drawable2, paint, compositeOnly, forceMode);
                flags = layer.getFlags();
            } while (--i >= 0 && (flags & 0x10) == 0);
        }
    }

    private static Rectangle transformRect(Rectangle rect, AffineTransform transform) {
        double[] coords = new double[16];
        coords[0] = rect.x;
        coords[1] = rect.y;
        coords[2] = rect.x + rect.width;
        coords[3] = rect.y + rect.height;
        coords[4] = rect.x;
        coords[5] = rect.y + rect.height;
        coords[6] = rect.x + rect.width;
        coords[7] = rect.y;
        transform.transform(coords, 0, coords, 8, 4);
        int x = (int)Math.floor(Math.min(Math.min(coords[8], coords[10]), Math.min(coords[12], coords[14])));
        int y = (int)Math.floor(Math.min(Math.min(coords[9], coords[11]), Math.min(coords[13], coords[15])));
        int w = (int)Math.ceil(Math.max(Math.max(coords[8], coords[10]), Math.max(coords[12], coords[14]))) - x;
        int h = (int)Math.ceil(Math.max(Math.max(coords[9], coords[11]), Math.max(coords[13], coords[15]))) - y;
        return new Rectangle(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawInLayer(Layer layer, Drawable drawable2, Paint_Delegate paint, boolean compositeOnly, int forceMode) {
        Graphics2D originalGraphics = layer.getGraphics();
        if (paint == null) {
            this.drawOnGraphics((Graphics2D)originalGraphics.create(), drawable2, null, layer);
        } else {
            Rectangle imgRect;
            ColorFilter_Delegate filter = paint.getColorFilter();
            if (filter == null || !filter.isSupported()) {
                Graphics2D configuredGraphics = this.createCustomGraphics(originalGraphics, paint, compositeOnly, forceMode);
                this.drawOnGraphics(configuredGraphics, drawable2, paint, layer);
                return;
            }
            Rectangle clipBounds = originalGraphics.getClip() != null ? originalGraphics.getClipBounds() : null;
            AffineTransform transform = originalGraphics.getTransform();
            if (clipBounds != null) {
                if (clipBounds.width == 0 || clipBounds.height == 0) {
                    return;
                }
                imgRect = GcSnapshot.transformRect(clipBounds, transform);
                transform = new AffineTransform(transform.getScaleX(), transform.getShearY(), transform.getShearX(), transform.getScaleY(), transform.getTranslateX() - (double)imgRect.x, transform.getTranslateY() - (double)imgRect.y);
            } else {
                imgRect = new Rectangle(0, 0, layer.getImage().getWidth(), layer.getImage().getHeight());
            }
            BufferedImage image = new BufferedImage(imgRect.width, imgRect.height, 2);
            Graphics2D imageBaseGraphics = (Graphics2D)image.getGraphics();
            Graphics2D imageGraphics = this.createCustomGraphics(imageBaseGraphics, paint, compositeOnly, 3);
            Graphics2D configuredGraphics = this.createCustomGraphics(originalGraphics, paint, true, forceMode);
            configuredGraphics.setTransform(IDENTITY_TRANSFORM);
            try {
                imageGraphics.setTransform(transform);
                drawable2.draw(imageGraphics, paint);
                imageGraphics.setTransform(IDENTITY_TRANSFORM);
                filter.applyFilter(imageGraphics, imgRect.width, imgRect.height);
                configuredGraphics.drawImage((Image)image, imgRect.x, imgRect.y, null);
                layer.change();
            }
            finally {
                imageGraphics.dispose();
                imageBaseGraphics.dispose();
                configuredGraphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOnGraphics(Graphics2D g, Drawable drawable2, Paint_Delegate paint, Layer layer) {
        try {
            drawable2.draw(g, paint);
            layer.change();
        }
        finally {
            g.dispose();
        }
    }

    private GcSnapshot doRestore() {
        if (this.mPrevious != null) {
            if (this.mLocalLayer != null) {
                int flags;
                int i = this.mLayers.size() - 1;
                do {
                    Layer dstLayer = this.mLayers.get(i - 1);
                    this.restoreLayer(dstLayer);
                    flags = dstLayer.getFlags();
                } while (--i > 0 && (flags & 0x10) == 0);
            }
            if ((this.mFlags & 1) == 0) {
                AffineTransform mtx = this.getTransform();
                for (Layer layer : this.mPrevious.mLayers) {
                    layer.getGraphics().setTransform(mtx);
                }
            }
            if ((this.mFlags & 2) == 0) {
                Shape clip = this.getClip();
                for (Layer layer : this.mPrevious.mLayers) {
                    layer.setClip(clip);
                }
            }
        }
        for (Layer layer : this.mLayers) {
            layer.getGraphics().dispose();
        }
        return this.mPrevious;
    }

    private void restoreLayer(Layer dstLayer) {
        Graphics2D g;
        Graphics2D baseGfx = dstLayer.getImage().createGraphics();
        BufferedImage originalCopy = dstLayer.getOriginalCopy();
        if (originalCopy != null) {
            g = (Graphics2D)baseGfx.create();
            g.setComposite(AlphaComposite.Src);
            g.drawImage(originalCopy, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, 0, 0, this.mLayerBounds.width(), this.mLayerBounds.height(), null);
            g.dispose();
        }
        g = this.createCustomGraphics(baseGfx, this.mLocalLayerPaint, true, 0);
        g.drawImage(this.mLocalLayer.getImage(), this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, this.mLayerBounds.left, this.mLayerBounds.top, this.mLayerBounds.right, this.mLayerBounds.bottom, null);
        g.dispose();
        baseGfx.dispose();
    }

    private Graphics2D createCustomGraphics(Graphics2D original, Paint_Delegate paint, boolean compositeOnly, int forceMode) {
        Graphics2D g = (Graphics2D)original.create();
        if (paint == null) {
            return g;
        }
        if (paint.isAntiAliased()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (!compositeOnly) {
            this.setShader(g, paint);
            g.setStroke(paint.getJavaStroke());
        }
        this.setComposite(g, paint, compositeOnly, forceMode);
        return g;
    }

    private void setShader(Graphics2D g, Paint_Delegate paint) {
        Shader_Delegate shaderDelegate = paint.getShader();
        if (shaderDelegate != null) {
            if (shaderDelegate.isSupported()) {
                Paint shaderPaint = shaderDelegate.getJavaPaint();
                assert (shaderPaint != null);
                g.setPaint(shaderPaint);
                return;
            }
            Bridge.getLog().fidelityWarning("shader", shaderDelegate.getSupportMessage(), null, null, null);
        }
        g.setColor(new Color(paint.getColor(), true));
    }

    private void setComposite(Graphics2D g, Paint_Delegate paint, boolean usePaintAlpha, int forceMode) {
        int alpha = usePaintAlpha ? paint.getAlpha() : 255;
        Shader_Delegate shader = paint.getShader();
        if (shader != null) {
            alpha = (int)((float)alpha * shader.getAlpha());
        }
        if (forceMode != 0) {
            g.setComposite(AlphaComposite.getInstance(forceMode, (float)alpha / 255.0f));
            return;
        }
        PorterDuff.Mode mode = PorterDuff.intToMode(paint.getPorterDuffMode());
        Composite composite = PorterDuffUtility.getComposite(mode, alpha);
        g.setComposite(composite);
    }

    private void mapRect(AffineTransform matrix, RectF dst, RectF src) {
        float[] corners = new float[]{src.left, src.top, src.right, src.top, src.right, src.bottom, src.left, src.bottom};
        matrix.transform(corners, 0, corners, 0, 4);
        dst.left = Math.min(Math.min(corners[0], corners[2]), Math.min(corners[4], corners[6]));
        dst.right = Math.max(Math.max(corners[0], corners[2]), Math.max(corners[4], corners[6]));
        dst.top = Math.min(Math.min(corners[1], corners[3]), Math.min(corners[5], corners[7]));
        dst.bottom = Math.max(Math.max(corners[1], corners[3]), Math.max(corners[5], corners[7]));
    }

    public Rectangle getOriginalClip() {
        GcSnapshot originalSnapshot = this;
        while (originalSnapshot.mPrevious != null) {
            originalSnapshot = originalSnapshot.mPrevious;
        }
        if (originalSnapshot.mLayers.isEmpty()) {
            return null;
        }
        Graphics2D graphics2D = originalSnapshot.mLayers.get(0).getGraphics();
        Rectangle bounds = graphics2D.getClipBounds();
        if (bounds == null) {
            return null;
        }
        try {
            AffineTransform originalTransform = ((Graphics2D)graphics2D.create()).getTransform().createInverse();
            AffineTransform latestTransform = this.getTransform().createInverse();
            bounds.x = (int)((double)bounds.x + (latestTransform.getTranslateX() - originalTransform.getTranslateX()));
            bounds.y = (int)((double)bounds.y + (latestTransform.getTranslateY() - originalTransform.getTranslateY()));
        }
        catch (NoninvertibleTransformException e) {
            Bridge.getLog().warning(null, "Non invertible transformation", null);
        }
        return bounds;
    }

    private static class Layer {
        private final Graphics2D mGraphics;
        private final Bitmap_Delegate mBitmap;
        private final BufferedImage mImage;
        private final int mFlags;
        private BufferedImage mOriginalCopy;

        Layer(Graphics2D graphics, Bitmap_Delegate bitmap) {
            this.mGraphics = graphics;
            this.mBitmap = bitmap;
            this.mImage = this.mBitmap.getImage();
            this.mFlags = 0;
        }

        Layer(Graphics2D graphics, BufferedImage image, int flags) {
            this.mGraphics = graphics;
            this.mBitmap = null;
            this.mImage = image;
            this.mFlags = flags;
        }

        Graphics2D getGraphics() {
            return this.mGraphics;
        }

        BufferedImage getImage() {
            return this.mImage;
        }

        int getFlags() {
            return this.mFlags;
        }

        Layer makeCopy() {
            if (this.mBitmap != null) {
                return new Layer((Graphics2D)this.mGraphics.create(), this.mBitmap);
            }
            return new Layer((Graphics2D)this.mGraphics.create(), this.mImage, this.mFlags);
        }

        void setOriginalCopy(BufferedImage image) {
            this.mOriginalCopy = image;
        }

        BufferedImage getOriginalCopy() {
            return this.mOriginalCopy;
        }

        void change() {
            if (this.mBitmap != null) {
                this.mBitmap.change();
            }
        }

        void setClip(Shape clipShape) {
            this.mGraphics.setClip(null);
            this.mGraphics.clip(clipShape);
        }

        public void clip(Shape shape) {
            this.mGraphics.clip(shape);
        }
    }

    public static interface Drawable {
        public void draw(Graphics2D var1, Paint_Delegate var2);
    }
}

