/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.tools.layoutlib.java.System_Delegate;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BridgeRenderSession
extends RenderSession {
    private final RenderSessionImpl mSession;
    private Result mLastResult;

    public Result getResult() {
        return this.mLastResult;
    }

    public BufferedImage getImage() {
        return this.mSession != null ? this.mSession.getImage() : new BufferedImage(1, 1, 2);
    }

    public List<ViewInfo> getRootViews() {
        return this.mSession != null ? this.mSession.getViewInfos() : Collections.emptyList();
    }

    public List<ViewInfo> getSystemRootViews() {
        return this.mSession != null ? this.mSession.getSystemViewInfos() : Collections.emptyList();
    }

    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultNamespacedProperties() {
        return this.mSession != null ? this.mSession.getDefaultNamespacedProperties() : Collections.emptyMap();
    }

    public Map<Object, String> getDefaultStyles() {
        return this.mSession != null ? this.mSession.getDefaultStyles() : Collections.emptyMap();
    }

    public Map<Object, ResourceReference> getDefaultNamespacedStyles() {
        return this.mSession != null ? this.mSession.getDefaultNamespacedStyles() : Collections.emptyMap();
    }

    public Result measure(long timeout) {
        if (this.mSession != null) {
            try {
                Bridge.prepareThread();
                this.mLastResult = this.mSession.acquire(timeout);
                if (this.mLastResult.isSuccess()) {
                    this.mSession.invalidateRenderingSize();
                    this.mLastResult = this.mSession.measure();
                }
            }
            finally {
                this.mSession.release();
                Bridge.cleanupThread();
            }
        }
        return this.mLastResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result render(long timeout, boolean forceMeasure) {
        if (this.mSession != null) {
            try {
                Bridge.prepareThread();
                this.mLastResult = this.mSession.acquire(timeout);
                if (this.mLastResult.isSuccess()) {
                    if (forceMeasure) {
                        this.mSession.invalidateRenderingSize();
                    }
                    this.mLastResult = this.mSession.render(false);
                }
            }
            finally {
                this.mSession.release();
                Bridge.cleanupThread();
            }
        }
        return this.mLastResult;
    }

    public void setSystemTimeNanos(long nanos) {
        System_Delegate.setNanosTime(nanos);
    }

    public void setSystemBootTimeNanos(long nanos) {
        System_Delegate.setBootTimeNanos(nanos);
    }

    public void setElapsedFrameTimeNanos(long nanos) {
        if (this.mSession != null) {
            this.mSession.setElapsedFrameTimeNanos(nanos);
        }
    }

    public void dispose() {
        if (this.mSession != null) {
            this.mSession.dispose();
        }
    }

    BridgeRenderSession(RenderSessionImpl scene, Result lastResult) {
        this.mSession = scene;
        if (scene != null) {
            this.mSession.setScene(this);
        }
        this.mLastResult = lastResult;
    }
}

