/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ReceiverCallNotAllowedException;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.android.internal.R;

public class SwipeDismissLayout
extends FrameLayout {
    private static final String TAG = "SwipeDismissLayout";
    private static final float MAX_DIST_THRESHOLD = 0.33f;
    private static final float MIN_DIST_THRESHOLD = 0.1f;
    private boolean mIsWindowNativelyTranslucent;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mActiveTouchId;
    private float mDownX;
    private float mDownY;
    private float mLastX;
    private boolean mSwiping;
    private boolean mDismissed;
    private boolean mDiscardIntercept;
    private VelocityTracker mVelocityTracker;
    private boolean mBlockGesture = false;
    private boolean mActivityTranslucencyConverted = false;
    private final DismissAnimator mDismissAnimator = new DismissAnimator();
    private OnDismissedListener mDismissedListener;
    private OnSwipeProgressChangedListener mProgressListener;
    private BroadcastReceiver mScreenOffReceiver;
    private IntentFilter mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
    private boolean mDismissable = true;

    public SwipeDismissLayout(Context context) {
        super(context);
        this.init(context);
    }

    public SwipeDismissLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SwipeDismissLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        TypedArray a = context.getTheme().obtainStyledAttributes(R.styleable.Theme);
        this.mIsWindowNativelyTranslucent = a.getBoolean(5, false);
        a.recycle();
    }

    public void setOnDismissedListener(OnDismissedListener listener) {
        this.mDismissedListener = listener;
    }

    public void setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        try {
            this.mScreenOffReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    SwipeDismissLayout.this.post(() -> {
                        if (SwipeDismissLayout.this.mDismissed) {
                            SwipeDismissLayout.this.dismiss();
                        } else {
                            SwipeDismissLayout.this.cancel();
                        }
                        SwipeDismissLayout.this.resetMembers();
                    });
                }
            };
            this.getContext().registerReceiver(this.mScreenOffReceiver, this.mScreenOffFilter);
        }
        catch (ReceiverCallNotAllowedException e) {
            this.mScreenOffReceiver = null;
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mScreenOffReceiver != null) {
            this.getContext().unregisterReceiver(this.mScreenOffReceiver);
            this.mScreenOffReceiver = null;
        }
        super.onDetachedFromWindow();
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.checkGesture(ev);
        if (this.mBlockGesture) {
            return true;
        }
        if (!this.mDismissable) {
            return super.onInterceptTouchEvent(ev);
        }
        ev.offsetLocation(ev.getRawX() - ev.getX(), 0.0f);
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActiveTouchId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain("int1");
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                this.mActiveTouchId = ev.getPointerId(actionIndex);
                break;
            }
            case 6: {
                int actionIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(actionIndex);
                if (pointerId != this.mActiveTouchId) break;
                int newActionIndex = actionIndex == 0 ? 1 : 0;
                this.mActiveTouchId = ev.getPointerId(newActionIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int pointerIndex = ev.findPointerIndex(this.mActiveTouchId);
                if (pointerIndex == -1) {
                    Log.e(TAG, "Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float dx = ev.getRawX() - this.mDownX;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (dx != 0.0f && this.canScroll(this, false, dx, x, y)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(ev);
            }
        }
        return !this.mDiscardIntercept && this.mSwiping;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        this.checkGesture(ev);
        if (this.mBlockGesture) {
            return true;
        }
        if (this.mVelocityTracker == null || !this.mDismissable) {
            return super.onTouchEvent(ev);
        }
        ev.offsetLocation(ev.getRawX() - ev.getX(), 0.0f);
        switch (ev.getActionMasked()) {
            case 1: {
                this.updateDismiss(ev);
                if (this.mDismissed) {
                    this.mDismissAnimator.animateDismissal(ev.getRawX() - this.mDownX);
                } else if (this.mSwiping && this.mLastX != -2.1474836E9f) {
                    this.mDismissAnimator.animateRecovery(ev.getRawX() - this.mDownX);
                }
                this.resetMembers();
                break;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(ev);
                this.mLastX = ev.getRawX();
                this.updateSwiping(ev);
                if (!this.mSwiping) break;
                this.setProgress(ev.getRawX() - this.mDownX);
            }
        }
        return true;
    }

    private void setProgress(float deltaX) {
        if (this.mProgressListener != null && deltaX >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, this.progressToAlpha(deltaX / (float)this.getWidth()), deltaX);
        }
    }

    private void dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    protected void cancel() {
        Activity activity;
        if (!this.mIsWindowNativelyTranslucent && (activity = this.findActivity()) != null && this.mActivityTranslucencyConverted) {
            activity.convertFromTranslucent();
            this.mActivityTranslucencyConverted = false;
        }
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCancelled(this);
        }
    }

    private void resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mDownX = 0.0f;
        this.mLastX = -2.1474836E9f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
    }

    private void updateSwiping(MotionEvent ev) {
        Activity activity;
        boolean oldSwiping = this.mSwiping;
        if (!this.mSwiping) {
            float deltaY;
            float deltaX = ev.getRawX() - this.mDownX;
            this.mSwiping = deltaX * deltaX + (deltaY = ev.getRawY() - this.mDownY) * deltaY > (float)(this.mSlop * this.mSlop) ? deltaX > (float)(this.mSlop * 2) && Math.abs(deltaY) < Math.abs(deltaX) : false;
        }
        if (this.mSwiping && !oldSwiping && !this.mIsWindowNativelyTranslucent && (activity = this.findActivity()) != null) {
            this.mActivityTranslucencyConverted = activity.convertToTranslucent(null, null);
        }
    }

    private void updateDismiss(MotionEvent ev) {
        float distanceThreshold;
        float deltaX = ev.getRawX() - this.mDownX;
        this.mVelocityTracker.computeCurrentVelocity(1000);
        float xVelocity = this.mVelocityTracker.getXVelocity();
        if (this.mLastX == -2.1474836E9f) {
            xVelocity = deltaX / (float)((ev.getEventTime() - ev.getDownTime()) / 1000L);
        }
        if (!this.mDismissed && (deltaX > (distanceThreshold = (float)this.getWidth() * Math.max(Math.min(-0.23000002f * xVelocity / (float)this.mMinFlingVelocity + 0.33f, 0.33f), 0.1f)) && ev.getRawX() >= this.mLastX || xVelocity >= (float)this.mMinFlingVelocity)) {
            this.mDismissed = true;
        }
        if (this.mDismissed && this.mSwiping && xVelocity < (float)(-this.mMinFlingVelocity)) {
            this.mDismissed = false;
        }
    }

    protected boolean canScroll(View v, boolean checkV, float dx, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (!(x + (float)scrollX >= (float)child.getLeft()) || !(x + (float)scrollX < (float)child.getRight()) || !(y + (float)scrollY >= (float)child.getTop()) || !(y + (float)scrollY < (float)child.getBottom()) || !this.canScroll(child, true, dx, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally((int)(-dx));
    }

    public void setDismissable(boolean dismissable) {
        if (!dismissable && this.mDismissable) {
            this.cancel();
            this.resetMembers();
        }
        this.mDismissable = dismissable;
    }

    private void checkGesture(MotionEvent ev) {
        if (ev.getActionMasked() == 0) {
            this.mBlockGesture = this.mDismissAnimator.isAnimating();
        }
    }

    private float progressToAlpha(float progress) {
        return 1.0f - progress * progress * progress;
    }

    private Activity findActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private class DismissAnimator
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        private final TimeInterpolator DISMISS_INTERPOLATOR = new DecelerateInterpolator(1.5f);
        private final long DISMISS_DURATION = 250L;
        private final ValueAnimator mDismissAnimator = new ValueAnimator();
        private boolean mWasCanceled = false;
        private boolean mDismissOnComplete = false;

        DismissAnimator() {
            this.mDismissAnimator.addUpdateListener(this);
            this.mDismissAnimator.addListener(this);
        }

        void animateDismissal(float currentTranslation) {
            this.animate(currentTranslation / (float)SwipeDismissLayout.this.getWidth(), 1.0f, 250L, this.DISMISS_INTERPOLATOR, true);
        }

        void animateRecovery(float currentTranslation) {
            this.animate(currentTranslation / (float)SwipeDismissLayout.this.getWidth(), 0.0f, 250L, this.DISMISS_INTERPOLATOR, false);
        }

        boolean isAnimating() {
            return this.mDismissAnimator.isStarted();
        }

        private void animate(float from, float to, long duration, TimeInterpolator interpolator2, boolean dismissOnComplete) {
            this.mDismissAnimator.cancel();
            this.mDismissOnComplete = dismissOnComplete;
            this.mDismissAnimator.setFloatValues(from, to);
            this.mDismissAnimator.setDuration(duration);
            this.mDismissAnimator.setInterpolator(interpolator2);
            this.mDismissAnimator.start();
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            SwipeDismissLayout.this.setProgress(value * (float)SwipeDismissLayout.this.getWidth());
        }

        @Override
        public void onAnimationStart(Animator animation) {
            this.mWasCanceled = false;
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            this.mWasCanceled = true;
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            if (!this.mWasCanceled) {
                if (this.mDismissOnComplete) {
                    SwipeDismissLayout.this.dismiss();
                } else {
                    SwipeDismissLayout.this.cancel();
                }
            }
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface OnSwipeProgressChangedListener {
        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);

        public void onSwipeCancelled(SwipeDismissLayout var1);
    }

    public static interface OnDismissedListener {
        public void onDismissed(SwipeDismissLayout var1);
    }
}

