/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.UnsupportedAppUsage;
import android.app.admin.DevicePolicyManager;
import android.app.admin.PasswordMetrics;
import android.app.trust.IStrongAuthTracker;
import android.app.trust.TrustManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.UserInfo;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.widget.ICheckCredentialProgressCallback;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.LockSettingsInternal;
import com.android.internal.widget.VerifyCredentialResponse;
import com.android.server.LocalServices;
import com.google.android.collect.Lists;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import libcore.util.HexEncoding;

public class LockPatternUtils {
    private static final String TAG = "LockPatternUtils";
    private static final boolean FRP_CREDENTIAL_ENABLED = true;
    public static final String LEGACY_LOCK_PATTERN_ENABLED = "legacy_lock_pattern_enabled";
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_LOCK_PASSWORD_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 4;
    public static final int CREDENTIAL_TYPE_NONE = -1;
    public static final int CREDENTIAL_TYPE_PATTERN = 1;
    public static final int CREDENTIAL_TYPE_PASSWORD = 2;
    public static final int USER_FRP = -9999;
    @Deprecated
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    @Deprecated
    public static final String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static final String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static final String LOCKSCREEN_OPTIONS = "lockscreen.options";
    @Deprecated
    public static final String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    @Deprecated
    public static final String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    public static final String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    @Deprecated
    public static final String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static final String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private static final String LOCK_SCREEN_DEVICE_OWNER_INFO = "lockscreen.device_owner_info";
    private static final String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    private static final String IS_TRUST_USUALLY_MANAGED = "lockscreen.istrustusuallymanaged";
    public static final String PROFILE_KEY_NAME_ENCRYPT = "profile_key_name_encrypt_";
    public static final String PROFILE_KEY_NAME_DECRYPT = "profile_key_name_decrypt_";
    public static final String SYNTHETIC_PASSWORD_KEY_PREFIX = "synthetic_password_";
    public static final String SYNTHETIC_PASSWORD_HANDLE_KEY = "sp-handle";
    public static final String SYNTHETIC_PASSWORD_ENABLED_KEY = "enable-sp";
    private static final String HISTORY_DELIMITER = ",";
    @UnsupportedAppUsage
    private final Context mContext;
    @UnsupportedAppUsage
    private final ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;
    private UserManager mUserManager;
    private final Handler mHandler;
    private final SparseLongArray mLockoutDeadlines = new SparseLongArray();
    private Boolean mHasSecureLockScreen;

    public boolean isTrustUsuallyManaged(int userId) {
        if (!(this.mLockSettingsService instanceof ILockSettings.Stub)) {
            throw new IllegalStateException("May only be called by TrustManagerService. Use TrustManager.isTrustUsuallyManaged()");
        }
        try {
            return this.getLockSettings().getBoolean(IS_TRUST_USUALLY_MANAGED, false, userId);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setTrustUsuallyManaged(boolean managed, int userId) {
        try {
            this.getLockSettings().setBoolean(IS_TRUST_USUALLY_MANAGED, managed, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void userPresent(int userId) {
        try {
            this.getLockSettings().userPresent(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    private UserManager getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = UserManager.get(this.mContext);
        }
        return this.mUserManager;
    }

    private TrustManager getTrustManager() {
        TrustManager trust = (TrustManager)this.mContext.getSystemService("trust");
        if (trust == null) {
            Log.e(TAG, "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trust;
    }

    @UnsupportedAppUsage
    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        Looper looper = Looper.myLooper();
        this.mHandler = looper != null ? new Handler(looper) : null;
    }

    @UnsupportedAppUsage
    @VisibleForTesting
    public ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            ILockSettings service;
            this.mLockSettingsService = service = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        }
        return this.mLockSettingsService;
    }

    public int getRequestedMinimumPasswordLength(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, userId);
    }

    public int getMaximumPasswordLength(int quality) {
        return this.getDevicePolicyManager().getPasswordMaximumLength(quality);
    }

    public int getRequestedPasswordQuality(int userId) {
        return this.getDevicePolicyManager().getPasswordQuality(null, userId);
    }

    private int getRequestedPasswordHistoryLength(int userId) {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, userId);
    }

    public int getRequestedPasswordMinimumLetters(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, userId);
    }

    public int getRequestedPasswordMinimumUpperCase(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, userId);
    }

    public int getRequestedPasswordMinimumLowerCase(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, userId);
    }

    public int getRequestedPasswordMinimumNumeric(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, userId);
    }

    public int getRequestedPasswordMinimumSymbols(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, userId);
    }

    public int getRequestedPasswordMinimumNonLetter(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, userId);
    }

    @UnsupportedAppUsage
    public void reportFailedPasswordAttempt(int userId) {
        if (userId == -9999 && LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            return;
        }
        this.getDevicePolicyManager().reportFailedPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(false, userId);
    }

    @UnsupportedAppUsage
    public void reportSuccessfulPasswordAttempt(int userId) {
        if (userId == -9999 && LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            return;
        }
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(true, userId);
    }

    public void reportPasswordLockout(int timeoutMs, int userId) {
        if (userId == -9999 && LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            return;
        }
        this.getTrustManager().reportUnlockLockout(timeoutMs, userId);
    }

    public int getCurrentFailedPasswordAttempts(int userId) {
        if (userId == -9999 && LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            return 0;
        }
        return this.getDevicePolicyManager().getCurrentFailedPasswordAttempts(userId);
    }

    public int getMaximumFailedPasswordsForWipe(int userId) {
        if (userId == -9999 && LockPatternUtils.frpCredentialEnabled(this.mContext)) {
            return 0;
        }
        return this.getDevicePolicyManager().getMaximumFailedPasswordsForWipe(null, userId);
    }

    private byte[] verifyCredential(byte[] credential, int type, long challenge, int userId) throws RequestThrottledException {
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyCredential(credential, type, challenge, userId);
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private boolean checkCredential(byte[] credential, int type, int userId, CheckCredentialProgressCallback progressCallback) throws RequestThrottledException {
        try {
            VerifyCredentialResponse response = this.getLockSettings().checkCredential(credential, type, userId, this.wrapCallback(progressCallback));
            if (response.getResponseCode() == 0) {
                return true;
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return false;
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public byte[] verifyPattern(List<LockPatternView.Cell> pattern, long challenge, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        return this.verifyCredential(LockPatternUtils.patternToByteArray(pattern), 1, challenge, userId);
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern, int userId) throws RequestThrottledException {
        return this.checkPattern(pattern, userId, null);
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern, int userId, CheckCredentialProgressCallback progressCallback) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        return this.checkCredential(LockPatternUtils.patternToByteArray(pattern), 1, userId, progressCallback);
    }

    public byte[] verifyPassword(byte[] password, long challenge, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        return this.verifyCredential(password, 2, challenge, userId);
    }

    public byte[] verifyTiedProfileChallenge(byte[] password, boolean isPattern, long challenge, int userId) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyTiedProfileChallenge(password, isPattern ? 1 : 2, challenge, userId);
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @UnsupportedAppUsage
    public boolean checkPassword(String password, int userId) throws RequestThrottledException {
        byte[] passwordBytes = password != null ? password.getBytes() : null;
        return this.checkPassword(passwordBytes, userId, null);
    }

    public boolean checkPassword(byte[] password, int userId) throws RequestThrottledException {
        return this.checkPassword(password, userId, null);
    }

    public boolean checkPassword(String password, int userId, CheckCredentialProgressCallback progressCallback) throws RequestThrottledException {
        byte[] passwordBytes = password != null ? password.getBytes() : null;
        this.throwIfCalledOnMainThread();
        return this.checkCredential(passwordBytes, 2, userId, progressCallback);
    }

    public boolean checkPassword(byte[] password, int userId, CheckCredentialProgressCallback progressCallback) throws RequestThrottledException {
        this.throwIfCalledOnMainThread();
        return this.checkCredential(password, 2, userId, progressCallback);
    }

    public boolean checkVoldPassword(int userId) {
        try {
            return this.getLockSettings().checkVoldPassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public byte[] getPasswordHistoryHashFactor(byte[] currentPassword, int userId) {
        try {
            return this.getLockSettings().getHashFactor(currentPassword, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to get hash factor", e);
            return null;
        }
    }

    public boolean checkPasswordHistory(byte[] passwordToCheck, byte[] hashFactor, int userId) {
        if (passwordToCheck == null || passwordToCheck.length == 0) {
            Log.e(TAG, "checkPasswordHistory: empty password");
            return false;
        }
        String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userId);
        if (TextUtils.isEmpty(passwordHistory)) {
            return false;
        }
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength(userId);
        if (passwordHistoryLength == 0) {
            return false;
        }
        String legacyHash = this.legacyPasswordToHash(passwordToCheck, userId);
        String passwordHash = this.passwordToHistoryHash(passwordToCheck, hashFactor, userId);
        String[] history = passwordHistory.split(HISTORY_DELIMITER);
        for (int i = 0; i < Math.min(passwordHistoryLength, history.length); ++i) {
            if (!history[i].equals(legacyHash) && !history[i].equals(passwordHash)) continue;
            return true;
        }
        return false;
    }

    private boolean savedPatternExists(int userId) {
        try {
            return this.getLockSettings().havePattern(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private boolean savedPasswordExists(int userId) {
        try {
            return this.getLockSettings().havePassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean isPatternEverChosen(int userId) {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY, false, userId);
    }

    public void reportPatternWasChosen(int userId) {
        this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true, userId);
    }

    @UnsupportedAppUsage
    public int getActivePasswordQuality(int userId) {
        int quality = this.getKeyguardStoredPasswordQuality(userId);
        if (this.isLockPasswordEnabled(quality, userId)) {
            return quality;
        }
        if (this.isLockPatternEnabled(quality, userId)) {
            return quality;
        }
        return 0;
    }

    public void resetKeyStore(int userId) {
        try {
            this.getLockSettings().resetKeyStore(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't reset keystore " + e);
        }
    }

    public boolean clearLock(byte[] savedCredential, int userHandle) {
        return this.clearLock(savedCredential, userHandle, false);
    }

    public boolean clearLock(byte[] savedCredential, int userHandle, boolean allowUntrustedChange) {
        int currentQuality = this.getKeyguardStoredPasswordQuality(userHandle);
        this.setKeyguardStoredPasswordQuality(0, userHandle);
        try {
            this.getLockSettings().setLockCredential(null, -1, savedCredential, 0, userHandle, allowUntrustedChange);
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to clear lock", e);
            this.setKeyguardStoredPasswordQuality(currentQuality, userHandle);
            return false;
        }
        if (userHandle == 0) {
            this.updateEncryptionPassword(1, null);
            this.setCredentialRequiredToDecrypt(false);
        }
        this.onAfterChangingPassword(userHandle);
        return true;
    }

    public void setLockScreenDisabled(boolean disable, int userId) {
        this.setBoolean(DISABLE_LOCKSCREEN_KEY, disable, userId);
    }

    @UnsupportedAppUsage
    public boolean isLockScreenDisabled(int userId) {
        if (this.isSecure(userId)) {
            return false;
        }
        boolean disabledByDefault = this.mContext.getResources().getBoolean(17891406);
        boolean isSystemUser = UserManager.isSplitSystemUser() && userId == 0;
        UserInfo userInfo = this.getUserManager().getUserInfo(userId);
        boolean isDemoUser = UserManager.isDeviceInDemoMode(this.mContext) && userInfo != null && userInfo.isDemo();
        return this.getBoolean(DISABLE_LOCKSCREEN_KEY, false, userId) || disabledByDefault && !isSystemUser || isDemoUser;
    }

    public boolean saveLockPattern(List<LockPatternView.Cell> pattern, byte[] savedPattern, int userId) {
        return this.saveLockPattern(pattern, savedPattern, userId, false);
    }

    public boolean saveLockPattern(List<LockPatternView.Cell> pattern, byte[] savedPattern, int userId, boolean allowUntrustedChange) {
        if (!this.hasSecureLockScreen()) {
            throw new UnsupportedOperationException("This operation requires the lock screen feature.");
        }
        if (pattern == null || pattern.size() < 4) {
            throw new IllegalArgumentException("pattern must not be null and at least 4 dots long.");
        }
        byte[] bytePattern = LockPatternUtils.patternToByteArray(pattern);
        int currentQuality = this.getKeyguardStoredPasswordQuality(userId);
        this.setKeyguardStoredPasswordQuality(65536, userId);
        try {
            this.getLockSettings().setLockCredential(bytePattern, 1, savedPattern, 65536, userId, allowUntrustedChange);
        }
        catch (Exception e) {
            Log.e(TAG, "Couldn't save lock pattern", e);
            this.setKeyguardStoredPasswordQuality(currentQuality, userId);
            return false;
        }
        if (userId == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
            if (!this.shouldEncryptWithCredentials(true)) {
                this.clearEncryptionPassword();
            } else {
                this.updateEncryptionPassword(2, bytePattern);
            }
        }
        this.reportPatternWasChosen(userId);
        this.onAfterChangingPassword(userId);
        return true;
    }

    private void updateCryptoUserInfo(int userId) {
        if (userId != 0) {
            return;
        }
        String ownerInfo = this.isOwnerInfoEnabled(userId) ? this.getOwnerInfo(userId) : "";
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IStorageManager storageManager = IStorageManager.Stub.asInterface(service);
        try {
            Log.d(TAG, "Setting owner info");
            storageManager.setField("OwnerInfo", ownerInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing user info", e);
        }
    }

    @UnsupportedAppUsage
    public void setOwnerInfo(String info, int userId) {
        this.setString(LOCK_SCREEN_OWNER_INFO, info, userId);
        this.updateCryptoUserInfo(userId);
    }

    @UnsupportedAppUsage
    public void setOwnerInfoEnabled(boolean enabled, int userId) {
        this.setBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, enabled, userId);
        this.updateCryptoUserInfo(userId);
    }

    @UnsupportedAppUsage
    public String getOwnerInfo(int userId) {
        return this.getString(LOCK_SCREEN_OWNER_INFO, userId);
    }

    public boolean isOwnerInfoEnabled(int userId) {
        return this.getBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, false, userId);
    }

    public void setDeviceOwnerInfo(String info) {
        if (info != null && info.isEmpty()) {
            info = null;
        }
        this.setString(LOCK_SCREEN_DEVICE_OWNER_INFO, info, 0);
    }

    public String getDeviceOwnerInfo() {
        return this.getString(LOCK_SCREEN_DEVICE_OWNER_INFO, 0);
    }

    public boolean isDeviceOwnerInfoEnabled() {
        return this.getDeviceOwnerInfo() != null;
    }

    private void updateEncryptionPassword(final int type, byte[] password) {
        if (!this.hasSecureLockScreen()) {
            throw new UnsupportedOperationException("This operation requires the lock screen feature.");
        }
        if (!LockPatternUtils.isDeviceEncryptionEnabled()) {
            return;
        }
        final IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the encryption password");
            return;
        }
        final String passwordString = password != null ? new String(password) : null;
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... dummy) {
                IStorageManager storageManager = IStorageManager.Stub.asInterface(service);
                try {
                    storageManager.changeEncryptionPassword(type, passwordString);
                }
                catch (RemoteException e) {
                    Log.e(LockPatternUtils.TAG, "Error changing encryption password", e);
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    @Deprecated
    public boolean saveLockPassword(String password, String savedPassword, int requestedQuality, int userHandle) {
        byte[] passwordBytes = password != null ? password.getBytes() : null;
        byte[] savedPasswordBytes = savedPassword != null ? savedPassword.getBytes() : null;
        return this.saveLockPassword(passwordBytes, savedPasswordBytes, requestedQuality, userHandle);
    }

    public boolean saveLockPassword(byte[] password, byte[] savedPassword, int requestedQuality, int userHandle) {
        return this.saveLockPassword(password, savedPassword, requestedQuality, userHandle, false);
    }

    public boolean saveLockPassword(byte[] password, byte[] savedPassword, int requestedQuality, int userHandle, boolean allowUntrustedChange) {
        if (!this.hasSecureLockScreen()) {
            throw new UnsupportedOperationException("This operation requires the lock screen feature.");
        }
        if (password == null || password.length < 4) {
            throw new IllegalArgumentException("password must not be null and at least of length 4");
        }
        if (requestedQuality < 131072) {
            throw new IllegalArgumentException("quality must be at least NUMERIC, but was " + requestedQuality);
        }
        int currentQuality = this.getKeyguardStoredPasswordQuality(userHandle);
        int passwordQuality = PasswordMetrics.computeForPassword((byte[])password).quality;
        int newKeyguardQuality = this.computeKeyguardQuality(2, requestedQuality, passwordQuality);
        this.setKeyguardStoredPasswordQuality(newKeyguardQuality, userHandle);
        try {
            this.getLockSettings().setLockCredential(password, 2, savedPassword, requestedQuality, userHandle, allowUntrustedChange);
        }
        catch (Exception e) {
            Log.e(TAG, "Unable to save lock password", e);
            this.setKeyguardStoredPasswordQuality(currentQuality, userHandle);
            return false;
        }
        this.updateEncryptionPasswordIfNeeded(password, passwordQuality, userHandle);
        this.updatePasswordHistory(password, userHandle);
        this.onAfterChangingPassword(userHandle);
        return true;
    }

    private int computeKeyguardQuality(int credentialType, int requestedQuality, int passwordQuality) {
        return credentialType == 2 ? Math.max(passwordQuality, requestedQuality) : passwordQuality;
    }

    private void updateEncryptionPasswordIfNeeded(byte[] password, int quality, int userHandle) {
        if (userHandle == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
            if (!this.shouldEncryptWithCredentials(true)) {
                this.clearEncryptionPassword();
            } else {
                boolean numeric = quality == 131072;
                boolean numericComplex = quality == 196608;
                int type = numeric || numericComplex ? 3 : 0;
                this.updateEncryptionPassword(type, password);
            }
        }
    }

    private void updatePasswordHistory(byte[] password, int userHandle) {
        int passwordHistoryLength;
        if (password == null || password.length == 0) {
            Log.e(TAG, "checkPasswordHistory: empty password");
            return;
        }
        String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userHandle);
        if (passwordHistory == null) {
            passwordHistory = "";
        }
        if ((passwordHistoryLength = this.getRequestedPasswordHistoryLength(userHandle)) == 0) {
            passwordHistory = "";
        } else {
            byte[] hashFactor = this.getPasswordHistoryHashFactor(password, userHandle);
            String hash = this.passwordToHistoryHash(password, hashFactor, userHandle);
            if (hash == null) {
                Log.e(TAG, "Compute new style password hash failed, fallback to legacy style");
                hash = this.legacyPasswordToHash(password, userHandle);
            }
            if (TextUtils.isEmpty(passwordHistory)) {
                passwordHistory = hash;
            } else {
                String[] history = passwordHistory.split(HISTORY_DELIMITER);
                StringJoiner joiner = new StringJoiner(HISTORY_DELIMITER);
                joiner.add(hash);
                for (int i = 0; i < passwordHistoryLength - 1 && i < history.length; ++i) {
                    joiner.add(history[i]);
                }
                passwordHistory = joiner.toString();
            }
        }
        this.setString(PASSWORD_HISTORY_KEY, passwordHistory, userHandle);
    }

    @UnsupportedAppUsage
    public static boolean isDeviceEncryptionEnabled() {
        return StorageManager.isEncrypted();
    }

    public static boolean isFileEncryptionEnabled() {
        return StorageManager.isFileEncryptedNativeOrEmulated();
    }

    public void clearEncryptionPassword() {
        this.updateEncryptionPassword(1, null);
    }

    @UnsupportedAppUsage
    public int getKeyguardStoredPasswordQuality(int userHandle) {
        return (int)this.getLong(PASSWORD_TYPE_KEY, 0L, userHandle);
    }

    private void setKeyguardStoredPasswordQuality(int quality, int userHandle) {
        this.setLong(PASSWORD_TYPE_KEY, quality, userHandle);
    }

    public void setSeparateProfileChallengeEnabled(int userHandle, boolean enabled, byte[] managedUserPassword) {
        if (!this.isManagedProfile(userHandle)) {
            return;
        }
        try {
            this.getLockSettings().setSeparateProfileChallengeEnabled(userHandle, enabled, managedUserPassword);
            this.onAfterChangingPassword(userHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't update work profile challenge enabled");
        }
    }

    public boolean isSeparateProfileChallengeEnabled(int userHandle) {
        return this.isManagedProfile(userHandle) && this.hasSeparateChallenge(userHandle);
    }

    public boolean isManagedProfileWithUnifiedChallenge(int userHandle) {
        return this.isManagedProfile(userHandle) && !this.hasSeparateChallenge(userHandle);
    }

    public boolean isSeparateProfileChallengeAllowed(int userHandle) {
        return this.isManagedProfile(userHandle) && this.getDevicePolicyManager().isSeparateProfileChallengeAllowed(userHandle);
    }

    public boolean isSeparateProfileChallengeAllowedToUnify(int userHandle) {
        return this.getDevicePolicyManager().isProfileActivePasswordSufficientForParent(userHandle) && !this.getUserManager().hasUserRestriction("no_unified_password", UserHandle.of(userHandle));
    }

    private boolean hasSeparateChallenge(int userHandle) {
        try {
            return this.getLockSettings().getSeparateProfileChallengeEnabled(userHandle);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Couldn't get separate profile challenge enabled");
            return false;
        }
    }

    private boolean isManagedProfile(int userHandle) {
        UserInfo info = this.getUserManager().getUserInfo(userHandle);
        return info != null && info.isManagedProfile();
    }

    @Deprecated
    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        if (string2 == null) {
            return null;
        }
        return LockPatternUtils.byteArrayToPattern(string2.getBytes());
    }

    public static List<LockPatternView.Cell> byteArrayToPattern(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = (byte)(bytes[i] - 49);
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static String patternToString(List<LockPatternView.Cell> pattern) {
        return new String(LockPatternUtils.patternToByteArray(pattern));
    }

    public static byte[] patternToByteArray(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return new byte[0];
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn() + 49);
        }
        return res;
    }

    public static byte[] patternByteArrayToBaseZero(byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        int patternSize = bytes.length;
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            res[i] = (byte)(bytes[i] - 49);
        }
        return res;
    }

    @UnsupportedAppUsage
    public static byte[] patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    private String getSalt(int userId) {
        long salt = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L, userId);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong(LOCK_PASSWORD_SALT_KEY, salt, userId);
                Log.v(TAG, "Initialized lock password salt for user: " + userId);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    public String legacyPasswordToHash(byte[] password, int userId) {
        if (password == null || password.length == 0) {
            return null;
        }
        try {
            byte[] salt = this.getSalt(userId).getBytes();
            byte[] saltedPassword = Arrays.copyOf(password, password.length + salt.length);
            System.arraycopy(salt, 0, saltedPassword, password.length, salt.length);
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            byte[] combined = new byte[sha1.length + md5.length];
            System.arraycopy(sha1, 0, combined, 0, sha1.length);
            System.arraycopy(md5, 0, combined, sha1.length, md5.length);
            char[] hexEncoded = HexEncoding.encode(combined);
            Arrays.fill(saltedPassword, (byte)0);
            return new String(hexEncoded);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Missing digest algorithm: ", e);
        }
    }

    private String passwordToHistoryHash(byte[] passwordToHash, byte[] hashFactor, int userId) {
        if (passwordToHash == null || passwordToHash.length == 0 || hashFactor == null) {
            return null;
        }
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(hashFactor);
            byte[] salt = this.getSalt(userId).getBytes();
            byte[] saltedPassword = Arrays.copyOf(passwordToHash, passwordToHash.length + salt.length);
            System.arraycopy(salt, 0, saltedPassword, passwordToHash.length, salt.length);
            sha256.update(saltedPassword);
            Arrays.fill(saltedPassword, (byte)0);
            return new String(HexEncoding.encode(sha256.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Missing digest algorithm: ", e);
        }
    }

    @UnsupportedAppUsage
    public boolean isSecure(int userId) {
        int mode = this.getKeyguardStoredPasswordQuality(userId);
        return this.isLockPatternEnabled(mode, userId) || this.isLockPasswordEnabled(mode, userId);
    }

    @UnsupportedAppUsage
    public boolean isLockPasswordEnabled(int userId) {
        return this.isLockPasswordEnabled(this.getKeyguardStoredPasswordQuality(userId), userId);
    }

    private boolean isLockPasswordEnabled(int mode, int userId) {
        boolean passwordEnabled = mode == 262144 || mode == 131072 || mode == 196608 || mode == 327680 || mode == 393216 || mode == 524288;
        return passwordEnabled && this.savedPasswordExists(userId);
    }

    @UnsupportedAppUsage
    public boolean isLockPatternEnabled(int userId) {
        return this.isLockPatternEnabled(this.getKeyguardStoredPasswordQuality(userId), userId);
    }

    @Deprecated
    public boolean isLegacyLockPatternEnabled(int userId) {
        return this.getBoolean(LEGACY_LOCK_PATTERN_ENABLED, true, userId);
    }

    @Deprecated
    public void setLegacyLockPatternEnabled(int userId) {
        this.setBoolean("lock_pattern_autolock", true, userId);
    }

    private boolean isLockPatternEnabled(int mode, int userId) {
        return mode == 65536 && this.savedPatternExists(userId);
    }

    @UnsupportedAppUsage
    public boolean isVisiblePatternEnabled(int userId) {
        return this.getBoolean("lock_pattern_visible_pattern", false, userId);
    }

    public void setVisiblePatternEnabled(boolean enabled, int userId) {
        this.setBoolean("lock_pattern_visible_pattern", enabled, userId);
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IStorageManager storageManager = IStorageManager.Stub.asInterface(service);
        try {
            storageManager.setField("PatternVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing pattern visible state", e);
        }
    }

    public boolean isVisiblePatternEverChosen(int userId) {
        return this.getString("lock_pattern_visible_pattern", userId) != null;
    }

    public void setVisiblePasswordEnabled(boolean enabled, int userId) {
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IStorageManager storageManager = IStorageManager.Stub.asInterface(service);
        try {
            storageManager.setField("PasswordVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing password visible state", e);
        }
    }

    @UnsupportedAppUsage
    public boolean isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    @UnsupportedAppUsage
    public long setLockoutAttemptDeadline(int userId, int timeoutMs) {
        long deadline = SystemClock.elapsedRealtime() + (long)timeoutMs;
        if (userId == -9999) {
            return deadline;
        }
        this.mLockoutDeadlines.put(userId, deadline);
        return deadline;
    }

    public long getLockoutAttemptDeadline(int userId) {
        long now;
        long deadline = this.mLockoutDeadlines.get(userId, 0L);
        if (deadline < (now = SystemClock.elapsedRealtime()) && deadline != 0L) {
            this.mLockoutDeadlines.put(userId, 0L);
            return 0L;
        }
        return deadline;
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private void setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private long getLong(String secureSettingKey, long defaultValue, int userHandle) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, userHandle);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    @UnsupportedAppUsage
    private void setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write long " + secureSettingKey + re);
        }
    }

    @UnsupportedAppUsage
    private String getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    @UnsupportedAppUsage
    private void setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write string " + secureSettingKey + re);
        }
    }

    public void setPowerButtonInstantlyLocks(boolean enabled, int userId) {
        this.setBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, enabled, userId);
    }

    @UnsupportedAppUsage
    public boolean getPowerButtonInstantlyLocks(int userId) {
        return this.getBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, true, userId);
    }

    public boolean isPowerButtonInstantlyLocksEverChosen(int userId) {
        return this.getString(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, userId) != null;
    }

    public void setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents, int userId) {
        StringBuilder sb = new StringBuilder();
        for (ComponentName cn : activeTrustAgents) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cn.flattenToShortString());
        }
        this.setString(ENABLED_TRUST_AGENTS, sb.toString(), userId);
        this.getTrustManager().reportEnabledTrustAgentsChanged(userId);
    }

    public List<ComponentName> getEnabledTrustAgents(int userId) {
        String serialized = this.getString(ENABLED_TRUST_AGENTS, userId);
        if (TextUtils.isEmpty(serialized)) {
            return null;
        }
        String[] split = serialized.split(HISTORY_DELIMITER);
        ArrayList<ComponentName> activeTrustAgents = new ArrayList<ComponentName>(split.length);
        for (String s : split) {
            if (TextUtils.isEmpty(s)) continue;
            activeTrustAgents.add(ComponentName.unflattenFromString(s));
        }
        return activeTrustAgents;
    }

    public void requireCredentialEntry(int userId) {
        this.requireStrongAuth(4, userId);
    }

    public void requireStrongAuth(int strongAuthReason, int userId) {
        try {
            this.getLockSettings().requireStrongAuth(strongAuthReason, userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error while requesting strong auth: " + e);
        }
    }

    private void onAfterChangingPassword(int userHandle) {
        this.getTrustManager().reportEnabledTrustAgentsChanged(userHandle);
    }

    public boolean isCredentialRequiredToDecrypt(boolean defaultValue) {
        int value = Settings.Global.getInt(this.mContentResolver, "require_password_to_decrypt", -1);
        return value == -1 ? defaultValue : value != 0;
    }

    public void setCredentialRequiredToDecrypt(boolean required) {
        if (!this.getUserManager().isSystemUser() && !this.getUserManager().isPrimaryUser()) {
            throw new IllegalStateException("Only the system or primary user may call setCredentialRequiredForDecrypt()");
        }
        if (LockPatternUtils.isDeviceEncryptionEnabled()) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "require_password_to_decrypt", required ? 1 : 0);
        }
    }

    private boolean isDoNotAskCredentialsOnBootSet() {
        return this.getDevicePolicyManager().getDoNotAskCredentialsOnBoot();
    }

    private boolean shouldEncryptWithCredentials(boolean defaultValue) {
        return this.isCredentialRequiredToDecrypt(defaultValue) && !this.isDoNotAskCredentialsOnBootSet();
    }

    private void throwIfCalledOnMainThread() {
        if (Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalStateException("should not be called from the main thread.");
        }
    }

    public void registerStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        try {
            this.getLockSettings().registerStrongAuthTracker(strongAuthTracker.mStub);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Could not register StrongAuthTracker");
        }
    }

    public void unregisterStrongAuthTracker(StrongAuthTracker strongAuthTracker) {
        try {
            this.getLockSettings().unregisterStrongAuthTracker(strongAuthTracker.mStub);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not unregister StrongAuthTracker", e);
        }
    }

    public int getStrongAuthForUser(int userId) {
        try {
            return this.getLockSettings().getStrongAuthForUser(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not get StrongAuth", e);
            return StrongAuthTracker.getDefaultFlags(this.mContext);
        }
    }

    public boolean isTrustAllowedForUser(int userId) {
        return this.getStrongAuthForUser(userId) == 0;
    }

    public boolean isBiometricAllowedForUser(int userId) {
        return (this.getStrongAuthForUser(userId) & 0xFFFFFFFB) == 0;
    }

    public boolean isUserInLockdown(int userId) {
        return this.getStrongAuthForUser(userId) == 32;
    }

    private ICheckCredentialProgressCallback wrapCallback(final CheckCredentialProgressCallback callback) {
        if (callback == null) {
            return null;
        }
        if (this.mHandler == null) {
            throw new IllegalStateException("Must construct LockPatternUtils on a looper thread to use progress callbacks.");
        }
        return new ICheckCredentialProgressCallback.Stub(){

            @Override
            public void onCredentialVerified() throws RemoteException {
                LockPatternUtils.this.mHandler.post(callback::onEarlyMatched);
            }
        };
    }

    private LockSettingsInternal getLockSettingsInternal() {
        LockSettingsInternal service = LocalServices.getService(LockSettingsInternal.class);
        if (service == null) {
            throw new SecurityException("Only available to system server itself");
        }
        return service;
    }

    public long addEscrowToken(byte[] token, int userId, EscrowTokenStateChangeCallback callback) {
        return this.getLockSettingsInternal().addEscrowToken(token, userId, callback);
    }

    public boolean removeEscrowToken(long handle, int userId) {
        return this.getLockSettingsInternal().removeEscrowToken(handle, userId);
    }

    public boolean isEscrowTokenActive(long handle, int userId) {
        return this.getLockSettingsInternal().isEscrowTokenActive(handle, userId);
    }

    public boolean setLockCredentialWithToken(byte[] credential, int type, int requestedQuality, long tokenHandle, byte[] token, int userId) {
        if (!this.hasSecureLockScreen()) {
            throw new UnsupportedOperationException("This operation requires the lock screen feature.");
        }
        LockSettingsInternal localService = this.getLockSettingsInternal();
        if (type != -1) {
            if (credential == null || credential.length < 4) {
                throw new IllegalArgumentException("password must not be null and at least of length 4");
            }
            int quality = PasswordMetrics.computeForCredential((int)type, (byte[])credential).quality;
            int keyguardQuality = this.computeKeyguardQuality(type, quality, requestedQuality);
            if (!localService.setLockCredentialWithToken(credential, type, tokenHandle, token, keyguardQuality, userId)) {
                return false;
            }
            this.setKeyguardStoredPasswordQuality(quality, userId);
            this.updateEncryptionPasswordIfNeeded(credential, quality, userId);
            this.updatePasswordHistory(credential, userId);
            this.onAfterChangingPassword(userId);
        } else {
            if (credential != null && credential.length != 0) {
                throw new IllegalArgumentException("password must be emtpy for NONE type");
            }
            if (!localService.setLockCredentialWithToken(null, -1, tokenHandle, token, 0, userId)) {
                return false;
            }
            this.setKeyguardStoredPasswordQuality(0, userId);
            if (userId == 0) {
                this.updateEncryptionPassword(1, null);
                this.setCredentialRequiredToDecrypt(false);
            }
        }
        this.onAfterChangingPassword(userId);
        return true;
    }

    public boolean unlockUserWithToken(long tokenHandle, byte[] token, int userId) {
        return this.getLockSettingsInternal().unlockUserWithToken(tokenHandle, token, userId);
    }

    public void enableSyntheticPassword() {
        this.setLong(SYNTHETIC_PASSWORD_ENABLED_KEY, 1L, 0);
    }

    public void disableSyntheticPassword() {
        this.setLong(SYNTHETIC_PASSWORD_ENABLED_KEY, 0L, 0);
    }

    public boolean isSyntheticPasswordEnabled() {
        return this.getLong(SYNTHETIC_PASSWORD_ENABLED_KEY, 0L, 0) != 0L;
    }

    public boolean hasPendingEscrowToken(int userId) {
        try {
            return this.getLockSettings().hasPendingEscrowToken(userId);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean hasSecureLockScreen() {
        if (this.mHasSecureLockScreen == null) {
            this.mHasSecureLockScreen = this.mContext.getPackageManager().hasSystemFeature("android.software.secure_lock_screen");
        }
        return this.mHasSecureLockScreen;
    }

    public static boolean userOwnsFrpCredential(Context context, UserInfo info) {
        return info != null && info.isPrimary() && info.isAdmin() && LockPatternUtils.frpCredentialEnabled(context);
    }

    public static boolean frpCredentialEnabled(Context context) {
        return context.getResources().getBoolean(17891435);
    }

    public static byte[] charSequenceToByteArray(CharSequence chars) {
        if (chars == null) {
            return null;
        }
        byte[] bytes = new byte[chars.length()];
        for (int i = 0; i < chars.length(); ++i) {
            bytes[i] = (byte)chars.charAt(i);
        }
        return bytes;
    }

    public static class StrongAuthTracker {
        public static final int STRONG_AUTH_NOT_REQUIRED = 0;
        public static final int STRONG_AUTH_REQUIRED_AFTER_BOOT = 1;
        public static final int STRONG_AUTH_REQUIRED_AFTER_DPM_LOCK_NOW = 2;
        public static final int SOME_AUTH_REQUIRED_AFTER_USER_REQUEST = 4;
        public static final int STRONG_AUTH_REQUIRED_AFTER_LOCKOUT = 8;
        public static final int STRONG_AUTH_REQUIRED_AFTER_TIMEOUT = 16;
        public static final int STRONG_AUTH_REQUIRED_AFTER_USER_LOCKDOWN = 32;
        private static final int ALLOWING_BIOMETRIC = 4;
        private final SparseIntArray mStrongAuthRequiredForUser = new SparseIntArray();
        private final H mHandler;
        private final int mDefaultStrongAuthFlags;
        protected final IStrongAuthTracker.Stub mStub = new IStrongAuthTracker.Stub(){

            @Override
            public void onStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
                mHandler.obtainMessage(1, strongAuthFlags, userId).sendToTarget();
            }
        };

        public StrongAuthTracker(Context context) {
            this(context, Looper.myLooper());
        }

        public StrongAuthTracker(Context context, Looper looper) {
            this.mHandler = new H(looper);
            this.mDefaultStrongAuthFlags = StrongAuthTracker.getDefaultFlags(context);
        }

        public static int getDefaultFlags(Context context) {
            boolean strongAuthRequired = context.getResources().getBoolean(17891527);
            return strongAuthRequired ? 1 : 0;
        }

        public int getStrongAuthForUser(int userId) {
            return this.mStrongAuthRequiredForUser.get(userId, this.mDefaultStrongAuthFlags);
        }

        public boolean isTrustAllowedForUser(int userId) {
            return this.getStrongAuthForUser(userId) == 0;
        }

        public boolean isBiometricAllowedForUser(int userId) {
            return (this.getStrongAuthForUser(userId) & 0xFFFFFFFB) == 0;
        }

        public void onStrongAuthRequiredChanged(int userId) {
        }

        protected void handleStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
            int oldValue = this.getStrongAuthForUser(userId);
            if (strongAuthFlags != oldValue) {
                if (strongAuthFlags == this.mDefaultStrongAuthFlags) {
                    this.mStrongAuthRequiredForUser.delete(userId);
                } else {
                    this.mStrongAuthRequiredForUser.put(userId, strongAuthFlags);
                }
                this.onStrongAuthRequiredChanged(userId);
            }
        }

        private class H
        extends Handler {
            static final int MSG_ON_STRONG_AUTH_REQUIRED_CHANGED = 1;

            public H(Looper looper) {
                super(looper);
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        StrongAuthTracker.this.handleStrongAuthRequiredChanged(msg.arg1, msg.arg2);
                    }
                }
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StrongAuthFlags {
        }
    }

    public static interface CheckCredentialProgressCallback {
        public void onEarlyMatched();
    }

    public static interface EscrowTokenStateChangeCallback {
        public void onEscrowTokenActivated(long var1, int var3);
    }

    public static class RequestThrottledException
    extends Exception {
        private int mTimeoutMs;

        @UnsupportedAppUsage
        public RequestThrottledException(int timeoutMs) {
            this.mTimeoutMs = timeoutMs;
        }

        @UnsupportedAppUsage
        public int getTimeoutMs() {
            return this.mTimeoutMs;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CredentialType {
    }
}

