/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.InputChannel;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.IInputMethodPrivilegedOperations;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;

public interface IInputMethod
extends IInterface {
    public void initializeInternal(IBinder var1, int var2, IInputMethodPrivilegedOperations var3) throws RemoteException;

    public void bindInput(InputBinding var1) throws RemoteException;

    public void unbindInput() throws RemoteException;

    public void startInput(IBinder var1, IInputContext var2, int var3, EditorInfo var4, boolean var5, boolean var6) throws RemoteException;

    public void createSession(InputChannel var1, IInputSessionCallback var2) throws RemoteException;

    public void setSessionEnabled(IInputMethodSession var1, boolean var2) throws RemoteException;

    public void revokeSession(IInputMethodSession var1) throws RemoteException;

    public void showSoftInput(int var1, ResultReceiver var2) throws RemoteException;

    public void hideSoftInput(int var1, ResultReceiver var2) throws RemoteException;

    public void changeInputMethodSubtype(InputMethodSubtype var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethod {
        private static final String DESCRIPTOR = "com.android.internal.view.IInputMethod";
        static final int TRANSACTION_initializeInternal = 1;
        static final int TRANSACTION_bindInput = 2;
        static final int TRANSACTION_unbindInput = 3;
        static final int TRANSACTION_startInput = 4;
        static final int TRANSACTION_createSession = 5;
        static final int TRANSACTION_setSessionEnabled = 6;
        static final int TRANSACTION_revokeSession = 7;
        static final int TRANSACTION_showSoftInput = 8;
        static final int TRANSACTION_hideSoftInput = 9;
        static final int TRANSACTION_changeInputMethodSubtype = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputMethod asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethod) {
                return (IInputMethod)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "initializeInternal";
                }
                case 2: {
                    return "bindInput";
                }
                case 3: {
                    return "unbindInput";
                }
                case 4: {
                    return "startInput";
                }
                case 5: {
                    return "createSession";
                }
                case 6: {
                    return "setSessionEnabled";
                }
                case 7: {
                    return "revokeSession";
                }
                case 8: {
                    return "showSoftInput";
                }
                case 9: {
                    return "hideSoftInput";
                }
                case 10: {
                    return "changeInputMethodSubtype";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    IInputMethodPrivilegedOperations _arg2 = IInputMethodPrivilegedOperations.Stub.asInterface(data.readStrongBinder());
                    this.initializeInternal(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    InputBinding _arg0 = 0 != data.readInt() ? InputBinding.CREATOR.createFromParcel(data) : null;
                    this.bindInput(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.unbindInput();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IInputContext _arg1 = IInputContext.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    EditorInfo _arg3 = 0 != data.readInt() ? EditorInfo.CREATOR.createFromParcel(data) : null;
                    boolean _arg4 = 0 != data.readInt();
                    boolean _arg5 = 0 != data.readInt();
                    this.startInput(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    InputChannel _arg0 = 0 != data.readInt() ? InputChannel.CREATOR.createFromParcel(data) : null;
                    IInputSessionCallback _arg1 = IInputSessionCallback.Stub.asInterface(data.readStrongBinder());
                    this.createSession(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IInputMethodSession _arg0 = IInputMethodSession.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.setSessionEnabled(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IInputMethodSession _arg0 = IInputMethodSession.Stub.asInterface(data.readStrongBinder());
                    this.revokeSession(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ResultReceiver _arg1 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    this.showSoftInput(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    ResultReceiver _arg1 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    this.hideSoftInput(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    InputMethodSubtype _arg0 = 0 != data.readInt() ? InputMethodSubtype.CREATOR.createFromParcel(data) : null;
                    this.changeInputMethodSubtype(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IInputMethod impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IInputMethod getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IInputMethod {
            private IBinder mRemote;
            public static IInputMethod sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeInternal(IBinder token, int displayId, IInputMethodPrivilegedOperations privOps) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(privOps != null ? privOps.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initializeInternal(token, displayId, privOps);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bindInput(InputBinding binding) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (binding != null) {
                        _data.writeInt(1);
                        binding.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().bindInput(binding);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unbindInput() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unbindInput();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInput(IBinder startInputToken, IInputContext inputContext, int missingMethods, EditorInfo attribute, boolean restarting, boolean preRenderImeViews) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(startInputToken);
                    _data.writeStrongBinder(inputContext != null ? inputContext.asBinder() : null);
                    _data.writeInt(missingMethods);
                    if (attribute != null) {
                        _data.writeInt(1);
                        attribute.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(restarting ? 1 : 0);
                    _data.writeInt(preRenderImeViews ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startInput(startInputToken, inputContext, missingMethods, attribute, restarting, preRenderImeViews);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSession(InputChannel channel, IInputSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (channel != null) {
                        _data.writeInt(1);
                        channel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createSession(channel, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionEnabled(IInputMethodSession session, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSessionEnabled(session, enabled);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeSession(IInputMethodSession session) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(session != null ? session.asBinder() : null);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeSession(session);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showSoftInput(int flags, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    if (resultReceiver != null) {
                        _data.writeInt(1);
                        resultReceiver.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showSoftInput(flags, resultReceiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideSoftInput(int flags, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    if (resultReceiver != null) {
                        _data.writeInt(1);
                        resultReceiver.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideSoftInput(flags, resultReceiver);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeInputMethodSubtype(InputMethodSubtype subtype) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (subtype != null) {
                        _data.writeInt(1);
                        subtype.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().changeInputMethodSubtype(subtype);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethod {
        @Override
        public void initializeInternal(IBinder token, int displayId, IInputMethodPrivilegedOperations privOps) throws RemoteException {
        }

        @Override
        public void bindInput(InputBinding binding) throws RemoteException {
        }

        @Override
        public void unbindInput() throws RemoteException {
        }

        @Override
        public void startInput(IBinder startInputToken, IInputContext inputContext, int missingMethods, EditorInfo attribute, boolean restarting, boolean preRenderImeViews) throws RemoteException {
        }

        @Override
        public void createSession(InputChannel channel, IInputSessionCallback callback) throws RemoteException {
        }

        @Override
        public void setSessionEnabled(IInputMethodSession session, boolean enabled) throws RemoteException {
        }

        @Override
        public void revokeSession(IInputMethodSession session) throws RemoteException {
        }

        @Override
        public void showSoftInput(int flags, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void hideSoftInput(int flags, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype subtype) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

