/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

public class RingBufferIndices {
    private final int mCapacity;
    private int mStart;
    private int mSize;

    public RingBufferIndices(int capacity) {
        this.mCapacity = capacity;
    }

    public int add() {
        if (this.mSize < this.mCapacity) {
            int pos = this.mSize++;
            return pos;
        }
        int pos = this.mStart++;
        if (this.mStart == this.mCapacity) {
            this.mStart = 0;
        }
        return pos;
    }

    public void clear() {
        this.mStart = 0;
        this.mSize = 0;
    }

    public int size() {
        return this.mSize;
    }

    public int indexOf(int pos) {
        int index = this.mStart + pos;
        if (index >= this.mCapacity) {
            index -= this.mCapacity;
        }
        return index;
    }
}

