/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.AutofillOptions;
import android.content.ContentCaptureOptions;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.view.ContextThemeWrapper;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.view.contentcapture.ContentCaptureManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.policy.PhoneWindow;
import java.lang.ref.WeakReference;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class DecorContext
extends ContextThemeWrapper {
    private PhoneWindow mPhoneWindow;
    private WindowManager mWindowManager;
    private Resources mActivityResources;
    private ContentCaptureManager mContentCaptureManager;
    private WeakReference<Context> mActivityContext;

    @VisibleForTesting
    public DecorContext(Context context, Context activityContext) {
        super(context.createDisplayContext(activityContext.getDisplay()), null);
        this.mActivityContext = new WeakReference<Context>(activityContext);
        this.mActivityResources = activityContext.getResources();
    }

    void setPhoneWindow(PhoneWindow phoneWindow) {
        this.mPhoneWindow = phoneWindow;
        this.mWindowManager = null;
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            if (this.mWindowManager == null) {
                WindowManagerImpl wm = (WindowManagerImpl)super.getSystemService("window");
                this.mWindowManager = wm.createLocalWindowManager(this.mPhoneWindow);
            }
            return this.mWindowManager;
        }
        if ("content_capture".equals(name)) {
            Context activityContext;
            if (this.mContentCaptureManager == null && (activityContext = (Context)this.mActivityContext.get()) != null) {
                this.mContentCaptureManager = (ContentCaptureManager)activityContext.getSystemService(name);
            }
            return this.mContentCaptureManager;
        }
        return super.getSystemService(name);
    }

    @Override
    public Resources getResources() {
        Context activityContext = (Context)this.mActivityContext.get();
        if (activityContext != null) {
            this.mActivityResources = activityContext.getResources();
        }
        return this.mActivityResources;
    }

    @Override
    public AssetManager getAssets() {
        return this.mActivityResources.getAssets();
    }

    @Override
    public AutofillOptions getAutofillOptions() {
        Context activityContext = (Context)this.mActivityContext.get();
        if (activityContext != null) {
            return activityContext.getAutofillOptions();
        }
        return null;
    }

    @Override
    public ContentCaptureOptions getContentCaptureOptions() {
        Context activityContext = (Context)this.mActivityContext.get();
        if (activityContext != null) {
            return activityContext.getContentCaptureOptions();
        }
        return null;
    }
}

