/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public class KernelCpuSpeedReader {
    private static final String TAG = "KernelCpuSpeedReader";
    private final String mProcFile;
    private final int mNumSpeedSteps;
    private final long[] mLastSpeedTimesMs;
    private final long[] mDeltaSpeedTimesMs;
    private final long mJiffyMillis;

    public KernelCpuSpeedReader(int cpuNumber, int numSpeedSteps) {
        this.mProcFile = String.format("/sys/devices/system/cpu/cpu%d/cpufreq/stats/time_in_state", cpuNumber);
        this.mNumSpeedSteps = numSpeedSteps;
        this.mLastSpeedTimesMs = new long[numSpeedSteps];
        this.mDeltaSpeedTimesMs = new long[numSpeedSteps];
        long jiffyHz = Os.sysconf(OsConstants._SC_CLK_TCK);
        this.mJiffyMillis = 1000L / jiffyHz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readDelta() {
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            for (int speedIndex = 0; speedIndex < this.mLastSpeedTimesMs.length && (line = reader.readLine()) != null; ++speedIndex) {
                splitter.setString(line);
                splitter.next();
                long time = Long.parseLong(splitter.next()) * this.mJiffyMillis;
                this.mDeltaSpeedTimesMs[speedIndex] = time < this.mLastSpeedTimesMs[speedIndex] ? time : time - this.mLastSpeedTimesMs[speedIndex];
                this.mLastSpeedTimesMs[speedIndex] = time;
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read cpu-freq: " + e.getMessage());
            Arrays.fill(this.mDeltaSpeedTimesMs, 0L);
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
        return this.mDeltaSpeedTimesMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readAbsolute() {
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        long[] speedTimeMs = new long[this.mNumSpeedSteps];
        try (BufferedReader reader = new BufferedReader(new FileReader(this.mProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            for (int speedIndex = 0; speedIndex < this.mNumSpeedSteps && (line = reader.readLine()) != null; ++speedIndex) {
                long time;
                splitter.setString(line);
                splitter.next();
                speedTimeMs[speedIndex] = time = Long.parseLong(splitter.next()) * this.mJiffyMillis;
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read cpu-freq: " + e.getMessage());
            Arrays.fill(speedTimeMs, 0L);
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
        return speedTimeMs;
    }
}

