/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.phonenumbers;

import com.android.i18n.phonenumbers.Phonenumber;
import dalvik.annotation.compat.UnsupportedAppUsage;
import java.util.Arrays;

public class PhoneNumberMatch {
    private final int start;
    private final String rawString;
    private final Phonenumber.PhoneNumber number;

    PhoneNumberMatch(int start, String rawString, Phonenumber.PhoneNumber number) {
        if (start < 0) {
            throw new IllegalArgumentException("Start index must be >= 0.");
        }
        if (rawString == null || number == null) {
            throw new NullPointerException();
        }
        this.start = start;
        this.rawString = rawString;
        this.number = number;
    }

    @UnsupportedAppUsage
    public Phonenumber.PhoneNumber number() {
        return this.number;
    }

    @UnsupportedAppUsage
    public int start() {
        return this.start;
    }

    @UnsupportedAppUsage
    public int end() {
        return this.start + this.rawString.length();
    }

    @UnsupportedAppUsage
    public String rawString() {
        return this.rawString;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.start, this.rawString, this.number});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PhoneNumberMatch)) {
            return false;
        }
        PhoneNumberMatch other = (PhoneNumberMatch)obj;
        return this.rawString.equals(other.rawString) && this.start == other.start && this.number.equals(other.number);
    }

    public String toString() {
        return "PhoneNumberMatch [" + this.start() + "," + this.end() + ") " + this.rawString;
    }
}

