/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.provider.DeviceConfig;
import android.util.ArrayMap;
import android.util.KeyValueListParser;
import android.view.textclassifier.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ConfigParser {
    private static final String TAG = "ConfigParser";
    static final boolean ENABLE_DEVICE_CONFIG = true;
    private static final String STRING_LIST_DELIMITER = ":";
    private final Supplier<String> mLegacySettingsSupplier;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<String, Object> mCache = new ArrayMap<String, Object>();
    @GuardedBy(value={"mLock"})
    private KeyValueListParser mSettingsParser;

    public ConfigParser(Supplier<String> legacySettingsSupplier) {
        this.mLegacySettingsSupplier = Preconditions.checkNotNull(legacySettingsSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyValueListParser getLegacySettings() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSettingsParser == null) {
                String legacySettings = this.mLegacySettingsSupplier.get();
                try {
                    this.mSettingsParser = new KeyValueListParser(',');
                    this.mSettingsParser.setString(legacySettings);
                }
                catch (IllegalArgumentException e) {
                    Log.w(TAG, "Bad text_classifier_constants: " + legacySettings);
                }
            }
            return this.mSettingsParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defaultValue) {
        Object object = this.mLock;
        synchronized (object) {
            Object cached = this.mCache.get(key);
            if (cached instanceof Boolean) {
                return (Boolean)cached;
            }
            boolean value = DeviceConfig.getBoolean("textclassifier", key, this.getLegacySettings().getBoolean(key, defaultValue));
            this.mCache.put(key, value);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defaultValue) {
        Object object = this.mLock;
        synchronized (object) {
            Object cached = this.mCache.get(key);
            if (cached instanceof Integer) {
                return (Integer)cached;
            }
            int value = DeviceConfig.getInt("textclassifier", key, this.getLegacySettings().getInt(key, defaultValue));
            this.mCache.put(key, value);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defaultValue) {
        Object object = this.mLock;
        synchronized (object) {
            Object cached = this.mCache.get(key);
            if (cached instanceof Float) {
                return ((Float)cached).floatValue();
            }
            float value = DeviceConfig.getFloat("textclassifier", key, this.getLegacySettings().getFloat(key, defaultValue));
            this.mCache.put(key, Float.valueOf(value));
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defaultValue) {
        Object object = this.mLock;
        synchronized (object) {
            Object cached = this.mCache.get(key);
            if (cached instanceof String) {
                return (String)cached;
            }
            String value = DeviceConfig.getString("textclassifier", key, this.getLegacySettings().getString(key, defaultValue));
            this.mCache.put(key, value);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStringList(String key, List<String> defaultValue) {
        Object object = this.mLock;
        synchronized (object) {
            Object cached = this.mCache.get(key);
            if (cached instanceof List) {
                List asList = (List)cached;
                if (asList.isEmpty()) {
                    return Collections.emptyList();
                }
                if (asList.get(0) instanceof String) {
                    return (List)cached;
                }
            }
            List<String> value = ConfigParser.getDeviceConfigStringList(key, this.getSettingsStringList(key, defaultValue));
            this.mCache.put(key, value);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getFloatArray(String key, float[] defaultValue) {
        Object object = this.mLock;
        synchronized (object) {
            Object cached = this.mCache.get(key);
            if (cached instanceof float[]) {
                return (float[])cached;
            }
            float[] value = ConfigParser.getDeviceConfigFloatArray(key, this.getSettingsFloatArray(key, defaultValue));
            this.mCache.put(key, value);
            return value;
        }
    }

    private List<String> getSettingsStringList(String key, List<String> defaultValue) {
        return ConfigParser.parse(this.mSettingsParser.getString(key, null), defaultValue);
    }

    private static List<String> getDeviceConfigStringList(String key, List<String> defaultValue) {
        return ConfigParser.parse(DeviceConfig.getString("textclassifier", key, null), defaultValue);
    }

    private static float[] getDeviceConfigFloatArray(String key, float[] defaultValue) {
        return ConfigParser.parse(DeviceConfig.getString("textclassifier", key, null), defaultValue);
    }

    private float[] getSettingsFloatArray(String key, float[] defaultValue) {
        return ConfigParser.parse(this.mSettingsParser.getString(key, null), defaultValue);
    }

    private static List<String> parse(String listStr, List<String> defaultValue) {
        if (listStr != null) {
            return Collections.unmodifiableList(Arrays.asList(listStr.split(STRING_LIST_DELIMITER)));
        }
        return defaultValue;
    }

    private static float[] parse(String arrayStr, float[] defaultValue) {
        if (arrayStr != null) {
            String[] split = arrayStr.split(STRING_LIST_DELIMITER);
            if (split.length != defaultValue.length) {
                return defaultValue;
            }
            float[] result = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                try {
                    result[i] = Float.parseFloat(split[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }
            return result;
        }
        return defaultValue;
    }
}

