/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.view.shadow.SpotShadowConfig;
import android.view.shadow.SpotShadowVertexCalculator;
import com.android.layoutlib.bridge.Bridge;

class SpotShadowTriangulator {
    private final SpotShadowConfig mShadowConfig;
    private float[][] mStrips;

    public SpotShadowTriangulator(SpotShadowConfig config) {
        this.mShadowConfig = config;
    }

    public void triangulate() {
        try {
            float[] lightSources = SpotShadowVertexCalculator.calculateLight(this.mShadowConfig.getLightRadius(), this.mShadowConfig.getLightCoord()[0], this.mShadowConfig.getLightCoord()[1], this.mShadowConfig.getLightCoord()[2]);
            this.mStrips = new float[2][];
            int[] sizes = SpotShadowVertexCalculator.getStripSizes(this.mShadowConfig.getPolyLength());
            for (int i = 0; i < sizes.length; ++i) {
                this.mStrips[i] = new float[3 * sizes[i]];
            }
            SpotShadowVertexCalculator.calculateShadow(lightSources, this.mShadowConfig.getPoly(), this.mShadowConfig.getPolyLength(), this.mShadowConfig.getShadowStrength(), this.mStrips);
        }
        catch (ArithmeticException | IndexOutOfBoundsException mathError) {
            Bridge.getLog().warning("info", "Arithmetic error while drawing spot shadow", (Object)mathError);
        }
        catch (Exception ex) {
            Bridge.getLog().warning("info", "Error while drawing shadow", (Object)ex);
        }
    }

    public boolean validate() {
        return this.mStrips != null && this.mStrips[0].length >= 9;
    }

    public float[][] getStrips() {
        return this.mStrips;
    }
}

