/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

import android.view.shadow.AmbientShadowConfig;

class AmbientShadowVertexCalculator {
    private final float[] mVertex;
    private final float[] mColor;
    private final int[] mIndex;
    private final AmbientShadowConfig mConfig;

    public AmbientShadowVertexCalculator(AmbientShadowConfig config) {
        this.mConfig = config;
        int size = this.mConfig.getPolygon().length / 3;
        this.mVertex = new float[size * 2 * 2];
        this.mColor = new float[size * 2 * 4];
        this.mIndex = new int[(size * 3 - 2) * 3];
    }

    public void generateVertex() {
        float[] polygon = this.mConfig.getPolygon();
        float cx = this.mConfig.getLightSourcePosition()[0];
        float cy = this.mConfig.getLightSourcePosition()[1];
        int polygonLength = polygon.length / 3;
        float opacity = 0.8f * (0.5f / (this.mConfig.getEdgeScale() / 10.0f));
        int trShift = 0;
        int i = 0;
        while (i < polygonLength) {
            int shift = i * 4;
            int colorShift = i * 8;
            int idxShift = i * 2;
            float px = polygon[3 * i + 0];
            float py = polygon[3 * i + 1];
            this.mVertex[shift + 0] = px;
            this.mVertex[shift + 1] = py;
            float h = polygon[3 * i + 2] * this.mConfig.getShadowBoundRatio();
            this.mVertex[shift + 2] = cx + h * (px - cx);
            this.mVertex[shift + 3] = cy + h * (py - cy);
            this.mColor[colorShift + 3] = opacity;
            this.mIndex[trShift + 0] = idxShift + 0;
            this.mIndex[trShift + 1] = idxShift + 1;
            this.mIndex[trShift + 2] = idxShift + 2;
            this.mIndex[trShift + 3] = idxShift + 1;
            this.mIndex[trShift + 4] = idxShift + 2;
            this.mIndex[trShift + 5] = idxShift + 3;
            ++i;
            trShift += 6;
        }
        this.mIndex[trShift - 1] = 1;
        this.mIndex[trShift - 2] = 0;
        this.mIndex[trShift - 4] = 0;
        i = 1;
        while (i < polygonLength - 1) {
            this.mIndex[trShift + 0] = 0;
            this.mIndex[trShift + 1] = 2 * i;
            this.mIndex[trShift + 2] = 2 * (i + 1);
            ++i;
            trShift += 3;
        }
    }

    public int[] getIndex() {
        return this.mIndex;
    }

    public float[] getVertex() {
        return this.mVertex;
    }

    public float[] getColor() {
        return this.mColor;
    }
}

