/*
 * Decompiled with CFR 0.152.
 */
package android.view.shadow;

class AmbientShadowConfig {
    private final float mEdgeScale;
    private final float mShadowBoundRatio;
    private final float mShadowStrength;
    private final float[] mPolygon;
    private float[] mLightSourcePosition;

    private AmbientShadowConfig(Builder builder) {
        this.mEdgeScale = builder.mEdgeScale;
        this.mShadowBoundRatio = builder.mShadowBoundRatio;
        this.mShadowStrength = builder.mShadowStrength;
        this.mPolygon = builder.mPolygon;
        this.mLightSourcePosition = builder.mLightSourcePosition;
    }

    public float getEdgeScale() {
        return this.mEdgeScale;
    }

    public float getShadowBoundRatio() {
        return this.mShadowBoundRatio;
    }

    public float getShadowStrength() {
        return this.mShadowStrength;
    }

    public float[] getPolygon() {
        return this.mPolygon;
    }

    public float[] getLightSourcePosition() {
        return this.mLightSourcePosition;
    }

    public static class Builder {
        private float mEdgeScale;
        private float mShadowBoundRatio;
        private float mShadowStrength;
        private float[] mPolygon;
        private float[] mLightSourcePosition;

        public Builder setEdgeScale(float edgeScale) {
            this.mEdgeScale = edgeScale;
            return this;
        }

        public Builder setShadowBoundRatio(float shadowBoundRatio) {
            this.mShadowBoundRatio = shadowBoundRatio;
            return this;
        }

        public Builder setShadowStrength(float shadowStrength) {
            this.mShadowStrength = shadowStrength;
            return this;
        }

        public Builder setPolygon(float[] polygon) {
            this.mPolygon = polygon;
            return this;
        }

        public Builder setLightSourcePosition(float x, float y) {
            this.mLightSourcePosition = new float[]{x, y};
            return this;
        }

        public AmbientShadowConfig build() {
            return new AmbientShadowConfig(this);
        }
    }
}

