/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.WindowManager;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.IContentCaptureManager;
import android.view.contentcapture.MainContentCaptureSession;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.internal.util.SyncResultReceiver;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Set;

public class ContentCaptureManager {
    private static final String TAG = ContentCaptureManager.class.getSimpleName();
    public static final int RESULT_CODE_OK = 0;
    public static final int RESULT_CODE_TRUE = 1;
    public static final int RESULT_CODE_FALSE = 2;
    public static final int RESULT_CODE_SECURITY_EXCEPTION = -1;
    private static final int SYNC_CALLS_TIMEOUT_MS = 5000;
    public static final String DEVICE_CONFIG_PROPERTY_SERVICE_EXPLICITLY_ENABLED = "service_explicitly_enabled";
    public static final String DEVICE_CONFIG_PROPERTY_MAX_BUFFER_SIZE = "max_buffer_size";
    public static final String DEVICE_CONFIG_PROPERTY_IDLE_FLUSH_FREQUENCY = "idle_flush_frequency";
    public static final String DEVICE_CONFIG_PROPERTY_TEXT_CHANGE_FLUSH_FREQUENCY = "text_change_flush_frequency";
    public static final String DEVICE_CONFIG_PROPERTY_LOG_HISTORY_SIZE = "log_history_size";
    public static final String DEVICE_CONFIG_PROPERTY_LOGGING_LEVEL = "logging_level";
    public static final String DEVICE_CONFIG_PROPERTY_IDLE_UNBIND_TIMEOUT = "idle_unbind_timeout";
    public static final int LOGGING_LEVEL_OFF = 0;
    public static final int LOGGING_LEVEL_DEBUG = 1;
    public static final int LOGGING_LEVEL_VERBOSE = 2;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 100;
    public static final int DEFAULT_IDLE_FLUSHING_FREQUENCY_MS = 5000;
    public static final int DEFAULT_TEXT_CHANGE_FLUSHING_FREQUENCY_MS = 1000;
    public static final int DEFAULT_LOG_HISTORY_SIZE = 10;
    private final Object mLock = new Object();
    private final Context mContext;
    private final IContentCaptureManager mService;
    final ContentCaptureOptions mOptions;
    @GuardedBy(value={"mLock"})
    private int mFlags;
    private final Handler mHandler;
    @GuardedBy(value={"mLock"})
    private MainContentCaptureSession mMainSession;

    public ContentCaptureManager(Context context, IContentCaptureManager service, ContentCaptureOptions options) {
        this.mContext = Preconditions.checkNotNull(context, "context cannot be null");
        this.mService = Preconditions.checkNotNull(service, "service cannot be null");
        this.mOptions = Preconditions.checkNotNull(options, "options cannot be null");
        ContentCaptureHelper.setLoggingLevel(this.mOptions.loggingLevel);
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "Constructor for " + context.getPackageName());
        }
        this.mHandler = Handler.createAsync(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainContentCaptureSession getMainContentCaptureSession() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMainSession == null) {
                this.mMainSession = new MainContentCaptureSession(this.mContext, this, this.mHandler, this.mService);
                if (ContentCaptureHelper.sVerbose) {
                    Log.v(TAG, "getMainContentCaptureSession(): created " + this.mMainSession);
                }
            }
            return this.mMainSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityCreated(IBinder applicationToken, ComponentName activityComponent) {
        if (this.mOptions.lite) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.getMainContentCaptureSession().start(applicationToken, activityComponent, this.mFlags);
        }
    }

    public void onActivityResumed() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().notifySessionLifecycle(true);
    }

    public void onActivityPaused() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().notifySessionLifecycle(false);
    }

    public void onActivityDestroyed() {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().destroy();
    }

    public void flush(int reason) {
        if (this.mOptions.lite) {
            return;
        }
        this.getMainContentCaptureSession().flush(reason);
    }

    public ComponentName getServiceComponentName() {
        if (!this.isContentCaptureEnabled() && !this.mOptions.lite) {
            return null;
        }
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            this.mService.getServiceComponentName(resultReceiver);
            return (ComponentName)resultReceiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static ComponentName getServiceSettingsComponentName() {
        IBinder binder = ServiceManager.checkService("content_capture");
        if (binder == null) {
            return null;
        }
        IContentCaptureManager service = IContentCaptureManager.Stub.asInterface(binder);
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            service.getServiceSettingsActivity(resultReceiver);
            int resultCode = resultReceiver.getIntResult();
            if (resultCode == -1) {
                throw new SecurityException(resultReceiver.getStringResult());
            }
            return (ComponentName)resultReceiver.getParcelableResult();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContentCaptureEnabled() {
        MainContentCaptureSession mainSession;
        if (this.mOptions.lite) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            mainSession = this.mMainSession;
        }
        return mainSession == null || !mainSession.isDisabled();
    }

    public Set<ContentCaptureCondition> getContentCaptureConditions() {
        if (!this.isContentCaptureEnabled() && !this.mOptions.lite) {
            return null;
        }
        SyncResultReceiver resultReceiver = this.syncRun(r -> this.mService.getContentCaptureConditions(this.mContext.getPackageName(), r));
        ArrayList result = resultReceiver.getParcelableListResult();
        return ContentCaptureHelper.toSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentCaptureEnabled(boolean enabled) {
        MainContentCaptureSession mainSession;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "setContentCaptureEnabled(): setting to " + enabled + " for " + this.mContext);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mFlags = enabled ? (this.mFlags &= 0xFFFFFFFE) : (this.mFlags |= 1);
            mainSession = this.mMainSession;
        }
        if (mainSession != null) {
            mainSession.setDisabled(!enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWindowAttributes(WindowManager.LayoutParams params) {
        MainContentCaptureSession mainSession;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "updateWindowAttributes(): window flags=" + params.flags);
        }
        boolean flagSecureEnabled = (params.flags & 0x2000) != 0;
        Object object = this.mLock;
        synchronized (object) {
            this.mFlags = flagSecureEnabled ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
            mainSession = this.mMainSession;
        }
        if (mainSession != null) {
            mainSession.setDisabled(flagSecureEnabled);
        }
    }

    @SystemApi
    public boolean isContentCaptureFeatureEnabled() {
        SyncResultReceiver resultReceiver = this.syncRun(r -> this.mService.isContentCaptureFeatureEnabled(r));
        int resultCode = resultReceiver.getIntResult();
        switch (resultCode) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        Log.wtf(TAG, "received invalid result: " + resultCode);
        return false;
    }

    public void removeData(DataRemovalRequest request) {
        Preconditions.checkNotNull(request);
        try {
            this.mService.removeData(request);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private SyncResultReceiver syncRun(MyRunnable r) {
        SyncResultReceiver resultReceiver = new SyncResultReceiver(5000);
        try {
            r.run(resultReceiver);
            int resultCode = resultReceiver.getIntResult();
            if (resultCode == -1) {
                throw new SecurityException(resultReceiver.getStringResult());
            }
            return resultReceiver;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.println("ContentCaptureManager");
        String prefix2 = prefix + "  ";
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix2);
            pw.print("isContentCaptureEnabled(): ");
            pw.println(this.isContentCaptureEnabled());
            pw.print(prefix2);
            pw.print("Debug: ");
            pw.print(ContentCaptureHelper.sDebug);
            pw.print(" Verbose: ");
            pw.println(ContentCaptureHelper.sVerbose);
            pw.print(prefix2);
            pw.print("Context: ");
            pw.println(this.mContext);
            pw.print(prefix2);
            pw.print("User: ");
            pw.println(this.mContext.getUserId());
            pw.print(prefix2);
            pw.print("Service: ");
            pw.println(this.mService);
            pw.print(prefix2);
            pw.print("Flags: ");
            pw.println(this.mFlags);
            pw.print(prefix2);
            pw.print("Options: ");
            this.mOptions.dumpShort(pw);
            pw.println();
            if (this.mMainSession != null) {
                String prefix3 = prefix2 + "  ";
                pw.print(prefix2);
                pw.println("Main session:");
                this.mMainSession.dump(prefix3, pw);
            } else {
                pw.print(prefix2);
                pw.println("No sessions");
            }
        }
    }

    private static interface MyRunnable {
        public void run(SyncResultReceiver var1) throws RemoteException;
    }

    public static interface ContentCaptureClient {
        public ComponentName contentCaptureClientGetComponentName();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoggingLevel {
    }
}

