/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import com.android.internal.view.SurfaceCallbackHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class _Original_SurfaceView
extends View
implements ViewRootImpl.WindowStoppedCallback {
    private static final String TAG = "SurfaceView";
    private static final boolean DEBUG = false;
    @UnsupportedAppUsage
    final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    final int[] mLocation = new int[2];
    @UnsupportedAppUsage
    final ReentrantLock mSurfaceLock = new ReentrantLock();
    @UnsupportedAppUsage
    final Surface mSurface = new Surface();
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mDrawingStopped = true;
    boolean mDrawFinished = false;
    final Rect mScreenRect = new Rect();
    SurfaceSession mSurfaceSession;
    SurfaceControl mSurfaceControl;
    SurfaceControl mDeferredDestroySurfaceControl;
    SurfaceControl mBackgroundControl;
    final Rect mTmpRect = new Rect();
    final Configuration mConfiguration = new Configuration();
    Paint mRoundedViewportPaint;
    int mSubLayer = -2;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mIsCreating = false;
    private volatile boolean mRtHandlingPositionUpdates = false;
    private final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

        @Override
        public void onScrollChanged() {
            _Original_SurfaceView.this.updateSurface();
        }
    };
    @UnsupportedAppUsage
    private final ViewTreeObserver.OnPreDrawListener mDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        @Override
        public boolean onPreDraw() {
            _Original_SurfaceView.this.mHaveFrame = _Original_SurfaceView.this.getWidth() > 0 && _Original_SurfaceView.this.getHeight() > 0;
            _Original_SurfaceView.this.updateSurface();
            return true;
        }
    };
    boolean mRequestedVisible = false;
    boolean mWindowVisibility = false;
    boolean mLastWindowVisibility = false;
    boolean mViewVisibility = false;
    boolean mWindowStopped = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mRequestedWidth = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mRequestedHeight = -1;
    @UnsupportedAppUsage
    int mRequestedFormat = 4;
    @UnsupportedAppUsage
    boolean mHaveFrame = false;
    boolean mSurfaceCreated = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    long mLastLockTime = 0L;
    boolean mVisible = false;
    int mWindowSpaceLeft = -1;
    int mWindowSpaceTop = -1;
    int mSurfaceWidth = -1;
    int mSurfaceHeight = -1;
    float mCornerRadius;
    @UnsupportedAppUsage
    int mFormat = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    final Rect mSurfaceFrame = new Rect();
    int mLastSurfaceWidth = -1;
    int mLastSurfaceHeight = -1;
    private CompatibilityInfo.Translator mTranslator;
    private boolean mGlobalListenersAdded;
    private boolean mAttachedToWindow;
    private int mSurfaceFlags = 4;
    private int mPendingReportDraws;
    private SurfaceControl.Transaction mRtTransaction = new SurfaceControl.Transaction();
    private Rect mRTLastReportedPosition = new Rect();
    private RenderNode.PositionUpdateListener mPositionListener = new RenderNode.PositionUpdateListener(){

        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            if (_Original_SurfaceView.this.mSurfaceControl == null) {
                return;
            }
            _Original_SurfaceView.this.mRtHandlingPositionUpdates = true;
            if (((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.left == left && ((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.top == top && ((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.right == right && ((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.bottom == bottom) {
                return;
            }
            try {
                _Original_SurfaceView.this.mRTLastReportedPosition.set(left, top, right, bottom);
                _Original_SurfaceView.this.setParentSpaceRectangle(_Original_SurfaceView.this.mRTLastReportedPosition, frameNumber);
            }
            catch (Exception ex) {
                Log.e(_Original_SurfaceView.TAG, "Exception from repositionChild", ex);
            }
        }

        @Override
        public void positionLost(long frameNumber) {
            _Original_SurfaceView.this.mRTLastReportedPosition.setEmpty();
            if (_Original_SurfaceView.this.mSurfaceControl == null) {
                return;
            }
            if (frameNumber > 0L) {
                ViewRootImpl viewRoot = _Original_SurfaceView.this.getViewRootImpl();
                _Original_SurfaceView.this.mRtTransaction.deferTransactionUntilSurface(_Original_SurfaceView.this.mSurfaceControl, viewRoot.mSurface, frameNumber);
            }
            _Original_SurfaceView.this.mRtTransaction.hide(_Original_SurfaceView.this.mSurfaceControl);
            _Original_SurfaceView.this.mRtTransaction.apply();
        }
    };
    @UnsupportedAppUsage
    private final SurfaceHolder mSurfaceHolder = new SurfaceHolder(){
        private static final String LOG_TAG = "SurfaceHolder";

        @Override
        public boolean isCreating() {
            return _Original_SurfaceView.this.mIsCreating;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                if (!_Original_SurfaceView.this.mCallbacks.contains(callback)) {
                    _Original_SurfaceView.this.mCallbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                _Original_SurfaceView.this.mCallbacks.remove(callback);
            }
        }

        @Override
        public void setFixedSize(int width, int height) {
            if (_Original_SurfaceView.this.mRequestedWidth != width || _Original_SurfaceView.this.mRequestedHeight != height) {
                _Original_SurfaceView.this.mRequestedWidth = width;
                _Original_SurfaceView.this.mRequestedHeight = height;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setSizeFromLayout() {
            if (_Original_SurfaceView.this.mRequestedWidth != -1 || _Original_SurfaceView.this.mRequestedHeight != -1) {
                _Original_SurfaceView.this.mRequestedHeight = -1;
                _Original_SurfaceView.this.mRequestedWidth = -1;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setFormat(int format) {
            if (format == -1) {
                format = 4;
            }
            _Original_SurfaceView.this.mRequestedFormat = format;
            if (_Original_SurfaceView.this.mSurfaceControl != null) {
                _Original_SurfaceView.this.updateSurface();
            }
        }

        @Override
        @Deprecated
        public void setType(int type) {
        }

        @Override
        public void setKeepScreenOn(boolean screenOn) {
            _Original_SurfaceView.this.runOnUiThread(() -> ((SurfaceView.4)this).lambda$setKeepScreenOn$0((boolean)screenOn));
        }

        @Override
        public Canvas lockCanvas() {
            return this.internalLockCanvas(null, false);
        }

        @Override
        public Canvas lockCanvas(Rect inOutDirty) {
            return this.internalLockCanvas(inOutDirty, false);
        }

        @Override
        public Canvas lockHardwareCanvas() {
            return this.internalLockCanvas(null, true);
        }

        private Canvas internalLockCanvas(Rect dirty, boolean hardware) {
            _Original_SurfaceView.this.mSurfaceLock.lock();
            Canvas c = null;
            if (!_Original_SurfaceView.this.mDrawingStopped && _Original_SurfaceView.this.mSurfaceControl != null) {
                try {
                    c = hardware ? _Original_SurfaceView.this.mSurface.lockHardwareCanvas() : _Original_SurfaceView.this.mSurface.lockCanvas(dirty);
                }
                catch (Exception e) {
                    Log.e(LOG_TAG, "Exception locking surface", e);
                }
            }
            if (c != null) {
                _Original_SurfaceView.this.mLastLockTime = SystemClock.uptimeMillis();
                return c;
            }
            long nextTime = _Original_SurfaceView.this.mLastLockTime + 100L;
            long now = SystemClock.uptimeMillis();
            if (nextTime > now) {
                try {
                    Thread.sleep(nextTime - now);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                now = SystemClock.uptimeMillis();
            }
            _Original_SurfaceView.this.mLastLockTime = now;
            _Original_SurfaceView.this.mSurfaceLock.unlock();
            return null;
        }

        @Override
        public void unlockCanvasAndPost(Canvas canvas) {
            _Original_SurfaceView.this.mSurface.unlockCanvasAndPost(canvas);
            _Original_SurfaceView.this.mSurfaceLock.unlock();
        }

        @Override
        public Surface getSurface() {
            return _Original_SurfaceView.this.mSurface;
        }

        @Override
        public Rect getSurfaceFrame() {
            return _Original_SurfaceView.this.mSurfaceFrame;
        }

        private /* synthetic */ void lambda$setKeepScreenOn$0(boolean screenOn) {
            _Original_SurfaceView.this.setKeepScreenOn(screenOn);
        }
    };

    public _Original_SurfaceView(Context context) {
        this(context, null);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mRenderNode.addPositionUpdateListener(this.mPositionListener);
        this.setWillNotDraw(true);
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    private void updateRequestedVisibility() {
        this.mRequestedVisible = this.mViewVisibility && this.mWindowVisibility && !this.mWindowStopped;
    }

    @Override
    public void windowStopped(boolean stopped) {
        this.mWindowStopped = stopped;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewRootImpl().addWindowStoppedCallback(this);
        this.mWindowStopped = false;
        this.mViewVisibility = this.getVisibility() == 0;
        this.updateRequestedVisibility();
        this.mAttachedToWindow = true;
        this.mParent.requestTransparentRegion(this);
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    public void setVisibility(int visibility) {
        boolean newRequestedVisible;
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        boolean bl = newRequestedVisible = this.mWindowVisibility && this.mViewVisibility && !this.mWindowStopped;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateSurface();
    }

    private void performDrawFinished() {
        if (this.mPendingReportDraws > 0) {
            this.mDrawFinished = true;
            if (this.mAttachedToWindow) {
                this.notifyDrawFinished();
                this.invalidate();
            }
        } else {
            Log.e(TAG, System.identityHashCode(this) + "finished drawing but no pending report draw (extra call to draw completion runnable?)");
        }
    }

    void notifyDrawFinished() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.pendingDrawFinished();
        }
        --this.mPendingReportDraws;
    }

    @Override
    protected void onDetachedFromWindow() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.removeWindowStoppedCallback(this);
        }
        this.mAttachedToWindow = false;
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        while (this.mPendingReportDraws > 0) {
            this.notifyDrawFinished();
        }
        this.mRequestedVisible = false;
        this.updateSurface();
        if (this.mSurfaceControl != null) {
            this.mSurfaceControl.remove();
        }
        this.mSurfaceControl = null;
        this.mHaveFrame = false;
        super.onDetachedFromWindow();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mRequestedWidth >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedWidth, widthMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, widthMeasureSpec);
        int height = this.mRequestedHeight >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedHeight, heightMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    @Override
    @UnsupportedAppUsage
    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateSurface();
        return result;
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        if (this.isAboveParent() || !this.mDrawFinished) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 0) {
            this.clearSurfaceViewPort(canvas);
        }
        super.draw(canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 128) {
            this.clearSurfaceViewPort(canvas);
        }
        super.dispatchDraw(canvas);
    }

    private void clearSurfaceViewPort(Canvas canvas) {
        if (this.mCornerRadius > 0.0f) {
            canvas.getClipBounds(this.mTmpRect);
            canvas.drawRoundRect(this.mTmpRect.left, this.mTmpRect.top, this.mTmpRect.right, this.mTmpRect.bottom, this.mCornerRadius, this.mCornerRadius, this.mRoundedViewportPaint);
        } else {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (this.mCornerRadius > 0.0f && this.mRoundedViewportPaint == null) {
            this.mRoundedViewportPaint = new Paint(1);
            this.mRoundedViewportPaint.setBlendMode(BlendMode.CLEAR);
            this.mRoundedViewportPaint.setColor(0);
        }
        this.invalidate();
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mSubLayer = isMediaOverlay ? -1 : -2;
    }

    public void setZOrderOnTop(boolean onTop) {
        this.mSubLayer = onTop ? 1 : -2;
    }

    public void setSecure(boolean isSecure) {
        this.mSurfaceFlags = isSecure ? (this.mSurfaceFlags |= 0x80) : (this.mSurfaceFlags &= 0xFFFFFF7F);
    }

    private void updateOpaqueFlag() {
        this.mSurfaceFlags = !PixelFormat.formatHasAlpha(this.mRequestedFormat) ? (this.mSurfaceFlags |= 0x400) : (this.mSurfaceFlags &= 0xFFFFFBFF);
    }

    private Rect getParentSurfaceInsets() {
        ViewRootImpl root = this.getViewRootImpl();
        if (root == null) {
            return null;
        }
        return root.mWindowAttributes.surfaceInsets;
    }

    private void updateBackgroundVisibilityInTransaction(SurfaceControl viewRoot) {
        if (this.mBackgroundControl == null) {
            return;
        }
        if (this.mSubLayer < 0 && (this.mSurfaceFlags & 0x400) != 0) {
            this.mBackgroundControl.show();
            this.mBackgroundControl.setRelativeLayer(viewRoot, Integer.MIN_VALUE);
        } else {
            this.mBackgroundControl.hide();
        }
    }

    private void releaseSurfaces() {
        if (this.mSurfaceControl != null) {
            this.mSurfaceControl.remove();
            this.mSurfaceControl = null;
        }
        if (this.mBackgroundControl != null) {
            this.mBackgroundControl.remove();
            this.mBackgroundControl = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSurface() {
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null || viewRoot.mSurface == null || !viewRoot.mSurface.isValid()) {
            return;
        }
        this.mTranslator = viewRoot.mTranslator;
        if (this.mTranslator != null) {
            this.mSurface.setCompatibilityTranslator(this.mTranslator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean creating = (this.mSurfaceControl == null || formatChanged || visibleChanged) && this.mRequestedVisible;
        boolean sizeChanged = this.mSurfaceWidth != myWidth || this.mSurfaceHeight != myHeight;
        boolean windowVisibleChanged = this.mWindowVisibility != this.mLastWindowVisibility;
        boolean redrawNeeded = false;
        if (creating || formatChanged || sizeChanged || visibleChanged || windowVisibleChanged) {
            this.getLocationInWindow(this.mLocation);
            try {
                boolean visible = this.mVisible = this.mRequestedVisible;
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mSurfaceWidth = myWidth;
                this.mSurfaceHeight = myHeight;
                this.mFormat = this.mRequestedFormat;
                this.mLastWindowVisibility = this.mWindowVisibility;
                this.mScreenRect.left = this.mWindowSpaceLeft;
                this.mScreenRect.top = this.mWindowSpaceTop;
                this.mScreenRect.right = this.mWindowSpaceLeft + this.getWidth();
                this.mScreenRect.bottom = this.mWindowSpaceTop + this.getHeight();
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                Rect surfaceInsets = this.getParentSurfaceInsets();
                this.mScreenRect.offset(surfaceInsets.left, surfaceInsets.top);
                if (creating) {
                    viewRoot.createBoundsSurface(this.mSubLayer);
                    this.mSurfaceSession = new SurfaceSession();
                    this.mDeferredDestroySurfaceControl = this.mSurfaceControl;
                    this.updateOpaqueFlag();
                    String name = "SurfaceView - " + viewRoot.getTitle().toString();
                    this.mSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setName(name).setOpaque((this.mSurfaceFlags & 0x400) != 0).setBufferSize(this.mSurfaceWidth, this.mSurfaceHeight).setFormat(this.mFormat).setParent(viewRoot.getSurfaceControl()).setFlags(this.mSurfaceFlags).build();
                    this.mBackgroundControl = new SurfaceControl.Builder(this.mSurfaceSession).setName("Background for -" + name).setOpaque(true).setColorLayer().setParent(this.mSurfaceControl).build();
                } else if (this.mSurfaceControl == null) {
                    return;
                }
                boolean realSizeChanged = false;
                this.mSurfaceLock.lock();
                try {
                    this.mDrawingStopped = !visible;
                    SurfaceControl.openTransaction();
                    try {
                        this.mSurfaceControl.setLayer(this.mSubLayer);
                        if (this.mViewVisibility) {
                            this.mSurfaceControl.show();
                        } else {
                            this.mSurfaceControl.hide();
                        }
                        this.updateBackgroundVisibilityInTransaction(viewRoot.getSurfaceControl());
                        if (sizeChanged || creating || !this.mRtHandlingPositionUpdates) {
                            this.mSurfaceControl.setPosition(this.mScreenRect.left, this.mScreenRect.top);
                            this.mSurfaceControl.setMatrix((float)this.mScreenRect.width() / (float)this.mSurfaceWidth, 0.0f, 0.0f, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
                            this.mSurfaceControl.setWindowCrop(this.mSurfaceWidth, this.mSurfaceHeight);
                        }
                        this.mSurfaceControl.setCornerRadius(this.mCornerRadius);
                        if (sizeChanged && !creating) {
                            this.mSurfaceControl.setBufferSize(this.mSurfaceWidth, this.mSurfaceHeight);
                        }
                    }
                    finally {
                        SurfaceControl.closeTransaction();
                    }
                    if (sizeChanged || creating) {
                        redrawNeeded = true;
                    }
                    this.mSurfaceFrame.left = 0;
                    this.mSurfaceFrame.top = 0;
                    if (this.mTranslator == null) {
                        this.mSurfaceFrame.right = this.mSurfaceWidth;
                        this.mSurfaceFrame.bottom = this.mSurfaceHeight;
                    } else {
                        float appInvertedScale = this.mTranslator.applicationInvertedScale;
                        this.mSurfaceFrame.right = (int)((float)this.mSurfaceWidth * appInvertedScale + 0.5f);
                        this.mSurfaceFrame.bottom = (int)((float)this.mSurfaceHeight * appInvertedScale + 0.5f);
                    }
                    int surfaceWidth = this.mSurfaceFrame.right;
                    int surfaceHeight = this.mSurfaceFrame.bottom;
                    realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
                    this.mLastSurfaceWidth = surfaceWidth;
                    this.mLastSurfaceHeight = surfaceHeight;
                }
                finally {
                    this.mSurfaceLock.unlock();
                }
                try {
                    redrawNeeded |= visible && !this.mDrawFinished;
                    SurfaceHolder.Callback[] callbacks = null;
                    boolean surfaceChanged = creating;
                    if (this.mSurfaceCreated && (surfaceChanged || !visible && visibleChanged)) {
                        this.mSurfaceCreated = false;
                        if (this.mSurface.isValid()) {
                            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                                c.surfaceDestroyed(this.mSurfaceHolder);
                            }
                            if (this.mSurface.isValid()) {
                                this.mSurface.forceScopedDisconnect();
                            }
                        }
                    }
                    if (creating) {
                        this.mSurface.copyFrom(this.mSurfaceControl);
                    }
                    if (sizeChanged && this.getContext().getApplicationInfo().targetSdkVersion < 26) {
                        this.mSurface.createFrom(this.mSurfaceControl);
                    }
                    if (visible && this.mSurface.isValid()) {
                        if (!this.mSurfaceCreated && (surfaceChanged || visibleChanged)) {
                            this.mSurfaceCreated = true;
                            this.mIsCreating = true;
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        if (creating || formatChanged || sizeChanged || visibleChanged || realSizeChanged) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                            }
                        }
                        if (redrawNeeded) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            ++this.mPendingReportDraws;
                            viewRoot.drawPending();
                            SurfaceCallbackHelper sch = new SurfaceCallbackHelper((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, onDrawFinished(), ()V)((SurfaceView)((Object)this)));
                            sch.dispatchSurfaceRedrawNeededAsync(this.mSurfaceHolder, callbacks);
                        }
                    }
                }
                finally {
                    this.mIsCreating = false;
                    if (this.mSurfaceControl != null && !this.mSurfaceCreated) {
                        this.mSurface.release();
                        this.releaseSurfaces();
                    }
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Exception configuring surface", ex);
            }
        } else {
            boolean layoutSizeChanged;
            this.getLocationInSurface(this.mLocation);
            boolean positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
            boolean bl = layoutSizeChanged = this.getWidth() != this.mScreenRect.width() || this.getHeight() != this.mScreenRect.height();
            if (positionChanged || layoutSizeChanged) {
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mLocation[0] = this.getWidth();
                this.mLocation[1] = this.getHeight();
                this.mScreenRect.set(this.mWindowSpaceLeft, this.mWindowSpaceTop, this.mWindowSpaceLeft + this.mLocation[0], this.mWindowSpaceTop + this.mLocation[1]);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                if (this.mSurfaceControl == null) {
                    return;
                }
                if (!this.isHardwareAccelerated() || !this.mRtHandlingPositionUpdates) {
                    try {
                        this.setParentSpaceRectangle(this.mScreenRect, -1L);
                    }
                    catch (Exception ex) {
                        Log.e(TAG, "Exception configuring surface", ex);
                    }
                }
            }
        }
    }

    private void onDrawFinished() {
        if (this.mDeferredDestroySurfaceControl != null) {
            this.mDeferredDestroySurfaceControl.remove();
            this.mDeferredDestroySurfaceControl = null;
        }
        this.runOnUiThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$onDrawFinished$0(), ()V)((SurfaceView)((Object)this)));
    }

    protected void applyChildSurfaceTransaction_renderWorker(SurfaceControl.Transaction t, Surface viewRootSurface, long nextViewRootFrameNumber) {
    }

    private void applySurfaceTransforms(SurfaceControl surface, Rect position, long frameNumber) {
        if (frameNumber > 0L) {
            ViewRootImpl viewRoot = this.getViewRootImpl();
            this.mRtTransaction.deferTransactionUntilSurface(surface, viewRoot.mSurface, frameNumber);
        }
        this.mRtTransaction.setPosition(surface, position.left, position.top);
        this.mRtTransaction.setMatrix(surface, (float)position.width() / (float)this.mSurfaceWidth, 0.0f, 0.0f, (float)position.height() / (float)this.mSurfaceHeight);
        if (this.mViewVisibility) {
            this.mRtTransaction.show(surface);
        }
    }

    private void setParentSpaceRectangle(Rect position, long frameNumber) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        this.applySurfaceTransforms(this.mSurfaceControl, position, frameNumber);
        this.applyChildSurfaceTransaction_renderWorker(this.mRtTransaction, viewRoot.mSurface, frameNumber);
        this.mRtTransaction.apply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        SurfaceHolder.Callback[] callbacks;
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbacks);
        }
        return callbacks;
    }

    private void runOnUiThread(Runnable runnable) {
        Handler handler = this.getHandler();
        if (handler != null && handler.getLooper() != Looper.myLooper()) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @UnsupportedAppUsage
    public boolean isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    private boolean isAboveParent() {
        return this.mSubLayer >= 0;
    }

    public void setResizeBackgroundColor(int bgColor) {
        if (this.mBackgroundControl == null) {
            return;
        }
        float[] colorComponents = new float[]{(float)Color.red(bgColor) / 255.0f, (float)Color.green(bgColor) / 255.0f, (float)Color.blue(bgColor) / 255.0f};
        SurfaceControl.openTransaction();
        try {
            this.mBackgroundControl.setColor(colorComponents);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    private /* synthetic */ void lambda$onDrawFinished$0() {
        this.performDrawFinished();
    }
}

