/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Region;
import android.os.IBinder;
import android.view.IWindow;
import android.view.InputApplicationHandle;
import android.view.SurfaceControl;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

public class InputWindowHandle {
    private long ptr;
    public final InputApplicationHandle inputApplicationHandle;
    public final IWindow clientWindow;
    public IBinder token;
    public String name;
    public int layoutParamsFlags;
    public int layoutParamsType;
    public long dispatchingTimeoutNanos;
    public int frameLeft;
    public int frameTop;
    public int frameRight;
    public int frameBottom;
    public int surfaceInset;
    public float scaleFactor;
    public final Region touchableRegion = new Region();
    public boolean visible;
    public boolean canReceiveKeys;
    public boolean hasFocus;
    public boolean hasWallpaper;
    public boolean paused;
    public int layer;
    public int ownerPid;
    public int ownerUid;
    public int inputFeatures;
    public int displayId;
    public int portalToDisplayId = -1;
    public WeakReference<IBinder> touchableRegionCropHandle = new WeakReference<Object>(null);
    public boolean replaceTouchableRegionWithCrop;

    private void nativeDispose() {
        OverrideMethod.invokeV("android.view.InputWindowHandle#nativeDispose()V", true, this);
    }

    public InputWindowHandle(InputApplicationHandle inputApplicationHandle, IWindow clientWindow, int displayId) {
        this.inputApplicationHandle = inputApplicationHandle;
        this.clientWindow = clientWindow;
        this.displayId = displayId;
    }

    public String toString() {
        return (this.name != null ? this.name : "") + ", layer=" + this.layer + ", frame=[" + this.frameLeft + "," + this.frameTop + "," + this.frameRight + "," + this.frameBottom + "]" + ", touchableRegion=" + this.touchableRegion + ", visible=" + this.visible;
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDispose();
        }
        finally {
            super.finalize();
        }
    }

    public void replaceTouchableRegionWithCrop(SurfaceControl bounds) {
        this.setTouchableRegionCrop(bounds);
        this.replaceTouchableRegionWithCrop = true;
    }

    public void setTouchableRegionCrop(SurfaceControl bounds) {
        if (bounds != null) {
            this.touchableRegionCropHandle = new WeakReference<IBinder>(bounds.getHandle());
        }
    }
}

