/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.text.TextUtils;
import android.view.InsetsController;
import android.view.InsetsSourceConsumer;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.function.Supplier;

public class ImeInsetsSourceConsumer
extends InsetsSourceConsumer {
    private EditorInfo mFocusedEditor;
    private EditorInfo mPreRenderedEditor;
    private boolean mShowOnNextImeRender;
    private boolean mHasWindowFocus;

    public ImeInsetsSourceConsumer(InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        super(10, state, transactionSupplier, controller);
    }

    public void onPreRendered(EditorInfo info) {
        this.mPreRenderedEditor = info;
        if (this.mShowOnNextImeRender) {
            this.mShowOnNextImeRender = false;
            if (this.isServedEditorRendered()) {
                this.applyImeVisibility(true);
            }
        }
    }

    public void onServedEditorChanged(EditorInfo info) {
        if (this.isDummyOrEmptyEditor(info)) {
            this.mShowOnNextImeRender = false;
        }
        this.mFocusedEditor = info;
    }

    public void applyImeVisibility(boolean setVisible) {
        if (!this.mHasWindowFocus) {
            return;
        }
        this.mController.applyImeVisibility(setVisible);
    }

    @Override
    public void onWindowFocusGained() {
        this.mHasWindowFocus = true;
        this.getImm().registerImeConsumer(this);
    }

    @Override
    public void onWindowFocusLost() {
        this.mHasWindowFocus = false;
        this.getImm().unregisterImeConsumer(this);
    }

    @Override
    int requestShow(boolean fromIme) {
        if (fromIme) {
            return 0;
        }
        return this.getImm().requestImeShow(null) ? 1 : 2;
    }

    @Override
    void notifyHidden() {
        this.getImm().notifyImeHidden();
    }

    private boolean isDummyOrEmptyEditor(EditorInfo info) {
        return info == null || info.fieldId <= 0 && info.inputType <= 0;
    }

    private boolean isServedEditorRendered() {
        if (this.mFocusedEditor == null || this.mPreRenderedEditor == null || this.isDummyOrEmptyEditor(this.mFocusedEditor) || this.isDummyOrEmptyEditor(this.mPreRenderedEditor)) {
            return false;
        }
        return ImeInsetsSourceConsumer.areEditorsSimilar(this.mFocusedEditor, this.mPreRenderedEditor);
    }

    @VisibleForTesting
    public static boolean areEditorsSimilar(EditorInfo info1, EditorInfo info2) {
        boolean areOptionsSimilar = info1.imeOptions == info2.imeOptions && info1.inputType == info2.inputType && TextUtils.equals(info1.packageName, info2.packageName);
        if (!(areOptionsSimilar &= info1.privateImeOptions != null ? info1.privateImeOptions.equals(info2.privateImeOptions) : true)) {
            return false;
        }
        if (info1.extras == null && info2.extras == null || info1.extras == info2.extras) {
            return true;
        }
        if (info1.extras == null && info2.extras != null || info1.extras == null && info2.extras != null) {
            return false;
        }
        if (info1.extras.hashCode() == info2.extras.hashCode() || info1.extras.equals(info1)) {
            return true;
        }
        if (info1.extras.size() != info2.extras.size()) {
            return false;
        }
        if (info1.extras.toString().equals(info2.extras.toString())) {
            return true;
        }
        Parcel parcel1 = Parcel.obtain();
        info1.extras.writeToParcel(parcel1, 0);
        parcel1.setDataPosition(0);
        Parcel parcel2 = Parcel.obtain();
        info2.extras.writeToParcel(parcel2, 0);
        parcel2.setDataPosition(0);
        return Arrays.equals(parcel1.createByteArray(), parcel2.createByteArray());
    }

    private InputMethodManager getImm() {
        return this.mController.getViewRoot().mContext.getSystemService(InputMethodManager.class);
    }
}

