/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;

public abstract class DisplayAddress
implements Parcelable {
    public static Physical fromPhysicalDisplayId(long physicalDisplayId) {
        return new Physical(physicalDisplayId);
    }

    public static Network fromMacAddress(String macAddress) {
        return new Network(macAddress);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Network
    extends DisplayAddress {
        private final String mMacAddress;
        public static final Parcelable.Creator<Network> CREATOR = new Parcelable.Creator<Network>(){

            @Override
            public Network createFromParcel(Parcel in) {
                return new Network(in.readString());
            }

            public Network[] newArray(int size) {
                return new Network[size];
            }
        };

        public boolean equals(Object other) {
            return other instanceof Network && this.mMacAddress.equals(((Network)other).mMacAddress);
        }

        public String toString() {
            return this.mMacAddress;
        }

        public int hashCode() {
            return this.mMacAddress.hashCode();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mMacAddress);
        }

        private Network(String macAddress) {
            this.mMacAddress = macAddress;
        }
    }

    public static class Physical
    extends DisplayAddress {
        private static final long UNKNOWN_MODEL = 0L;
        private static final int MODEL_SHIFT = 8;
        private static final int PORT_MASK = 255;
        private final long mPhysicalDisplayId;
        public static final Parcelable.Creator<Physical> CREATOR = new Parcelable.Creator<Physical>(){

            @Override
            public Physical createFromParcel(Parcel in) {
                return new Physical(in.readLong());
            }

            public Physical[] newArray(int size) {
                return new Physical[size];
            }
        };

        public byte getPort() {
            return (byte)this.mPhysicalDisplayId;
        }

        public Long getModel() {
            long model = this.mPhysicalDisplayId >>> 8;
            return model == 0L ? null : Long.valueOf(model);
        }

        public boolean equals(Object other) {
            return other instanceof Physical && this.mPhysicalDisplayId == ((Physical)other).mPhysicalDisplayId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{").append("port=").append(this.getPort() & 0xFF);
            Long model = this.getModel();
            if (model != null) {
                builder.append(", model=0x").append(Long.toHexString(model));
            }
            return builder.append("}").toString();
        }

        public int hashCode() {
            return Long.hashCode(this.mPhysicalDisplayId);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeLong(this.mPhysicalDisplayId);
        }

        private Physical(long physicalDisplayId) {
            this.mPhysicalDisplayId = physicalDisplayId;
        }
    }
}

