/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.IBinder;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.concurrent.Executor;

public abstract class CompositionSamplingListener {
    private final long mNativeListener;
    private final Executor mExecutor;

    public CompositionSamplingListener(Executor executor) {
        this.mExecutor = executor;
        this.mNativeListener = CompositionSamplingListener.nativeCreate(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mNativeListener != 0L) {
                CompositionSamplingListener.unregister(this);
                CompositionSamplingListener.nativeDestroy(this.mNativeListener);
            }
        }
        finally {
            super.finalize();
        }
    }

    public abstract void onSampleCollected(float var1);

    public static void register(CompositionSamplingListener listener, int displayId, IBinder stopLayer, Rect samplingArea) {
        Preconditions.checkArgument(displayId == 0, "default display only for now");
        CompositionSamplingListener.nativeRegister(listener.mNativeListener, stopLayer, samplingArea.left, samplingArea.top, samplingArea.right, samplingArea.bottom);
    }

    public static void unregister(CompositionSamplingListener listener) {
        CompositionSamplingListener.nativeUnregister(listener.mNativeListener);
    }

    private static void dispatchOnSampleCollected(CompositionSamplingListener listener, float medianLuma) {
        listener.mExecutor.execute(() -> listener.onSampleCollected(medianLuma));
    }

    private static long nativeCreate(CompositionSamplingListener compositionSamplingListener) {
        return OverrideMethod.invokeL("android.view.CompositionSamplingListener#nativeCreate(Landroid/view/CompositionSamplingListener;)J", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.CompositionSamplingListener#nativeDestroy(J)V", true, null);
    }

    private static void nativeRegister(long l, IBinder iBinder, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.CompositionSamplingListener#nativeRegister(JLandroid/os/IBinder;IIII)V", true, null);
    }

    private static void nativeUnregister(long l) {
        OverrideMethod.invokeV("android.view.CompositionSamplingListener#nativeUnregister(J)V", true, null);
    }
}

