/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import android.os.Trace;
import android.os._Original_Build;
import android.util.Pair;
import android.util.Slog;
import java.util.ArrayDeque;
import java.util.Deque;

public class TimingsTraceLog {
    private static final boolean DEBUG_BOOT_TIME = !_Original_Build.IS_USER;
    private final Deque<Pair<String, Long>> mStartTimes = DEBUG_BOOT_TIME ? new ArrayDeque() : null;
    private final String mTag;
    private long mTraceTag;
    private long mThreadId;

    public TimingsTraceLog(String tag, long traceTag) {
        this.mTag = tag;
        this.mTraceTag = traceTag;
        this.mThreadId = Thread.currentThread().getId();
    }

    public void traceBegin(String name) {
        this.assertSameThread();
        Trace.traceBegin(this.mTraceTag, name);
        if (DEBUG_BOOT_TIME) {
            this.mStartTimes.push(Pair.create(name, SystemClock.elapsedRealtime()));
        }
    }

    public void traceEnd() {
        this.assertSameThread();
        Trace.traceEnd(this.mTraceTag);
        if (!DEBUG_BOOT_TIME) {
            return;
        }
        if (this.mStartTimes.peek() == null) {
            Slog.w(this.mTag, "traceEnd called more times than traceBegin");
            return;
        }
        Pair<String, Long> event = this.mStartTimes.pop();
        this.logDuration((String)event.first, SystemClock.elapsedRealtime() - (Long)event.second);
    }

    private void assertSameThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread.getId() != this.mThreadId) {
            throw new IllegalStateException("Instance of TimingsTraceLog can only be called from the thread it was created on (tid: " + this.mThreadId + "), but was from " + currentThread.getName() + " (tid: " + currentThread.getId() + ")");
        }
    }

    public void logDuration(String name, long timeMs) {
        Slog.d(this.mTag, name + " took to complete: " + timeMs + "ms");
    }
}

