/*
 * Decompiled with CFR 0.152.
 */
package android.util;

public class Half
extends Number
implements Comparable<Half> {
    public static final int SIZE = 16;
    public static final short EPSILON = 5120;
    public static final int MAX_EXPONENT = 15;
    public static final int MIN_EXPONENT = -14;
    public static final short LOWEST_VALUE = -1025;
    public static final short MAX_VALUE = 31743;
    public static final short MIN_NORMAL = 1024;
    public static final short MIN_VALUE = 1;
    public static final short NaN = 32256;
    public static final short NEGATIVE_INFINITY = -1024;
    public static final short NEGATIVE_ZERO = Short.MIN_VALUE;
    public static final short POSITIVE_INFINITY = 31744;
    public static final short POSITIVE_ZERO = 0;
    private static final int FP16_SIGN_SHIFT = 15;
    private static final int FP16_SIGN_MASK = 32768;
    private static final int FP16_EXPONENT_SHIFT = 10;
    private static final int FP16_EXPONENT_MASK = 31;
    private static final int FP16_SIGNIFICAND_MASK = 1023;
    private static final int FP16_EXPONENT_BIAS = 15;
    private static final int FP16_COMBINED = Short.MAX_VALUE;
    private static final int FP16_EXPONENT_MAX = 31744;
    private static final int FP32_SIGN_SHIFT = 31;
    private static final int FP32_EXPONENT_SHIFT = 23;
    private static final int FP32_EXPONENT_MASK = 255;
    private static final int FP32_SIGNIFICAND_MASK = 0x7FFFFF;
    private static final int FP32_EXPONENT_BIAS = 127;
    private static final int FP32_QNAN_MASK = 0x400000;
    private static final int FP32_DENORMAL_MAGIC = 0x3F000000;
    private static final float FP32_DENORMAL_FLOAT = Float.intBitsToFloat(0x3F000000);
    private final short mValue;

    public Half(short value) {
        this.mValue = value;
    }

    public Half(float value) {
        this.mValue = Half.toHalf(value);
    }

    public Half(double value) {
        this.mValue = Half.toHalf((float)value);
    }

    public Half(String value) throws NumberFormatException {
        this.mValue = Half.toHalf(Float.parseFloat(value));
    }

    public short halfValue() {
        return this.mValue;
    }

    @Override
    public byte byteValue() {
        return (byte)Half.toFloat(this.mValue);
    }

    @Override
    public short shortValue() {
        return (short)Half.toFloat(this.mValue);
    }

    @Override
    public int intValue() {
        return (int)Half.toFloat(this.mValue);
    }

    @Override
    public long longValue() {
        return (long)Half.toFloat(this.mValue);
    }

    @Override
    public float floatValue() {
        return Half.toFloat(this.mValue);
    }

    @Override
    public double doubleValue() {
        return Half.toFloat(this.mValue);
    }

    public boolean isNaN() {
        return Half.isNaN(this.mValue);
    }

    public boolean equals(Object o) {
        return o instanceof Half && Half.halfToIntBits(((Half)o).mValue) == Half.halfToIntBits(this.mValue);
    }

    public int hashCode() {
        return Half.hashCode(this.mValue);
    }

    public String toString() {
        return Half.toString(this.mValue);
    }

    @Override
    public int compareTo(Half h) {
        return Half.compare(this.mValue, h.mValue);
    }

    public static int hashCode(short h) {
        return Half.halfToIntBits(h);
    }

    public static int compare(short x, short y) {
        int yBits;
        if (Half.less(x, y)) {
            return -1;
        }
        if (Half.greater(x, y)) {
            return 1;
        }
        int xBits = (x & Short.MAX_VALUE) > 31744 ? 32256 : (int)x;
        int n = yBits = (y & Short.MAX_VALUE) > 31744 ? 32256 : (int)y;
        return xBits == yBits ? 0 : (xBits < yBits ? -1 : 1);
    }

    public static short halfToShortBits(short h) {
        return (h & Short.MAX_VALUE) > 31744 ? (short)32256 : (short)h;
    }

    public static int halfToIntBits(short h) {
        return (h & Short.MAX_VALUE) > 31744 ? 32256 : h & 0xFFFF;
    }

    public static int halfToRawIntBits(short h) {
        return h & 0xFFFF;
    }

    public static short intBitsToHalf(int bits) {
        return (short)(bits & 0xFFFF);
    }

    public static short copySign(short magnitude, short sign) {
        return (short)(sign & 0x8000 | magnitude & Short.MAX_VALUE);
    }

    public static short abs(short h) {
        return (short)(h & Short.MAX_VALUE);
    }

    public static short round(short h) {
        int bits = h & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & (e >= 14336 ? 65535 : 0);
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result += 1 << e - 1;
            result &= ~mask;
        }
        return (short)result;
    }

    public static short ceil(short h) {
        int bits = h & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & -(~(bits >> 15) & (e != 0 ? 1 : 0));
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result += mask & (bits >> 15) - 1;
            result &= ~mask;
        }
        return (short)result;
    }

    public static short floor(short h) {
        int bits = h & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
            result |= 0x3C00 & (bits > 32768 ? 65535 : 0);
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result += mask & -(bits >> 15);
            result &= ~mask;
        }
        return (short)result;
    }

    public static short trunc(short h) {
        int bits = h & 0xFFFF;
        int e = bits & Short.MAX_VALUE;
        int result = bits;
        if (e < 15360) {
            result &= 0x8000;
        } else if (e < 25600) {
            e = 25 - (e >> 10);
            int mask = (1 << e) - 1;
            result &= ~mask;
        }
        return (short)result;
    }

    public static short min(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return 32256;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return 32256;
        }
        if ((x & Short.MAX_VALUE) == 0 && (y & Short.MAX_VALUE) == 0) {
            return (x & 0x8000) != 0 ? x : y;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) < ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF) ? x : y;
    }

    public static short max(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return 32256;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return 32256;
        }
        if ((x & Short.MAX_VALUE) == 0 && (y & Short.MAX_VALUE) == 0) {
            return (x & 0x8000) != 0 ? y : x;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) > ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF) ? x : y;
    }

    public static boolean less(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return false;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) < ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean lessEquals(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return false;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) <= ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean greater(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return false;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) > ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean greaterEquals(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return false;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return false;
        }
        return ((x & 0x8000) != 0 ? 32768 - (x & 0xFFFF) : x & 0xFFFF) >= ((y & 0x8000) != 0 ? 32768 - (y & 0xFFFF) : y & 0xFFFF);
    }

    public static boolean equals(short x, short y) {
        if ((x & Short.MAX_VALUE) > 31744) {
            return false;
        }
        if ((y & Short.MAX_VALUE) > 31744) {
            return false;
        }
        return x == y || ((x | y) & Short.MAX_VALUE) == 0;
    }

    public static int getSign(short h) {
        return (h & 0x8000) == 0 ? 1 : -1;
    }

    public static int getExponent(short h) {
        return (h >>> 10 & 0x1F) - 15;
    }

    public static int getSignificand(short h) {
        return h & 0x3FF;
    }

    public static boolean isInfinite(short h) {
        return (h & Short.MAX_VALUE) == 31744;
    }

    public static boolean isNaN(short h) {
        return (h & Short.MAX_VALUE) > 31744;
    }

    public static boolean isNormalized(short h) {
        return (h & 0x7C00) != 0 && (h & 0x7C00) != 31744;
    }

    public static float toFloat(short h) {
        int bits = h & 0xFFFF;
        int s = bits & 0x8000;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        int outE = 0;
        int outM = 0;
        if (e == 0) {
            if (m != 0) {
                float o = Float.intBitsToFloat(0x3F000000 + m);
                return s == 0 ? o : -(o -= FP32_DENORMAL_FLOAT);
            }
        } else {
            outM = m << 13;
            if (e == 31) {
                outE = 255;
                if (outM != 0) {
                    outM |= 0x400000;
                }
            } else {
                outE = e - 15 + 127;
            }
        }
        int out = s << 16 | outE << 23 | outM;
        return Float.intBitsToFloat(out);
    }

    public static short toHalf(float f) {
        int bits = Float.floatToRawIntBits(f);
        int s = bits >>> 31;
        int e = bits >>> 23 & 0xFF;
        int m = bits & 0x7FFFFF;
        int outE = 0;
        int outM = 0;
        if (e == 255) {
            outE = 31;
            outM = m != 0 ? 512 : 0;
        } else if ((e = e - 127 + 15) >= 31) {
            outE = 49;
        } else if (e <= 0) {
            if (e >= -10) {
                if (((m = (m | 0x800000) >> 1 - e) & 0x1000) != 0) {
                    m += 8192;
                }
                outM = m >> 13;
            }
        } else {
            outE = e;
            outM = m >> 13;
            if ((m & 0x1000) != 0) {
                int out = outE << 10 | outM;
                return (short)(++out | s << 15);
            }
        }
        return (short)(s << 15 | outE << 10 | outM);
    }

    public static Half valueOf(short h) {
        return new Half(h);
    }

    public static Half valueOf(float f) {
        return new Half(f);
    }

    public static Half valueOf(String s) {
        return new Half(s);
    }

    public static short parseHalf(String s) throws NumberFormatException {
        return Half.toHalf(Float.parseFloat(s));
    }

    public static String toString(short h) {
        return Float.toString(Half.toFloat(h));
    }

    public static String toHexString(short h) {
        StringBuilder o = new StringBuilder();
        int bits = h & 0xFFFF;
        int s = bits >>> 15;
        int e = bits >>> 10 & 0x1F;
        int m = bits & 0x3FF;
        if (e == 31) {
            if (m == 0) {
                if (s != 0) {
                    o.append('-');
                }
                o.append("Infinity");
            } else {
                o.append("NaN");
            }
        } else {
            if (s == 1) {
                o.append('-');
            }
            if (e == 0) {
                if (m == 0) {
                    o.append("0x0.0p0");
                } else {
                    o.append("0x0.");
                    String significand = Integer.toHexString(m);
                    o.append(significand.replaceFirst("0{2,}$", ""));
                    o.append("p-14");
                }
            } else {
                o.append("0x1.");
                String significand = Integer.toHexString(m);
                o.append(significand.replaceFirst("0{2,}$", ""));
                o.append('p');
                o.append(Integer.toString(e - 15));
            }
        }
        return o.toString();
    }
}

