/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.UnsupportedAppUsage;
import android.graphics.BaseCanvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import libcore.util.EmptyArray;

public class SpannableStringBuilder
implements CharSequence,
GetChars,
Spannable,
Editable,
Appendable,
GraphicsOperations {
    private static final String TAG = "SpannableStringBuilder";
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    @GuardedBy(value={"sCachedIntBuffer"})
    private static final int[][] sCachedIntBuffer = new int[6][0];
    private InputFilter[] mFilters = NO_FILTERS;
    @UnsupportedAppUsage
    private char[] mText;
    @UnsupportedAppUsage
    private int mGapStart;
    @UnsupportedAppUsage
    private int mGapLength;
    @UnsupportedAppUsage
    private Object[] mSpans;
    @UnsupportedAppUsage
    private int[] mSpanStarts;
    @UnsupportedAppUsage
    private int[] mSpanEnds;
    private int[] mSpanMax;
    @UnsupportedAppUsage
    private int[] mSpanFlags;
    private int[] mSpanOrder;
    private int mSpanInsertCount;
    @UnsupportedAppUsage
    private int mSpanCount;
    private IdentityHashMap<Object, Integer> mIndexOfSpan;
    private int mLowWaterMark;
    private int mTextWatcherDepth;
    private static final int MARK = 1;
    private static final int POINT = 2;
    private static final int PARAGRAPH = 3;
    private static final int START_MASK = 240;
    private static final int END_MASK = 15;
    private static final int START_SHIFT = 4;
    private static final int SPAN_ADDED = 2048;
    private static final int SPAN_START_AT_START = 4096;
    private static final int SPAN_START_AT_END = 8192;
    private static final int SPAN_END_AT_START = 16384;
    private static final int SPAN_END_AT_END = 32768;
    private static final int SPAN_START_END_MASK = 61440;

    public SpannableStringBuilder() {
        this("");
    }

    public SpannableStringBuilder(CharSequence text) {
        this(text, 0, text.length());
    }

    public SpannableStringBuilder(CharSequence text, int start, int end) {
        int srclen = end - start;
        if (srclen < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        this.mText = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(srclen));
        this.mGapStart = srclen;
        this.mGapLength = this.mText.length - srclen;
        TextUtils.getChars(text, start, end, this.mText, 0);
        this.mSpanCount = 0;
        this.mSpanInsertCount = 0;
        this.mSpans = EmptyArray.OBJECT;
        this.mSpanStarts = EmptyArray.INT;
        this.mSpanEnds = EmptyArray.INT;
        this.mSpanFlags = EmptyArray.INT;
        this.mSpanMax = EmptyArray.INT;
        this.mSpanOrder = EmptyArray.INT;
        if (text instanceof Spanned) {
            Spanned sp = (Spanned)text;
            Object[] spans = sp.getSpans(start, end, Object.class);
            for (int i = 0; i < spans.length; ++i) {
                if (spans[i] instanceof NoCopySpan) continue;
                int st = sp.getSpanStart(spans[i]) - start;
                int en = sp.getSpanEnd(spans[i]) - start;
                int fl = sp.getSpanFlags(spans[i]);
                if (st < 0) {
                    st = 0;
                }
                if (st > end - start) {
                    st = end - start;
                }
                if (en < 0) {
                    en = 0;
                }
                if (en > end - start) {
                    en = end - start;
                }
                this.setSpan(false, spans[i], st, en, fl, false);
            }
            this.restoreInvariants();
        }
    }

    public static SpannableStringBuilder valueOf(CharSequence source) {
        if (source instanceof SpannableStringBuilder) {
            return (SpannableStringBuilder)source;
        }
        return new SpannableStringBuilder(source);
    }

    @Override
    public char charAt(int where) {
        int len = this.length();
        if (where < 0) {
            throw new IndexOutOfBoundsException("charAt: " + where + " < 0");
        }
        if (where >= len) {
            throw new IndexOutOfBoundsException("charAt: " + where + " >= length " + len);
        }
        if (where >= this.mGapStart) {
            return this.mText[where + this.mGapLength];
        }
        return this.mText[where];
    }

    @Override
    public int length() {
        return this.mText.length - this.mGapLength;
    }

    private void resizeFor(int size) {
        int oldLength = this.mText.length;
        if (size + 1 <= oldLength) {
            return;
        }
        char[] newText = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(size));
        System.arraycopy(this.mText, 0, newText, 0, this.mGapStart);
        int newLength = newText.length;
        int delta = newLength - oldLength;
        int after = oldLength - (this.mGapStart + this.mGapLength);
        System.arraycopy(this.mText, oldLength - after, newText, newLength - after, after);
        this.mText = newText;
        this.mGapLength += delta;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        if (this.mSpanCount != 0) {
            for (int i = 0; i < this.mSpanCount; ++i) {
                if (this.mSpanStarts[i] > this.mGapStart) {
                    int n = i;
                    this.mSpanStarts[n] = this.mSpanStarts[n] + delta;
                }
                if (this.mSpanEnds[i] <= this.mGapStart) continue;
                int n = i;
                this.mSpanEnds[n] = this.mSpanEnds[n] + delta;
            }
            this.calcMax(this.treeRoot());
        }
    }

    private void moveGapTo(int where) {
        int overlap;
        boolean atEnd;
        if (where == this.mGapStart) {
            return;
        }
        boolean bl = atEnd = where == this.length();
        if (where < this.mGapStart) {
            overlap = this.mGapStart - where;
            System.arraycopy(this.mText, where, this.mText, this.mGapStart + this.mGapLength - overlap, overlap);
        } else {
            overlap = where - this.mGapStart;
            System.arraycopy(this.mText, where + this.mGapLength - overlap, this.mText, this.mGapStart, overlap);
        }
        if (this.mSpanCount != 0) {
            for (int i = 0; i < this.mSpanCount; ++i) {
                int flag;
                int start = this.mSpanStarts[i];
                int end = this.mSpanEnds[i];
                if (start > this.mGapStart) {
                    start -= this.mGapLength;
                }
                if (start > where) {
                    start += this.mGapLength;
                } else if (start == where && ((flag = (this.mSpanFlags[i] & 0xF0) >> 4) == 2 || atEnd && flag == 3)) {
                    start += this.mGapLength;
                }
                if (end > this.mGapStart) {
                    end -= this.mGapLength;
                }
                if (end > where) {
                    end += this.mGapLength;
                } else if (end == where && ((flag = this.mSpanFlags[i] & 0xF) == 2 || atEnd && flag == 3)) {
                    end += this.mGapLength;
                }
                this.mSpanStarts[i] = start;
                this.mSpanEnds[i] = end;
            }
            this.calcMax(this.treeRoot());
        }
        this.mGapStart = where;
    }

    @Override
    public SpannableStringBuilder insert(int where, CharSequence tb, int start, int end) {
        return this.replace(where, where, tb, start, end);
    }

    @Override
    public SpannableStringBuilder insert(int where, CharSequence tb) {
        return this.replace(where, where, tb, 0, tb.length());
    }

    @Override
    public SpannableStringBuilder delete(int start, int end) {
        SpannableStringBuilder ret = this.replace(start, end, "", 0, 0);
        if (this.mGapLength > 2 * this.length()) {
            this.resizeFor(this.length());
        }
        return ret;
    }

    @Override
    public void clear() {
        this.replace(0, this.length(), "", 0, 0);
        this.mSpanInsertCount = 0;
    }

    @Override
    public void clearSpans() {
        for (int i = this.mSpanCount - 1; i >= 0; --i) {
            Object what = this.mSpans[i];
            int ostart = this.mSpanStarts[i];
            int oend = this.mSpanEnds[i];
            if (ostart > this.mGapStart) {
                ostart -= this.mGapLength;
            }
            if (oend > this.mGapStart) {
                oend -= this.mGapLength;
            }
            this.mSpanCount = i;
            this.mSpans[i] = null;
            this.sendSpanRemoved(what, ostart, oend);
        }
        if (this.mIndexOfSpan != null) {
            this.mIndexOfSpan.clear();
        }
        this.mSpanInsertCount = 0;
    }

    @Override
    public SpannableStringBuilder append(CharSequence text) {
        int length = this.length();
        return this.replace(length, length, text, 0, text.length());
    }

    public SpannableStringBuilder append(CharSequence text, Object what, int flags) {
        int start = this.length();
        this.append(text);
        this.setSpan(what, start, this.length(), flags);
        return this;
    }

    @Override
    public SpannableStringBuilder append(CharSequence text, int start, int end) {
        int length = this.length();
        return this.replace(length, length, text, start, end);
    }

    @Override
    public SpannableStringBuilder append(char text) {
        return this.append(String.valueOf(text));
    }

    private boolean removeSpansForChange(int start, int end, boolean textIsRemoved, int i) {
        if ((i & 1) != 0 && this.resolveGap(this.mSpanMax[i]) >= start && this.removeSpansForChange(start, end, textIsRemoved, SpannableStringBuilder.leftChild(i))) {
            return true;
        }
        if (i < this.mSpanCount) {
            if ((this.mSpanFlags[i] & 0x21) == 33 && this.mSpanStarts[i] >= start && this.mSpanStarts[i] < this.mGapStart + this.mGapLength && this.mSpanEnds[i] >= start && this.mSpanEnds[i] < this.mGapStart + this.mGapLength && (textIsRemoved || this.mSpanStarts[i] > start || this.mSpanEnds[i] < this.mGapStart)) {
                this.mIndexOfSpan.remove(this.mSpans[i]);
                this.removeSpan(i, 0);
                return true;
            }
            return this.resolveGap(this.mSpanStarts[i]) <= end && (i & 1) != 0 && this.removeSpansForChange(start, end, textIsRemoved, SpannableStringBuilder.rightChild(i));
        }
        return false;
    }

    private void change(int start, int end, CharSequence cs, int csStart, int csEnd) {
        boolean textIsRemoved;
        int replacedLength = end - start;
        int replacementLength = csEnd - csStart;
        int nbNewChars = replacementLength - replacedLength;
        boolean changed = false;
        int i = this.mSpanCount - 1;
        while (i >= 0) {
            int spanEnd;
            int spanStart = this.mSpanStarts[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if ((spanEnd = this.mSpanEnds[i]) > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            if ((this.mSpanFlags[i] & 0x33) == 51) {
                int ost = spanStart;
                int oen = spanEnd;
                int clen = this.length();
                if (spanStart > start && spanStart <= end) {
                    for (spanStart = end; spanStart < clen && (spanStart <= end || this.charAt(spanStart - 1) != '\n'); ++spanStart) {
                    }
                }
                if (spanEnd > start && spanEnd <= end) {
                    for (spanEnd = end; spanEnd < clen && (spanEnd <= end || this.charAt(spanEnd - 1) != '\n'); ++spanEnd) {
                    }
                }
                if (spanStart != ost || spanEnd != oen) {
                    this.setSpan(false, this.mSpans[i], spanStart, spanEnd, this.mSpanFlags[i], true);
                    changed = true;
                }
            }
            int flags = 0;
            if (spanStart == start) {
                flags |= 0x1000;
            } else if (spanStart == end + nbNewChars) {
                flags |= 0x2000;
            }
            if (spanEnd == start) {
                flags |= 0x4000;
            } else if (spanEnd == end + nbNewChars) {
                flags |= 0x8000;
            }
            int n = i--;
            this.mSpanFlags[n] = this.mSpanFlags[n] | flags;
        }
        if (changed) {
            this.restoreInvariants();
        }
        this.moveGapTo(end);
        if (nbNewChars >= this.mGapLength) {
            this.resizeFor(this.mText.length + nbNewChars - this.mGapLength);
        }
        boolean bl = textIsRemoved = replacementLength == 0;
        if (replacedLength > 0) {
            while (this.mSpanCount > 0 && this.removeSpansForChange(start, end, textIsRemoved, this.treeRoot())) {
            }
        }
        this.mGapStart += nbNewChars;
        this.mGapLength -= nbNewChars;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        TextUtils.getChars(cs, csStart, csEnd, this.mText, start);
        if (replacedLength > 0) {
            boolean atEnd = this.mGapStart + this.mGapLength == this.mText.length;
            for (int i2 = 0; i2 < this.mSpanCount; ++i2) {
                int startFlag = (this.mSpanFlags[i2] & 0xF0) >> 4;
                this.mSpanStarts[i2] = this.updatedIntervalBound(this.mSpanStarts[i2], start, nbNewChars, startFlag, atEnd, textIsRemoved);
                int endFlag = this.mSpanFlags[i2] & 0xF;
                this.mSpanEnds[i2] = this.updatedIntervalBound(this.mSpanEnds[i2], start, nbNewChars, endFlag, atEnd, textIsRemoved);
            }
            this.restoreInvariants();
        }
        if (cs instanceof Spanned) {
            Spanned sp = (Spanned)cs;
            Object[] spans = sp.getSpans(csStart, csEnd, Object.class);
            for (int i3 = 0; i3 < spans.length; ++i3) {
                int st = sp.getSpanStart(spans[i3]);
                int en = sp.getSpanEnd(spans[i3]);
                if (st < csStart) {
                    st = csStart;
                }
                if (en > csEnd) {
                    en = csEnd;
                }
                if (this.getSpanStart(spans[i3]) >= 0) continue;
                int copySpanStart = st - csStart + start;
                int copySpanEnd = en - csStart + start;
                int copySpanFlags = sp.getSpanFlags(spans[i3]) | 0x800;
                this.setSpan(false, spans[i3], copySpanStart, copySpanEnd, copySpanFlags, false);
            }
            this.restoreInvariants();
        }
    }

    private int updatedIntervalBound(int offset, int start, int nbNewChars, int flag, boolean atEnd, boolean textIsRemoved) {
        if (offset >= start && offset < this.mGapStart + this.mGapLength) {
            if (flag == 2) {
                if (textIsRemoved || offset > start) {
                    return this.mGapStart + this.mGapLength;
                }
            } else if (flag == 3) {
                if (atEnd) {
                    return this.mGapStart + this.mGapLength;
                }
            } else {
                if (textIsRemoved || offset < this.mGapStart - nbNewChars) {
                    return start;
                }
                return this.mGapStart;
            }
        }
        return offset;
    }

    private void removeSpan(int i, int flags) {
        Object object = this.mSpans[i];
        int start = this.mSpanStarts[i];
        int end = this.mSpanEnds[i];
        if (start > this.mGapStart) {
            start -= this.mGapLength;
        }
        if (end > this.mGapStart) {
            end -= this.mGapLength;
        }
        int count = this.mSpanCount - (i + 1);
        System.arraycopy(this.mSpans, i + 1, this.mSpans, i, count);
        System.arraycopy(this.mSpanStarts, i + 1, this.mSpanStarts, i, count);
        System.arraycopy(this.mSpanEnds, i + 1, this.mSpanEnds, i, count);
        System.arraycopy(this.mSpanFlags, i + 1, this.mSpanFlags, i, count);
        System.arraycopy(this.mSpanOrder, i + 1, this.mSpanOrder, i, count);
        --this.mSpanCount;
        this.invalidateIndex(i);
        this.mSpans[this.mSpanCount] = null;
        this.restoreInvariants();
        if ((flags & 0x200) == 0) {
            this.sendSpanRemoved(object, start, end);
        }
    }

    @Override
    public SpannableStringBuilder replace(int start, int end, CharSequence tb) {
        return this.replace(start, end, tb, 0, tb.length());
    }

    @Override
    public SpannableStringBuilder replace(int start, int end, CharSequence tb, int tbstart, int tbend) {
        this.checkRange("replace", start, end);
        int filtercount = this.mFilters.length;
        for (int i = 0; i < filtercount; ++i) {
            CharSequence repl = this.mFilters[i].filter(tb, tbstart, tbend, this, start, end);
            if (repl == null) continue;
            tb = repl;
            tbstart = 0;
            tbend = repl.length();
        }
        int origLen = end - start;
        int newLen = tbend - tbstart;
        if (origLen == 0 && newLen == 0 && !SpannableStringBuilder.hasNonExclusiveExclusiveSpanAt(tb, tbstart)) {
            return this;
        }
        TextWatcher[] textWatchers = this.getSpans(start, start + origLen, TextWatcher.class);
        this.sendBeforeTextChanged(textWatchers, start, origLen, newLen);
        boolean adjustSelection = origLen != 0 && newLen != 0;
        int selectionStart = 0;
        int selectionEnd = 0;
        if (adjustSelection) {
            selectionStart = Selection.getSelectionStart(this);
            selectionEnd = Selection.getSelectionEnd(this);
        }
        this.change(start, end, tb, tbstart, tbend);
        if (adjustSelection) {
            int offset;
            long diff;
            boolean changed = false;
            if (selectionStart > start && selectionStart < end) {
                diff = selectionStart - start;
                offset = Math.toIntExact(diff * (long)newLen / (long)origLen);
                selectionStart = start + offset;
                changed = true;
                this.setSpan(false, Selection.SELECTION_START, selectionStart, selectionStart, 34, true);
            }
            if (selectionEnd > start && selectionEnd < end) {
                diff = selectionEnd - start;
                offset = Math.toIntExact(diff * (long)newLen / (long)origLen);
                selectionEnd = start + offset;
                changed = true;
                this.setSpan(false, Selection.SELECTION_END, selectionEnd, selectionEnd, 34, true);
            }
            if (changed) {
                this.restoreInvariants();
            }
        }
        this.sendTextChanged(textWatchers, start, origLen, newLen);
        this.sendAfterTextChanged(textWatchers);
        this.sendToSpanWatchers(start, end, newLen - origLen);
        return this;
    }

    private static boolean hasNonExclusiveExclusiveSpanAt(CharSequence text, int offset) {
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            for (Object span : spanned.getSpans(offset, offset, Object.class)) {
                int flags = spanned.getSpanFlags(span);
                if (flags == 33) continue;
                return true;
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    private void sendToSpanWatchers(int replaceStart, int replaceEnd, int nbNewChars) {
        int spanEnd;
        int spanStart;
        int spanFlags;
        int i;
        for (i = 0; i < this.mSpanCount; ++i) {
            spanFlags = this.mSpanFlags[i];
            if ((spanFlags & 0x800) != 0) continue;
            spanStart = this.mSpanStarts[i];
            spanEnd = this.mSpanEnds[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if (spanEnd > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            int newReplaceEnd = replaceEnd + nbNewChars;
            boolean spanChanged = false;
            int previousSpanStart = spanStart;
            if (spanStart > newReplaceEnd) {
                if (nbNewChars != 0) {
                    previousSpanStart -= nbNewChars;
                    spanChanged = true;
                }
            } else if (!(spanStart < replaceStart || spanStart == replaceStart && (spanFlags & 0x1000) == 4096 || spanStart == newReplaceEnd && (spanFlags & 0x2000) == 8192)) {
                spanChanged = true;
            }
            int previousSpanEnd = spanEnd;
            if (spanEnd > newReplaceEnd) {
                if (nbNewChars != 0) {
                    previousSpanEnd -= nbNewChars;
                    spanChanged = true;
                }
            } else if (!(spanEnd < replaceStart || spanEnd == replaceStart && (spanFlags & 0x4000) == 16384 || spanEnd == newReplaceEnd && (spanFlags & 0x8000) == 32768)) {
                spanChanged = true;
            }
            if (spanChanged) {
                this.sendSpanChanged(this.mSpans[i], previousSpanStart, previousSpanEnd, spanStart, spanEnd);
            }
            int n = i;
            this.mSpanFlags[n] = this.mSpanFlags[n] & 0xFFFF0FFF;
        }
        for (i = 0; i < this.mSpanCount; ++i) {
            spanFlags = this.mSpanFlags[i];
            if ((spanFlags & 0x800) == 0) continue;
            int n = i;
            this.mSpanFlags[n] = this.mSpanFlags[n] & 0xFFFFF7FF;
            spanStart = this.mSpanStarts[i];
            spanEnd = this.mSpanEnds[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if (spanEnd > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            this.sendSpanAdded(this.mSpans[i], spanStart, spanEnd);
        }
    }

    @Override
    public void setSpan(Object what, int start, int end, int flags) {
        this.setSpan(true, what, start, end, flags, true);
    }

    private void setSpan(boolean send, Object what, int start, int end, int flags, boolean enforceParagraph) {
        Integer index;
        this.checkRange("setSpan", start, end);
        int flagsStart = (flags & 0xF0) >> 4;
        if (this.isInvalidParagraph(start, flagsStart)) {
            if (!enforceParagraph) {
                return;
            }
            throw new RuntimeException("PARAGRAPH span must start at paragraph boundary (" + start + " follows " + this.charAt(start - 1) + ")");
        }
        int flagsEnd = flags & 0xF;
        if (this.isInvalidParagraph(end, flagsEnd)) {
            if (!enforceParagraph) {
                return;
            }
            throw new RuntimeException("PARAGRAPH span must end at paragraph boundary (" + end + " follows " + this.charAt(end - 1) + ")");
        }
        if (flagsStart == 2 && flagsEnd == 1 && start == end) {
            if (send) {
                Log.e(TAG, "SPAN_EXCLUSIVE_EXCLUSIVE spans cannot have a zero length");
            }
            return;
        }
        int nstart = start;
        int nend = end;
        if (start > this.mGapStart) {
            start += this.mGapLength;
        } else if (start == this.mGapStart && (flagsStart == 2 || flagsStart == 3 && start == this.length())) {
            start += this.mGapLength;
        }
        if (end > this.mGapStart) {
            end += this.mGapLength;
        } else if (end == this.mGapStart && (flagsEnd == 2 || flagsEnd == 3 && end == this.length())) {
            end += this.mGapLength;
        }
        if (this.mIndexOfSpan != null && (index = this.mIndexOfSpan.get(what)) != null) {
            int i = index;
            int ostart = this.mSpanStarts[i];
            int oend = this.mSpanEnds[i];
            if (ostart > this.mGapStart) {
                ostart -= this.mGapLength;
            }
            if (oend > this.mGapStart) {
                oend -= this.mGapLength;
            }
            this.mSpanStarts[i] = start;
            this.mSpanEnds[i] = end;
            this.mSpanFlags[i] = flags;
            if (send) {
                this.restoreInvariants();
                this.sendSpanChanged(what, ostart, oend, nstart, nend);
            }
            return;
        }
        this.mSpans = GrowingArrayUtils.append(this.mSpans, this.mSpanCount, what);
        this.mSpanStarts = GrowingArrayUtils.append(this.mSpanStarts, this.mSpanCount, start);
        this.mSpanEnds = GrowingArrayUtils.append(this.mSpanEnds, this.mSpanCount, end);
        this.mSpanFlags = GrowingArrayUtils.append(this.mSpanFlags, this.mSpanCount, flags);
        this.mSpanOrder = GrowingArrayUtils.append(this.mSpanOrder, this.mSpanCount, this.mSpanInsertCount);
        this.invalidateIndex(this.mSpanCount);
        ++this.mSpanCount;
        ++this.mSpanInsertCount;
        int sizeOfMax = 2 * this.treeRoot() + 1;
        if (this.mSpanMax.length < sizeOfMax) {
            this.mSpanMax = new int[sizeOfMax];
        }
        if (send) {
            this.restoreInvariants();
            this.sendSpanAdded(what, nstart, nend);
        }
    }

    private boolean isInvalidParagraph(int index, int flag) {
        return flag == 3 && index != 0 && index != this.length() && this.charAt(index - 1) != '\n';
    }

    @Override
    public void removeSpan(Object what) {
        this.removeSpan(what, 0);
    }

    @Override
    public void removeSpan(Object what, int flags) {
        if (this.mIndexOfSpan == null) {
            return;
        }
        Integer i = this.mIndexOfSpan.remove(what);
        if (i != null) {
            this.removeSpan(i, flags);
        }
    }

    private int resolveGap(int i) {
        return i > this.mGapStart ? i - this.mGapLength : i;
    }

    @Override
    public int getSpanStart(Object what) {
        if (this.mIndexOfSpan == null) {
            return -1;
        }
        Integer i = this.mIndexOfSpan.get(what);
        return i == null ? -1 : this.resolveGap(this.mSpanStarts[i]);
    }

    @Override
    public int getSpanEnd(Object what) {
        if (this.mIndexOfSpan == null) {
            return -1;
        }
        Integer i = this.mIndexOfSpan.get(what);
        return i == null ? -1 : this.resolveGap(this.mSpanEnds[i]);
    }

    @Override
    public int getSpanFlags(Object what) {
        if (this.mIndexOfSpan == null) {
            return 0;
        }
        Integer i = this.mIndexOfSpan.get(what);
        return i == null ? 0 : this.mSpanFlags[i];
    }

    @Override
    public <T> T[] getSpans(int queryStart, int queryEnd, Class<T> kind) {
        return this.getSpans(queryStart, queryEnd, kind, true);
    }

    @UnsupportedAppUsage
    public <T> T[] getSpans(int queryStart, int queryEnd, Class<T> kind, boolean sortByInsertionOrder) {
        if (kind == null) {
            return ArrayUtils.emptyArray(Object.class);
        }
        if (this.mSpanCount == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        int count = this.countSpans(queryStart, queryEnd, kind, this.treeRoot());
        if (count == 0) {
            return ArrayUtils.emptyArray(kind);
        }
        Object[] ret = (Object[])Array.newInstance(kind, count);
        int[] prioSortBuffer = sortByInsertionOrder ? SpannableStringBuilder.obtain(count) : EmptyArray.INT;
        int[] orderSortBuffer = sortByInsertionOrder ? SpannableStringBuilder.obtain(count) : EmptyArray.INT;
        this.getSpansRec(queryStart, queryEnd, kind, this.treeRoot(), ret, prioSortBuffer, orderSortBuffer, 0, sortByInsertionOrder);
        if (sortByInsertionOrder) {
            this.sort(ret, prioSortBuffer, orderSortBuffer);
            SpannableStringBuilder.recycle(prioSortBuffer);
            SpannableStringBuilder.recycle(orderSortBuffer);
        }
        return ret;
    }

    private int countSpans(int queryStart, int queryEnd, Class kind, int i) {
        int count = 0;
        if ((i & 1) != 0) {
            int left = SpannableStringBuilder.leftChild(i);
            int spanMax = this.mSpanMax[left];
            if (spanMax > this.mGapStart) {
                spanMax -= this.mGapLength;
            }
            if (spanMax >= queryStart) {
                count = this.countSpans(queryStart, queryEnd, kind, left);
            }
        }
        if (i < this.mSpanCount) {
            int spanStart = this.mSpanStarts[i];
            if (spanStart > this.mGapStart) {
                spanStart -= this.mGapLength;
            }
            if (spanStart <= queryEnd) {
                int spanEnd = this.mSpanEnds[i];
                if (spanEnd > this.mGapStart) {
                    spanEnd -= this.mGapLength;
                }
                if (spanEnd >= queryStart && (spanStart == spanEnd || queryStart == queryEnd || spanStart != queryEnd && spanEnd != queryStart) && (Object.class == kind || kind.isInstance(this.mSpans[i]))) {
                    ++count;
                }
                if ((i & 1) != 0) {
                    count += this.countSpans(queryStart, queryEnd, kind, SpannableStringBuilder.rightChild(i));
                }
            }
        }
        return count;
    }

    private <T> int getSpansRec(int queryStart, int queryEnd, Class<T> kind, int i, T[] ret, int[] priority, int[] insertionOrder, int count, boolean sort) {
        if ((i & 1) != 0) {
            int left = SpannableStringBuilder.leftChild(i);
            int spanMax = this.mSpanMax[left];
            if (spanMax > this.mGapStart) {
                spanMax -= this.mGapLength;
            }
            if (spanMax >= queryStart) {
                count = this.getSpansRec(queryStart, queryEnd, kind, left, ret, priority, insertionOrder, count, sort);
            }
        }
        if (i >= this.mSpanCount) {
            return count;
        }
        int spanStart = this.mSpanStarts[i];
        if (spanStart > this.mGapStart) {
            spanStart -= this.mGapLength;
        }
        if (spanStart <= queryEnd) {
            int spanEnd = this.mSpanEnds[i];
            if (spanEnd > this.mGapStart) {
                spanEnd -= this.mGapLength;
            }
            if (spanEnd >= queryStart && (spanStart == spanEnd || queryStart == queryEnd || spanStart != queryEnd && spanEnd != queryStart) && (Object.class == kind || kind.isInstance(this.mSpans[i]))) {
                int spanPriority = this.mSpanFlags[i] & 0xFF0000;
                int target = count;
                if (sort) {
                    priority[target] = spanPriority;
                    insertionOrder[target] = this.mSpanOrder[i];
                } else if (spanPriority != 0) {
                    int p;
                    int j;
                    for (j = 0; j < count && spanPriority <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                    }
                    System.arraycopy(ret, j, ret, j + 1, count - j);
                    target = j;
                }
                ret[target] = this.mSpans[i];
                ++count;
            }
            if (count < ret.length && (i & 1) != 0) {
                count = this.getSpansRec(queryStart, queryEnd, kind, SpannableStringBuilder.rightChild(i), ret, priority, insertionOrder, count, sort);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] obtain(int elementCount) {
        int[] result = null;
        int[][] nArray = sCachedIntBuffer;
        synchronized (sCachedIntBuffer) {
            int candidateIndex = -1;
            for (int i = sCachedIntBuffer.length - 1; i >= 0; --i) {
                if (sCachedIntBuffer[i] == null) continue;
                if (sCachedIntBuffer[i].length >= elementCount) {
                    candidateIndex = i;
                    break;
                }
                if (candidateIndex != -1) continue;
                candidateIndex = i;
            }
            if (candidateIndex != -1) {
                result = sCachedIntBuffer[candidateIndex];
                SpannableStringBuilder.sCachedIntBuffer[candidateIndex] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            result = SpannableStringBuilder.checkSortBuffer(result, elementCount);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycle(int[] buffer) {
        int[][] nArray = sCachedIntBuffer;
        synchronized (sCachedIntBuffer) {
            for (int i = 0; i < sCachedIntBuffer.length; ++i) {
                if (sCachedIntBuffer[i] != null && buffer.length <= sCachedIntBuffer[i].length) continue;
                SpannableStringBuilder.sCachedIntBuffer[i] = buffer;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static int[] checkSortBuffer(int[] buffer, int size) {
        if (buffer == null || size > buffer.length) {
            return ArrayUtils.newUnpaddedIntArray(GrowingArrayUtils.growSize(size));
        }
        return buffer;
    }

    private <T> void sort(T[] array2, int[] priority, int[] insertionOrder) {
        int i;
        int size = array2.length;
        for (i = size / 2 - 1; i >= 0; --i) {
            this.siftDown(i, array2, size, priority, insertionOrder);
        }
        for (i = size - 1; i > 0; --i) {
            T tmpSpan = array2[0];
            array2[0] = array2[i];
            array2[i] = tmpSpan;
            int tmpPriority = priority[0];
            priority[0] = priority[i];
            priority[i] = tmpPriority;
            int tmpOrder = insertionOrder[0];
            insertionOrder[0] = insertionOrder[i];
            insertionOrder[i] = tmpOrder;
            this.siftDown(0, array2, i, priority, insertionOrder);
        }
    }

    private <T> void siftDown(int index, T[] array2, int size, int[] priority, int[] insertionOrder) {
        int left = 2 * index + 1;
        while (left < size) {
            if (left < size - 1 && this.compareSpans(left, left + 1, priority, insertionOrder) < 0) {
                ++left;
            }
            if (this.compareSpans(index, left, priority, insertionOrder) >= 0) break;
            T tmpSpan = array2[index];
            array2[index] = array2[left];
            array2[left] = tmpSpan;
            int tmpPriority = priority[index];
            priority[index] = priority[left];
            priority[left] = tmpPriority;
            int tmpOrder = insertionOrder[index];
            insertionOrder[index] = insertionOrder[left];
            insertionOrder[left] = tmpOrder;
            index = left;
            left = 2 * index + 1;
        }
    }

    private int compareSpans(int left, int right, int[] priority, int[] insertionOrder) {
        int priority1 = priority[left];
        int priority2 = priority[right];
        if (priority1 == priority2) {
            return Integer.compare(insertionOrder[left], insertionOrder[right]);
        }
        return Integer.compare(priority2, priority1);
    }

    @Override
    public int nextSpanTransition(int start, int limit, Class kind) {
        if (this.mSpanCount == 0) {
            return limit;
        }
        if (kind == null) {
            kind = Object.class;
        }
        return this.nextSpanTransitionRec(start, limit, kind, this.treeRoot());
    }

    private int nextSpanTransitionRec(int start, int limit, Class kind, int i) {
        int left;
        if ((i & 1) != 0 && this.resolveGap(this.mSpanMax[left = SpannableStringBuilder.leftChild(i)]) > start) {
            limit = this.nextSpanTransitionRec(start, limit, kind, left);
        }
        if (i < this.mSpanCount) {
            int st = this.resolveGap(this.mSpanStarts[i]);
            int en = this.resolveGap(this.mSpanEnds[i]);
            if (st > start && st < limit && kind.isInstance(this.mSpans[i])) {
                limit = st;
            }
            if (en > start && en < limit && kind.isInstance(this.mSpans[i])) {
                limit = en;
            }
            if (st < limit && (i & 1) != 0) {
                limit = this.nextSpanTransitionRec(start, limit, kind, SpannableStringBuilder.rightChild(i));
            }
        }
        return limit;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new SpannableStringBuilder(this, start, end);
    }

    @Override
    public void getChars(int start, int end, char[] dest, int destoff) {
        this.checkRange("getChars", start, end);
        if (end <= this.mGapStart) {
            System.arraycopy(this.mText, start, dest, destoff, end - start);
        } else if (start >= this.mGapStart) {
            System.arraycopy(this.mText, start + this.mGapLength, dest, destoff, end - start);
        } else {
            System.arraycopy(this.mText, start, dest, destoff, this.mGapStart - start);
            System.arraycopy(this.mText, this.mGapStart + this.mGapLength, dest, destoff + (this.mGapStart - start), end - this.mGapStart);
        }
    }

    @Override
    public String toString() {
        int len = this.length();
        char[] buf = new char[len];
        this.getChars(0, len, buf, 0);
        return new String(buf);
    }

    @UnsupportedAppUsage
    public String substring(int start, int end) {
        char[] buf = new char[end - start];
        this.getChars(start, end, buf, 0);
        return new String(buf);
    }

    public int getTextWatcherDepth() {
        return this.mTextWatcherDepth;
    }

    private void sendBeforeTextChanged(TextWatcher[] watchers, int start, int before, int after) {
        int n = watchers.length;
        ++this.mTextWatcherDepth;
        for (int i = 0; i < n; ++i) {
            watchers[i].beforeTextChanged(this, start, before, after);
        }
        --this.mTextWatcherDepth;
    }

    private void sendTextChanged(TextWatcher[] watchers, int start, int before, int after) {
        int n = watchers.length;
        ++this.mTextWatcherDepth;
        for (int i = 0; i < n; ++i) {
            watchers[i].onTextChanged(this, start, before, after);
        }
        --this.mTextWatcherDepth;
    }

    private void sendAfterTextChanged(TextWatcher[] watchers) {
        int n = watchers.length;
        ++this.mTextWatcherDepth;
        for (int i = 0; i < n; ++i) {
            watchers[i].afterTextChanged(this);
        }
        --this.mTextWatcherDepth;
    }

    private void sendSpanAdded(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanAdded(this, what, start, end);
        }
    }

    private void sendSpanRemoved(Object what, int start, int end) {
        SpanWatcher[] recip = this.getSpans(start, end, SpanWatcher.class);
        int n = recip.length;
        for (int i = 0; i < n; ++i) {
            recip[i].onSpanRemoved(this, what, start, end);
        }
    }

    private void sendSpanChanged(Object what, int oldStart, int oldEnd, int start, int end) {
        SpanWatcher[] spanWatchers = this.getSpans(Math.min(oldStart, start), Math.min(Math.max(oldEnd, end), this.length()), SpanWatcher.class);
        int n = spanWatchers.length;
        for (int i = 0; i < n; ++i) {
            spanWatchers[i].onSpanChanged(this, what, oldStart, oldEnd, start, end);
        }
    }

    private static String region(int start, int end) {
        return "(" + start + " ... " + end + ")";
    }

    private void checkRange(String operation, int start, int end) {
        if (end < start) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " has end before start");
        }
        int len = this.length();
        if (start > len || end > len) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " ends beyond length " + len);
        }
        if (start < 0 || end < 0) {
            throw new IndexOutOfBoundsException(operation + " " + SpannableStringBuilder.region(start, end) + " starts before 0");
        }
    }

    @Override
    public void drawText(BaseCanvas c, int start, int end, float x, float y, Paint p) {
        this.checkRange("drawText", start, end);
        if (end <= this.mGapStart) {
            c.drawText(this.mText, start, end - start, x, y, p);
        } else if (start >= this.mGapStart) {
            c.drawText(this.mText, start + this.mGapLength, end - start, x, y, p);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            c.drawText(buf, 0, end - start, x, y, p);
            TextUtils.recycle(buf);
        }
    }

    @Override
    public void drawTextRun(BaseCanvas c, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint p) {
        this.checkRange("drawTextRun", start, end);
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (contextEnd <= this.mGapStart) {
            c.drawTextRun(this.mText, start, len, contextStart, contextLen, x, y, isRtl, p);
        } else if (contextStart >= this.mGapStart) {
            c.drawTextRun(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, x, y, isRtl, p);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            c.drawTextRun(buf, start - contextStart, len, 0, contextLen, x, y, isRtl, p);
            TextUtils.recycle(buf);
        }
    }

    @Override
    public float measureText(int start, int end, Paint p) {
        float ret;
        this.checkRange("measureText", start, end);
        if (end <= this.mGapStart) {
            ret = p.measureText(this.mText, start, end - start);
        } else if (start >= this.mGapStart) {
            ret = p.measureText(this.mText, start + this.mGapLength, end - start);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            ret = p.measureText(buf, 0, end - start);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public int getTextWidths(int start, int end, float[] widths, Paint p) {
        int ret;
        this.checkRange("getTextWidths", start, end);
        if (end <= this.mGapStart) {
            ret = p.getTextWidths(this.mText, start, end - start, widths);
        } else if (start >= this.mGapStart) {
            ret = p.getTextWidths(this.mText, start + this.mGapLength, end - start, widths);
        } else {
            char[] buf = TextUtils.obtain(end - start);
            this.getChars(start, end, buf, 0);
            ret = p.getTextWidths(buf, 0, end - start, widths);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public float getTextRunAdvances(int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesPos, Paint p) {
        float ret;
        int contextLen = contextEnd - contextStart;
        int len = end - start;
        if (end <= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start, len, contextStart, contextLen, isRtl, advances, advancesPos);
        } else if (start >= this.mGapStart) {
            ret = p.getTextRunAdvances(this.mText, start + this.mGapLength, len, contextStart + this.mGapLength, contextLen, isRtl, advances, advancesPos);
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunAdvances(buf, start - contextStart, len, 0, contextLen, isRtl, advances, advancesPos);
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Deprecated
    public int getTextRunCursor(int contextStart, int contextEnd, int dir, int offset, int cursorOpt, Paint p) {
        return this.getTextRunCursor(contextStart, contextEnd, dir == 1, offset, cursorOpt, p);
    }

    @Override
    public int getTextRunCursor(int contextStart, int contextEnd, boolean isRtl, int offset, int cursorOpt, Paint p) {
        int ret;
        int contextLen = contextEnd - contextStart;
        if (contextEnd <= this.mGapStart) {
            ret = p.getTextRunCursor(this.mText, contextStart, contextLen, isRtl, offset, cursorOpt);
        } else if (contextStart >= this.mGapStart) {
            ret = p.getTextRunCursor(this.mText, contextStart + this.mGapLength, contextLen, isRtl, offset + this.mGapLength, cursorOpt) - this.mGapLength;
        } else {
            char[] buf = TextUtils.obtain(contextLen);
            this.getChars(contextStart, contextEnd, buf, 0);
            ret = p.getTextRunCursor(buf, 0, contextLen, isRtl, offset - contextStart, cursorOpt) + contextStart;
            TextUtils.recycle(buf);
        }
        return ret;
    }

    @Override
    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
    }

    @Override
    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    public boolean equals(Object o) {
        if (o instanceof Spanned && this.toString().equals(o.toString())) {
            Spanned other = (Spanned)o;
            Object[] otherSpans = other.getSpans(0, other.length(), Object.class);
            Object[] thisSpans = this.getSpans(0, this.length(), Object.class);
            if (this.mSpanCount == otherSpans.length) {
                for (int i = 0; i < this.mSpanCount; ++i) {
                    Object thisSpan = thisSpans[i];
                    Object otherSpan = otherSpans[i];
                    if (!(thisSpan == this ? other != otherSpan || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan) : !thisSpan.equals(otherSpan) || this.getSpanStart(thisSpan) != other.getSpanStart(otherSpan) || this.getSpanEnd(thisSpan) != other.getSpanEnd(otherSpan) || this.getSpanFlags(thisSpan) != other.getSpanFlags(otherSpan))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.toString().hashCode();
        hash = hash * 31 + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object span = this.mSpans[i];
            if (span != this) {
                hash = hash * 31 + span.hashCode();
            }
            hash = hash * 31 + this.getSpanStart(span);
            hash = hash * 31 + this.getSpanEnd(span);
            hash = hash * 31 + this.getSpanFlags(span);
        }
        return hash;
    }

    private int treeRoot() {
        return Integer.highestOneBit(this.mSpanCount) - 1;
    }

    private static int leftChild(int i) {
        return i - ((i + 1 & ~i) >> 1);
    }

    private static int rightChild(int i) {
        return i + ((i + 1 & ~i) >> 1);
    }

    private int calcMax(int i) {
        int max = 0;
        if ((i & 1) != 0) {
            max = this.calcMax(SpannableStringBuilder.leftChild(i));
        }
        if (i < this.mSpanCount) {
            max = Math.max(max, this.mSpanEnds[i]);
            if ((i & 1) != 0) {
                max = Math.max(max, this.calcMax(SpannableStringBuilder.rightChild(i)));
            }
        }
        this.mSpanMax[i] = max;
        return max;
    }

    private void restoreInvariants() {
        int i;
        if (this.mSpanCount == 0) {
            return;
        }
        for (i = 1; i < this.mSpanCount; ++i) {
            if (this.mSpanStarts[i] >= this.mSpanStarts[i - 1]) continue;
            Object span = this.mSpans[i];
            int start = this.mSpanStarts[i];
            int end = this.mSpanEnds[i];
            int flags = this.mSpanFlags[i];
            int insertionOrder = this.mSpanOrder[i];
            int j = i;
            do {
                this.mSpans[j] = this.mSpans[j - 1];
                this.mSpanStarts[j] = this.mSpanStarts[j - 1];
                this.mSpanEnds[j] = this.mSpanEnds[j - 1];
                this.mSpanFlags[j] = this.mSpanFlags[j - 1];
                this.mSpanOrder[j] = this.mSpanOrder[j - 1];
            } while (--j > 0 && start < this.mSpanStarts[j - 1]);
            this.mSpans[j] = span;
            this.mSpanStarts[j] = start;
            this.mSpanEnds[j] = end;
            this.mSpanFlags[j] = flags;
            this.mSpanOrder[j] = insertionOrder;
            this.invalidateIndex(j);
        }
        this.calcMax(this.treeRoot());
        if (this.mIndexOfSpan == null) {
            this.mIndexOfSpan = new IdentityHashMap();
        }
        for (i = this.mLowWaterMark; i < this.mSpanCount; ++i) {
            Integer existing = this.mIndexOfSpan.get(this.mSpans[i]);
            if (existing != null && existing == i) continue;
            this.mIndexOfSpan.put(this.mSpans[i], i);
        }
        this.mLowWaterMark = Integer.MAX_VALUE;
    }

    private void invalidateIndex(int i) {
        this.mLowWaterMark = Math.min(i, this.mLowWaterMark);
    }
}

