/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsIncomingMessage;
import android.telephony.ims.RcsIncomingMessageCreationParams;
import android.telephony.ims.RcsMessage;
import android.telephony.ims.RcsMessageQueryParams;
import android.telephony.ims.RcsMessageQueryResult;
import android.telephony.ims.RcsMessageSnippet;
import android.telephony.ims.RcsMessageStoreException;
import android.telephony.ims.RcsOutgoingMessage;
import android.telephony.ims.RcsOutgoingMessageCreationParams;
import com.android.internal.annotations.VisibleForTesting;

public abstract class RcsThread {
    protected int mThreadId;
    protected final RcsControllerCall mRcsControllerCall;

    protected RcsThread(RcsControllerCall rcsControllerCall, int threadId) {
        this.mThreadId = threadId;
        this.mRcsControllerCall = rcsControllerCall;
    }

    public RcsMessageSnippet getSnippet() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessageSnippet(this.mThreadId, callingPackage));
    }

    public RcsIncomingMessage addIncomingMessage(RcsIncomingMessageCreationParams rcsIncomingMessageCreationParams) throws RcsMessageStoreException {
        int messageId = this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.addIncomingMessage(this.mThreadId, rcsIncomingMessageCreationParams, callingPackage));
        return new RcsIncomingMessage(this.mRcsControllerCall, messageId);
    }

    public RcsOutgoingMessage addOutgoingMessage(RcsOutgoingMessageCreationParams rcsOutgoingMessageCreationParams) throws RcsMessageStoreException {
        int messageId = this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.addOutgoingMessage(this.mThreadId, rcsOutgoingMessageCreationParams, callingPackage));
        return new RcsOutgoingMessage(this.mRcsControllerCall, messageId);
    }

    public void deleteMessage(RcsMessage rcsMessage) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.deleteMessage(rcsMessage.getId(), rcsMessage.isIncoming(), this.mThreadId, this.isGroup(), callingPackage));
    }

    public RcsMessageQueryResult getMessages() throws RcsMessageStoreException {
        RcsMessageQueryParams queryParams = new RcsMessageQueryParams.Builder().setThread(this).build();
        return new RcsMessageQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessages(queryParams, callingPackage)));
    }

    public abstract boolean isGroup();

    @VisibleForTesting
    public int getThreadId() {
        return this.mThreadId;
    }

    public int getThreadType() {
        return this.isGroup() ? 1 : 0;
    }
}

