/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.content.Context;
import android.net.Uri;
import android.telephony.ims.Rcs1To1Thread;
import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsEvent;
import android.telephony.ims.RcsEventQueryParams;
import android.telephony.ims.RcsEventQueryResult;
import android.telephony.ims.RcsGroupThread;
import android.telephony.ims.RcsMessageQueryParams;
import android.telephony.ims.RcsMessageQueryResult;
import android.telephony.ims.RcsMessageStoreException;
import android.telephony.ims.RcsParticipant;
import android.telephony.ims.RcsParticipantQueryParams;
import android.telephony.ims.RcsParticipantQueryResult;
import android.telephony.ims.RcsQueryContinuationToken;
import android.telephony.ims.RcsThread;
import android.telephony.ims.RcsThreadQueryParams;
import android.telephony.ims.RcsThreadQueryResult;
import java.util.List;

public class RcsMessageStore {
    RcsControllerCall mRcsControllerCall;

    RcsMessageStore(Context context) {
        this.mRcsControllerCall = new RcsControllerCall(context);
    }

    public RcsThreadQueryResult getRcsThreads(RcsThreadQueryParams queryParameters) throws RcsMessageStoreException {
        return new RcsThreadQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getRcsThreads(queryParameters, callingPackage)));
    }

    public RcsThreadQueryResult getRcsThreads(RcsQueryContinuationToken continuationToken) throws RcsMessageStoreException {
        return new RcsThreadQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getRcsThreadsWithToken(continuationToken, callingPackage)));
    }

    public RcsParticipantQueryResult getRcsParticipants(RcsParticipantQueryParams queryParameters) throws RcsMessageStoreException {
        return new RcsParticipantQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getParticipants(queryParameters, callingPackage)));
    }

    public RcsParticipantQueryResult getRcsParticipants(RcsQueryContinuationToken continuationToken) throws RcsMessageStoreException {
        return new RcsParticipantQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getParticipantsWithToken(continuationToken, callingPackage)));
    }

    public RcsMessageQueryResult getRcsMessages(RcsMessageQueryParams queryParams) throws RcsMessageStoreException {
        return new RcsMessageQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessages(queryParams, callingPackage)));
    }

    public RcsMessageQueryResult getRcsMessages(RcsQueryContinuationToken continuationToken) throws RcsMessageStoreException {
        return new RcsMessageQueryResult(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessagesWithToken(continuationToken, callingPackage)));
    }

    public RcsEventQueryResult getRcsEvents(RcsEventQueryParams queryParams) throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getEvents(queryParams, callingPackage)).getRcsEventQueryResult(this.mRcsControllerCall);
    }

    public RcsEventQueryResult getRcsEvents(RcsQueryContinuationToken continuationToken) throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getEventsWithToken(continuationToken, callingPackage)).getRcsEventQueryResult(this.mRcsControllerCall);
    }

    public void persistRcsEvent(RcsEvent rcsEvent) throws RcsMessageStoreException {
        rcsEvent.persist(this.mRcsControllerCall);
    }

    public Rcs1To1Thread createRcs1To1Thread(RcsParticipant recipient) throws RcsMessageStoreException {
        return new Rcs1To1Thread(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.createRcs1To1Thread(recipient.getId(), callingPackage)));
    }

    public RcsGroupThread createGroupThread(List<RcsParticipant> recipients, String groupName, Uri groupIcon) throws RcsMessageStoreException {
        int[] recipientIds = null;
        if (recipients != null) {
            recipientIds = new int[recipients.size()];
            for (int i = 0; i < recipients.size(); ++i) {
                recipientIds[i] = recipients.get(i).getId();
            }
        }
        int[] finalRecipientIds = recipientIds;
        int threadId = this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.createGroupThread(finalRecipientIds, groupName, groupIcon, callingPackage));
        return new RcsGroupThread(this.mRcsControllerCall, threadId);
    }

    public void deleteThread(RcsThread thread) throws RcsMessageStoreException {
        if (thread == null) {
            return;
        }
        boolean isDeleteSucceeded = this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.deleteThread(thread.getThreadId(), thread.getThreadType(), callingPackage));
        if (!isDeleteSucceeded) {
            throw new RcsMessageStoreException("Could not delete RcsThread");
        }
    }

    public RcsParticipant createRcsParticipant(String canonicalAddress, String alias) throws RcsMessageStoreException {
        return new RcsParticipant(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.createRcsParticipant(canonicalAddress, alias, callingPackage)));
    }
}

