/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.telephony.ims.RcsControllerCall;
import android.telephony.ims.RcsFileTransferCreationParams;
import android.telephony.ims.RcsFileTransferPart;
import android.telephony.ims.RcsMessageStoreException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class RcsMessage {
    public static final double LOCATION_NOT_SET = Double.MIN_VALUE;
    public static final int NOT_SET = 0;
    public static final int DRAFT = 1;
    public static final int QUEUED = 2;
    public static final int SENDING = 3;
    public static final int SENT = 4;
    public static final int RETRYING = 5;
    public static final int FAILED = 6;
    public static final int RECEIVED = 7;
    public static final int SEEN = 9;
    protected final RcsControllerCall mRcsControllerCall;
    protected final int mId;

    RcsMessage(RcsControllerCall rcsControllerCall, int id2) {
        this.mRcsControllerCall = rcsControllerCall;
        this.mId = id2;
    }

    public int getId() {
        return this.mId;
    }

    public int getSubscriptionId() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessageSubId(this.mId, this.isIncoming(), callingPackage));
    }

    public void setSubscriptionId(int subId) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setMessageSubId(this.mId, this.isIncoming(), subId, callingPackage));
    }

    public void setStatus(int rcsMessageStatus) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setMessageStatus(this.mId, this.isIncoming(), rcsMessageStatus, callingPackage));
    }

    public int getStatus() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessageStatus(this.mId, this.isIncoming(), callingPackage));
    }

    public void setOriginationTimestamp(long timestamp) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setMessageOriginationTimestamp(this.mId, this.isIncoming(), timestamp, callingPackage));
    }

    public long getOriginationTimestamp() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getMessageOriginationTimestamp(this.mId, this.isIncoming(), callingPackage));
    }

    public void setRcsMessageId(String rcsMessageGlobalId) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setGlobalMessageIdForMessage(this.mId, this.isIncoming(), rcsMessageGlobalId, callingPackage));
    }

    public String getRcsMessageId() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getGlobalMessageIdForMessage(this.mId, this.isIncoming(), callingPackage));
    }

    public String getText() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getTextForMessage(this.mId, this.isIncoming(), callingPackage));
    }

    public void setText(String text) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setTextForMessage(this.mId, this.isIncoming(), text, callingPackage));
    }

    public double getLatitude() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getLatitudeForMessage(this.mId, this.isIncoming(), callingPackage));
    }

    public void setLatitude(double latitude) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setLatitudeForMessage(this.mId, this.isIncoming(), latitude, callingPackage));
    }

    public double getLongitude() throws RcsMessageStoreException {
        return this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getLongitudeForMessage(this.mId, this.isIncoming(), callingPackage));
    }

    public void setLongitude(double longitude) throws RcsMessageStoreException {
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.setLongitudeForMessage(this.mId, this.isIncoming(), longitude, callingPackage));
    }

    public RcsFileTransferPart insertFileTransfer(RcsFileTransferCreationParams fileTransferCreationParameters) throws RcsMessageStoreException {
        return new RcsFileTransferPart(this.mRcsControllerCall, this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.storeFileTransfer(this.mId, this.isIncoming(), fileTransferCreationParameters, callingPackage)));
    }

    public Set<RcsFileTransferPart> getFileTransferParts() throws RcsMessageStoreException {
        int[] fileTransferIds;
        HashSet<RcsFileTransferPart> fileTransferParts = new HashSet<RcsFileTransferPart>();
        for (int fileTransfer : fileTransferIds = this.mRcsControllerCall.call((iRcs, callingPackage) -> iRcs.getFileTransfersAttachedToMessage(this.mId, this.isIncoming(), callingPackage))) {
            fileTransferParts.add(new RcsFileTransferPart(this.mRcsControllerCall, fileTransfer));
        }
        return Collections.unmodifiableSet(fileTransferParts);
    }

    public void removeFileTransferPart(RcsFileTransferPart fileTransferPart) throws RcsMessageStoreException {
        if (fileTransferPart == null) {
            return;
        }
        this.mRcsControllerCall.callWithNoReturn((iRcs, callingPackage) -> iRcs.deleteFileTransfer(fileTransferPart.getId(), callingPackage));
    }

    public abstract boolean isIncoming();

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RcsMessageStatus {
    }
}

