/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.emergency;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class EmergencyNumber
implements Parcelable,
Comparable<EmergencyNumber> {
    private static final String LOG_TAG = "EmergencyNumber";
    public static final int EMERGENCY_SERVICE_CATEGORY_UNSPECIFIED = 0;
    public static final int EMERGENCY_SERVICE_CATEGORY_POLICE = 1;
    public static final int EMERGENCY_SERVICE_CATEGORY_AMBULANCE = 2;
    public static final int EMERGENCY_SERVICE_CATEGORY_FIRE_BRIGADE = 4;
    public static final int EMERGENCY_SERVICE_CATEGORY_MARINE_GUARD = 8;
    public static final int EMERGENCY_SERVICE_CATEGORY_MOUNTAIN_RESCUE = 16;
    public static final int EMERGENCY_SERVICE_CATEGORY_MIEC = 32;
    public static final int EMERGENCY_SERVICE_CATEGORY_AIEC = 64;
    private static final Set<Integer> EMERGENCY_SERVICE_CATEGORY_SET = new HashSet<Integer>();
    public static final int EMERGENCY_NUMBER_SOURCE_NETWORK_SIGNALING = 1;
    public static final int EMERGENCY_NUMBER_SOURCE_SIM = 2;
    public static final int EMERGENCY_NUMBER_SOURCE_DATABASE = 16;
    public static final int EMERGENCY_NUMBER_SOURCE_TEST = 32;
    public static final int EMERGENCY_NUMBER_SOURCE_MODEM_CONFIG = 4;
    public static final int EMERGENCY_NUMBER_SOURCE_DEFAULT = 8;
    private static final Set<Integer> EMERGENCY_NUMBER_SOURCE_SET;
    public static final int EMERGENCY_CALL_ROUTING_UNKNOWN = 0;
    public static final int EMERGENCY_CALL_ROUTING_EMERGENCY = 1;
    public static final int EMERGENCY_CALL_ROUTING_NORMAL = 2;
    private final String mNumber;
    private final String mCountryIso;
    private final String mMnc;
    private final int mEmergencyServiceCategoryBitmask;
    private final List<String> mEmergencyUrns;
    private final int mEmergencyNumberSourceBitmask;
    private final int mEmergencyCallRouting;
    public static final Parcelable.Creator<EmergencyNumber> CREATOR;

    public EmergencyNumber(String number, String countryIso, String mnc, int emergencyServiceCategories, List<String> emergencyUrns, int emergencyNumberSources, int emergencyCallRouting) {
        this.mNumber = number;
        this.mCountryIso = countryIso;
        this.mMnc = mnc;
        this.mEmergencyServiceCategoryBitmask = emergencyServiceCategories;
        this.mEmergencyUrns = emergencyUrns;
        this.mEmergencyNumberSourceBitmask = emergencyNumberSources;
        this.mEmergencyCallRouting = emergencyCallRouting;
    }

    public EmergencyNumber(Parcel source) {
        this.mNumber = source.readString();
        this.mCountryIso = source.readString();
        this.mMnc = source.readString();
        this.mEmergencyServiceCategoryBitmask = source.readInt();
        this.mEmergencyUrns = source.createStringArrayList();
        this.mEmergencyNumberSourceBitmask = source.readInt();
        this.mEmergencyCallRouting = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mNumber);
        dest.writeString(this.mCountryIso);
        dest.writeString(this.mMnc);
        dest.writeInt(this.mEmergencyServiceCategoryBitmask);
        dest.writeStringList(this.mEmergencyUrns);
        dest.writeInt(this.mEmergencyNumberSourceBitmask);
        dest.writeInt(this.mEmergencyCallRouting);
    }

    public String getNumber() {
        return this.mNumber;
    }

    public String getCountryIso() {
        return this.mCountryIso;
    }

    public String getMnc() {
        return this.mMnc;
    }

    public int getEmergencyServiceCategoryBitmask() {
        return this.mEmergencyServiceCategoryBitmask;
    }

    public int getEmergencyServiceCategoryBitmaskInternalDial() {
        if (this.mEmergencyNumberSourceBitmask == 16) {
            return 0;
        }
        return this.mEmergencyServiceCategoryBitmask;
    }

    public List<Integer> getEmergencyServiceCategories() {
        ArrayList<Integer> categories = new ArrayList<Integer>();
        if (this.serviceUnspecified()) {
            categories.add(0);
            return categories;
        }
        for (Integer category : EMERGENCY_SERVICE_CATEGORY_SET) {
            if (!this.isInEmergencyServiceCategories(category)) continue;
            categories.add(category);
        }
        return categories;
    }

    public List<String> getEmergencyUrns() {
        return Collections.unmodifiableList(this.mEmergencyUrns);
    }

    private boolean serviceUnspecified() {
        return this.mEmergencyServiceCategoryBitmask == 0;
    }

    public boolean isInEmergencyServiceCategories(int categories) {
        if (categories == 0) {
            return this.serviceUnspecified();
        }
        if (this.serviceUnspecified()) {
            return true;
        }
        return (this.mEmergencyServiceCategoryBitmask & categories) == categories;
    }

    public int getEmergencyNumberSourceBitmask() {
        return this.mEmergencyNumberSourceBitmask;
    }

    public List<Integer> getEmergencyNumberSources() {
        ArrayList<Integer> sources = new ArrayList<Integer>();
        for (Integer source : EMERGENCY_NUMBER_SOURCE_SET) {
            if ((this.mEmergencyNumberSourceBitmask & source) != source) continue;
            sources.add(source);
        }
        return sources;
    }

    public boolean isFromSources(int sources) {
        return (this.mEmergencyNumberSourceBitmask & sources) == sources;
    }

    public int getEmergencyCallRouting() {
        return this.mEmergencyCallRouting;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "EmergencyNumber:Number-" + this.mNumber + "|CountryIso-" + this.mCountryIso + "|Mnc-" + this.mMnc + "|ServiceCategories-" + Integer.toBinaryString(this.mEmergencyServiceCategoryBitmask) + "|Urns-" + this.mEmergencyUrns + "|Sources-" + Integer.toBinaryString(this.mEmergencyNumberSourceBitmask) + "|Routing-" + Integer.toBinaryString(this.mEmergencyCallRouting);
    }

    public boolean equals(Object o) {
        if (!EmergencyNumber.class.isInstance(o)) {
            return false;
        }
        EmergencyNumber other = (EmergencyNumber)o;
        return this.mNumber.equals(other.mNumber) && this.mCountryIso.equals(other.mCountryIso) && this.mMnc.equals(other.mMnc) && this.mEmergencyServiceCategoryBitmask == other.mEmergencyServiceCategoryBitmask && this.mEmergencyUrns.equals(other.mEmergencyUrns) && this.mEmergencyNumberSourceBitmask == other.mEmergencyNumberSourceBitmask && this.mEmergencyCallRouting == other.mEmergencyCallRouting;
    }

    public int hashCode() {
        return Objects.hash(this.mNumber, this.mCountryIso, this.mMnc, this.mEmergencyServiceCategoryBitmask, this.mEmergencyUrns, this.mEmergencyNumberSourceBitmask, this.mEmergencyCallRouting);
    }

    private int getDisplayPriorityScore() {
        int score = 0;
        if (this.isFromSources(1)) {
            score += 16;
        }
        if (this.isFromSources(2)) {
            score += 8;
        }
        if (this.isFromSources(16)) {
            score += 4;
        }
        if (this.isFromSources(8)) {
            score += 2;
        }
        if (this.isFromSources(4)) {
            ++score;
        }
        return score;
    }

    @Override
    public int compareTo(EmergencyNumber emergencyNumber) {
        if (this.getDisplayPriorityScore() > emergencyNumber.getDisplayPriorityScore()) {
            return -1;
        }
        if (this.getDisplayPriorityScore() < emergencyNumber.getDisplayPriorityScore()) {
            return 1;
        }
        if (this.getNumber().compareTo(emergencyNumber.getNumber()) != 0) {
            return this.getNumber().compareTo(emergencyNumber.getNumber());
        }
        if (this.getCountryIso().compareTo(emergencyNumber.getCountryIso()) != 0) {
            return this.getCountryIso().compareTo(emergencyNumber.getCountryIso());
        }
        if (this.getMnc().compareTo(emergencyNumber.getMnc()) != 0) {
            return this.getMnc().compareTo(emergencyNumber.getMnc());
        }
        if (this.getEmergencyServiceCategoryBitmask() != emergencyNumber.getEmergencyServiceCategoryBitmask()) {
            return this.getEmergencyServiceCategoryBitmask() > emergencyNumber.getEmergencyServiceCategoryBitmask() ? -1 : 1;
        }
        if (this.getEmergencyUrns().toString().compareTo(emergencyNumber.getEmergencyUrns().toString()) != 0) {
            return this.getEmergencyUrns().toString().compareTo(emergencyNumber.getEmergencyUrns().toString());
        }
        if (this.getEmergencyCallRouting() != emergencyNumber.getEmergencyCallRouting()) {
            return this.getEmergencyCallRouting() > emergencyNumber.getEmergencyCallRouting() ? -1 : 1;
        }
        return 0;
    }

    public static void mergeSameNumbersInEmergencyNumberList(List<EmergencyNumber> emergencyNumberList) {
        int i;
        if (emergencyNumberList == null) {
            return;
        }
        HashSet<Integer> duplicatedEmergencyNumberPosition = new HashSet<Integer>();
        for (i = 0; i < emergencyNumberList.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!EmergencyNumber.areSameEmergencyNumbers(emergencyNumberList.get(i), emergencyNumberList.get(j))) continue;
                Rlog.e(LOG_TAG, "Found unexpected duplicate numbers: " + emergencyNumberList.get(i) + " vs " + emergencyNumberList.get(j));
                emergencyNumberList.set(i, EmergencyNumber.mergeSameEmergencyNumbers(emergencyNumberList.get(i), emergencyNumberList.get(j)));
                duplicatedEmergencyNumberPosition.add(j);
            }
        }
        for (i = emergencyNumberList.size() - 1; i >= 0; --i) {
            if (!duplicatedEmergencyNumberPosition.contains(i)) continue;
            emergencyNumberList.remove(i);
        }
        Collections.sort(emergencyNumberList);
    }

    public static boolean areSameEmergencyNumbers(EmergencyNumber first, EmergencyNumber second) {
        if (!first.getNumber().equals(second.getNumber())) {
            return false;
        }
        if (!first.getCountryIso().equals(second.getCountryIso())) {
            return false;
        }
        if (!first.getMnc().equals(second.getMnc())) {
            return false;
        }
        if (first.getEmergencyServiceCategoryBitmask() != second.getEmergencyServiceCategoryBitmask()) {
            return false;
        }
        if (!first.getEmergencyUrns().equals(second.getEmergencyUrns())) {
            return false;
        }
        if (first.getEmergencyCallRouting() != second.getEmergencyCallRouting()) {
            return false;
        }
        return !(first.isFromSources(32) ^ second.isFromSources(32));
    }

    public static EmergencyNumber mergeSameEmergencyNumbers(EmergencyNumber first, EmergencyNumber second) {
        if (EmergencyNumber.areSameEmergencyNumbers(first, second)) {
            return new EmergencyNumber(first.getNumber(), first.getCountryIso(), first.getMnc(), first.getEmergencyServiceCategoryBitmask(), first.getEmergencyUrns(), first.getEmergencyNumberSourceBitmask() | second.getEmergencyNumberSourceBitmask(), first.getEmergencyCallRouting());
        }
        return null;
    }

    public static boolean validateEmergencyNumberAddress(String address) {
        if (address == null) {
            return false;
        }
        for (char c : address.toCharArray()) {
            if (PhoneNumberUtils.isDialable(c)) continue;
            return false;
        }
        return true;
    }

    static {
        EMERGENCY_SERVICE_CATEGORY_SET.add(1);
        EMERGENCY_SERVICE_CATEGORY_SET.add(2);
        EMERGENCY_SERVICE_CATEGORY_SET.add(4);
        EMERGENCY_SERVICE_CATEGORY_SET.add(8);
        EMERGENCY_SERVICE_CATEGORY_SET.add(16);
        EMERGENCY_SERVICE_CATEGORY_SET.add(32);
        EMERGENCY_SERVICE_CATEGORY_SET.add(64);
        EMERGENCY_NUMBER_SOURCE_SET = new HashSet<Integer>();
        EMERGENCY_NUMBER_SOURCE_SET.add(1);
        EMERGENCY_NUMBER_SOURCE_SET.add(2);
        EMERGENCY_NUMBER_SOURCE_SET.add(16);
        EMERGENCY_NUMBER_SOURCE_SET.add(4);
        EMERGENCY_NUMBER_SOURCE_SET.add(8);
        CREATOR = new Parcelable.Creator<EmergencyNumber>(){

            @Override
            public EmergencyNumber createFromParcel(Parcel in) {
                return new EmergencyNumber(in);
            }

            public EmergencyNumber[] newArray(int size) {
                return new EmergencyNumber[size];
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmergencyCallRouting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmergencyNumberSources {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EmergencyServiceCategories {
    }
}

