/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.RILConstants;

public class RadioAccessFamily
implements Parcelable {
    public static final int RAF_UNKNOWN = 0;
    public static final int RAF_GSM = 32768;
    public static final int RAF_GPRS = 1;
    public static final int RAF_EDGE = 2;
    public static final int RAF_IS95A = 8;
    public static final int RAF_IS95B = 8;
    public static final int RAF_1xRTT = 64;
    public static final int RAF_EVDO_0 = 16;
    public static final int RAF_EVDO_A = 32;
    public static final int RAF_EVDO_B = 2048;
    public static final int RAF_EHRPD = 8192;
    public static final int RAF_HSUPA = 256;
    public static final int RAF_HSDPA = 128;
    public static final int RAF_HSPA = 512;
    public static final int RAF_HSPAP = 16384;
    public static final int RAF_UMTS = 4;
    public static final int RAF_TD_SCDMA = 65536;
    public static final int RAF_LTE = 4096;
    public static final int RAF_LTE_CA = 262144;
    public static final int RAF_NR = 524288;
    private static final int GSM = 32771;
    private static final int CDMA = 72;
    private static final int EVDO = 10288;
    private static final int HS = 17280;
    private static final int WCDMA = 17284;
    private static final int LTE = 266240;
    private static final int NR = 524288;
    private int mPhoneId;
    private int mRadioAccessFamily;
    public static final Parcelable.Creator<RadioAccessFamily> CREATOR = new Parcelable.Creator<RadioAccessFamily>(){

        @Override
        public RadioAccessFamily createFromParcel(Parcel in) {
            int phoneId = in.readInt();
            int radioAccessFamily = in.readInt();
            return new RadioAccessFamily(phoneId, radioAccessFamily);
        }

        public RadioAccessFamily[] newArray(int size) {
            return new RadioAccessFamily[size];
        }
    };

    @UnsupportedAppUsage
    public RadioAccessFamily(int phoneId, int radioAccessFamily) {
        this.mPhoneId = phoneId;
        this.mRadioAccessFamily = radioAccessFamily;
    }

    @UnsupportedAppUsage
    public int getPhoneId() {
        return this.mPhoneId;
    }

    @UnsupportedAppUsage
    public int getRadioAccessFamily() {
        return this.mRadioAccessFamily;
    }

    public String toString() {
        String ret = "{ mPhoneId = " + this.mPhoneId + ", mRadioAccessFamily = " + this.mRadioAccessFamily + "}";
        return ret;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel outParcel, int flags) {
        outParcel.writeInt(this.mPhoneId);
        outParcel.writeInt(this.mRadioAccessFamily);
    }

    @UnsupportedAppUsage
    public static int getRafFromNetworkType(int type) {
        switch (type) {
            case 0: {
                return 50055;
            }
            case 1: {
                return 32771;
            }
            case 2: {
                return 17284;
            }
            case 3: {
                return 50055;
            }
            case 4: {
                return 10360;
            }
            case 8: {
                return 276600;
            }
            case 9: {
                return 316295;
            }
            case 10: {
                return 326655;
            }
            case 11: {
                return 266240;
            }
            case 12: {
                return 283524;
            }
            case 5: {
                return 72;
            }
            case 6: {
                return 10288;
            }
            case 7: {
                return 60415;
            }
            case 13: {
                return 65536;
            }
            case 14: {
                return 82820;
            }
            case 15: {
                return 331776;
            }
            case 16: {
                return 98307;
            }
            case 17: {
                return 364547;
            }
            case 18: {
                return 115591;
            }
            case 19: {
                return 349060;
            }
            case 20: {
                return 381831;
            }
            case 21: {
                return 125951;
            }
            case 22: {
                return 392191;
            }
            case 23: {
                return 524288;
            }
            case 24: {
                return 790528;
            }
            case 25: {
                return 800888;
            }
            case 26: {
                return 840583;
            }
            case 27: {
                return 850943;
            }
            case 28: {
                return 807812;
            }
            case 29: {
                return 856064;
            }
            case 30: {
                return 888835;
            }
            case 31: {
                return 873348;
            }
            case 32: {
                return 906119;
            }
            case 33: {
                return 916479;
            }
        }
        return 0;
    }

    private static int getAdjustedRaf(int raf) {
        raf = (0x8003 & raf) > 0 ? 0x8003 | raf : raf;
        raf = (0x4384 & raf) > 0 ? 0x4384 | raf : raf;
        raf = (0x48 & raf) > 0 ? 0x48 | raf : raf;
        raf = (0x2830 & raf) > 0 ? 0x2830 | raf : raf;
        raf = (0x41000 & raf) > 0 ? 0x41000 | raf : raf;
        raf = (0x80000 & raf) > 0 ? 0x80000 | raf : raf;
        return raf;
    }

    public static int getHighestRafCapability(int raf) {
        if ((0x41000 & raf) > 0) {
            return 3;
        }
        if ((0x6BB0 | 0x4384 & raf) > 0) {
            return 2;
        }
        if ((0x8003 | 0x48 & raf) > 0) {
            return 1;
        }
        return 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static int getNetworkTypeFromRaf(int raf) {
        raf = RadioAccessFamily.getAdjustedRaf(raf);
        switch (raf) {
            case 50055: {
                return 0;
            }
            case 32771: {
                return 1;
            }
            case 17284: {
                return 2;
            }
            case 10360: {
                return 4;
            }
            case 276600: {
                return 8;
            }
            case 316295: {
                return 9;
            }
            case 326655: {
                return 10;
            }
            case 266240: {
                return 11;
            }
            case 283524: {
                return 12;
            }
            case 72: {
                return 5;
            }
            case 10288: {
                return 6;
            }
            case 60415: {
                return 7;
            }
            case 65536: {
                return 13;
            }
            case 82820: {
                return 14;
            }
            case 331776: {
                return 15;
            }
            case 98307: {
                return 16;
            }
            case 364547: {
                return 17;
            }
            case 115591: {
                return 18;
            }
            case 349060: {
                return 19;
            }
            case 381831: {
                return 20;
            }
            case 125951: {
                return 21;
            }
            case 392191: {
                return 22;
            }
            case 524288: {
                return 23;
            }
            case 790528: {
                return 24;
            }
            case 800888: {
                return 25;
            }
            case 840583: {
                return 26;
            }
            case 850943: {
                return 27;
            }
            case 807812: {
                return 28;
            }
            case 856064: {
                return 29;
            }
            case 888835: {
                return 30;
            }
            case 873348: {
                return 31;
            }
            case 906119: {
                return 32;
            }
            case 916479: {
                return 33;
            }
        }
        return RILConstants.PREFERRED_NETWORK_MODE;
    }

    public static int singleRafTypeFromString(String rafString) {
        switch (rafString) {
            case "GPRS": {
                return 1;
            }
            case "EDGE": {
                return 2;
            }
            case "UMTS": {
                return 4;
            }
            case "IS95A": {
                return 8;
            }
            case "IS95B": {
                return 8;
            }
            case "1XRTT": {
                return 64;
            }
            case "EVDO_0": {
                return 16;
            }
            case "EVDO_A": {
                return 32;
            }
            case "HSDPA": {
                return 128;
            }
            case "HSUPA": {
                return 256;
            }
            case "HSPA": {
                return 512;
            }
            case "EVDO_B": {
                return 2048;
            }
            case "EHRPD": {
                return 8192;
            }
            case "LTE": {
                return 4096;
            }
            case "HSPAP": {
                return 16384;
            }
            case "GSM": {
                return 32768;
            }
            case "TD_SCDMA": {
                return 65536;
            }
            case "HS": {
                return 17280;
            }
            case "CDMA": {
                return 72;
            }
            case "EVDO": {
                return 10288;
            }
            case "WCDMA": {
                return 17284;
            }
            case "LTE_CA": {
                return 262144;
            }
            case "NR": {
                return 524288;
            }
        }
        return 0;
    }

    public static int rafTypeFromString(String rafList) {
        rafList = rafList.toUpperCase();
        String[] rafs = rafList.split("\\|");
        int result = 0;
        for (String raf : rafs) {
            int rafType = RadioAccessFamily.singleRafTypeFromString(raf.trim());
            if (rafType == 0) {
                return rafType;
            }
            result |= rafType;
        }
        return result;
    }
}

