/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.UnsupportedAppUsage;
import android.hardware.radio.V1_0.LteSignalStrength;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import java.util.Objects;

public class CellSignalStrengthLte
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthLte";
    private static final boolean DBG = false;
    private static final int SIGNAL_STRENGTH_LTE_RSSI_ASU_UNKNOWN = 99;
    private static final int SIGNAL_STRENGTH_LTE_RSSI_VALID_ASU_MAX_VALUE = 31;
    private static final int SIGNAL_STRENGTH_LTE_RSSI_VALID_ASU_MIN_VALUE = 0;
    private static final int MAX_LTE_RSRP = -44;
    private static final int MIN_LTE_RSRP = -140;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mSignalStrength;
    private int mRssi;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mRsrp;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mRsrq;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mRssnr;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mCqi;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mTimingAdvance;
    private int mLevel;
    private static final int[] sThresholds = new int[]{-115, -105, -95, -85};
    private static final int sRsrpBoost = 0;
    private static final CellSignalStrengthLte sInvalid = new CellSignalStrengthLte();
    public static final Parcelable.Creator<CellSignalStrengthLte> CREATOR = new Parcelable.Creator<CellSignalStrengthLte>(){

        @Override
        public CellSignalStrengthLte createFromParcel(Parcel in) {
            return new CellSignalStrengthLte(in);
        }

        public CellSignalStrengthLte[] newArray(int size) {
            return new CellSignalStrengthLte[size];
        }
    };

    @UnsupportedAppUsage
    public CellSignalStrengthLte() {
        this.setDefaultValues();
    }

    public CellSignalStrengthLte(int rssi, int rsrp, int rsrq, int rssnr, int cqi, int timingAdvance) {
        this.mSignalStrength = this.mRssi = CellSignalStrengthLte.inRangeOrUnavailable(rssi, -113, -51);
        this.mRsrp = CellSignalStrengthLte.inRangeOrUnavailable(rsrp, -140, -43);
        this.mRsrq = CellSignalStrengthLte.inRangeOrUnavailable(rsrq, -20, -3);
        this.mRssnr = CellSignalStrengthLte.inRangeOrUnavailable(rssnr, -200, 300);
        this.mCqi = CellSignalStrengthLte.inRangeOrUnavailable(cqi, 0, 15);
        this.mTimingAdvance = CellSignalStrengthLte.inRangeOrUnavailable(timingAdvance, 0, 1282);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthLte(LteSignalStrength lte) {
        this(CellSignalStrengthLte.convertRssiAsuToDBm(lte.signalStrength), lte.rsrp != Integer.MAX_VALUE ? -lte.rsrp : lte.rsrp, lte.rsrq != Integer.MAX_VALUE ? -lte.rsrq : lte.rsrq, lte.rssnr, lte.cqi, lte.timingAdvance);
    }

    public CellSignalStrengthLte(CellSignalStrengthLte s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthLte s) {
        this.mSignalStrength = s.mSignalStrength;
        this.mRssi = s.mRssi;
        this.mRsrp = s.mRsrp;
        this.mRsrq = s.mRsrq;
        this.mRssnr = s.mRssnr;
        this.mCqi = s.mCqi;
        this.mTimingAdvance = s.mTimingAdvance;
        this.mLevel = s.mLevel;
    }

    @Override
    public CellSignalStrengthLte copy() {
        return new CellSignalStrengthLte(this);
    }

    @Override
    public void setDefaultValues() {
        this.mSignalStrength = Integer.MAX_VALUE;
        this.mRssi = Integer.MAX_VALUE;
        this.mRsrp = Integer.MAX_VALUE;
        this.mRsrq = Integer.MAX_VALUE;
        this.mRssnr = Integer.MAX_VALUE;
        this.mCqi = Integer.MAX_VALUE;
        this.mTimingAdvance = Integer.MAX_VALUE;
        this.mLevel = 0;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        boolean rsrpOnly;
        int[] thresholds;
        if (cc == null) {
            thresholds = sThresholds;
            rsrpOnly = false;
        } else {
            rsrpOnly = cc.getBoolean("use_only_rsrp_for_lte_signal_bar_bool", false);
            thresholds = cc.getIntArray("lte_rsrp_thresholds_int_array");
            if (thresholds == null) {
                thresholds = sThresholds;
            }
        }
        int rsrpBoost = 0;
        if (ss != null) {
            rsrpBoost = ss.getLteEarfcnRsrpBoost();
        }
        int rssiIconLevel = 0;
        int rsrpIconLevel = 0;
        int snrIconLevel = -1;
        int rsrp = this.mRsrp + rsrpBoost;
        if (rsrp < -140 || rsrp > -44) {
            rsrpIconLevel = -1;
        } else {
            for (rsrpIconLevel = thresholds.length; rsrpIconLevel > 0 && rsrp < thresholds[rsrpIconLevel - 1]; --rsrpIconLevel) {
            }
        }
        if (rsrpOnly && rsrpIconLevel != -1) {
            this.mLevel = rsrpIconLevel;
            return;
        }
        if (this.mRssnr > 300) {
            snrIconLevel = -1;
        } else if (this.mRssnr >= 130) {
            snrIconLevel = 4;
        } else if (this.mRssnr >= 45) {
            snrIconLevel = 3;
        } else if (this.mRssnr >= 10) {
            snrIconLevel = 2;
        } else if (this.mRssnr >= -30) {
            snrIconLevel = 1;
        } else if (this.mRssnr >= -200) {
            snrIconLevel = 0;
        }
        if (snrIconLevel != -1 && rsrpIconLevel != -1) {
            this.mLevel = rsrpIconLevel < snrIconLevel ? rsrpIconLevel : snrIconLevel;
            return;
        }
        if (snrIconLevel != -1) {
            this.mLevel = snrIconLevel;
            return;
        }
        if (rsrpIconLevel != -1) {
            this.mLevel = rsrpIconLevel;
            return;
        }
        rssiIconLevel = this.mRssi > -51 ? 0 : (this.mRssi >= -89 ? 4 : (this.mRssi >= -97 ? 3 : (this.mRssi >= -103 ? 2 : (this.mRssi >= -113 ? 1 : 0))));
        this.mLevel = rssiIconLevel;
    }

    public int getRsrq() {
        return this.mRsrq;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getRssnr() {
        return this.mRssnr;
    }

    public int getRsrp() {
        return this.mRsrp;
    }

    public int getCqi() {
        return this.mCqi;
    }

    @Override
    public int getDbm() {
        return this.mRsrp;
    }

    @Override
    public int getAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.mRsrp;
        lteAsuLevel = lteDbm == Integer.MAX_VALUE ? 99 : (lteDbm <= -140 ? 0 : (lteDbm >= -43 ? 97 : lteDbm + 140));
        return lteAsuLevel;
    }

    public int getTimingAdvance() {
        return this.mTimingAdvance;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mRssi, this.mRsrp, this.mRsrq, this.mRssnr, this.mCqi, this.mTimingAdvance, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CellSignalStrengthLte)) {
            return false;
        }
        CellSignalStrengthLte s = (CellSignalStrengthLte)o;
        return this.mRssi == s.mRssi && this.mRsrp == s.mRsrp && this.mRsrq == s.mRsrq && this.mRssnr == s.mRssnr && this.mCqi == s.mCqi && this.mTimingAdvance == s.mTimingAdvance && this.mLevel == s.mLevel;
    }

    public String toString() {
        return "CellSignalStrengthLte: rssi=" + this.mRssi + " rsrp=" + this.mRsrp + " rsrq=" + this.mRsrq + " rssnr=" + this.mRssnr + " cqi=" + this.mCqi + " ta=" + this.mTimingAdvance + " level=" + this.mLevel;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mRsrp);
        dest.writeInt(this.mRsrq);
        dest.writeInt(this.mRssnr);
        dest.writeInt(this.mCqi);
        dest.writeInt(this.mTimingAdvance);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthLte(Parcel in) {
        this.mSignalStrength = this.mRssi = in.readInt();
        this.mRsrp = in.readInt();
        this.mRsrq = in.readInt();
        this.mRssnr = in.readInt();
        this.mCqi = in.readInt();
        this.mTimingAdvance = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }

    private static int convertRssiAsuToDBm(int rssiAsu) {
        if (rssiAsu == 99) {
            return Integer.MAX_VALUE;
        }
        if (rssiAsu < 0 || rssiAsu > 31) {
            Rlog.e(LOG_TAG, "convertRssiAsuToDBm: invalid RSSI in ASU=" + rssiAsu);
            return Integer.MAX_VALUE;
        }
        return -113 + 2 * rssiAsu;
    }
}

