/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.SystemProperties;
import android.os.Trace;
import android.provider.Settings;
import android.util.Log;
import android.widget.Toast;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphicsEnvironment {
    private static final GraphicsEnvironment sInstance = new GraphicsEnvironment();
    private static final boolean DEBUG = false;
    private static final String TAG = "GraphicsEnvironment";
    private static final String SYSTEM_DRIVER_NAME = "system";
    private static final String SYSTEM_DRIVER_VERSION_NAME = "";
    private static final long SYSTEM_DRIVER_VERSION_CODE = 0L;
    private static final String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";
    private static final String PROPERTY_GFX_DRIVER_PRERELEASE = "ro.gfx.driver.1";
    private static final String PROPERTY_GFX_DRIVER_BUILD_TIME = "ro.gfx.driver_build_time";
    private static final String METADATA_DRIVER_BUILD_TIME = "com.android.gamedriver.build_time";
    private static final String ANGLE_RULES_FILE = "a4a_rules.json";
    private static final String ANGLE_TEMP_RULES = "debug.angle.rules";
    private static final String ACTION_ANGLE_FOR_ANDROID = "android.app.action.ANGLE_FOR_ANDROID";
    private static final String ACTION_ANGLE_FOR_ANDROID_TOAST_MESSAGE = "android.app.action.ANGLE_FOR_ANDROID_TOAST_MESSAGE";
    private static final String INTENT_KEY_A4A_TOAST_MESSAGE = "A4A Toast Message";
    private static final String GAME_DRIVER_WHITELIST_ALL = "*";
    private static final String GAME_DRIVER_SPHAL_LIBRARIES_FILENAME = "sphal_libraries.txt";
    private static final int VULKAN_1_0 = 0x400000;
    private static final int VULKAN_1_1 = 0x401000;
    private static final int GAME_DRIVER_GLOBAL_OPT_IN_DEFAULT = 0;
    private static final int GAME_DRIVER_GLOBAL_OPT_IN_GAME_DRIVER = 1;
    private static final int GAME_DRIVER_GLOBAL_OPT_IN_PRERELEASE_DRIVER = 2;
    private static final int GAME_DRIVER_GLOBAL_OPT_IN_OFF = 3;
    private ClassLoader mClassLoader;
    private String mLayerPath;
    private String mDebugLayerPath;
    private static final Map<OpenGlDriverChoice, String> sDriverMap = GraphicsEnvironment.buildMap();

    public static GraphicsEnvironment getInstance() {
        return sInstance;
    }

    public void setup(Context context, Bundle coreSettings) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        Trace.traceBegin(2L, "setupGpuLayers");
        this.setupGpuLayers(context, coreSettings, pm, packageName);
        Trace.traceEnd(2L);
        Trace.traceBegin(2L, "setupAngle");
        this.setupAngle(context, coreSettings, pm, packageName);
        Trace.traceEnd(2L);
        Trace.traceBegin(2L, "chooseDriver");
        if (!GraphicsEnvironment.chooseDriver(context, coreSettings, pm, packageName)) {
            GraphicsEnvironment.setGpuStats(SYSTEM_DRIVER_NAME, SYSTEM_DRIVER_VERSION_NAME, 0L, SystemProperties.getLong(PROPERTY_GFX_DRIVER_BUILD_TIME, 0L), packageName, GraphicsEnvironment.getVulkanVersion(pm));
        }
        Trace.traceEnd(2L);
    }

    public static void hintActivityLaunch() {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#hintActivityLaunch()V", true, null);
    }

    public static boolean shouldUseAngle(Context context, Bundle coreSettings, String packageName) {
        boolean useAngle;
        if (packageName.isEmpty()) {
            Log.v(TAG, "No package name available yet, ANGLE should not be used");
            return false;
        }
        String devOptIn = GraphicsEnvironment.getDriverForPkg(context, coreSettings, packageName);
        boolean whitelisted = GraphicsEnvironment.checkAngleWhitelist(context, coreSettings, packageName);
        boolean requested = devOptIn.equals(sDriverMap.get((Object)OpenGlDriverChoice.ANGLE));
        boolean bl = useAngle = whitelisted || requested;
        if (!useAngle) {
            return false;
        }
        if (whitelisted) {
            Log.v(TAG, "ANGLE whitelist includes " + packageName);
        }
        if (requested) {
            Log.v(TAG, "ANGLE developer option for " + packageName + ": " + devOptIn);
        }
        return true;
    }

    private static int getVulkanVersion(PackageManager pm) {
        if (pm.hasSystemFeature("android.hardware.vulkan.version", 0x401000)) {
            return 0x401000;
        }
        if (pm.hasSystemFeature("android.hardware.vulkan.version", 0x400000)) {
            return 0x400000;
        }
        return 0;
    }

    private static boolean isDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) > 0;
    }

    public void setLayerPaths(ClassLoader classLoader, String layerPath, String debugLayerPath) {
        this.mClassLoader = classLoader;
        this.mLayerPath = layerPath;
        this.mDebugLayerPath = debugLayerPath;
    }

    private static String getDebugLayerAppPaths(PackageManager pm, String app) {
        ApplicationInfo appInfo;
        try {
            appInfo = pm.getApplicationInfo(app, 131072);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Debug layer app '" + app + "' not installed");
            return null;
        }
        String abi = GraphicsEnvironment.chooseAbi(appInfo);
        StringBuilder sb = new StringBuilder();
        sb.append(appInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(appInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        return paths;
    }

    private void setupGpuLayers(Context context, Bundle coreSettings, PackageManager pm, String packageName) {
        String gpuDebugApp;
        int enable;
        String layerPaths = SYSTEM_DRIVER_VERSION_NAME;
        if ((GraphicsEnvironment.isDebuggable(context) || GraphicsEnvironment.getCanLoadSystemLibraries() == 1) && (enable = coreSettings.getInt("enable_gpu_debug_layers", 0)) != 0 && (gpuDebugApp = coreSettings.getString("gpu_debug_app")) != null && packageName != null && !gpuDebugApp.isEmpty() && !packageName.isEmpty() && gpuDebugApp.equals(packageName)) {
            Log.i(TAG, "GPU debug layers enabled for " + packageName);
            layerPaths = this.mDebugLayerPath + ":";
            String gpuDebugLayerApp = coreSettings.getString("gpu_debug_layer_app");
            if (gpuDebugLayerApp != null && !gpuDebugLayerApp.isEmpty()) {
                Log.i(TAG, "GPU debug layer app: " + gpuDebugLayerApp);
                String[] layerApps = gpuDebugLayerApp.split(":");
                for (int i = 0; i < layerApps.length; ++i) {
                    String paths = GraphicsEnvironment.getDebugLayerAppPaths(pm, layerApps[i]);
                    if (paths == null) continue;
                    layerPaths = layerPaths + paths + ":";
                }
            }
            String layers = coreSettings.getString("gpu_debug_layers");
            Log.i(TAG, "Vulkan debug layer list: " + layers);
            if (layers != null && !layers.isEmpty()) {
                GraphicsEnvironment.setDebugLayers(layers);
            }
            String layersGLES = coreSettings.getString("gpu_debug_layers_gles");
            Log.i(TAG, "GLES debug layer list: " + layersGLES);
            if (layersGLES != null && !layersGLES.isEmpty()) {
                GraphicsEnvironment.setDebugLayersGLES(layersGLES);
            }
        }
        layerPaths = layerPaths + this.mLayerPath;
        GraphicsEnvironment.setLayerPaths(this.mClassLoader, layerPaths);
    }

    private static Map<OpenGlDriverChoice, String> buildMap() {
        HashMap<OpenGlDriverChoice, String> map = new HashMap<OpenGlDriverChoice, String>();
        map.put(OpenGlDriverChoice.DEFAULT, "default");
        map.put(OpenGlDriverChoice.ANGLE, "angle");
        map.put(OpenGlDriverChoice.NATIVE, "native");
        return map;
    }

    private static List<String> getGlobalSettingsString(ContentResolver contentResolver, Bundle bundle, String globalSetting) {
        String settingsValue = bundle != null ? bundle.getString(globalSetting) : Settings.Global.getString(contentResolver, globalSetting);
        ArrayList<String> valueList = settingsValue != null ? new ArrayList<String>(Arrays.asList(settingsValue.split(","))) : new ArrayList<String>();
        return valueList;
    }

    private static int getGlobalSettingsPkgIndex(String pkgName, List<String> globalSettingsDriverPkgs) {
        for (int pkgIndex = 0; pkgIndex < globalSettingsDriverPkgs.size(); ++pkgIndex) {
            if (!globalSettingsDriverPkgs.get(pkgIndex).equals(pkgName)) continue;
            return pkgIndex;
        }
        return -1;
    }

    private static String getDriverForPkg(Context context, Bundle bundle, String packageName) {
        ContentResolver contentResolver;
        String allUseAngle;
        if (bundle != null) {
            allUseAngle = bundle.getString("angle_gl_driver_all_angle");
        } else {
            contentResolver = context.getContentResolver();
            allUseAngle = Settings.Global.getString(contentResolver, "angle_gl_driver_all_angle");
        }
        if (allUseAngle != null && allUseAngle.equals("1")) {
            return sDriverMap.get((Object)OpenGlDriverChoice.ANGLE);
        }
        contentResolver = context.getContentResolver();
        List<String> globalSettingsDriverPkgs = GraphicsEnvironment.getGlobalSettingsString(contentResolver, bundle, "angle_gl_driver_selection_pkgs");
        List<String> globalSettingsDriverValues = GraphicsEnvironment.getGlobalSettingsString(contentResolver, bundle, "angle_gl_driver_selection_values");
        if (packageName == null || packageName.isEmpty()) {
            return sDriverMap.get((Object)OpenGlDriverChoice.DEFAULT);
        }
        if (globalSettingsDriverPkgs.size() != globalSettingsDriverValues.size()) {
            Log.w(TAG, "Global.Settings values are invalid: globalSettingsDriverPkgs.size = " + globalSettingsDriverPkgs.size() + ", globalSettingsDriverValues.size = " + globalSettingsDriverValues.size());
            return sDriverMap.get((Object)OpenGlDriverChoice.DEFAULT);
        }
        int pkgIndex = GraphicsEnvironment.getGlobalSettingsPkgIndex(packageName, globalSettingsDriverPkgs);
        if (pkgIndex < 0) {
            return sDriverMap.get((Object)OpenGlDriverChoice.DEFAULT);
        }
        return globalSettingsDriverValues.get(pkgIndex);
    }

    private String getAnglePackageName(PackageManager pm) {
        Intent intent = new Intent(ACTION_ANGLE_FOR_ANDROID);
        List<ResolveInfo> resolveInfos = pm.queryIntentActivities(intent, 0x100000);
        if (resolveInfos.size() != 1) {
            Log.e(TAG, "Invalid number of ANGLE packages. Required: 1, Found: " + resolveInfos.size());
            for (ResolveInfo resolveInfo : resolveInfos) {
                Log.e(TAG, "Found ANGLE package: " + resolveInfo.activityInfo.packageName);
            }
            return SYSTEM_DRIVER_VERSION_NAME;
        }
        return resolveInfos.get((int)0).activityInfo.packageName;
    }

    private String getAngleDebugPackage(Context context, Bundle coreSettings) {
        boolean deviceIsDebuggable;
        boolean appIsDebuggable = GraphicsEnvironment.isDebuggable(context);
        boolean bl = deviceIsDebuggable = GraphicsEnvironment.getCanLoadSystemLibraries() == 1;
        if (appIsDebuggable || deviceIsDebuggable) {
            String debugPackage;
            if (coreSettings != null) {
                debugPackage = coreSettings.getString("angle_debug_package");
            } else {
                ContentResolver contentResolver = context.getContentResolver();
                debugPackage = Settings.Global.getString(contentResolver, "angle_debug_package");
            }
            if (debugPackage != null && !debugPackage.isEmpty()) {
                return debugPackage;
            }
        }
        return SYSTEM_DRIVER_VERSION_NAME;
    }

    private static boolean setupAngleWithTempRulesFile(Context context, String packageName, String paths, String devOptIn) {
        boolean deviceIsDebuggable;
        boolean appIsDebuggable = GraphicsEnvironment.isDebuggable(context);
        boolean bl = deviceIsDebuggable = GraphicsEnvironment.getCanLoadSystemLibraries() == 1;
        if (!appIsDebuggable && !deviceIsDebuggable) {
            Log.v(TAG, "Skipping loading temporary rules file: appIsDebuggable = " + appIsDebuggable + ", adbRootEnabled = " + deviceIsDebuggable);
            return false;
        }
        String angleTempRules = SystemProperties.get(ANGLE_TEMP_RULES);
        if (angleTempRules == null || angleTempRules.isEmpty()) {
            Log.v(TAG, "System property 'debug.angle.rules' is not set or is empty");
            return false;
        }
        Log.i(TAG, "Detected system property debug.angle.rules: " + angleTempRules);
        File tempRulesFile = new File(angleTempRules);
        if (tempRulesFile.exists()) {
            Log.i(TAG, angleTempRules + " exists, loading file.");
            try {
                FileInputStream stream = new FileInputStream(angleTempRules);
                try {
                    FileDescriptor rulesFd = stream.getFD();
                    long rulesOffset = 0L;
                    long rulesLength = stream.getChannel().size();
                    Log.i(TAG, "Loaded temporary ANGLE rules from " + angleTempRules);
                    GraphicsEnvironment.setAngleInfo(paths, packageName, devOptIn, rulesFd, 0L, rulesLength);
                    stream.close();
                    return true;
                }
                catch (IOException e) {
                    Log.w(TAG, "Hit IOException thrown by FileInputStream: " + e);
                }
            }
            catch (FileNotFoundException e) {
                Log.w(TAG, "Temp ANGLE rules file not found: " + e);
            }
            catch (SecurityException e) {
                Log.w(TAG, "Temp ANGLE rules file not accessible: " + e);
            }
        }
        return false;
    }

    private static boolean setupAngleRulesApk(String anglePkgName, ApplicationInfo angleInfo, PackageManager pm, String packageName, String paths, String devOptIn) {
        try {
            AssetManager angleAssets = pm.getResourcesForApplication(angleInfo).getAssets();
            try {
                AssetFileDescriptor assetsFd = angleAssets.openFd(ANGLE_RULES_FILE);
                GraphicsEnvironment.setAngleInfo(paths, packageName, devOptIn, assetsFd.getFileDescriptor(), assetsFd.getStartOffset(), assetsFd.getLength());
                assetsFd.close();
                return true;
            }
            catch (IOException e) {
                Log.w(TAG, "Failed to get AssetFileDescriptor for a4a_rules.json from '" + anglePkgName + "': " + e);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Failed to get AssetManager for '" + anglePkgName + "': " + e);
        }
        return false;
    }

    private static boolean checkAngleWhitelist(Context context, Bundle bundle, String packageName) {
        ContentResolver contentResolver = context.getContentResolver();
        List<String> angleWhitelist = GraphicsEnvironment.getGlobalSettingsString(contentResolver, bundle, "angle_whitelist");
        return angleWhitelist.contains(packageName);
    }

    public boolean setupAngle(Context context, Bundle bundle, PackageManager pm, String packageName) {
        String devOptIn;
        if (!GraphicsEnvironment.shouldUseAngle(context, bundle, packageName)) {
            return false;
        }
        ApplicationInfo angleInfo = null;
        String anglePkgName = this.getAngleDebugPackage(context, bundle);
        if (!anglePkgName.isEmpty()) {
            Log.i(TAG, "ANGLE debug package enabled: " + anglePkgName);
            try {
                angleInfo = pm.getApplicationInfo(anglePkgName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, "ANGLE debug package '" + anglePkgName + "' not installed");
                return false;
            }
        }
        if (angleInfo == null) {
            anglePkgName = this.getAnglePackageName(pm);
            if (!anglePkgName.isEmpty()) {
                Log.i(TAG, "ANGLE package enabled: " + anglePkgName);
                try {
                    angleInfo = pm.getApplicationInfo(anglePkgName, 0x100000);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.w(TAG, "ANGLE package '" + anglePkgName + "' not installed");
                    return false;
                }
            } else {
                Log.e(TAG, "Failed to find ANGLE package.");
                return false;
            }
        }
        String abi = GraphicsEnvironment.chooseAbi(angleInfo);
        String paths = angleInfo.nativeLibraryDir + File.pathSeparator + angleInfo.sourceDir + "!/lib/" + abi;
        if (GraphicsEnvironment.setupAngleWithTempRulesFile(context, packageName, paths, devOptIn = GraphicsEnvironment.getDriverForPkg(context, bundle, packageName))) {
            return true;
        }
        return GraphicsEnvironment.setupAngleRulesApk(anglePkgName, angleInfo, pm, packageName, paths, devOptIn);
    }

    private boolean shouldShowAngleInUseDialogBox(Context context) {
        try {
            ContentResolver contentResolver = context.getContentResolver();
            int showDialogBox = Settings.Global.getInt(contentResolver, "show_angle_in_use_dialog_box");
            return showDialogBox == 1;
        }
        catch (Settings.SettingNotFoundException | SecurityException exception) {
            return false;
        }
    }

    private boolean setupAndUseAngle(Context context, String packageName) {
        if (!this.setupAngle(context, null, context.getPackageManager(), packageName)) {
            Log.v(TAG, "Package '" + packageName + "' should not use ANGLE");
            return false;
        }
        boolean useAngle = GraphicsEnvironment.getShouldUseAngle(packageName);
        Log.v(TAG, "Package '" + packageName + "' should use ANGLE = '" + useAngle + "'");
        return useAngle;
    }

    public void showAngleInUseDialogBox(Context context) {
        String packageName = context.getPackageName();
        if (this.shouldShowAngleInUseDialogBox(context) && this.setupAndUseAngle(context, packageName)) {
            Intent intent = new Intent(ACTION_ANGLE_FOR_ANDROID_TOAST_MESSAGE);
            String anglePkg = this.getAnglePackageName(context.getPackageManager());
            intent.setPackage(anglePkg);
            context.sendOrderedBroadcast(intent, null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    Bundle results = this.getResultExtras(true);
                    String toastMsg = results.getString(GraphicsEnvironment.INTENT_KEY_A4A_TOAST_MESSAGE);
                    Toast toast = Toast.makeText(context, toastMsg, 1);
                    toast.show();
                }
            }, null, -1, null, null);
        }
    }

    private static String chooseDriverInternal(Context context, Bundle coreSettings) {
        boolean hasPrereleaseDriver;
        String gameDriver = SystemProperties.get(PROPERTY_GFX_DRIVER);
        boolean hasGameDriver = gameDriver != null && !gameDriver.isEmpty();
        String prereleaseDriver = SystemProperties.get(PROPERTY_GFX_DRIVER_PRERELEASE);
        boolean bl = hasPrereleaseDriver = prereleaseDriver != null && !prereleaseDriver.isEmpty();
        if (!hasGameDriver && !hasPrereleaseDriver) {
            return null;
        }
        ApplicationInfo ai = context.getApplicationInfo();
        if (ai.isPrivilegedApp() || ai.isSystemApp() && !ai.isUpdatedSystemApp()) {
            return null;
        }
        switch (coreSettings.getInt("game_driver_all_apps", 0)) {
            case 3: {
                return null;
            }
            case 1: {
                return hasGameDriver ? gameDriver : null;
            }
            case 2: {
                return hasPrereleaseDriver ? prereleaseDriver : null;
            }
        }
        String appPackageName = ai.packageName;
        if (GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "game_driver_opt_out_apps").contains(appPackageName)) {
            return null;
        }
        if (GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "game_driver_prerelease_opt_in_apps").contains(appPackageName)) {
            return hasPrereleaseDriver ? prereleaseDriver : null;
        }
        if (!hasGameDriver) {
            return null;
        }
        boolean isOptIn = GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "game_driver_opt_in_apps").contains(appPackageName);
        List<String> whitelist = GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "game_driver_whitelist");
        if (!isOptIn && whitelist.indexOf(GAME_DRIVER_WHITELIST_ALL) != 0 && !whitelist.contains(appPackageName)) {
            return null;
        }
        if (!isOptIn && GraphicsEnvironment.getGlobalSettingsString(null, coreSettings, "game_driver_blacklist").contains(appPackageName)) {
            return null;
        }
        return gameDriver;
    }

    private static boolean chooseDriver(Context context, Bundle coreSettings, PackageManager pm, String packageName) {
        PackageInfo driverPackageInfo;
        String driverPackageName = GraphicsEnvironment.chooseDriverInternal(context, coreSettings);
        if (driverPackageName == null) {
            return false;
        }
        try {
            driverPackageInfo = pm.getPackageInfo(driverPackageName, 0x100080);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "driver package '" + driverPackageName + "' not installed");
            return false;
        }
        ApplicationInfo driverAppInfo = driverPackageInfo.applicationInfo;
        if (driverAppInfo.targetSdkVersion < 26) {
            return false;
        }
        String abi = GraphicsEnvironment.chooseAbi(driverAppInfo);
        if (abi == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(driverAppInfo.nativeLibraryDir).append(File.pathSeparator);
        sb.append(driverAppInfo.sourceDir).append("!/lib/").append(abi);
        String paths = sb.toString();
        String sphalLibraries = GraphicsEnvironment.getSphalLibraries(context, driverPackageName);
        GraphicsEnvironment.setDriverPathAndSphalLibraries(paths, sphalLibraries);
        if (driverAppInfo.metaData == null) {
            throw new NullPointerException("apk's meta-data cannot be null");
        }
        String driverBuildTime = driverAppInfo.metaData.getString(METADATA_DRIVER_BUILD_TIME);
        if (driverBuildTime == null || driverBuildTime.isEmpty()) {
            throw new IllegalArgumentException("com.android.gamedriver.build_time is not set");
        }
        GraphicsEnvironment.setGpuStats(driverPackageName, driverPackageInfo.versionName, driverAppInfo.longVersionCode, Long.parseLong(driverBuildTime.substring(1)), packageName, 0);
        return true;
    }

    private static String chooseAbi(ApplicationInfo ai) {
        String isa = VMRuntime.getCurrentInstructionSet();
        if (ai.primaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.primaryCpuAbi))) {
            return ai.primaryCpuAbi;
        }
        if (ai.secondaryCpuAbi != null && isa.equals(VMRuntime.getInstructionSet(ai.secondaryCpuAbi))) {
            return ai.secondaryCpuAbi;
        }
        return null;
    }

    private static String getSphalLibraries(Context context, String driverPackageName) {
        try {
            String assetString;
            Context driverContext = context.createPackageContext(driverPackageName, 4);
            BufferedReader reader = new BufferedReader(new InputStreamReader(driverContext.getAssets().open(GAME_DRIVER_SPHAL_LIBRARIES_FILENAME)));
            ArrayList<String> assetStrings = new ArrayList<String>();
            while ((assetString = reader.readLine()) != null) {
                assetStrings.add(assetString);
            }
            return String.join((CharSequence)":", assetStrings);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return SYSTEM_DRIVER_VERSION_NAME;
    }

    private static int getCanLoadSystemLibraries() {
        return OverrideMethod.invokeI("android.os.GraphicsEnvironment#getCanLoadSystemLibraries()I", true, null);
    }

    private static void setLayerPaths(ClassLoader classLoader, String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setLayerPaths(Ljava/lang/ClassLoader;Ljava/lang/String;)V", true, null);
    }

    private static void setDebugLayers(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDebugLayers(Ljava/lang/String;)V", true, null);
    }

    private static void setDebugLayersGLES(String string2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDebugLayersGLES(Ljava/lang/String;)V", true, null);
    }

    private static void setDriverPathAndSphalLibraries(String string2, String string3) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setDriverPathAndSphalLibraries(Ljava/lang/String;Ljava/lang/String;)V", true, null);
    }

    private static void setGpuStats(String string2, String string3, long l, long l2, String string4, int n) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setGpuStats(Ljava/lang/String;Ljava/lang/String;JJLjava/lang/String;I)V", true, null);
    }

    private static void setAngleInfo(String string2, String string3, String string4, FileDescriptor fileDescriptor, long l, long l2) {
        OverrideMethod.invokeV("android.os.GraphicsEnvironment#setAngleInfo(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/FileDescriptor;JJ)V", true, null);
    }

    private static boolean getShouldUseAngle(String string2) {
        return OverrideMethod.invokeI("android.os.GraphicsEnvironment#getShouldUseAngle(Ljava/lang/String;)Z", true, null) != 0;
    }

    static enum OpenGlDriverChoice {
        DEFAULT,
        NATIVE,
        ANGLE;

    }
}

