/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.UnsupportedAppUsage;
import android.app.AppGlobals;
import android.app.Application;
import android.content.Context;
import android.os.Environment;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.TypedProperties;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMDebug;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class Debug {
    private static final String TAG = "Debug";
    @Deprecated
    public static final int TRACE_COUNT_ALLOCS = 1;
    public static final int SHOW_FULL_DETAIL = 1;
    public static final int SHOW_CLASSLOADER = 2;
    public static final int SHOW_INITIALIZED = 4;
    private static volatile boolean mWaiting = false;
    private static final int MIN_DEBUGGER_IDLE = 1300;
    private static final int SPIN_DELAY = 200;
    private static final String DEFAULT_TRACE_BODY = "dmtrace";
    private static final String DEFAULT_TRACE_EXTENSION = ".trace";
    private static final String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";
    public static final int MEMINFO_TOTAL = 0;
    public static final int MEMINFO_FREE = 1;
    public static final int MEMINFO_BUFFERS = 2;
    public static final int MEMINFO_CACHED = 3;
    public static final int MEMINFO_SHMEM = 4;
    public static final int MEMINFO_SLAB = 5;
    public static final int MEMINFO_SLAB_RECLAIMABLE = 6;
    public static final int MEMINFO_SLAB_UNRECLAIMABLE = 7;
    public static final int MEMINFO_SWAP_TOTAL = 8;
    public static final int MEMINFO_SWAP_FREE = 9;
    public static final int MEMINFO_ZRAM_TOTAL = 10;
    public static final int MEMINFO_MAPPED = 11;
    public static final int MEMINFO_VM_ALLOC_USED = 12;
    public static final int MEMINFO_PAGE_TABLES = 13;
    public static final int MEMINFO_KERNEL_STACK = 14;
    public static final int MEMINFO_COUNT = 15;
    private static final TypedProperties debugProperties = null;

    @UnsupportedAppUsage
    private Debug() {
    }

    public static void waitForDebugger() {
        block9: {
            long delta;
            if (!VMDebug.isDebuggingEnabled()) {
                return;
            }
            if (Debug.isDebuggerConnected()) {
                return;
            }
            System.out.println("Sending WAIT chunk");
            byte[] data = new byte[]{0};
            Chunk waitChunk = new Chunk(ChunkHandler.type("WAIT"), data, 0, 1);
            DdmServer.sendChunk(waitChunk);
            mWaiting = true;
            while (!Debug.isDebuggerConnected()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            mWaiting = false;
            System.out.println("Debugger has connected");
            while (true) {
                if ((delta = VMDebug.lastDebuggerActivity()) < 0L) {
                    System.out.println("debugger detached?");
                    break block9;
                }
                if (delta >= 1300L) break;
                System.out.println("waiting for debugger to settle...");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("debugger has settled (" + delta + ")");
        }
    }

    public static boolean waitingForDebugger() {
        return mWaiting;
    }

    public static boolean isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    public static String[] getVmFeatureList() {
        return VMDebug.getVmFeatureList();
    }

    @Deprecated
    public static void changeDebugPort(int port) {
    }

    public static void startNativeTracing() {
        try (PrintWriter outStream = null;){
            FileOutputStream fos = new FileOutputStream(SYSFS_QEMU_TRACE_STATE);
            outStream = new FastPrintWriter(fos);
            outStream.println("1");
        }
        VMDebug.startEmulatorTracing();
    }

    public static void stopNativeTracing() {
        VMDebug.stopEmulatorTracing();
        try (PrintWriter outStream = null;){
            FileOutputStream fos = new FileOutputStream(SYSFS_QEMU_TRACE_STATE);
            outStream = new FastPrintWriter(fos);
            outStream.println("0");
        }
    }

    public static void enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    public static void startMethodTracing() {
        VMDebug.startMethodTracing(Debug.fixTracePath(null), 0, 0, false, 0);
    }

    public static void startMethodTracing(String tracePath) {
        Debug.startMethodTracing(tracePath, 0, 0);
    }

    public static void startMethodTracing(String tracePath, int bufferSize) {
        Debug.startMethodTracing(tracePath, bufferSize, 0);
    }

    public static void startMethodTracing(String tracePath, int bufferSize, int flags) {
        VMDebug.startMethodTracing(Debug.fixTracePath(tracePath), bufferSize, flags, false, 0);
    }

    public static void startMethodTracingSampling(String tracePath, int bufferSize, int intervalUs) {
        VMDebug.startMethodTracing(Debug.fixTracePath(tracePath), bufferSize, 0, true, intervalUs);
    }

    private static String fixTracePath(String tracePath) {
        if (tracePath == null || tracePath.charAt(0) != '/') {
            Application context = AppGlobals.getInitialApplication();
            File dir = context != null ? ((Context)context).getExternalFilesDir(null) : Environment.getExternalStorageDirectory();
            tracePath = tracePath == null ? new File(dir, DEFAULT_TRACE_BODY).getAbsolutePath() : new File(dir, tracePath).getAbsolutePath();
        }
        if (!tracePath.endsWith(DEFAULT_TRACE_EXTENSION)) {
            tracePath = tracePath + DEFAULT_TRACE_EXTENSION;
        }
        return tracePath;
    }

    public static void startMethodTracing(String traceName, FileDescriptor fd, int bufferSize, int flags, boolean streamOutput) {
        VMDebug.startMethodTracing(traceName, fd, bufferSize, flags, false, 0, streamOutput);
    }

    public static void startMethodTracingDdms(int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingDdms(bufferSize, flags, samplingEnabled, intervalUs);
    }

    public static int getMethodTracingMode() {
        return VMDebug.getMethodTracingMode();
    }

    public static void stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    public static long threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    @Deprecated
    public static void startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    @Deprecated
    public static void stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    @Deprecated
    public static int getGlobalAllocCount() {
        return VMDebug.getAllocCount(1);
    }

    @Deprecated
    public static void resetGlobalAllocCount() {
        VMDebug.resetAllocCount(1);
    }

    @Deprecated
    public static int getGlobalAllocSize() {
        return VMDebug.getAllocCount(2);
    }

    @Deprecated
    public static void resetGlobalAllocSize() {
        VMDebug.resetAllocCount(2);
    }

    @Deprecated
    public static int getGlobalFreedCount() {
        return VMDebug.getAllocCount(4);
    }

    @Deprecated
    public static void resetGlobalFreedCount() {
        VMDebug.resetAllocCount(4);
    }

    @Deprecated
    public static int getGlobalFreedSize() {
        return VMDebug.getAllocCount(8);
    }

    @Deprecated
    public static void resetGlobalFreedSize() {
        VMDebug.resetAllocCount(8);
    }

    @Deprecated
    public static int getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount(16);
    }

    @Deprecated
    public static void resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount(16);
    }

    @Deprecated
    public static int getGlobalClassInitCount() {
        return VMDebug.getAllocCount(32);
    }

    @Deprecated
    public static void resetGlobalClassInitCount() {
        VMDebug.resetAllocCount(32);
    }

    @Deprecated
    public static int getGlobalClassInitTime() {
        return VMDebug.getAllocCount(64);
    }

    @Deprecated
    public static void resetGlobalClassInitTime() {
        VMDebug.resetAllocCount(64);
    }

    @Deprecated
    public static int getGlobalExternalAllocCount() {
        return 0;
    }

    @Deprecated
    public static void resetGlobalExternalAllocSize() {
    }

    @Deprecated
    public static void resetGlobalExternalAllocCount() {
    }

    @Deprecated
    public static int getGlobalExternalAllocSize() {
        return 0;
    }

    @Deprecated
    public static int getGlobalExternalFreedCount() {
        return 0;
    }

    @Deprecated
    public static void resetGlobalExternalFreedCount() {
    }

    @Deprecated
    public static int getGlobalExternalFreedSize() {
        return 0;
    }

    @Deprecated
    public static void resetGlobalExternalFreedSize() {
    }

    @Deprecated
    public static int getThreadAllocCount() {
        return VMDebug.getAllocCount(65536);
    }

    @Deprecated
    public static void resetThreadAllocCount() {
        VMDebug.resetAllocCount(65536);
    }

    @Deprecated
    public static int getThreadAllocSize() {
        return VMDebug.getAllocCount(131072);
    }

    @Deprecated
    public static void resetThreadAllocSize() {
        VMDebug.resetAllocCount(131072);
    }

    @Deprecated
    public static int getThreadExternalAllocCount() {
        return 0;
    }

    @Deprecated
    public static void resetThreadExternalAllocCount() {
    }

    @Deprecated
    public static int getThreadExternalAllocSize() {
        return 0;
    }

    @Deprecated
    public static void resetThreadExternalAllocSize() {
    }

    @Deprecated
    public static int getThreadGcInvocationCount() {
        return VMDebug.getAllocCount(0x100000);
    }

    @Deprecated
    public static void resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount(0x100000);
    }

    @Deprecated
    public static void resetAllCounts() {
        VMDebug.resetAllocCount(-1);
    }

    public static String getRuntimeStat(String statName) {
        return VMDebug.getRuntimeStat(statName);
    }

    public static Map<String, String> getRuntimeStats() {
        return VMDebug.getRuntimeStats();
    }

    public static long getNativeHeapSize() {
        return OverrideMethod.invokeL("android.os.Debug#getNativeHeapSize()J", true, null);
    }

    public static long getNativeHeapAllocatedSize() {
        return OverrideMethod.invokeL("android.os.Debug#getNativeHeapAllocatedSize()J", true, null);
    }

    public static long getNativeHeapFreeSize() {
        return OverrideMethod.invokeL("android.os.Debug#getNativeHeapFreeSize()J", true, null);
    }

    public static void getMemoryInfo(MemoryInfo memoryInfo) {
        OverrideMethod.invokeV("android.os.Debug#getMemoryInfo(Landroid/os/Debug$MemoryInfo;)V", true, null);
    }

    @UnsupportedAppUsage
    public static void getMemoryInfo(int n, MemoryInfo memoryInfo) {
        OverrideMethod.invokeV("android.os.Debug#getMemoryInfo(ILandroid/os/Debug$MemoryInfo;)V", true, null);
    }

    public static long getPss() {
        return OverrideMethod.invokeL("android.os.Debug#getPss()J", true, null);
    }

    public static long getPss(int n, long[] lArray, long[] lArray2) {
        return OverrideMethod.invokeL("android.os.Debug#getPss(I[J[J)J", true, null);
    }

    @UnsupportedAppUsage
    public static void getMemInfo(long[] lArray) {
        OverrideMethod.invokeV("android.os.Debug#getMemInfo([J)V", true, null);
    }

    @Deprecated
    public static int setAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int limit) {
        return -1;
    }

    public static void printLoadedClasses(int flags) {
        VMDebug.printLoadedClasses(flags);
    }

    public static int getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    public static void dumpHprofData(String fileName) throws IOException {
        VMDebug.dumpHprofData(fileName);
    }

    public static void dumpHprofData(String fileName, FileDescriptor fd) throws IOException {
        VMDebug.dumpHprofData(fileName, fd);
    }

    public static void dumpHprofDataDdms() {
        VMDebug.dumpHprofDataDdms();
    }

    @UnsupportedAppUsage
    public static void dumpNativeHeap(FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.os.Debug#dumpNativeHeap(Ljava/io/FileDescriptor;)V", true, null);
    }

    public static void dumpNativeMallocInfo(FileDescriptor fileDescriptor) {
        OverrideMethod.invokeV("android.os.Debug#dumpNativeMallocInfo(Ljava/io/FileDescriptor;)V", true, null);
    }

    @UnsupportedAppUsage
    public static long countInstancesOfClass(Class cls) {
        return VMDebug.countInstancesOfClass(cls, true);
    }

    public static int getBinderSentTransactions() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderSentTransactions()I", true, null);
    }

    public static int getBinderReceivedTransactions() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderReceivedTransactions()I", true, null);
    }

    public static int getBinderLocalObjectCount() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderLocalObjectCount()I", true, null);
    }

    public static int getBinderProxyObjectCount() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderProxyObjectCount()I", true, null);
    }

    public static int getBinderDeathObjectCount() {
        return OverrideMethod.invokeI("android.os.Debug#getBinderDeathObjectCount()I", true, null);
    }

    public static boolean cacheRegisterMap(String classAndMethodDesc) {
        return VMDebug.cacheRegisterMap(classAndMethodDesc);
    }

    @UnsupportedAppUsage
    public static void dumpReferenceTables() {
        VMDebug.dumpReferenceTables();
    }

    private static boolean fieldTypeMatches(Field field, Class<?> cl) {
        Field primitiveTypeField;
        Class<?> fieldClass = field.getType();
        if (fieldClass == cl) {
            return true;
        }
        try {
            primitiveTypeField = cl.getField("TYPE");
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
        try {
            return fieldClass == (Class)primitiveTypeField.get(null);
        }
        catch (IllegalAccessException ex) {
            return false;
        }
    }

    private static void modifyFieldIfSet(Field field, TypedProperties properties, String propertyName) {
        Object value;
        if (field.getType() == String.class) {
            int stringInfo = properties.getStringInfo(propertyName);
            switch (stringInfo) {
                case 1: {
                    break;
                }
                case 0: {
                    try {
                        field.set(null, null);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
                    }
                    return;
                }
                case -1: {
                    return;
                }
                case -2: {
                    throw new IllegalArgumentException("Type of " + propertyName + "  does not match field type (" + field.getType() + ")");
                }
                default: {
                    throw new IllegalStateException("Unexpected getStringInfo(" + propertyName + ") return value " + stringInfo);
                }
            }
        }
        if ((value = properties.get(propertyName)) != null) {
            if (!Debug.fieldTypeMatches(field, value.getClass())) {
                throw new IllegalArgumentException("Type of " + propertyName + " (" + value.getClass() + ")  does not match field type (" + field.getType() + ")");
            }
            try {
                field.set(null, value);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
            }
        }
    }

    public static void setFieldsOn(Class<?> cl) {
        Debug.setFieldsOn(cl, false);
    }

    public static void setFieldsOn(Class<?> cl, boolean partial) {
        Log.wtf(TAG, "setFieldsOn(" + (cl == null ? "null" : cl.getName()) + ") called in non-DEBUG build");
    }

    public static boolean dumpService(String name, FileDescriptor fd, String[] args) {
        IBinder service = ServiceManager.getService(name);
        if (service == null) {
            Log.e(TAG, "Can't find service to dump: " + name);
            return false;
        }
        try {
            service.dump(fd, args);
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Can't dump service: " + name, e);
            return false;
        }
    }

    public static boolean dumpJavaBacktraceToFileTimeout(int n, String string2, int n2) {
        return OverrideMethod.invokeI("android.os.Debug#dumpJavaBacktraceToFileTimeout(ILjava/lang/String;I)Z", true, null) != 0;
    }

    public static boolean dumpNativeBacktraceToFileTimeout(int n, String string2, int n2) {
        return OverrideMethod.invokeI("android.os.Debug#dumpNativeBacktraceToFileTimeout(ILjava/lang/String;I)Z", true, null) != 0;
    }

    public static String getUnreachableMemory(int n, boolean bl) {
        return (String)OverrideMethod.invokeA("android.os.Debug#getUnreachableMemory(IZ)Ljava/lang/String;", true, null);
    }

    private static String getCaller(StackTraceElement[] callStack, int depth) {
        if (4 + depth >= callStack.length) {
            return "<bottom of call stack>";
        }
        StackTraceElement caller = callStack[4 + depth];
        return caller.getClassName() + "." + caller.getMethodName() + ":" + caller.getLineNumber();
    }

    @UnsupportedAppUsage
    public static String getCallers(int depth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(Debug.getCaller(callStack, i)).append(" ");
        }
        return sb.toString();
    }

    public static String getCallers(int start, int depth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        depth += start;
        for (int i = start; i < depth; ++i) {
            sb.append(Debug.getCaller(callStack, i)).append(" ");
        }
        return sb.toString();
    }

    public static String getCallers(int depth, String linePrefix) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(linePrefix).append(Debug.getCaller(callStack, i)).append("\n");
        }
        return sb.toString();
    }

    @UnsupportedAppUsage
    public static String getCaller() {
        return Debug.getCaller(Thread.currentThread().getStackTrace(), 0);
    }

    public static void attachJvmtiAgent(String library, String options, ClassLoader classLoader) throws IOException {
        Preconditions.checkNotNull(library);
        Preconditions.checkArgument(!library.contains("="));
        if (options == null) {
            VMDebug.attachAgent(library, classLoader);
        } else {
            VMDebug.attachAgent(library + "=" + options, classLoader);
        }
    }

    public static long getZramFreeKb() {
        return OverrideMethod.invokeL("android.os.Debug#getZramFreeKb()J", true, null);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DebugProperty {
    }

    @Deprecated
    public static class InstructionCount {
        public boolean resetAndStart() {
            return false;
        }

        public boolean collect() {
            return false;
        }

        public int globalTotal() {
            return 0;
        }

        public int globalMethodInvocations() {
            return 0;
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public int dalvikPss;
        @UnsupportedAppUsage
        public int dalvikSwappablePss;
        @UnsupportedAppUsage
        public int dalvikRss;
        public int dalvikPrivateDirty;
        public int dalvikSharedDirty;
        @UnsupportedAppUsage
        public int dalvikPrivateClean;
        @UnsupportedAppUsage
        public int dalvikSharedClean;
        @UnsupportedAppUsage
        public int dalvikSwappedOut;
        @UnsupportedAppUsage
        public int dalvikSwappedOutPss;
        public int nativePss;
        @UnsupportedAppUsage
        public int nativeSwappablePss;
        @UnsupportedAppUsage
        public int nativeRss;
        public int nativePrivateDirty;
        public int nativeSharedDirty;
        @UnsupportedAppUsage
        public int nativePrivateClean;
        @UnsupportedAppUsage
        public int nativeSharedClean;
        @UnsupportedAppUsage
        public int nativeSwappedOut;
        @UnsupportedAppUsage
        public int nativeSwappedOutPss;
        public int otherPss;
        @UnsupportedAppUsage
        public int otherSwappablePss;
        @UnsupportedAppUsage
        public int otherRss;
        public int otherPrivateDirty;
        public int otherSharedDirty;
        @UnsupportedAppUsage
        public int otherPrivateClean;
        @UnsupportedAppUsage
        public int otherSharedClean;
        @UnsupportedAppUsage
        public int otherSwappedOut;
        @UnsupportedAppUsage
        public int otherSwappedOutPss;
        @UnsupportedAppUsage
        public boolean hasSwappedOutPss;
        public static final int HEAP_UNKNOWN = 0;
        public static final int HEAP_DALVIK = 1;
        public static final int HEAP_NATIVE = 2;
        public static final int OTHER_DALVIK_OTHER = 0;
        public static final int OTHER_STACK = 1;
        public static final int OTHER_CURSOR = 2;
        public static final int OTHER_ASHMEM = 3;
        public static final int OTHER_GL_DEV = 4;
        public static final int OTHER_UNKNOWN_DEV = 5;
        public static final int OTHER_SO = 6;
        public static final int OTHER_JAR = 7;
        public static final int OTHER_APK = 8;
        public static final int OTHER_TTF = 9;
        public static final int OTHER_DEX = 10;
        public static final int OTHER_OAT = 11;
        public static final int OTHER_ART = 12;
        public static final int OTHER_UNKNOWN_MAP = 13;
        public static final int OTHER_GRAPHICS = 14;
        public static final int OTHER_GL = 15;
        public static final int OTHER_OTHER_MEMTRACK = 16;
        @UnsupportedAppUsage
        public static final int NUM_OTHER_STATS = 17;
        public static final int OTHER_DALVIK_NORMAL = 17;
        public static final int OTHER_DALVIK_LARGE = 18;
        public static final int OTHER_DALVIK_ZYGOTE = 19;
        public static final int OTHER_DALVIK_NON_MOVING = 20;
        public static final int OTHER_DVK_STAT_DALVIK_START = 0;
        public static final int OTHER_DVK_STAT_DALVIK_END = 3;
        public static final int OTHER_DALVIK_OTHER_LINEARALLOC = 21;
        public static final int OTHER_DALVIK_OTHER_ACCOUNTING = 22;
        public static final int OTHER_DALVIK_OTHER_CODE_CACHE = 23;
        public static final int OTHER_DALVIK_OTHER_COMPILER_METADATA = 24;
        public static final int OTHER_DALVIK_OTHER_INDIRECT_REFERENCE_TABLE = 25;
        public static final int OTHER_DVK_STAT_DALVIK_OTHER_START = 4;
        public static final int OTHER_DVK_STAT_DALVIK_OTHER_END = 8;
        public static final int OTHER_DEX_BOOT_VDEX = 26;
        public static final int OTHER_DEX_APP_DEX = 27;
        public static final int OTHER_DEX_APP_VDEX = 28;
        public static final int OTHER_DVK_STAT_DEX_START = 9;
        public static final int OTHER_DVK_STAT_DEX_END = 11;
        public static final int OTHER_ART_APP = 29;
        public static final int OTHER_ART_BOOT = 30;
        public static final int OTHER_DVK_STAT_ART_START = 12;
        public static final int OTHER_DVK_STAT_ART_END = 13;
        @UnsupportedAppUsage
        public static final int NUM_DVK_STATS = 14;
        public static final int NUM_CATEGORIES = 9;
        public static final int OFFSET_PSS = 0;
        public static final int OFFSET_SWAPPABLE_PSS = 1;
        public static final int OFFSET_RSS = 2;
        public static final int OFFSET_PRIVATE_DIRTY = 3;
        public static final int OFFSET_SHARED_DIRTY = 4;
        public static final int OFFSET_PRIVATE_CLEAN = 5;
        public static final int OFFSET_SHARED_CLEAN = 6;
        public static final int OFFSET_SWAPPED_OUT = 7;
        public static final int OFFSET_SWAPPED_OUT_PSS = 8;
        @UnsupportedAppUsage
        private int[] otherStats = new int[279];
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel source) {
                return new MemoryInfo(source);
            }

            public MemoryInfo[] newArray(int size) {
                return new MemoryInfo[size];
            }
        };

        public MemoryInfo() {
        }

        public void set(MemoryInfo other) {
            this.dalvikPss = other.dalvikPss;
            this.dalvikSwappablePss = other.dalvikSwappablePss;
            this.dalvikRss = other.dalvikRss;
            this.dalvikPrivateDirty = other.dalvikPrivateDirty;
            this.dalvikSharedDirty = other.dalvikSharedDirty;
            this.dalvikPrivateClean = other.dalvikPrivateClean;
            this.dalvikSharedClean = other.dalvikSharedClean;
            this.dalvikSwappedOut = other.dalvikSwappedOut;
            this.dalvikSwappedOutPss = other.dalvikSwappedOutPss;
            this.nativePss = other.nativePss;
            this.nativeSwappablePss = other.nativeSwappablePss;
            this.nativeRss = other.nativeRss;
            this.nativePrivateDirty = other.nativePrivateDirty;
            this.nativeSharedDirty = other.nativeSharedDirty;
            this.nativePrivateClean = other.nativePrivateClean;
            this.nativeSharedClean = other.nativeSharedClean;
            this.nativeSwappedOut = other.nativeSwappedOut;
            this.nativeSwappedOutPss = other.nativeSwappedOutPss;
            this.otherPss = other.otherPss;
            this.otherSwappablePss = other.otherSwappablePss;
            this.otherRss = other.otherRss;
            this.otherPrivateDirty = other.otherPrivateDirty;
            this.otherSharedDirty = other.otherSharedDirty;
            this.otherPrivateClean = other.otherPrivateClean;
            this.otherSharedClean = other.otherSharedClean;
            this.otherSwappedOut = other.otherSwappedOut;
            this.otherSwappedOutPss = other.otherSwappedOutPss;
            this.hasSwappedOutPss = other.hasSwappedOutPss;
            System.arraycopy(other.otherStats, 0, this.otherStats, 0, this.otherStats.length);
        }

        public int getTotalPss() {
            return this.dalvikPss + this.nativePss + this.otherPss + this.getTotalSwappedOutPss();
        }

        @UnsupportedAppUsage
        public int getTotalUss() {
            return this.dalvikPrivateClean + this.dalvikPrivateDirty + this.nativePrivateClean + this.nativePrivateDirty + this.otherPrivateClean + this.otherPrivateDirty;
        }

        public int getTotalSwappablePss() {
            return this.dalvikSwappablePss + this.nativeSwappablePss + this.otherSwappablePss;
        }

        public int getTotalRss() {
            return this.dalvikRss + this.nativeRss + this.otherRss;
        }

        public int getTotalPrivateDirty() {
            return this.dalvikPrivateDirty + this.nativePrivateDirty + this.otherPrivateDirty;
        }

        public int getTotalSharedDirty() {
            return this.dalvikSharedDirty + this.nativeSharedDirty + this.otherSharedDirty;
        }

        public int getTotalPrivateClean() {
            return this.dalvikPrivateClean + this.nativePrivateClean + this.otherPrivateClean;
        }

        public int getTotalSharedClean() {
            return this.dalvikSharedClean + this.nativeSharedClean + this.otherSharedClean;
        }

        public int getTotalSwappedOut() {
            return this.dalvikSwappedOut + this.nativeSwappedOut + this.otherSwappedOut;
        }

        public int getTotalSwappedOutPss() {
            return this.dalvikSwappedOutPss + this.nativeSwappedOutPss + this.otherSwappedOutPss;
        }

        @UnsupportedAppUsage
        public int getOtherPss(int which) {
            return this.otherStats[which * 9 + 0];
        }

        public int getOtherSwappablePss(int which) {
            return this.otherStats[which * 9 + 1];
        }

        public int getOtherRss(int which) {
            return this.otherStats[which * 9 + 2];
        }

        @UnsupportedAppUsage
        public int getOtherPrivateDirty(int which) {
            return this.otherStats[which * 9 + 3];
        }

        @UnsupportedAppUsage
        public int getOtherSharedDirty(int which) {
            return this.otherStats[which * 9 + 4];
        }

        public int getOtherPrivateClean(int which) {
            return this.otherStats[which * 9 + 5];
        }

        @UnsupportedAppUsage
        public int getOtherPrivate(int which) {
            return this.getOtherPrivateClean(which) + this.getOtherPrivateDirty(which);
        }

        public int getOtherSharedClean(int which) {
            return this.otherStats[which * 9 + 6];
        }

        public int getOtherSwappedOut(int which) {
            return this.otherStats[which * 9 + 7];
        }

        public int getOtherSwappedOutPss(int which) {
            return this.otherStats[which * 9 + 8];
        }

        @UnsupportedAppUsage
        public static String getOtherLabel(int which) {
            switch (which) {
                case 0: {
                    return "Dalvik Other";
                }
                case 1: {
                    return "Stack";
                }
                case 2: {
                    return "Cursor";
                }
                case 3: {
                    return "Ashmem";
                }
                case 4: {
                    return "Gfx dev";
                }
                case 5: {
                    return "Other dev";
                }
                case 6: {
                    return ".so mmap";
                }
                case 7: {
                    return ".jar mmap";
                }
                case 8: {
                    return ".apk mmap";
                }
                case 9: {
                    return ".ttf mmap";
                }
                case 10: {
                    return ".dex mmap";
                }
                case 11: {
                    return ".oat mmap";
                }
                case 12: {
                    return ".art mmap";
                }
                case 13: {
                    return "Other mmap";
                }
                case 14: {
                    return "EGL mtrack";
                }
                case 15: {
                    return "GL mtrack";
                }
                case 16: {
                    return "Other mtrack";
                }
                case 17: {
                    return ".Heap";
                }
                case 18: {
                    return ".LOS";
                }
                case 19: {
                    return ".Zygote";
                }
                case 20: {
                    return ".NonMoving";
                }
                case 21: {
                    return ".LinearAlloc";
                }
                case 22: {
                    return ".GC";
                }
                case 23: {
                    return ".JITCache";
                }
                case 24: {
                    return ".CompilerMetadata";
                }
                case 25: {
                    return ".IndirectRef";
                }
                case 26: {
                    return ".Boot vdex";
                }
                case 27: {
                    return ".App dex";
                }
                case 28: {
                    return ".App vdex";
                }
                case 29: {
                    return ".App art";
                }
                case 30: {
                    return ".Boot art";
                }
            }
            return "????";
        }

        public String getMemoryStat(String statName) {
            switch (statName) {
                case "summary.java-heap": {
                    return Integer.toString(this.getSummaryJavaHeap());
                }
                case "summary.native-heap": {
                    return Integer.toString(this.getSummaryNativeHeap());
                }
                case "summary.code": {
                    return Integer.toString(this.getSummaryCode());
                }
                case "summary.stack": {
                    return Integer.toString(this.getSummaryStack());
                }
                case "summary.graphics": {
                    return Integer.toString(this.getSummaryGraphics());
                }
                case "summary.private-other": {
                    return Integer.toString(this.getSummaryPrivateOther());
                }
                case "summary.system": {
                    return Integer.toString(this.getSummarySystem());
                }
                case "summary.total-pss": {
                    return Integer.toString(this.getSummaryTotalPss());
                }
                case "summary.total-swap": {
                    return Integer.toString(this.getSummaryTotalSwap());
                }
            }
            return null;
        }

        public Map<String, String> getMemoryStats() {
            HashMap<String, String> stats = new HashMap<String, String>();
            stats.put("summary.java-heap", Integer.toString(this.getSummaryJavaHeap()));
            stats.put("summary.native-heap", Integer.toString(this.getSummaryNativeHeap()));
            stats.put("summary.code", Integer.toString(this.getSummaryCode()));
            stats.put("summary.stack", Integer.toString(this.getSummaryStack()));
            stats.put("summary.graphics", Integer.toString(this.getSummaryGraphics()));
            stats.put("summary.private-other", Integer.toString(this.getSummaryPrivateOther()));
            stats.put("summary.system", Integer.toString(this.getSummarySystem()));
            stats.put("summary.total-pss", Integer.toString(this.getSummaryTotalPss()));
            stats.put("summary.total-swap", Integer.toString(this.getSummaryTotalSwap()));
            return stats;
        }

        @UnsupportedAppUsage
        public int getSummaryJavaHeap() {
            return this.dalvikPrivateDirty + this.getOtherPrivate(12);
        }

        @UnsupportedAppUsage
        public int getSummaryNativeHeap() {
            return this.nativePrivateDirty;
        }

        @UnsupportedAppUsage
        public int getSummaryCode() {
            return this.getOtherPrivate(6) + this.getOtherPrivate(7) + this.getOtherPrivate(8) + this.getOtherPrivate(9) + this.getOtherPrivate(10) + this.getOtherPrivate(11);
        }

        @UnsupportedAppUsage
        public int getSummaryStack() {
            return this.getOtherPrivateDirty(1);
        }

        @UnsupportedAppUsage
        public int getSummaryGraphics() {
            return this.getOtherPrivate(4) + this.getOtherPrivate(14) + this.getOtherPrivate(15);
        }

        @UnsupportedAppUsage
        public int getSummaryPrivateOther() {
            return this.getTotalPrivateClean() + this.getTotalPrivateDirty() - this.getSummaryJavaHeap() - this.getSummaryNativeHeap() - this.getSummaryCode() - this.getSummaryStack() - this.getSummaryGraphics();
        }

        @UnsupportedAppUsage
        public int getSummarySystem() {
            return this.getTotalPss() - this.getTotalPrivateClean() - this.getTotalPrivateDirty();
        }

        public int getSummaryTotalPss() {
            return this.getTotalPss();
        }

        public int getSummaryTotalSwap() {
            return this.getTotalSwappedOut();
        }

        public int getSummaryTotalSwapPss() {
            return this.getTotalSwappedOutPss();
        }

        public boolean hasSwappedOutPss() {
            return this.hasSwappedOutPss;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.dalvikPss);
            dest.writeInt(this.dalvikSwappablePss);
            dest.writeInt(this.dalvikRss);
            dest.writeInt(this.dalvikPrivateDirty);
            dest.writeInt(this.dalvikSharedDirty);
            dest.writeInt(this.dalvikPrivateClean);
            dest.writeInt(this.dalvikSharedClean);
            dest.writeInt(this.dalvikSwappedOut);
            dest.writeInt(this.dalvikSwappedOutPss);
            dest.writeInt(this.nativePss);
            dest.writeInt(this.nativeSwappablePss);
            dest.writeInt(this.nativeRss);
            dest.writeInt(this.nativePrivateDirty);
            dest.writeInt(this.nativeSharedDirty);
            dest.writeInt(this.nativePrivateClean);
            dest.writeInt(this.nativeSharedClean);
            dest.writeInt(this.nativeSwappedOut);
            dest.writeInt(this.nativeSwappedOutPss);
            dest.writeInt(this.otherPss);
            dest.writeInt(this.otherSwappablePss);
            dest.writeInt(this.otherRss);
            dest.writeInt(this.otherPrivateDirty);
            dest.writeInt(this.otherSharedDirty);
            dest.writeInt(this.otherPrivateClean);
            dest.writeInt(this.otherSharedClean);
            dest.writeInt(this.otherSwappedOut);
            dest.writeInt(this.hasSwappedOutPss ? 1 : 0);
            dest.writeInt(this.otherSwappedOutPss);
            dest.writeIntArray(this.otherStats);
        }

        public void readFromParcel(Parcel source) {
            this.dalvikPss = source.readInt();
            this.dalvikSwappablePss = source.readInt();
            this.dalvikRss = source.readInt();
            this.dalvikPrivateDirty = source.readInt();
            this.dalvikSharedDirty = source.readInt();
            this.dalvikPrivateClean = source.readInt();
            this.dalvikSharedClean = source.readInt();
            this.dalvikSwappedOut = source.readInt();
            this.dalvikSwappedOutPss = source.readInt();
            this.nativePss = source.readInt();
            this.nativeSwappablePss = source.readInt();
            this.nativeRss = source.readInt();
            this.nativePrivateDirty = source.readInt();
            this.nativeSharedDirty = source.readInt();
            this.nativePrivateClean = source.readInt();
            this.nativeSharedClean = source.readInt();
            this.nativeSwappedOut = source.readInt();
            this.nativeSwappedOutPss = source.readInt();
            this.otherPss = source.readInt();
            this.otherSwappablePss = source.readInt();
            this.otherRss = source.readInt();
            this.otherPrivateDirty = source.readInt();
            this.otherSharedDirty = source.readInt();
            this.otherPrivateClean = source.readInt();
            this.otherSharedClean = source.readInt();
            this.otherSwappedOut = source.readInt();
            this.hasSwappedOutPss = source.readInt() != 0;
            this.otherSwappedOutPss = source.readInt();
            this.otherStats = source.createIntArray();
        }

        private MemoryInfo(Parcel source) {
            this.readFromParcel(source);
        }
    }
}

