/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioFormat;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Objects;

public class AudioPolicyConfig
implements Parcelable {
    private static final String TAG = "AudioPolicyConfig";
    protected final ArrayList<AudioMix> mMixes;
    protected int mDuckingPolicy = 0;
    private String mRegistrationId = null;
    private int mMixCounter = 0;
    public static final Parcelable.Creator<AudioPolicyConfig> CREATOR = new Parcelable.Creator<AudioPolicyConfig>(){

        @Override
        public AudioPolicyConfig createFromParcel(Parcel p) {
            return new AudioPolicyConfig(p);
        }

        public AudioPolicyConfig[] newArray(int size) {
            return new AudioPolicyConfig[size];
        }
    };

    protected AudioPolicyConfig(AudioPolicyConfig conf) {
        this.mMixes = conf.mMixes;
    }

    AudioPolicyConfig(ArrayList<AudioMix> mixes) {
        this.mMixes = mixes;
    }

    public void addMix(AudioMix mix) throws IllegalArgumentException {
        if (mix == null) {
            throw new IllegalArgumentException("Illegal null AudioMix argument");
        }
        this.mMixes.add(mix);
    }

    public ArrayList<AudioMix> getMixes() {
        return this.mMixes;
    }

    public int hashCode() {
        return Objects.hash(this.mMixes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMixes.size());
        for (AudioMix mix : this.mMixes) {
            dest.writeInt(mix.getRouteFlags());
            dest.writeInt(mix.mCallbackFlags);
            dest.writeInt(mix.mDeviceSystemType);
            dest.writeString(mix.mDeviceAddress);
            dest.writeInt(mix.getFormat().getSampleRate());
            dest.writeInt(mix.getFormat().getEncoding());
            dest.writeInt(mix.getFormat().getChannelMask());
            dest.writeBoolean(mix.getRule().allowPrivilegedPlaybackCapture());
            ArrayList<AudioMixingRule.AudioMixMatchCriterion> criteria = mix.getRule().getCriteria();
            dest.writeInt(criteria.size());
            for (AudioMixingRule.AudioMixMatchCriterion criterion : criteria) {
                criterion.writeToParcel(dest);
            }
        }
    }

    private AudioPolicyConfig(Parcel in) {
        this.mMixes = new ArrayList();
        int nbMixes = in.readInt();
        for (int i = 0; i < nbMixes; ++i) {
            AudioMix.Builder mixBuilder = new AudioMix.Builder();
            int routeFlags = in.readInt();
            mixBuilder.setRouteFlags(routeFlags);
            mixBuilder.setCallbackFlags(in.readInt());
            mixBuilder.setDevice(in.readInt(), in.readString());
            int sampleRate = in.readInt();
            int encoding = in.readInt();
            int channelMask = in.readInt();
            AudioFormat format = new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelMask).setEncoding(encoding).build();
            mixBuilder.setFormat(format);
            AudioMixingRule.Builder ruleBuilder = new AudioMixingRule.Builder();
            ruleBuilder.allowPrivilegedPlaybackCapture(in.readBoolean());
            int nbRules = in.readInt();
            for (int j = 0; j < nbRules; ++j) {
                ruleBuilder.addRuleFromParcel(in);
            }
            mixBuilder.setMixingRule(ruleBuilder.build());
            this.mMixes.add(mixBuilder.build());
        }
    }

    public String toLogFriendlyString() {
        String textDump = new String("android.media.audiopolicy.AudioPolicyConfig:\n");
        textDump = textDump + this.mMixes.size() + " AudioMix: " + this.mRegistrationId + "\n";
        for (AudioMix mix : this.mMixes) {
            textDump = textDump + "* route flags=0x" + Integer.toHexString(mix.getRouteFlags()) + "\n";
            textDump = textDump + "  rate=" + mix.getFormat().getSampleRate() + "Hz\n";
            textDump = textDump + "  encoding=" + mix.getFormat().getEncoding() + "\n";
            textDump = textDump + "  channels=0x";
            textDump = textDump + Integer.toHexString(mix.getFormat().getChannelMask()).toUpperCase() + "\n";
            textDump = textDump + "  ignore playback capture opt out=" + mix.getRule().allowPrivilegedPlaybackCapture() + "\n";
            ArrayList<AudioMixingRule.AudioMixMatchCriterion> criteria = mix.getRule().getCriteria();
            for (AudioMixingRule.AudioMixMatchCriterion criterion : criteria) {
                switch (criterion.mRule) {
                    case 32769: {
                        textDump = textDump + "  exclude usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 1: {
                        textDump = textDump + "  match usage ";
                        textDump = textDump + criterion.mAttr.usageToString();
                        break;
                    }
                    case 32770: {
                        textDump = textDump + "  exclude capture preset ";
                        textDump = textDump + criterion.mAttr.getCapturePreset();
                        break;
                    }
                    case 2: {
                        textDump = textDump + "  match capture preset ";
                        textDump = textDump + criterion.mAttr.getCapturePreset();
                        break;
                    }
                    case 4: {
                        textDump = textDump + "  match UID ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    case 32772: {
                        textDump = textDump + "  exclude UID ";
                        textDump = textDump + criterion.mIntProp;
                        break;
                    }
                    default: {
                        textDump = textDump + "invalid rule!";
                    }
                }
                textDump = textDump + "\n";
            }
        }
        return textDump;
    }

    protected void setRegistration(String regId) {
        boolean newRegNull;
        boolean currentRegNull = this.mRegistrationId == null || this.mRegistrationId.isEmpty();
        boolean bl = newRegNull = regId == null || regId.isEmpty();
        if (!(currentRegNull || newRegNull || this.mRegistrationId.equals(regId))) {
            Log.e(TAG, "Invalid registration transition from " + this.mRegistrationId + " to " + regId);
            return;
        }
        this.mRegistrationId = regId == null ? "" : regId;
        for (AudioMix mix : this.mMixes) {
            this.setMixRegistration(mix);
        }
    }

    private void setMixRegistration(AudioMix mix) {
        if (!this.mRegistrationId.isEmpty()) {
            if ((mix.getRouteFlags() & 2) == 2) {
                mix.setRegistration(this.mRegistrationId + "mix" + AudioPolicyConfig.mixTypeId(mix.getMixType()) + ":" + this.mMixCounter);
            } else if ((mix.getRouteFlags() & 1) == 1) {
                mix.setRegistration(mix.mDeviceAddress);
            }
        } else {
            mix.setRegistration("");
        }
        ++this.mMixCounter;
    }

    @GuardedBy(value={"mMixes"})
    protected void add(ArrayList<AudioMix> mixes) {
        for (AudioMix mix : mixes) {
            this.setMixRegistration(mix);
            this.mMixes.add(mix);
        }
    }

    @GuardedBy(value={"mMixes"})
    protected void remove(ArrayList<AudioMix> mixes) {
        for (AudioMix mix : mixes) {
            this.mMixes.remove(mix);
        }
    }

    private static String mixTypeId(int type) {
        if (type == 0) {
            return "p";
        }
        if (type == 1) {
            return "r";
        }
        return "i";
    }

    protected String getRegistration() {
        return this.mRegistrationId;
    }
}

