/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.MediaFormat;
import android.media.MediaTimeProvider;
import android.media.SubtitleTrack;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.accessibility.CaptioningManager;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Locale;
import java.util.Vector;

public class SubtitleController {
    private MediaTimeProvider mTimeProvider;
    private Vector<Renderer> mRenderers;
    private Vector<SubtitleTrack> mTracks;
    private SubtitleTrack mSelectedTrack;
    private boolean mShowing;
    private CaptioningManager mCaptioningManager;
    @UnsupportedAppUsage
    private Handler mHandler;
    private static final int WHAT_SHOW = 1;
    private static final int WHAT_HIDE = 2;
    private static final int WHAT_SELECT_TRACK = 3;
    private static final int WHAT_SELECT_DEFAULT_TRACK = 4;
    private final Handler.Callback mCallback = new Handler.Callback(){

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SubtitleController.this.doShow();
                    return true;
                }
                case 2: {
                    SubtitleController.this.doHide();
                    return true;
                }
                case 3: {
                    SubtitleController.this.doSelectTrack((SubtitleTrack)msg.obj);
                    return true;
                }
                case 4: {
                    SubtitleController.this.doSelectDefaultTrack();
                    return true;
                }
            }
            return false;
        }
    };
    private CaptioningManager.CaptioningChangeListener mCaptioningChangeListener = new CaptioningManager.CaptioningChangeListener(){

        @Override
        public void onEnabledChanged(boolean enabled) {
            SubtitleController.this.selectDefaultTrack();
        }

        @Override
        public void onLocaleChanged(Locale locale) {
            SubtitleController.this.selectDefaultTrack();
        }
    };
    private boolean mTrackIsExplicit = false;
    private boolean mVisibilityIsExplicit = false;
    private Anchor mAnchor;
    private Listener mListener;

    @UnsupportedAppUsage
    public SubtitleController(Context context, MediaTimeProvider timeProvider, Listener listener) {
        this.mTimeProvider = timeProvider;
        this.mListener = listener;
        this.mRenderers = new Vector();
        this.mShowing = false;
        this.mTracks = new Vector();
        this.mCaptioningManager = (CaptioningManager)context.getSystemService("captioning");
    }

    protected void finalize() throws Throwable {
        this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubtitleTrack[] getTracks() {
        Vector<SubtitleTrack> vector = this.mTracks;
        synchronized (vector) {
            SubtitleTrack[] tracks = new SubtitleTrack[this.mTracks.size()];
            this.mTracks.toArray(tracks);
            return tracks;
        }
    }

    public SubtitleTrack getSelectedTrack() {
        return this.mSelectedTrack;
    }

    private SubtitleTrack.RenderingWidget getRenderingWidget() {
        if (this.mSelectedTrack == null) {
            return null;
        }
        return this.mSelectedTrack.getRenderingWidget();
    }

    public boolean selectTrack(SubtitleTrack track) {
        if (track != null && !this.mTracks.contains(track)) {
            return false;
        }
        this.processOnAnchor(this.mHandler.obtainMessage(3, track));
        return true;
    }

    private void doSelectTrack(SubtitleTrack track) {
        this.mTrackIsExplicit = true;
        if (this.mSelectedTrack == track) {
            return;
        }
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.hide();
            this.mSelectedTrack.setTimeProvider(null);
        }
        this.mSelectedTrack = track;
        if (this.mAnchor != null) {
            this.mAnchor.setSubtitleWidget(this.getRenderingWidget());
        }
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.setTimeProvider(this.mTimeProvider);
            this.mSelectedTrack.show();
        }
        if (this.mListener != null) {
            this.mListener.onSubtitleTrackSelected(track);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubtitleTrack getDefaultTrack() {
        SubtitleTrack bestTrack = null;
        int bestScore = -1;
        Locale selectedLocale = this.mCaptioningManager.getLocale();
        Locale locale = selectedLocale;
        if (locale == null) {
            locale = AndroidLocale.getDefault();
        }
        boolean selectForced = !this.mCaptioningManager.isEnabled();
        Vector<SubtitleTrack> vector = this.mTracks;
        synchronized (vector) {
            for (SubtitleTrack track : this.mTracks) {
                MediaFormat format = track.getFormat();
                String language = format.getString("language");
                boolean forced = format.getInteger("is-forced-subtitle", 0) != 0;
                boolean autoselect = format.getInteger("is-autoselect", 1) != 0;
                boolean is_default = format.getInteger("is-default", 0) != 0;
                boolean languageMatches = locale == null || locale.getLanguage().equals("") || locale.getISO3Language().equals(language) || locale.getLanguage().equals(language);
                int score = (forced ? 0 : 8) + (selectedLocale == null && is_default ? 4 : 0) + (autoselect ? 0 : 2) + (languageMatches ? 1 : 0);
                if (selectForced && !forced || (selectedLocale != null || !is_default) && (!languageMatches || !autoselect && !forced && selectedLocale == null) || score <= bestScore) continue;
                bestScore = score;
                bestTrack = track;
            }
        }
        return bestTrack;
    }

    public void selectDefaultTrack() {
        this.processOnAnchor(this.mHandler.obtainMessage(4));
    }

    private void doSelectDefaultTrack() {
        if (this.mTrackIsExplicit) {
            if (!this.mVisibilityIsExplicit) {
                if (this.mCaptioningManager.isEnabled() || this.mSelectedTrack != null && this.mSelectedTrack.getFormat().getInteger("is-forced-subtitle", 0) != 0) {
                    this.show();
                } else if (this.mSelectedTrack != null && this.mSelectedTrack.getTrackType() == 4) {
                    this.hide();
                }
                this.mVisibilityIsExplicit = false;
            }
            return;
        }
        SubtitleTrack track = this.getDefaultTrack();
        if (track != null) {
            this.selectTrack(track);
            this.mTrackIsExplicit = false;
            if (!this.mVisibilityIsExplicit) {
                this.show();
                this.mVisibilityIsExplicit = false;
            }
        }
    }

    @UnsupportedAppUsage
    public void reset() {
        this.checkAnchorLooper();
        this.hide();
        this.selectTrack(null);
        this.mTracks.clear();
        this.mTrackIsExplicit = false;
        this.mVisibilityIsExplicit = false;
        this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubtitleTrack addTrack(MediaFormat format) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            for (Renderer renderer : this.mRenderers) {
                SubtitleTrack track;
                if (!renderer.supports(format) || (track = renderer.createTrack(format)) == null) continue;
                Vector<SubtitleTrack> vector2 = this.mTracks;
                synchronized (vector2) {
                    if (this.mTracks.size() == 0) {
                        this.mCaptioningManager.addCaptioningChangeListener(this.mCaptioningChangeListener);
                    }
                    this.mTracks.add(track);
                }
                return track;
            }
        }
        return null;
    }

    @UnsupportedAppUsage
    public void show() {
        this.processOnAnchor(this.mHandler.obtainMessage(1));
    }

    private void doShow() {
        this.mShowing = true;
        this.mVisibilityIsExplicit = true;
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.show();
        }
    }

    @UnsupportedAppUsage
    public void hide() {
        this.processOnAnchor(this.mHandler.obtainMessage(2));
    }

    private void doHide() {
        this.mVisibilityIsExplicit = true;
        if (this.mSelectedTrack != null) {
            this.mSelectedTrack.hide();
        }
        this.mShowing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void registerRenderer(Renderer renderer) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            if (!this.mRenderers.contains(renderer)) {
                this.mRenderers.add(renderer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRendererFor(MediaFormat format) {
        Vector<Renderer> vector = this.mRenderers;
        synchronized (vector) {
            for (Renderer renderer : this.mRenderers) {
                if (!renderer.supports(format)) continue;
                return true;
            }
            return false;
        }
    }

    public void setAnchor(Anchor anchor) {
        if (this.mAnchor == anchor) {
            return;
        }
        if (this.mAnchor != null) {
            this.checkAnchorLooper();
            this.mAnchor.setSubtitleWidget(null);
        }
        this.mAnchor = anchor;
        this.mHandler = null;
        if (this.mAnchor != null) {
            this.mHandler = new Handler(this.mAnchor.getSubtitleLooper(), this.mCallback);
            this.checkAnchorLooper();
            this.mAnchor.setSubtitleWidget(this.getRenderingWidget());
        }
    }

    private void checkAnchorLooper() {
        assert (this.mHandler != null) : "Should have a looper already";
        assert (Looper.myLooper() == this.mHandler.getLooper()) : "Must be called from the anchor's looper";
    }

    private void processOnAnchor(Message m) {
        assert (this.mHandler != null) : "Should have a looper already";
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.mHandler.dispatchMessage(m);
        } else {
            this.mHandler.sendMessage(m);
        }
    }

    public static interface Listener {
        public void onSubtitleTrackSelected(SubtitleTrack var1);
    }

    public static interface Anchor {
        public void setSubtitleWidget(SubtitleTrack.RenderingWidget var1);

        public Looper getSubtitleLooper();
    }

    public static abstract class Renderer {
        public abstract boolean supports(MediaFormat var1);

        public abstract SubtitleTrack createTrack(MediaFormat var1);
    }
}

