/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import java.util.HashMap;
import libcore.net.MimeUtils;

public class MediaFile {
    @Deprecated
    @UnsupportedAppUsage
    private static final int FIRST_AUDIO_FILE_TYPE = 1;
    @Deprecated
    @UnsupportedAppUsage
    private static final int LAST_AUDIO_FILE_TYPE = 10;
    @Deprecated
    @UnsupportedAppUsage
    private static final HashMap<String, MediaFileType> sFileTypeMap = new HashMap();
    @Deprecated
    @UnsupportedAppUsage
    private static final HashMap<String, Integer> sFileTypeToFormatMap = new HashMap();
    @UnsupportedAppUsage
    private static final HashMap<String, Integer> sMimeTypeToFormatMap = new HashMap();
    @UnsupportedAppUsage
    private static final HashMap<Integer, String> sFormatToMimeTypeMap = new HashMap();

    @Deprecated
    @UnsupportedAppUsage
    static void addFileType(String extension, int fileType, String mimeType) {
    }

    private static void addFileType(int mtpFormatCode, String mimeType) {
        if (!sMimeTypeToFormatMap.containsKey(mimeType)) {
            sMimeTypeToFormatMap.put(mimeType, mtpFormatCode);
        }
        if (!sFormatToMimeTypeMap.containsKey(mtpFormatCode)) {
            sFormatToMimeTypeMap.put(mtpFormatCode, mimeType);
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isAudioFileType(int fileType) {
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isVideoFileType(int fileType) {
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isImageFileType(int fileType) {
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isPlayListFileType(int fileType) {
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static boolean isDrmFileType(int fileType) {
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static MediaFileType getFileType(String path) {
        return null;
    }

    public static boolean isExifMimeType(String mimeType) {
        return MediaFile.isImageMimeType(mimeType);
    }

    public static boolean isAudioMimeType(String mimeType) {
        return MediaFile.normalizeMimeType(mimeType).startsWith("audio/");
    }

    public static boolean isVideoMimeType(String mimeType) {
        return MediaFile.normalizeMimeType(mimeType).startsWith("video/");
    }

    public static boolean isImageMimeType(String mimeType) {
        return MediaFile.normalizeMimeType(mimeType).startsWith("image/");
    }

    public static boolean isPlayListMimeType(String mimeType) {
        switch (MediaFile.normalizeMimeType(mimeType)) {
            case "application/vnd.ms-wpl": 
            case "audio/x-mpegurl": 
            case "audio/mpegurl": 
            case "application/x-mpegurl": 
            case "application/vnd.apple.mpegurl": 
            case "audio/x-scpls": {
                return true;
            }
        }
        return false;
    }

    public static boolean isDrmMimeType(String mimeType) {
        return MediaFile.normalizeMimeType(mimeType).equals("application/x-android-drm-fl");
    }

    @UnsupportedAppUsage
    public static String getFileTitle(String path) {
        int lastDot;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && ++lastSlash < path.length()) {
            path = path.substring(lastSlash);
        }
        if ((lastDot = path.lastIndexOf(46)) > 0) {
            path = path.substring(0, lastDot);
        }
        return path;
    }

    public static String getFileExtension(String path) {
        if (path == null) {
            return null;
        }
        int lastDot = path.lastIndexOf(46);
        if (lastDot >= 0) {
            return path.substring(lastDot + 1);
        }
        return null;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int getFileTypeForMimeType(String mimeType) {
        return 0;
    }

    public static String getMimeType(String path, int formatCode) {
        String mimeType = MediaFile.getMimeTypeForFile(path);
        if (!"application/octet-stream".equals(mimeType)) {
            return mimeType;
        }
        return MediaFile.getMimeTypeForFormatCode(formatCode);
    }

    @UnsupportedAppUsage
    public static String getMimeTypeForFile(String path) {
        String mimeType = MimeUtils.guessMimeTypeFromExtension(MediaFile.getFileExtension(path));
        return mimeType != null ? mimeType : "application/octet-stream";
    }

    public static String getMimeTypeForFormatCode(int formatCode) {
        String mimeType = sFormatToMimeTypeMap.get(formatCode);
        return mimeType != null ? mimeType : "application/octet-stream";
    }

    public static int getFormatCode(String path, String mimeType) {
        int formatCode = MediaFile.getFormatCodeForMimeType(mimeType);
        if (formatCode != 12288) {
            return formatCode;
        }
        return MediaFile.getFormatCodeForFile(path);
    }

    public static int getFormatCodeForFile(String path) {
        return MediaFile.getFormatCodeForMimeType(MediaFile.getMimeTypeForFile(path));
    }

    public static int getFormatCodeForMimeType(String mimeType) {
        if (mimeType == null) {
            return 12288;
        }
        Integer value = sMimeTypeToFormatMap.get(mimeType);
        if (value != null) {
            return value;
        }
        value = sMimeTypeToFormatMap.get(mimeType = MediaFile.normalizeMimeType(mimeType));
        if (value != null) {
            return value;
        }
        if (mimeType.startsWith("audio/")) {
            return 47360;
        }
        if (mimeType.startsWith("video/")) {
            return 47488;
        }
        if (mimeType.startsWith("image/")) {
            return 14336;
        }
        return 12288;
    }

    private static String normalizeMimeType(String mimeType) {
        String extensionMimeType;
        String extension = MimeUtils.guessExtensionFromMimeType(mimeType);
        if (extension != null && (extensionMimeType = MimeUtils.guessMimeTypeFromExtension(extension)) != null) {
            return extensionMimeType;
        }
        return mimeType != null ? mimeType : "application/octet-stream";
    }

    static {
        MediaFile.addFileType(12297, "audio/mpeg");
        MediaFile.addFileType(12296, "audio/x-wav");
        MediaFile.addFileType(47361, "audio/x-ms-wma");
        MediaFile.addFileType(47362, "audio/ogg");
        MediaFile.addFileType(47363, "audio/aac");
        MediaFile.addFileType(47366, "audio/flac");
        MediaFile.addFileType(12295, "audio/x-aiff");
        MediaFile.addFileType(47491, "audio/mpeg");
        MediaFile.addFileType(12299, "video/mpeg");
        MediaFile.addFileType(47490, "video/mp4");
        MediaFile.addFileType(47492, "video/3gpp");
        MediaFile.addFileType(47492, "video/3gpp2");
        MediaFile.addFileType(12298, "video/avi");
        MediaFile.addFileType(47489, "video/x-ms-wmv");
        MediaFile.addFileType(12300, "video/x-ms-asf");
        MediaFile.addFileType(14337, "image/jpeg");
        MediaFile.addFileType(14343, "image/gif");
        MediaFile.addFileType(14347, "image/png");
        MediaFile.addFileType(14340, "image/x-ms-bmp");
        MediaFile.addFileType(14354, "image/heif");
        MediaFile.addFileType(14353, "image/x-adobe-dng");
        MediaFile.addFileType(14349, "image/tiff");
        MediaFile.addFileType(14349, "image/x-canon-cr2");
        MediaFile.addFileType(14349, "image/x-nikon-nrw");
        MediaFile.addFileType(14349, "image/x-sony-arw");
        MediaFile.addFileType(14349, "image/x-panasonic-rw2");
        MediaFile.addFileType(14349, "image/x-olympus-orf");
        MediaFile.addFileType(14349, "image/x-pentax-pef");
        MediaFile.addFileType(14349, "image/x-samsung-srw");
        MediaFile.addFileType(14338, "image/tiff");
        MediaFile.addFileType(14338, "image/x-nikon-nef");
        MediaFile.addFileType(14351, "image/jp2");
        MediaFile.addFileType(14352, "image/jpx");
        MediaFile.addFileType(47633, "audio/x-mpegurl");
        MediaFile.addFileType(47636, "audio/x-scpls");
        MediaFile.addFileType(47632, "application/vnd.ms-wpl");
        MediaFile.addFileType(47635, "video/x-ms-asf");
        MediaFile.addFileType(12292, "text/plain");
        MediaFile.addFileType(12293, "text/html");
        MediaFile.addFileType(47746, "text/xml");
        MediaFile.addFileType(47747, "application/msword");
        MediaFile.addFileType(47747, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        MediaFile.addFileType(47749, "application/vnd.ms-excel");
        MediaFile.addFileType(47749, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        MediaFile.addFileType(47750, "application/vnd.ms-powerpoint");
        MediaFile.addFileType(47750, "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    }

    @Deprecated
    public static class MediaFileType {
        @UnsupportedAppUsage
        public final int fileType;
        @UnsupportedAppUsage
        public final String mimeType;

        MediaFileType(int fileType, String mimeType) {
            this.fileType = fileType;
            this.mimeType = mimeType;
        }
    }
}

