/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.coll;

import android.icu.impl.ICUBinary;
import android.icu.impl.coll.CollationData;
import android.icu.impl.coll.CollationDataReader;
import android.icu.impl.coll.CollationSettings;
import android.icu.impl.coll.CollationTailoring;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;

public class CollationRoot {
    private static final CollationTailoring rootSingleton;
    private static final RuntimeException exception;

    public static CollationTailoring getRoot() {
        if (exception != null) {
            throw exception;
        }
        return rootSingleton;
    }

    public static CollationData getData() {
        CollationTailoring root = CollationRoot.getRoot();
        return root.data;
    }

    static CollationSettings getSettings() {
        CollationTailoring root = CollationRoot.getRoot();
        return root.settings.readOnly();
    }

    static {
        CollationTailoring t = null;
        RuntimeException e2 = null;
        try {
            ByteBuffer bytes = ICUBinary.getRequiredData("coll/ucadata.icu");
            CollationTailoring t2 = new CollationTailoring(null);
            CollationDataReader.read(null, bytes, t2);
            t = t2;
        }
        catch (IOException e) {
            e2 = new MissingResourceException("IOException while reading CLDR root data", "CollationRoot", "data/icudt63b/coll/ucadata.icu");
        }
        catch (RuntimeException e) {
            e2 = e;
        }
        rootSingleton = t;
        exception = e2;
    }
}

