/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_4;

import android.hardware.radio.V1_4.CellIdentityNr;
import android.hardware.radio.V1_4.NrSignalStrength;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class CellInfoNr {
    public NrSignalStrength signalStrength = new NrSignalStrength();
    public CellIdentityNr cellidentity = new CellIdentityNr();

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CellInfoNr.class) {
            return false;
        }
        CellInfoNr other = (CellInfoNr)otherObject;
        if (!HidlSupport.deepEquals(this.signalStrength, other.signalStrength)) {
            return false;
        }
        return HidlSupport.deepEquals(this.cellidentity, other.cellidentity);
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.signalStrength), HidlSupport.deepHashCode(this.cellidentity));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".signalStrength = ");
        builder.append(this.signalStrength);
        builder.append(", .cellidentity = ");
        builder.append(this.cellidentity);
        builder.append("}");
        return builder.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(112L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<CellInfoNr> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellInfoNr> _hidl_vec = new ArrayList<CellInfoNr>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 112, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellInfoNr _hidl_vec_element = new CellInfoNr();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 112);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.signalStrength.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.cellidentity.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 24L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(112);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfoNr> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 112);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 112);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.signalStrength.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        this.cellidentity.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 24L);
    }
}

