/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_2;

import android.hardware.radio.V1_0.CellInfoType;
import android.hardware.radio.V1_0.TimeStampType;
import android.hardware.radio.V1_2.CellConnectionStatus;
import android.hardware.radio.V1_2.CellInfoCdma;
import android.hardware.radio.V1_2.CellInfoGsm;
import android.hardware.radio.V1_2.CellInfoLte;
import android.hardware.radio.V1_2.CellInfoTdscdma;
import android.hardware.radio.V1_2.CellInfoWcdma;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public class CellInfo {
    public int cellInfoType;
    public boolean registered;
    public int timeStampType;
    public long timeStamp;
    public ArrayList<CellInfoGsm> gsm = new ArrayList();
    public ArrayList<CellInfoCdma> cdma = new ArrayList();
    public ArrayList<CellInfoLte> lte = new ArrayList();
    public ArrayList<CellInfoWcdma> wcdma = new ArrayList();
    public ArrayList<CellInfoTdscdma> tdscdma = new ArrayList();
    public int connectionStatus;

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CellInfo.class) {
            return false;
        }
        CellInfo other = (CellInfo)otherObject;
        if (this.cellInfoType != other.cellInfoType) {
            return false;
        }
        if (this.registered != other.registered) {
            return false;
        }
        if (this.timeStampType != other.timeStampType) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.gsm, other.gsm)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.cdma, other.cdma)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.lte, other.lte)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.wcdma, other.wcdma)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.tdscdma, other.tdscdma)) {
            return false;
        }
        return this.connectionStatus == other.connectionStatus;
    }

    public int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.cellInfoType), HidlSupport.deepHashCode(this.registered), HidlSupport.deepHashCode(this.timeStampType), HidlSupport.deepHashCode(this.timeStamp), HidlSupport.deepHashCode(this.gsm), HidlSupport.deepHashCode(this.cdma), HidlSupport.deepHashCode(this.lte), HidlSupport.deepHashCode(this.wcdma), HidlSupport.deepHashCode(this.tdscdma), HidlSupport.deepHashCode(this.connectionStatus));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".cellInfoType = ");
        builder.append(CellInfoType.toString(this.cellInfoType));
        builder.append(", .registered = ");
        builder.append(this.registered);
        builder.append(", .timeStampType = ");
        builder.append(TimeStampType.toString(this.timeStampType));
        builder.append(", .timeStamp = ");
        builder.append(this.timeStamp);
        builder.append(", .gsm = ");
        builder.append(this.gsm);
        builder.append(", .cdma = ");
        builder.append(this.cdma);
        builder.append(", .lte = ");
        builder.append(this.lte);
        builder.append(", .wcdma = ");
        builder.append(this.wcdma);
        builder.append(", .tdscdma = ");
        builder.append(this.tdscdma);
        builder.append(", .connectionStatus = ");
        builder.append(CellConnectionStatus.toString(this.connectionStatus));
        builder.append("}");
        return builder.toString();
    }

    public void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(112L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static ArrayList<CellInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CellInfo> _hidl_vec = new ArrayList<CellInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 112, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CellInfo _hidl_vec_element = new CellInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 112);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        Object _hidl_vec_element;
        int _hidl_index_0;
        this.cellInfoType = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.registered = _hidl_blob.getBool(_hidl_offset + 4L);
        this.timeStampType = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.timeStamp = _hidl_blob.getInt64(_hidl_offset + 16L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 24L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 96, _hidl_blob.handle(), _hidl_offset + 24L + 0L, true);
        this.gsm.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new CellInfoGsm();
            ((CellInfoGsm)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 96);
            this.gsm.add((CellInfoGsm)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 40L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 80, _hidl_blob.handle(), _hidl_offset + 40L + 0L, true);
        this.cdma.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new CellInfoCdma();
            ((CellInfoCdma)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 80);
            this.cdma.add((CellInfoCdma)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 56L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 112, _hidl_blob.handle(), _hidl_offset + 56L + 0L, true);
        this.lte.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new CellInfoLte();
            ((CellInfoLte)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 112);
            this.lte.add((CellInfoLte)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 72L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 96, _hidl_blob.handle(), _hidl_offset + 72L + 0L, true);
        this.wcdma.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new CellInfoWcdma();
            ((CellInfoWcdma)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 96);
            this.wcdma.add((CellInfoWcdma)_hidl_vec_element);
        }
        _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 88L + 8L);
        childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 104, _hidl_blob.handle(), _hidl_offset + 88L + 0L, true);
        this.tdscdma.clear();
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec_element = new CellInfoTdscdma();
            ((CellInfoTdscdma)_hidl_vec_element).readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 104);
            this.tdscdma.add((CellInfoTdscdma)_hidl_vec_element);
        }
        this.connectionStatus = _hidl_blob.getInt32(_hidl_offset + 104L);
    }

    public void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(112);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static void writeVectorToParcel(HwParcel parcel, ArrayList<CellInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 112);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 112);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        int _hidl_index_0;
        _hidl_blob.putInt32(_hidl_offset + 0L, this.cellInfoType);
        _hidl_blob.putBool(_hidl_offset + 4L, this.registered);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.timeStampType);
        _hidl_blob.putInt64(_hidl_offset + 16L, this.timeStamp);
        int _hidl_vec_size = this.gsm.size();
        _hidl_blob.putInt32(_hidl_offset + 24L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 24L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 96);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.gsm.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 96);
        }
        _hidl_blob.putBlob(_hidl_offset + 24L + 0L, childBlob);
        _hidl_vec_size = this.cdma.size();
        _hidl_blob.putInt32(_hidl_offset + 40L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 40L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 80);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.cdma.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 80);
        }
        _hidl_blob.putBlob(_hidl_offset + 40L + 0L, childBlob);
        _hidl_vec_size = this.lte.size();
        _hidl_blob.putInt32(_hidl_offset + 56L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 56L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 112);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.lte.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 112);
        }
        _hidl_blob.putBlob(_hidl_offset + 56L + 0L, childBlob);
        _hidl_vec_size = this.wcdma.size();
        _hidl_blob.putInt32(_hidl_offset + 72L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 72L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 96);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.wcdma.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 96);
        }
        _hidl_blob.putBlob(_hidl_offset + 72L + 0L, childBlob);
        _hidl_vec_size = this.tdscdma.size();
        _hidl_blob.putInt32(_hidl_offset + 88L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 88L + 12L, false);
        childBlob = new HwBlob(_hidl_vec_size * 104);
        for (_hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            this.tdscdma.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 104);
        }
        _hidl_blob.putBlob(_hidl_offset + 88L + 0L, childBlob);
        _hidl_blob.putInt32(_hidl_offset + 104L, this.connectionStatus);
    }
}

