/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.IContextHubClient;
import android.hardware.location.NanoAppMessage;
import android.os.RemoteException;
import com.android.internal.util.Preconditions;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

@SystemApi
public class ContextHubClient
implements Closeable {
    private IContextHubClient mClientProxy = null;
    private final ContextHubInfo mAttachedHub;
    private final CloseGuard mCloseGuard;
    private final AtomicBoolean mIsClosed = new AtomicBoolean(false);
    private final boolean mPersistent;

    ContextHubClient(ContextHubInfo hubInfo, boolean persistent) {
        this.mAttachedHub = hubInfo;
        this.mPersistent = persistent;
        if (this.mPersistent) {
            this.mCloseGuard = null;
        } else {
            this.mCloseGuard = CloseGuard.get();
            this.mCloseGuard.open("close");
        }
    }

    void setClientProxy(IContextHubClient clientProxy) {
        Preconditions.checkNotNull(clientProxy, "IContextHubClient cannot be null");
        if (this.mClientProxy != null) {
            throw new IllegalStateException("Cannot change client proxy multiple times");
        }
        this.mClientProxy = clientProxy;
    }

    public ContextHubInfo getAttachedHub() {
        return this.mAttachedHub;
    }

    @Override
    public void close() {
        if (!this.mIsClosed.getAndSet(true)) {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.close();
            }
            try {
                this.mClientProxy.close();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int sendMessageToNanoApp(NanoAppMessage message) {
        Preconditions.checkNotNull(message, "NanoAppMessage cannot be null");
        try {
            return this.mClientProxy.sendMessageToNanoApp(message);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mPersistent) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

