/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.Collection;

public class RequestHolder {
    private static final String TAG = "RequestHolder";
    private final boolean mRepeating;
    private final CaptureRequest mRequest;
    private final int mRequestId;
    private final int mSubsequeceId;
    private final long mFrameNumber;
    private final int mNumJpegTargets;
    private final int mNumPreviewTargets;
    private volatile boolean mFailed = false;
    private boolean mOutputAbandoned = false;
    private final Collection<Long> mJpegSurfaceIds;

    private RequestHolder(int requestId, int subsequenceId, CaptureRequest request, boolean repeating, long frameNumber, int numJpegTargets, int numPreviewTargets, Collection<Long> jpegSurfaceIds) {
        this.mRepeating = repeating;
        this.mRequest = request;
        this.mRequestId = requestId;
        this.mSubsequeceId = subsequenceId;
        this.mFrameNumber = frameNumber;
        this.mNumJpegTargets = numJpegTargets;
        this.mNumPreviewTargets = numPreviewTargets;
        this.mJpegSurfaceIds = jpegSurfaceIds;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public boolean isRepeating() {
        return this.mRepeating;
    }

    public int getSubsequeceId() {
        return this.mSubsequeceId;
    }

    public long getFrameNumber() {
        return this.mFrameNumber;
    }

    public CaptureRequest getRequest() {
        return this.mRequest;
    }

    public Collection<Surface> getHolderTargets() {
        return this.getRequest().getTargets();
    }

    public boolean hasJpegTargets() {
        return this.mNumJpegTargets > 0;
    }

    public boolean hasPreviewTargets() {
        return this.mNumPreviewTargets > 0;
    }

    public int numJpegTargets() {
        return this.mNumJpegTargets;
    }

    public int numPreviewTargets() {
        return this.mNumPreviewTargets;
    }

    public boolean jpegType(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        return LegacyCameraDevice.containsSurfaceId(s, this.mJpegSurfaceIds);
    }

    public void failRequest() {
        Log.w(TAG, "Capture failed for request: " + this.getRequestId());
        this.mFailed = true;
    }

    public boolean requestFailed() {
        return this.mFailed;
    }

    public void setOutputAbandoned() {
        this.mOutputAbandoned = true;
    }

    public boolean isOutputAbandoned() {
        return this.mOutputAbandoned;
    }

    public static class Builder {
        private final int mRequestId;
        private final int mSubsequenceId;
        private final CaptureRequest mRequest;
        private final boolean mRepeating;
        private final int mNumJpegTargets;
        private final int mNumPreviewTargets;
        private final Collection<Long> mJpegSurfaceIds;

        public Builder(int requestId, int subsequenceId, CaptureRequest request, boolean repeating, Collection<Long> jpegSurfaceIds) {
            Preconditions.checkNotNull(request, "request must not be null");
            this.mRequestId = requestId;
            this.mSubsequenceId = subsequenceId;
            this.mRequest = request;
            this.mRepeating = repeating;
            this.mJpegSurfaceIds = jpegSurfaceIds;
            this.mNumJpegTargets = this.numJpegTargets(this.mRequest);
            this.mNumPreviewTargets = this.numPreviewTargets(this.mRequest);
        }

        private boolean jpegType(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return LegacyCameraDevice.containsSurfaceId(s, this.mJpegSurfaceIds);
        }

        private boolean previewType(Surface s) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return !this.jpegType(s);
        }

        private int numJpegTargets(CaptureRequest request) {
            int count = 0;
            for (Surface s : request.getTargets()) {
                try {
                    if (!this.jpegType(s)) continue;
                    ++count;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.d(RequestHolder.TAG, "Surface abandoned, skipping...", e);
                }
            }
            return count;
        }

        private int numPreviewTargets(CaptureRequest request) {
            int count = 0;
            for (Surface s : request.getTargets()) {
                try {
                    if (!this.previewType(s)) continue;
                    ++count;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException e) {
                    Log.d(RequestHolder.TAG, "Surface abandoned, skipping...", e);
                }
            }
            return count;
        }

        public RequestHolder build(long frameNumber) {
            return new RequestHolder(this.mRequestId, this.mSubsequenceId, this.mRequest, this.mRepeating, frameNumber, this.mNumJpegTargets, this.mNumPreviewTargets, this.mJpegSurfaceIds);
        }
    }
}

