/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.content.res.AssetManager;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import libcore.util.NativeAllocationRegistry_Delegate;

public class Font_Builder_Delegate {
    protected static final DelegateManager<Font_Builder_Delegate> sBuilderManager = new DelegateManager<Font_Builder_Delegate>(Font_Builder_Delegate.class);
    private static final DelegateManager<String> sAssetManager = new DelegateManager<String>(String.class);
    private static long sFontFinalizer = -1L;
    private static long sAssetFinalizer = -1L;
    protected ByteBuffer mBuffer;
    protected int mWeight;
    protected boolean mItalic;
    protected int mTtcIndex;
    protected String filePath;

    @LayoutlibDelegate
    static long nInitBuilder() {
        return sBuilderManager.addNewDelegate(new Font_Builder_Delegate());
    }

    @LayoutlibDelegate
    static long nGetNativeAsset(AssetManager am, String path, boolean isAsset, int cookie) {
        return sAssetManager.addNewDelegate(path);
    }

    @LayoutlibDelegate
    static ByteBuffer nGetAssetBuffer(long nativeAsset) {
        String fullPath = sAssetManager.getDelegate(nativeAsset);
        if (fullPath == null) {
            return null;
        }
        try {
            byte[] byteArray = Files.readAllBytes(new File(fullPath).toPath());
            return ByteBuffer.wrap(byteArray);
        }
        catch (IOException e) {
            Bridge.getLog().error("missingasset", "Error mapping font file " + fullPath, null, null, null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseNativeAssetFunc() {
        Class<Font_Builder_Delegate> clazz = Font_Builder_Delegate.class;
        synchronized (Font_Builder_Delegate.class) {
            if (sAssetFinalizer == -1L) {
                sAssetFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sAssetManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sAssetFinalizer;
        }
    }

    @LayoutlibDelegate
    static void nAddAxis(long builderPtr, int tag, float value) {
    }

    @LayoutlibDelegate
    static long nBuild(long builderPtr, ByteBuffer buffer, String filePath, int weight, boolean italic, int ttcIndex) {
        Font_Builder_Delegate font = sBuilderManager.getDelegate(builderPtr);
        if (font != null) {
            font.mBuffer = buffer;
            font.mWeight = weight;
            font.mItalic = italic;
            font.mTtcIndex = ttcIndex;
            font.filePath = filePath;
        }
        return builderPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetReleaseNativeFont() {
        Class<Font_Builder_Delegate> clazz = Font_Builder_Delegate.class;
        synchronized (Font_Builder_Delegate.class) {
            if (sFontFinalizer == -1L) {
                sFontFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(sBuilderManager::removeJavaReferenceFor);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFontFinalizer;
        }
    }
}

