/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Gradient_Delegate;
import android.graphics.Shader;
import android.graphics.Shader_Delegate;
import com.android.layoutlib.bridge.Bridge;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public class RadialGradient_Delegate
extends Gradient_Delegate {
    private Paint mJavaPaint;

    @Override
    public Paint getJavaPaint() {
        return this.mJavaPaint;
    }

    @LayoutlibDelegate
    static long nativeCreate(long matrix, float x, float y, float radius, long[] colors, float[] positions, int tileMode, long colorSpaceHandle) {
        RadialGradient_Delegate newDelegate = new RadialGradient_Delegate(matrix, x, y, radius, colors, positions, Shader_Delegate.getTileMode(tileMode));
        return sManager.addNewDelegate(newDelegate);
    }

    private RadialGradient_Delegate(long nativeMatrix, float x, float y, float radius, long[] colors, float[] positions, Shader.TileMode tile) {
        super(nativeMatrix, colors, positions);
        this.mJavaPaint = new RadialGradientPaint(x, y, radius, this.mColors, this.mPositions, tile);
    }

    private class RadialGradientPaint
    extends Gradient_Delegate.GradientPaint {
        private final float mX;
        private final float mY;
        private final float mRadius;

        public RadialGradientPaint(float x, float y, float radius, int[] colors, float[] positions, Shader.TileMode mode) {
            super(colors, positions, mode);
            this.mX = x;
            this.mY = y;
            this.mRadius = radius;
        }

        @Override
        public PaintContext createContext(ColorModel colorModel, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            AffineTransform canvasMatrix;
            this.precomputeGradientColors();
            try {
                canvasMatrix = xform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in RadialGradient", (Throwable)e, null);
                canvasMatrix = new AffineTransform();
            }
            AffineTransform localMatrix = RadialGradient_Delegate.this.getLocalMatrix();
            try {
                localMatrix = localMatrix.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                Bridge.getLog().fidelityWarning("matrix.inverse", "Unable to inverse matrix in RadialGradient", (Throwable)e, null);
                localMatrix = new AffineTransform();
            }
            return new RadialGradientPaintContext(canvasMatrix, localMatrix, colorModel);
        }

        private class RadialGradientPaintContext
        implements PaintContext {
            private final AffineTransform mCanvasMatrix;
            private final AffineTransform mLocalMatrix;
            private final ColorModel mColorModel;

            public RadialGradientPaintContext(AffineTransform canvasMatrix, AffineTransform localMatrix, ColorModel colorModel) {
                this.mCanvasMatrix = canvasMatrix;
                this.mLocalMatrix = localMatrix;
                this.mColorModel = colorModel.hasAlpha() ? colorModel : ColorModel.getRGBdefault();
            }

            @Override
            public void dispose() {
            }

            @Override
            public ColorModel getColorModel() {
                return this.mColorModel;
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                int[] data = new int[w * h];
                int index = 0;
                float[] pt1 = new float[2];
                float[] pt2 = new float[2];
                for (int iy = 0; iy < h; ++iy) {
                    for (int ix = 0; ix < w; ++ix) {
                        pt1[0] = x + ix;
                        pt1[1] = y + iy;
                        this.mCanvasMatrix.transform(pt1, 0, pt2, 0, 1);
                        pt1[0] = pt2[0];
                        pt1[1] = pt2[1];
                        this.mLocalMatrix.transform(pt1, 0, pt2, 0, 1);
                        float _x = pt2[0] - RadialGradientPaint.this.mX;
                        float _y = pt2[1] - RadialGradientPaint.this.mY;
                        float distance = (float)Math.hypot(_x, _y);
                        data[index++] = RadialGradientPaint.this.getGradientColor(distance / RadialGradientPaint.this.mRadius);
                    }
                }
                DataBufferInt dataBuffer = new DataBufferInt(data, data.length);
                SampleModel colorModel = this.mColorModel.createCompatibleSampleModel(w, h);
                return Raster.createWritableRaster(colorModel, dataBuffer, null);
            }
        }
    }
}

