/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.ContentResolver;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PostProcessor;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Size;
import android.util.TypedValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;

public final class ImageDecoder
implements AutoCloseable {
    public static final int ERROR_SOURCE_EXCEPTION = 1;
    public static final int ERROR_SOURCE_INCOMPLETE = 2;
    public static final int ERROR_SOURCE_ERROR = 3;
    private boolean mAnimated = true;
    private Rect mOutPaddingRect;
    public static final int ALLOCATOR_DEFAULT = 0;
    public static final int ALLOCATOR_SOFTWARE = 1;
    public static final int ALLOCATOR_SHARED_MEMORY = 2;
    public static final int ALLOCATOR_HARDWARE = 3;

    public static Source createSource(Resources res, int resId) {
        return new ResourceSource(res, resId);
    }

    public static Source createSource(ContentResolver cr, Uri uri) {
        return new ContentResolverSource(cr, uri);
    }

    public static Source createSource(byte[] data, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (offset < 0 || length < 0 || offset >= data.length || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException("invalid offset/length!");
        }
        return new ByteArraySource(data, offset, length);
    }

    public static Source createSource(byte[] data) {
        return ImageDecoder.createSource(data, 0, data.length);
    }

    public static Source createSource(ByteBuffer buffer) {
        return new ByteBufferSource(buffer);
    }

    public static Source createSource(Resources res, InputStream is) {
        return new InputStreamSource(res, is, Bitmap.getDefaultDensity());
    }

    public static Source createSource(Resources res, InputStream is, int density) {
        return new InputStreamSource(res, is, density);
    }

    public static Source createSource(File file) {
        return new FileSource(file);
    }

    public Size getSampledSize(int sampleSize) {
        return new Size(0, 0);
    }

    public void setResize(int width, int height) {
    }

    public void setResize(int sampleSize) {
    }

    public void setAllocator(int allocator) {
    }

    public ImageDecoder setRequireUnpremultiplied(boolean requireUnpremultiplied) {
        return this;
    }

    public void setPostProcessor(PostProcessor p) {
    }

    public void setOnPartialImageListener(OnPartialImageListener l) {
    }

    public void setCrop(Rect subset) {
    }

    public void setOutPaddingRect(Rect outPadding) {
        this.mOutPaddingRect = outPadding;
    }

    public ImageDecoder setMutable(boolean mutable) {
        return this;
    }

    public ImageDecoder setPreferRamOverQuality(boolean preferRamOverQuality) {
        return this;
    }

    public ImageDecoder setAsAlphaMask(boolean asAlphaMask) {
        return this;
    }

    @Override
    public void close() {
    }

    public static Drawable decodeDrawable(Source src, OnHeaderDecodedListener listener) throws IOException {
        Bitmap bitmap = ImageDecoder.decodeBitmap(src, listener);
        return new BitmapDrawable(src.getResources(), bitmap);
    }

    public static Drawable decodeDrawable(Source src) throws IOException {
        return ImageDecoder.decodeDrawable(src, null);
    }

    public static Bitmap decodeBitmap(Source src, OnHeaderDecodedListener listener) throws IOException {
        TypedValue value = new TypedValue();
        value.density = src.getDensity();
        ImageDecoder decoder = src.createImageDecoder();
        if (listener != null) {
            listener.onHeaderDecoded(decoder, new ImageInfo(decoder), src);
        }
        return BitmapFactory.decodeResourceStream(src.getResources(), value, ((InputStreamSource)src).mInputStream, decoder.mOutPaddingRect, null);
    }

    public static Bitmap decodeBitmap(Source src) throws IOException {
        return ImageDecoder.decodeBitmap(src, null);
    }

    public static final class DecodeException
    extends IOException {
        public static final int SOURCE_EXCEPTION = 1;
        public static final int SOURCE_INCOMPLETE = 2;
        public static final int SOURCE_MALFORMED_DATA = 3;
        final int mError;
        final Source mSource;

        DecodeException(int error, Throwable cause, Source source) {
            super(DecodeException.errorMessage(error, cause), cause);
            this.mError = error;
            this.mSource = source;
        }

        DecodeException(int error, String msg, Throwable cause, Source source) {
            super(msg + DecodeException.errorMessage(error, cause), cause);
            this.mError = error;
            this.mSource = source;
        }

        public int getError() {
            return this.mError;
        }

        public Source getSource() {
            return this.mSource;
        }

        private static String errorMessage(int error, Throwable cause) {
            switch (error) {
                case 1: {
                    return "Exception in input: " + cause;
                }
                case 2: {
                    return "Input was incomplete.";
                }
                case 3: {
                    return "Input contained an error.";
                }
            }
            return "";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Allocator {
    }

    public static interface OnPartialImageListener {
        public boolean onPartialImage(int var1, Source var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }

    public static interface OnHeaderDecodedListener {
        public void onHeaderDecoded(ImageDecoder var1, ImageInfo var2, Source var3);
    }

    public static class IncompleteException
    extends IOException {
    }

    public static class ImageInfo {
        private ImageDecoder mDecoder;

        private ImageInfo(ImageDecoder decoder) {
            this.mDecoder = decoder;
        }

        public Size getSize() {
            return new Size(0, 0);
        }

        public String getMimeType() {
            return "";
        }

        public boolean isAnimated() {
            return this.mDecoder.mAnimated;
        }
    }

    private static class FileSource
    extends Source {
        private final File mFile;

        FileSource(File file) {
            this.mFile = file;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    private static class ResourceSource
    extends Source {
        final Resources mResources;
        final int mResId;
        int mResDensity;

        ResourceSource(Resources res, int resId) {
            this.mResources = res;
            this.mResId = resId;
            this.mResDensity = 0;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mResDensity;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    public static class AssetInputStreamSource
    extends Source {
        private AssetManager.AssetInputStream mAssetInputStream;
        private final Resources mResources;
        private final int mDensity;

        public AssetInputStreamSource(AssetManager.AssetInputStream ais, Resources res, TypedValue value) {
            this.mAssetInputStream = ais;
            this.mResources = res;
            this.mDensity = value.density == 0 ? 160 : (value.density != 65535 ? value.density : 0);
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mDensity;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    private static class InputStreamSource
    extends Source {
        final Resources mResources;
        InputStream mInputStream;
        final int mInputDensity;

        InputStreamSource(Resources res, InputStream is, int inputDensity) {
            if (is == null) {
                throw new IllegalArgumentException("The InputStream cannot be null");
            }
            this.mResources = res;
            this.mInputStream = is;
            this.mInputDensity = res != null ? inputDensity : 0;
        }

        @Override
        public Resources getResources() {
            return this.mResources;
        }

        @Override
        public int getDensity() {
            return this.mInputDensity;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    private static class ContentResolverSource
    extends Source {
        private final ContentResolver mResolver;
        private final Uri mUri;

        ContentResolverSource(ContentResolver resolver, Uri uri) {
            this.mResolver = resolver;
            this.mUri = uri;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    private static class ByteBufferSource
    extends Source {
        private final ByteBuffer mBuffer;

        ByteBufferSource(ByteBuffer buffer) {
            this.mBuffer = buffer;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    private static class ByteArraySource
    extends Source {
        private final byte[] mData;
        private final int mOffset;
        private final int mLength;

        ByteArraySource(byte[] data, int offset, int length) {
            this.mData = data;
            this.mOffset = offset;
            this.mLength = length;
        }

        @Override
        public ImageDecoder createImageDecoder() throws IOException {
            return new ImageDecoder();
        }
    }

    public static abstract class Source {
        private Source() {
        }

        Resources getResources() {
            return null;
        }

        int getDensity() {
            return 0;
        }

        int computeDstDensity() {
            Resources res = this.getResources();
            if (res == null) {
                return Bitmap.getDefaultDensity();
            }
            return res.getDisplayMetrics().densityDpi;
        }

        abstract ImageDecoder createImageDecoder() throws IOException;
    }
}

