/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.graphics.FontFamily_Delegate;
import android.graphics.fonts.FontVariationAxis;
import android.text.TextUtils;
import android.util.Log;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import libcore.util.NativeAllocationRegistry;

@Deprecated
public class FontFamily {
    private static String TAG = "FontFamily";
    private static final NativeAllocationRegistry sBuilderRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), FontFamily.nGetBuilderReleaseFunc());
    private Runnable mNativeBuilderCleaner;
    private static final NativeAllocationRegistry sFamilyRegistry = NativeAllocationRegistry.createMalloced(FontFamily.class.getClassLoader(), FontFamily.nGetFamilyReleaseFunc());
    @UnsupportedAppUsage(trackingBug=123768928L)
    public long mNativePtr;
    public long mBuilderPtr;

    @UnsupportedAppUsage(trackingBug=123768928L)
    public FontFamily() {
        this.mBuilderPtr = FontFamily.nInitBuilder(null, 0);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation(this, this.mBuilderPtr);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public FontFamily(String[] langs, int variant) {
        String langsString = langs == null || langs.length == 0 ? null : (langs.length == 1 ? langs[0] : TextUtils.join((CharSequence)",", langs));
        this.mBuilderPtr = FontFamily.nInitBuilder(langsString, variant);
        this.mNativeBuilderCleaner = sBuilderRegistry.registerNativeAllocation(this, this.mBuilderPtr);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean freeze() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen");
        }
        this.mNativePtr = FontFamily.nCreateFamily(this.mBuilderPtr);
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
        if (this.mNativePtr != 0L) {
            sFamilyRegistry.registerNativeAllocation(this, this.mNativePtr);
        }
        return this.mNativePtr != 0L;
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public void abortCreation() {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("This FontFamily is already frozen or abandoned");
        }
        this.mNativeBuilderCleaner.run();
        this.mBuilderPtr = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean addFont_Original(String path, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFont after freezing.");
        }
        try (FileInputStream file = new FileInputStream(path);){
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            MappedByteBuffer fontBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
            if (axes != null) {
                for (FontVariationAxis axis : axes) {
                    FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
                }
            }
            boolean bl = FontFamily.nAddFont(this.mBuilderPtr, fontBuffer, ttcIndex, weight, italic);
            return bl;
        }
        catch (IOException e) {
            Log.e(TAG, "Error mapping font file " + path);
            return false;
        }
    }

    @LayoutlibDelegate
    public boolean addFont(String string2, int n, FontVariationAxis[] fontVariationAxisArray, int n2, int n3) {
        return FontFamily_Delegate.addFont(this, string2, n, fontVariationAxisArray, n2, n3);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean addFontFromBuffer(ByteBuffer font, int ttcIndex, FontVariationAxis[] axes, int weight, int italic) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontWeightStyle after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontWeightStyle(this.mBuilderPtr, font, ttcIndex, weight, italic);
    }

    @UnsupportedAppUsage(trackingBug=123768928L)
    public boolean addFontFromAssetManager(AssetManager mgr, String path, int cookie, boolean isAsset, int ttcIndex, int weight, int isItalic, FontVariationAxis[] axes) {
        if (this.mBuilderPtr == 0L) {
            throw new IllegalStateException("Unable to call addFontFromAsset after freezing.");
        }
        if (axes != null) {
            for (FontVariationAxis axis : axes) {
                FontFamily.nAddAxisValue(this.mBuilderPtr, axis.getOpenTypeTagValue(), axis.getStyleValue());
            }
        }
        return FontFamily.nAddFontFromAssetManager(this.mBuilderPtr, mgr, path, cookie, isAsset, ttcIndex, weight, isItalic);
    }

    private static boolean nAddFont(long builderPtr, ByteBuffer font, int ttcIndex) {
        return FontFamily.nAddFont(builderPtr, font, ttcIndex, -1, -1);
    }

    @LayoutlibDelegate
    private static long nInitBuilder(String string2, int n) {
        return FontFamily_Delegate.nInitBuilder(string2, n);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nCreateFamily(long l) {
        return FontFamily_Delegate.nCreateFamily(l);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nGetBuilderReleaseFunc() {
        return FontFamily_Delegate.nGetBuilderReleaseFunc();
    }

    @LayoutlibDelegate
    @CriticalNative
    private static long nGetFamilyReleaseFunc() {
        return FontFamily_Delegate.nGetFamilyReleaseFunc();
    }

    @LayoutlibDelegate
    private static boolean nAddFont(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return FontFamily_Delegate.nAddFont(l, byteBuffer, n, n2, n3);
    }

    @LayoutlibDelegate
    private static boolean nAddFontWeightStyle(long l, ByteBuffer byteBuffer, int n, int n2, int n3) {
        return FontFamily_Delegate.nAddFontWeightStyle(l, byteBuffer, n, n2, n3);
    }

    @LayoutlibDelegate
    private static boolean nAddFontFromAssetManager(long l, AssetManager assetManager, String string2, int n, boolean bl, int n2, int n3, int n4) {
        return FontFamily_Delegate.nAddFontFromAssetManager(l, assetManager, string2, n, bl, n2, n3, n4);
    }

    @LayoutlibDelegate
    @CriticalNative
    private static void nAddAxisValue(long l, int n, float f) {
        FontFamily_Delegate.nAddAxisValue(l, n, f);
    }
}

