/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.annotation.UnsupportedAppUsage;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteTokenizer;
import android.os.CancellationSignal;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.util.EmptyArray;

public class SQLiteQueryBuilder {
    private static final String TAG = "SQLiteQueryBuilder";
    private static final Pattern sAggregationPattern = Pattern.compile("(?i)(AVG|COUNT|MAX|MIN|SUM|TOTAL|GROUP_CONCAT)\\((.+)\\)");
    private Map<String, String> mProjectionMap = null;
    private List<Pattern> mProjectionGreylist = null;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private String mTables = "";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private StringBuilder mWhereClause = null;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private boolean mDistinct = false;
    private SQLiteDatabase.CursorFactory mFactory = null;
    private static final int STRICT_PARENTHESES = 1;
    private static final int STRICT_COLUMNS = 2;
    private static final int STRICT_GRAMMAR = 4;
    private int mStrictFlags;

    public void setDistinct(boolean distinct) {
        this.mDistinct = distinct;
    }

    public boolean isDistinct() {
        return this.mDistinct;
    }

    public String getTables() {
        return this.mTables;
    }

    public void setTables(String inTables) {
        this.mTables = inTables;
    }

    public void appendWhere(CharSequence inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        this.mWhereClause.append(inWhere);
    }

    public void appendWhereEscapeString(String inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        DatabaseUtils.appendEscapedSQLString(this.mWhereClause, inWhere);
    }

    public void appendWhereStandalone(CharSequence inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        if (this.mWhereClause.length() > 0) {
            this.mWhereClause.append(" AND ");
        }
        this.mWhereClause.append('(').append(inWhere).append(')');
    }

    public void setProjectionMap(Map<String, String> columnMap) {
        this.mProjectionMap = columnMap;
    }

    public Map<String, String> getProjectionMap() {
        return this.mProjectionMap;
    }

    public void setProjectionGreylist(List<Pattern> projectionGreylist) {
        this.mProjectionGreylist = projectionGreylist;
    }

    public List<Pattern> getProjectionGreylist() {
        return this.mProjectionGreylist;
    }

    @Deprecated
    public void setProjectionAggregationAllowed(boolean projectionAggregationAllowed) {
    }

    @Deprecated
    public boolean isProjectionAggregationAllowed() {
        return true;
    }

    public void setCursorFactory(SQLiteDatabase.CursorFactory factory) {
        this.mFactory = factory;
    }

    public SQLiteDatabase.CursorFactory getCursorFactory() {
        return this.mFactory;
    }

    public void setStrict(boolean strict) {
        this.mStrictFlags = strict ? (this.mStrictFlags |= 1) : (this.mStrictFlags &= 0xFFFFFFFE);
    }

    public boolean isStrict() {
        return (this.mStrictFlags & 1) != 0;
    }

    public void setStrictColumns(boolean strictColumns) {
        this.mStrictFlags = strictColumns ? (this.mStrictFlags |= 2) : (this.mStrictFlags &= 0xFFFFFFFD);
    }

    public boolean isStrictColumns() {
        return (this.mStrictFlags & 2) != 0;
    }

    public void setStrictGrammar(boolean strictGrammar) {
        this.mStrictFlags = strictGrammar ? (this.mStrictFlags |= 4) : (this.mStrictFlags &= 0xFFFFFFFB);
    }

    public boolean isStrictGrammar() {
        return (this.mStrictFlags & 4) != 0;
    }

    public static String buildQueryString(boolean distinct, String tables, String[] columns, String where, String groupBy, String having, String orderBy, String limit) {
        if (TextUtils.isEmpty(groupBy) && !TextUtils.isEmpty(having)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        StringBuilder query = new StringBuilder(120);
        query.append("SELECT ");
        if (distinct) {
            query.append("DISTINCT ");
        }
        if (columns != null && columns.length != 0) {
            SQLiteQueryBuilder.appendColumns(query, columns);
        } else {
            query.append("* ");
        }
        query.append("FROM ");
        query.append(tables);
        SQLiteQueryBuilder.appendClause(query, " WHERE ", where);
        SQLiteQueryBuilder.appendClause(query, " GROUP BY ", groupBy);
        SQLiteQueryBuilder.appendClause(query, " HAVING ", having);
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", orderBy);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private static void appendClause(StringBuilder s, String name, String clause) {
        if (!TextUtils.isEmpty(clause)) {
            s.append(name);
            s.append(clause);
        }
    }

    public static void appendColumns(StringBuilder s, String[] columns) {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            String column = columns[i];
            if (column == null) continue;
            if (i > 0) {
                s.append(", ");
            }
            s.append(column);
        }
        s.append(' ');
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, null, null);
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, limit, null);
    }

    public Cursor query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit, CancellationSignal cancellationSignal) {
        String sql;
        if (this.mTables == null) {
            return null;
        }
        String unwrappedSql = this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
        if (this.isStrictColumns()) {
            this.enforceStrictColumns(projectionIn);
        }
        if (this.isStrictGrammar()) {
            this.enforceStrictGrammar(selection, groupBy, having, sortOrder, limit);
        }
        if (this.isStrict()) {
            String wrappedSql;
            db.validateSql(unwrappedSql, cancellationSignal);
            sql = wrappedSql = this.buildQuery(projectionIn, this.wrap(selection), groupBy, this.wrap(having), sortOrder, limit);
        } else {
            sql = unwrappedSql;
        }
        Object[] sqlArgs = selectionArgs;
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.rawQueryWithFactory(this.mFactory, sql, (String[])sqlArgs, SQLiteDatabase.findEditTable(this.mTables), cancellationSignal);
    }

    public long insert(SQLiteDatabase db, ContentValues values) {
        Objects.requireNonNull(this.mTables, "No tables defined");
        Objects.requireNonNull(db, "No database defined");
        Objects.requireNonNull(values, "No values defined");
        if (this.isStrictColumns()) {
            this.enforceStrictColumns(values);
        }
        String sql = this.buildInsert(values);
        ArrayMap<String, Object> rawValues = values.getValues();
        int valuesLength = rawValues.size();
        Object[] sqlArgs = new Object[valuesLength];
        for (int i = 0; i < sqlArgs.length; ++i) {
            sqlArgs[i] = rawValues.valueAt(i);
        }
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.executeSql(sql, sqlArgs);
    }

    public int update(SQLiteDatabase db, ContentValues values, String selection, String[] selectionArgs) {
        String sql;
        Objects.requireNonNull(this.mTables, "No tables defined");
        Objects.requireNonNull(db, "No database defined");
        Objects.requireNonNull(values, "No values defined");
        String unwrappedSql = this.buildUpdate(values, selection);
        if (this.isStrictColumns()) {
            this.enforceStrictColumns(values);
        }
        if (this.isStrictGrammar()) {
            this.enforceStrictGrammar(selection, null, null, null, null);
        }
        if (this.isStrict()) {
            String wrappedSql;
            db.validateSql(unwrappedSql, null);
            sql = wrappedSql = this.buildUpdate(values, this.wrap(selection));
        } else {
            sql = unwrappedSql;
        }
        if (selectionArgs == null) {
            selectionArgs = EmptyArray.STRING;
        }
        ArrayMap<String, Object> rawValues = values.getValues();
        int valuesLength = rawValues.size();
        Object[] sqlArgs = new Object[valuesLength + selectionArgs.length];
        for (int i = 0; i < sqlArgs.length; ++i) {
            sqlArgs[i] = i < valuesLength ? rawValues.valueAt(i) : selectionArgs[i - valuesLength];
        }
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.executeSql(sql, sqlArgs);
    }

    public int delete(SQLiteDatabase db, String selection, String[] selectionArgs) {
        String sql;
        Objects.requireNonNull(this.mTables, "No tables defined");
        Objects.requireNonNull(db, "No database defined");
        String unwrappedSql = this.buildDelete(selection);
        if (this.isStrictGrammar()) {
            this.enforceStrictGrammar(selection, null, null, null, null);
        }
        if (this.isStrict()) {
            String wrappedSql;
            db.validateSql(unwrappedSql, null);
            sql = wrappedSql = this.buildDelete(this.wrap(selection));
        } else {
            sql = unwrappedSql;
        }
        Object[] sqlArgs = selectionArgs;
        if (Log.isLoggable(TAG, 3)) {
            if (_Original_Build.IS_DEBUGGABLE) {
                Log.d(TAG, sql + " with args " + Arrays.toString(sqlArgs));
            } else {
                Log.d(TAG, sql);
            }
        }
        return db.executeSql(sql, sqlArgs);
    }

    private void enforceStrictColumns(String[] projection) {
        Objects.requireNonNull(this.mProjectionMap, "No projection map defined");
        this.computeProjection(projection);
    }

    private void enforceStrictColumns(ContentValues values) {
        Objects.requireNonNull(this.mProjectionMap, "No projection map defined");
        ArrayMap<String, Object> rawValues = values.getValues();
        for (int i = 0; i < rawValues.size(); ++i) {
            String column = rawValues.keyAt(i);
            if (this.mProjectionMap.containsKey(column)) continue;
            throw new IllegalArgumentException("Invalid column " + column);
        }
    }

    private void enforceStrictGrammar(String selection, String groupBy, String having, String sortOrder, String limit) {
        SQLiteTokenizer.tokenize(selection, 0, this::enforceStrictGrammarWhereHaving);
        SQLiteTokenizer.tokenize(groupBy, 0, this::enforceStrictGrammarGroupBy);
        SQLiteTokenizer.tokenize(having, 0, this::enforceStrictGrammarWhereHaving);
        SQLiteTokenizer.tokenize(sortOrder, 0, this::enforceStrictGrammarOrderBy);
        SQLiteTokenizer.tokenize(limit, 0, this::enforceStrictGrammarLimit);
    }

    private void enforceStrictGrammarWhereHaving(String token) {
        if (this.isTableOrColumn(token)) {
            return;
        }
        if (SQLiteTokenizer.isFunction(token)) {
            return;
        }
        if (SQLiteTokenizer.isType(token)) {
            return;
        }
        switch (token.toUpperCase(Locale.US)) {
            case "AND": 
            case "AS": 
            case "BETWEEN": 
            case "BINARY": 
            case "CASE": 
            case "CAST": 
            case "COLLATE": 
            case "DISTINCT": 
            case "ELSE": 
            case "END": 
            case "ESCAPE": 
            case "EXISTS": 
            case "GLOB": 
            case "IN": 
            case "IS": 
            case "ISNULL": 
            case "LIKE": 
            case "MATCH": 
            case "NOCASE": 
            case "NOT": 
            case "NOTNULL": 
            case "NULL": 
            case "OR": 
            case "REGEXP": 
            case "RTRIM": 
            case "THEN": 
            case "WHEN": {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid token " + token);
    }

    private void enforceStrictGrammarGroupBy(String token) {
        if (this.isTableOrColumn(token)) {
            return;
        }
        throw new IllegalArgumentException("Invalid token " + token);
    }

    private void enforceStrictGrammarOrderBy(String token) {
        if (this.isTableOrColumn(token)) {
            return;
        }
        switch (token.toUpperCase(Locale.US)) {
            case "COLLATE": 
            case "ASC": 
            case "DESC": 
            case "BINARY": 
            case "RTRIM": 
            case "NOCASE": {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid token " + token);
    }

    private void enforceStrictGrammarLimit(String token) {
        switch (token.toUpperCase(Locale.US)) {
            case "OFFSET": {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid token " + token);
    }

    public String buildQuery(String[] projectionIn, String selection, String groupBy, String having, String sortOrder, String limit) {
        String[] projection = this.computeProjection(projectionIn);
        String where = this.computeWhere(selection);
        return SQLiteQueryBuilder.buildQueryString(this.mDistinct, this.mTables, projection, where, groupBy, having, sortOrder, limit);
    }

    @Deprecated
    public String buildQuery(String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
    }

    public String buildInsert(ContentValues values) {
        int i;
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("INSERT INTO ");
        sql.append(SQLiteDatabase.findEditTable(this.mTables));
        sql.append(" (");
        ArrayMap<String, Object> rawValues = values.getValues();
        for (i = 0; i < rawValues.size(); ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append(rawValues.keyAt(i));
        }
        sql.append(") VALUES (");
        for (i = 0; i < rawValues.size(); ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(")");
        return sql.toString();
    }

    public String buildUpdate(ContentValues values, String selection) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Empty values");
        }
        StringBuilder sql = new StringBuilder(120);
        sql.append("UPDATE ");
        sql.append(SQLiteDatabase.findEditTable(this.mTables));
        sql.append(" SET ");
        ArrayMap<String, Object> rawValues = values.getValues();
        for (int i = 0; i < rawValues.size(); ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append(rawValues.keyAt(i));
            sql.append("=?");
        }
        String where = this.computeWhere(selection);
        SQLiteQueryBuilder.appendClause(sql, " WHERE ", where);
        return sql.toString();
    }

    public String buildDelete(String selection) {
        StringBuilder sql = new StringBuilder(120);
        sql.append("DELETE FROM ");
        sql.append(SQLiteDatabase.findEditTable(this.mTables));
        String where = this.computeWhere(selection);
        SQLiteQueryBuilder.appendClause(sql, " WHERE ", where);
        return sql.toString();
    }

    public String buildUnionSubQuery(String typeDiscriminatorColumn, String[] unionColumns, Set<String> columnsPresentInTable, int computedColumnsOffset, String typeDiscriminatorValue, String selection, String groupBy, String having) {
        int unionColumnsCount = unionColumns.length;
        String[] projectionIn = new String[unionColumnsCount];
        for (int i = 0; i < unionColumnsCount; ++i) {
            String unionColumn = unionColumns[i];
            projectionIn[i] = unionColumn.equals(typeDiscriminatorColumn) ? "'" + typeDiscriminatorValue + "' AS " + typeDiscriminatorColumn : (i <= computedColumnsOffset || columnsPresentInTable.contains(unionColumn) ? unionColumn : "NULL AS " + unionColumn);
        }
        return this.buildQuery(projectionIn, selection, groupBy, having, null, null);
    }

    @Deprecated
    public String buildUnionSubQuery(String typeDiscriminatorColumn, String[] unionColumns, Set<String> columnsPresentInTable, int computedColumnsOffset, String typeDiscriminatorValue, String selection, String[] selectionArgs, String groupBy, String having) {
        return this.buildUnionSubQuery(typeDiscriminatorColumn, unionColumns, columnsPresentInTable, computedColumnsOffset, typeDiscriminatorValue, selection, groupBy, having);
    }

    public String buildUnionQuery(String[] subQueries, String sortOrder, String limit) {
        StringBuilder query = new StringBuilder(128);
        int subQueryCount = subQueries.length;
        String unionOperator = this.mDistinct ? " UNION " : " UNION ALL ";
        for (int i = 0; i < subQueryCount; ++i) {
            if (i > 0) {
                query.append(unionOperator);
            }
            query.append(subQueries[i]);
        }
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", sortOrder);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private static String maybeWithOperator(String operator, String column) {
        if (operator != null) {
            return operator + "(" + column + ")";
        }
        return column;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public String[] computeProjection(String[] projectionIn) {
        if (!ArrayUtils.isEmpty(projectionIn)) {
            String[] projectionOut = new String[projectionIn.length];
            for (int i = 0; i < projectionIn.length; ++i) {
                projectionOut[i] = this.computeSingleProjectionOrThrow(projectionIn[i]);
            }
            return projectionOut;
        }
        if (this.mProjectionMap != null) {
            Set<Map.Entry<String, String>> entrySet = this.mProjectionMap.entrySet();
            String[] projection = new String[entrySet.size()];
            Iterator<Map.Entry<String, String>> entryIter = entrySet.iterator();
            int i = 0;
            while (entryIter.hasNext()) {
                Map.Entry<String, String> entry = entryIter.next();
                if (entry.getKey().equals("_count")) continue;
                projection[i++] = entry.getValue();
            }
            return projection;
        }
        return null;
    }

    private String computeSingleProjectionOrThrow(String userColumn) {
        String column = this.computeSingleProjection(userColumn);
        if (column != null) {
            return column;
        }
        throw new IllegalArgumentException("Invalid column " + userColumn);
    }

    private String computeSingleProjection(String userColumn) {
        Matcher matcher;
        if (this.mProjectionMap == null) {
            return userColumn;
        }
        String operator = null;
        String column = this.mProjectionMap.get(userColumn);
        if (column == null && (matcher = sAggregationPattern.matcher(userColumn)).matches()) {
            operator = matcher.group(1);
            userColumn = matcher.group(2);
            column = this.mProjectionMap.get(userColumn);
        }
        if (column != null) {
            return SQLiteQueryBuilder.maybeWithOperator(operator, column);
        }
        if (this.mStrictFlags == 0 && (userColumn.contains(" AS ") || userColumn.contains(" as "))) {
            return SQLiteQueryBuilder.maybeWithOperator(operator, userColumn);
        }
        if (this.mProjectionGreylist != null) {
            boolean match = false;
            for (Pattern p : this.mProjectionGreylist) {
                if (!p.matcher(userColumn).matches()) continue;
                match = true;
                break;
            }
            if (match) {
                Log.w(TAG, "Allowing abusive custom column: " + userColumn);
                return SQLiteQueryBuilder.maybeWithOperator(operator, userColumn);
            }
        }
        return null;
    }

    private boolean isTableOrColumn(String token) {
        if (this.mTables.equals(token)) {
            return true;
        }
        return this.computeSingleProjection(token) != null;
    }

    public String computeWhere(String selection) {
        boolean hasExternal;
        boolean hasInternal = !TextUtils.isEmpty(this.mWhereClause);
        boolean bl = hasExternal = !TextUtils.isEmpty(selection);
        if (hasInternal || hasExternal) {
            StringBuilder where = new StringBuilder();
            if (hasInternal) {
                where.append('(').append((CharSequence)this.mWhereClause).append(')');
            }
            if (hasInternal && hasExternal) {
                where.append(" AND ");
            }
            if (hasExternal) {
                where.append('(').append(selection).append(')');
            }
            return where.toString();
        }
        return null;
    }

    private String wrap(String arg) {
        if (TextUtils.isEmpty(arg)) {
            return arg;
        }
        return "(" + arg + ")";
    }
}

