/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.UnsupportedAppUsage;
import android.app.WindowConfiguration;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.WireTypeMismatchException;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.IllformedLocaleException;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Configuration
implements Parcelable,
Comparable<Configuration> {
    public static final Configuration EMPTY = new Configuration();
    private static final String TAG = "Configuration";
    public float fontScale;
    public int mcc;
    public int mnc;
    public static final int MNC_ZERO = 65535;
    @Deprecated
    public Locale locale;
    private LocaleList mLocaleList;
    @UnsupportedAppUsage
    public boolean userSetLocale;
    public static final int COLOR_MODE_WIDE_COLOR_GAMUT_MASK = 3;
    public static final int COLOR_MODE_WIDE_COLOR_GAMUT_UNDEFINED = 0;
    public static final int COLOR_MODE_WIDE_COLOR_GAMUT_NO = 1;
    public static final int COLOR_MODE_WIDE_COLOR_GAMUT_YES = 2;
    public static final int COLOR_MODE_HDR_MASK = 12;
    public static final int COLOR_MODE_HDR_SHIFT = 2;
    public static final int COLOR_MODE_HDR_UNDEFINED = 0;
    public static final int COLOR_MODE_HDR_NO = 4;
    public static final int COLOR_MODE_HDR_YES = 8;
    public static final int COLOR_MODE_UNDEFINED = 0;
    public int colorMode;
    public static final int SCREENLAYOUT_SIZE_MASK = 15;
    public static final int SCREENLAYOUT_SIZE_UNDEFINED = 0;
    public static final int SCREENLAYOUT_SIZE_SMALL = 1;
    public static final int SCREENLAYOUT_SIZE_NORMAL = 2;
    public static final int SCREENLAYOUT_SIZE_LARGE = 3;
    public static final int SCREENLAYOUT_SIZE_XLARGE = 4;
    public static final int SCREENLAYOUT_LONG_MASK = 48;
    public static final int SCREENLAYOUT_LONG_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LONG_NO = 16;
    public static final int SCREENLAYOUT_LONG_YES = 32;
    public static final int SCREENLAYOUT_LAYOUTDIR_MASK = 192;
    public static final int SCREENLAYOUT_LAYOUTDIR_SHIFT = 6;
    public static final int SCREENLAYOUT_LAYOUTDIR_UNDEFINED = 0;
    public static final int SCREENLAYOUT_LAYOUTDIR_LTR = 64;
    public static final int SCREENLAYOUT_LAYOUTDIR_RTL = 128;
    public static final int SCREENLAYOUT_ROUND_MASK = 768;
    public static final int SCREENLAYOUT_ROUND_SHIFT = 8;
    public static final int SCREENLAYOUT_ROUND_UNDEFINED = 0;
    public static final int SCREENLAYOUT_ROUND_NO = 256;
    public static final int SCREENLAYOUT_ROUND_YES = 512;
    public static final int SCREENLAYOUT_UNDEFINED = 0;
    public static final int SCREENLAYOUT_COMPAT_NEEDED = 0x10000000;
    public int screenLayout;
    public final WindowConfiguration windowConfiguration = new WindowConfiguration();
    public static final int TOUCHSCREEN_UNDEFINED = 0;
    public static final int TOUCHSCREEN_NOTOUCH = 1;
    @Deprecated
    public static final int TOUCHSCREEN_STYLUS = 2;
    public static final int TOUCHSCREEN_FINGER = 3;
    public int touchscreen;
    public static final int KEYBOARD_UNDEFINED = 0;
    public static final int KEYBOARD_NOKEYS = 1;
    public static final int KEYBOARD_QWERTY = 2;
    public static final int KEYBOARD_12KEY = 3;
    public int keyboard;
    public static final int KEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int KEYBOARDHIDDEN_NO = 1;
    public static final int KEYBOARDHIDDEN_YES = 2;
    public static final int KEYBOARDHIDDEN_SOFT = 3;
    public int keyboardHidden;
    public static final int HARDKEYBOARDHIDDEN_UNDEFINED = 0;
    public static final int HARDKEYBOARDHIDDEN_NO = 1;
    public static final int HARDKEYBOARDHIDDEN_YES = 2;
    public int hardKeyboardHidden;
    public static final int NAVIGATION_UNDEFINED = 0;
    public static final int NAVIGATION_NONAV = 1;
    public static final int NAVIGATION_DPAD = 2;
    public static final int NAVIGATION_TRACKBALL = 3;
    public static final int NAVIGATION_WHEEL = 4;
    public int navigation;
    public static final int NAVIGATIONHIDDEN_UNDEFINED = 0;
    public static final int NAVIGATIONHIDDEN_NO = 1;
    public static final int NAVIGATIONHIDDEN_YES = 2;
    public int navigationHidden;
    public static final int ORIENTATION_UNDEFINED = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    @Deprecated
    public static final int ORIENTATION_SQUARE = 3;
    public int orientation;
    public static final int UI_MODE_TYPE_MASK = 15;
    public static final int UI_MODE_TYPE_UNDEFINED = 0;
    public static final int UI_MODE_TYPE_NORMAL = 1;
    public static final int UI_MODE_TYPE_DESK = 2;
    public static final int UI_MODE_TYPE_CAR = 3;
    public static final int UI_MODE_TYPE_TELEVISION = 4;
    public static final int UI_MODE_TYPE_APPLIANCE = 5;
    public static final int UI_MODE_TYPE_WATCH = 6;
    public static final int UI_MODE_TYPE_VR_HEADSET = 7;
    public static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_UNDEFINED = 0;
    public static final int UI_MODE_NIGHT_NO = 16;
    public static final int UI_MODE_NIGHT_YES = 32;
    public int uiMode;
    public static final int SCREEN_WIDTH_DP_UNDEFINED = 0;
    public int screenWidthDp;
    public static final int SCREEN_HEIGHT_DP_UNDEFINED = 0;
    public int screenHeightDp;
    public static final int SMALLEST_SCREEN_WIDTH_DP_UNDEFINED = 0;
    public int smallestScreenWidthDp;
    public static final int DENSITY_DPI_UNDEFINED = 0;
    public static final int DENSITY_DPI_ANY = 65534;
    public static final int DENSITY_DPI_NONE = 65535;
    public int densityDpi;
    public int compatScreenWidthDp;
    public int compatScreenHeightDp;
    public int compatSmallestScreenWidthDp;
    public static final int ASSETS_SEQ_UNDEFINED = 0;
    public int assetsSeq;
    @UnsupportedAppUsage
    public int seq;
    public static final int NATIVE_CONFIG_MCC = 1;
    public static final int NATIVE_CONFIG_MNC = 2;
    public static final int NATIVE_CONFIG_LOCALE = 4;
    public static final int NATIVE_CONFIG_TOUCHSCREEN = 8;
    public static final int NATIVE_CONFIG_KEYBOARD = 16;
    public static final int NATIVE_CONFIG_KEYBOARD_HIDDEN = 32;
    public static final int NATIVE_CONFIG_NAVIGATION = 64;
    public static final int NATIVE_CONFIG_ORIENTATION = 128;
    public static final int NATIVE_CONFIG_DENSITY = 256;
    public static final int NATIVE_CONFIG_SCREEN_SIZE = 512;
    public static final int NATIVE_CONFIG_VERSION = 1024;
    public static final int NATIVE_CONFIG_SCREEN_LAYOUT = 2048;
    public static final int NATIVE_CONFIG_UI_MODE = 4096;
    public static final int NATIVE_CONFIG_SMALLEST_SCREEN_SIZE = 8192;
    public static final int NATIVE_CONFIG_LAYOUTDIR = 16384;
    public static final int NATIVE_CONFIG_COLOR_MODE = 65536;
    public static final Parcelable.Creator<Configuration> CREATOR = new Parcelable.Creator<Configuration>(){

        @Override
        public Configuration createFromParcel(Parcel source) {
            return new Configuration(source);
        }

        public Configuration[] newArray(int size) {
            return new Configuration[size];
        }
    };
    private static final String XML_ATTR_FONT_SCALE = "fs";
    private static final String XML_ATTR_MCC = "mcc";
    private static final String XML_ATTR_MNC = "mnc";
    private static final String XML_ATTR_LOCALES = "locales";
    private static final String XML_ATTR_TOUCHSCREEN = "touch";
    private static final String XML_ATTR_KEYBOARD = "key";
    private static final String XML_ATTR_KEYBOARD_HIDDEN = "keyHid";
    private static final String XML_ATTR_HARD_KEYBOARD_HIDDEN = "hardKeyHid";
    private static final String XML_ATTR_NAVIGATION = "nav";
    private static final String XML_ATTR_NAVIGATION_HIDDEN = "navHid";
    private static final String XML_ATTR_ORIENTATION = "ori";
    private static final String XML_ATTR_ROTATION = "rot";
    private static final String XML_ATTR_SCREEN_LAYOUT = "scrLay";
    private static final String XML_ATTR_COLOR_MODE = "clrMod";
    private static final String XML_ATTR_UI_MODE = "ui";
    private static final String XML_ATTR_SCREEN_WIDTH = "width";
    private static final String XML_ATTR_SCREEN_HEIGHT = "height";
    private static final String XML_ATTR_SMALLEST_WIDTH = "sw";
    private static final String XML_ATTR_DENSITY = "density";
    private static final String XML_ATTR_APP_BOUNDS = "app_bounds";

    public static int resetScreenLayout(int curLayout) {
        return curLayout & 0xEFFFFFC0 | 0x24;
    }

    public static int reduceScreenLayout(int curLayout, int longSizeDp, int shortSizeDp) {
        int curSize;
        boolean screenLayoutCompatNeeded;
        boolean screenLayoutLong;
        int screenLayoutSize;
        if (longSizeDp < 470) {
            screenLayoutSize = 1;
            screenLayoutLong = false;
            screenLayoutCompatNeeded = false;
        } else {
            screenLayoutSize = longSizeDp >= 960 && shortSizeDp >= 720 ? 4 : (longSizeDp >= 640 && shortSizeDp >= 480 ? 3 : 2);
            screenLayoutCompatNeeded = shortSizeDp > 321 || longSizeDp > 570;
            screenLayoutLong = longSizeDp * 3 / 5 >= shortSizeDp - 1;
        }
        if (!screenLayoutLong) {
            curLayout = curLayout & 0xFFFFFFCF | 0x10;
        }
        if (screenLayoutCompatNeeded) {
            curLayout |= 0x10000000;
        }
        if (screenLayoutSize < (curSize = curLayout & 0xF)) {
            curLayout = curLayout & 0xFFFFFFF0 | screenLayoutSize;
        }
        return curLayout;
    }

    public static String configurationDiffToString(int diff) {
        ArrayList<String> list = new ArrayList<String>();
        if ((diff & 1) != 0) {
            list.add("CONFIG_MCC");
        }
        if ((diff & 2) != 0) {
            list.add("CONFIG_MNC");
        }
        if ((diff & 4) != 0) {
            list.add("CONFIG_LOCALE");
        }
        if ((diff & 8) != 0) {
            list.add("CONFIG_TOUCHSCREEN");
        }
        if ((diff & 0x10) != 0) {
            list.add("CONFIG_KEYBOARD");
        }
        if ((diff & 0x20) != 0) {
            list.add("CONFIG_KEYBOARD_HIDDEN");
        }
        if ((diff & 0x40) != 0) {
            list.add("CONFIG_NAVIGATION");
        }
        if ((diff & 0x80) != 0) {
            list.add("CONFIG_ORIENTATION");
        }
        if ((diff & 0x100) != 0) {
            list.add("CONFIG_SCREEN_LAYOUT");
        }
        if ((diff & 0x4000) != 0) {
            list.add("CONFIG_COLOR_MODE");
        }
        if ((diff & 0x200) != 0) {
            list.add("CONFIG_UI_MODE");
        }
        if ((diff & 0x400) != 0) {
            list.add("CONFIG_SCREEN_SIZE");
        }
        if ((diff & 0x800) != 0) {
            list.add("CONFIG_SMALLEST_SCREEN_SIZE");
        }
        if ((diff & 0x2000) != 0) {
            list.add("CONFIG_LAYOUT_DIRECTION");
        }
        if ((diff & 0x40000000) != 0) {
            list.add("CONFIG_FONT_SCALE");
        }
        if ((diff & Integer.MIN_VALUE) != 0) {
            list.add("CONFIG_ASSETS_PATHS");
        }
        StringBuilder builder = new StringBuilder("{");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            builder.append((String)list.get(i));
            if (i == n - 1) continue;
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean isLayoutSizeAtLeast(int size) {
        int cur = this.screenLayout & 0xF;
        if (cur == 0) {
            return false;
        }
        return cur >= size;
    }

    public Configuration() {
        this.unset();
    }

    public Configuration(Configuration o) {
        this.setTo(o);
    }

    private void fixUpLocaleList() {
        if (this.locale == null && !this.mLocaleList.isEmpty() || this.locale != null && !this.locale.equals(this.mLocaleList.get(0))) {
            this.mLocaleList = this.locale == null ? LocaleList.getEmptyLocaleList() : new LocaleList(this.locale);
        }
    }

    public void setTo(Configuration o) {
        this.fontScale = o.fontScale;
        this.mcc = o.mcc;
        this.mnc = o.mnc;
        this.locale = o.locale == null ? null : (Locale)o.locale.clone();
        o.fixUpLocaleList();
        this.mLocaleList = o.mLocaleList;
        this.userSetLocale = o.userSetLocale;
        this.touchscreen = o.touchscreen;
        this.keyboard = o.keyboard;
        this.keyboardHidden = o.keyboardHidden;
        this.hardKeyboardHidden = o.hardKeyboardHidden;
        this.navigation = o.navigation;
        this.navigationHidden = o.navigationHidden;
        this.orientation = o.orientation;
        this.screenLayout = o.screenLayout;
        this.colorMode = o.colorMode;
        this.uiMode = o.uiMode;
        this.screenWidthDp = o.screenWidthDp;
        this.screenHeightDp = o.screenHeightDp;
        this.smallestScreenWidthDp = o.smallestScreenWidthDp;
        this.densityDpi = o.densityDpi;
        this.compatScreenWidthDp = o.compatScreenWidthDp;
        this.compatScreenHeightDp = o.compatScreenHeightDp;
        this.compatSmallestScreenWidthDp = o.compatSmallestScreenWidthDp;
        this.assetsSeq = o.assetsSeq;
        this.seq = o.seq;
        this.windowConfiguration.setTo(o.windowConfiguration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{");
        sb.append(this.fontScale);
        sb.append(" ");
        if (this.mcc != 0) {
            sb.append(this.mcc);
            sb.append(XML_ATTR_MCC);
        } else {
            sb.append("?mcc");
        }
        if (this.mnc != 0) {
            sb.append(this.mnc);
            sb.append(XML_ATTR_MNC);
        } else {
            sb.append("?mnc");
        }
        this.fixUpLocaleList();
        if (!this.mLocaleList.isEmpty()) {
            sb.append(" ");
            sb.append(this.mLocaleList);
        } else {
            sb.append(" ?localeList");
        }
        int layoutDir = this.screenLayout & 0xC0;
        switch (layoutDir) {
            case 0: {
                sb.append(" ?layoutDir");
                break;
            }
            case 64: {
                sb.append(" ldltr");
                break;
            }
            case 128: {
                sb.append(" ldrtl");
                break;
            }
            default: {
                sb.append(" layoutDir=");
                sb.append(layoutDir >> 6);
            }
        }
        if (this.smallestScreenWidthDp != 0) {
            sb.append(" sw");
            sb.append(this.smallestScreenWidthDp);
            sb.append("dp");
        } else {
            sb.append(" ?swdp");
        }
        if (this.screenWidthDp != 0) {
            sb.append(" w");
            sb.append(this.screenWidthDp);
            sb.append("dp");
        } else {
            sb.append(" ?wdp");
        }
        if (this.screenHeightDp != 0) {
            sb.append(" h");
            sb.append(this.screenHeightDp);
            sb.append("dp");
        } else {
            sb.append(" ?hdp");
        }
        if (this.densityDpi != 0) {
            sb.append(" ");
            sb.append(this.densityDpi);
            sb.append("dpi");
        } else {
            sb.append(" ?density");
        }
        switch (this.screenLayout & 0xF) {
            case 0: {
                sb.append(" ?lsize");
                break;
            }
            case 1: {
                sb.append(" smll");
                break;
            }
            case 2: {
                sb.append(" nrml");
                break;
            }
            case 3: {
                sb.append(" lrg");
                break;
            }
            case 4: {
                sb.append(" xlrg");
                break;
            }
            default: {
                sb.append(" layoutSize=");
                sb.append(this.screenLayout & 0xF);
            }
        }
        switch (this.screenLayout & 0x30) {
            case 0: {
                sb.append(" ?long");
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                sb.append(" long");
                break;
            }
            default: {
                sb.append(" layoutLong=");
                sb.append(this.screenLayout & 0x30);
            }
        }
        switch (this.colorMode & 0xC) {
            case 0: {
                sb.append(" ?ldr");
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                sb.append(" hdr");
                break;
            }
            default: {
                sb.append(" dynamicRange=");
                sb.append(this.colorMode & 0xC);
            }
        }
        switch (this.colorMode & 3) {
            case 0: {
                sb.append(" ?wideColorGamut");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                sb.append(" widecg");
                break;
            }
            default: {
                sb.append(" wideColorGamut=");
                sb.append(this.colorMode & 3);
            }
        }
        switch (this.orientation) {
            case 0: {
                sb.append(" ?orien");
                break;
            }
            case 2: {
                sb.append(" land");
                break;
            }
            case 1: {
                sb.append(" port");
                break;
            }
            default: {
                sb.append(" orien=");
                sb.append(this.orientation);
            }
        }
        switch (this.uiMode & 0xF) {
            case 0: {
                sb.append(" ?uimode");
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                sb.append(" desk");
                break;
            }
            case 3: {
                sb.append(" car");
                break;
            }
            case 4: {
                sb.append(" television");
                break;
            }
            case 5: {
                sb.append(" appliance");
                break;
            }
            case 6: {
                sb.append(" watch");
                break;
            }
            case 7: {
                sb.append(" vrheadset");
                break;
            }
            default: {
                sb.append(" uimode=");
                sb.append(this.uiMode & 0xF);
            }
        }
        switch (this.uiMode & 0x30) {
            case 0: {
                sb.append(" ?night");
                break;
            }
            case 16: {
                break;
            }
            case 32: {
                sb.append(" night");
                break;
            }
            default: {
                sb.append(" night=");
                sb.append(this.uiMode & 0x30);
            }
        }
        switch (this.touchscreen) {
            case 0: {
                sb.append(" ?touch");
                break;
            }
            case 1: {
                sb.append(" -touch");
                break;
            }
            case 2: {
                sb.append(" stylus");
                break;
            }
            case 3: {
                sb.append(" finger");
                break;
            }
            default: {
                sb.append(" touch=");
                sb.append(this.touchscreen);
            }
        }
        switch (this.keyboard) {
            case 0: {
                sb.append(" ?keyb");
                break;
            }
            case 1: {
                sb.append(" -keyb");
                break;
            }
            case 2: {
                sb.append(" qwerty");
                break;
            }
            case 3: {
                sb.append(" 12key");
                break;
            }
            default: {
                sb.append(" keys=");
                sb.append(this.keyboard);
            }
        }
        switch (this.keyboardHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            case 3: {
                sb.append("/s");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.keyboardHidden);
            }
        }
        switch (this.hardKeyboardHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.hardKeyboardHidden);
            }
        }
        switch (this.navigation) {
            case 0: {
                sb.append(" ?nav");
                break;
            }
            case 1: {
                sb.append(" -nav");
                break;
            }
            case 2: {
                sb.append(" dpad");
                break;
            }
            case 3: {
                sb.append(" tball");
                break;
            }
            case 4: {
                sb.append(" wheel");
                break;
            }
            default: {
                sb.append(" nav=");
                sb.append(this.navigation);
            }
        }
        switch (this.navigationHidden) {
            case 0: {
                sb.append("/?");
                break;
            }
            case 1: {
                sb.append("/v");
                break;
            }
            case 2: {
                sb.append("/h");
                break;
            }
            default: {
                sb.append("/");
                sb.append(this.navigationHidden);
            }
        }
        sb.append(" winConfig=");
        sb.append(this.windowConfiguration);
        if (this.assetsSeq != 0) {
            sb.append(" as.").append(this.assetsSeq);
        }
        if (this.seq != 0) {
            sb.append(" s.").append(this.seq);
        }
        sb.append('}');
        return sb.toString();
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long fieldId, boolean persisted, boolean critical) {
        long token = protoOutputStream.start(fieldId);
        if (!critical) {
            protoOutputStream.write(0x10200000001L, this.fontScale);
            protoOutputStream.write(1155346202626L, this.mcc);
            protoOutputStream.write(1155346202627L, this.mnc);
            if (this.mLocaleList != null) {
                protoOutputStream.write(1138166333460L, this.mLocaleList.toLanguageTags());
            }
            protoOutputStream.write(1155346202629L, this.screenLayout);
            protoOutputStream.write(1155346202630L, this.colorMode);
            protoOutputStream.write(1155346202631L, this.touchscreen);
            protoOutputStream.write(1155346202632L, this.keyboard);
            protoOutputStream.write(1155346202633L, this.keyboardHidden);
            protoOutputStream.write(1155346202634L, this.hardKeyboardHidden);
            protoOutputStream.write(1155346202635L, this.navigation);
            protoOutputStream.write(1155346202636L, this.navigationHidden);
            protoOutputStream.write(1155346202638L, this.uiMode);
            protoOutputStream.write(0x10D00000011L, this.smallestScreenWidthDp);
            protoOutputStream.write(1155346202642L, this.densityDpi);
            if (!persisted && this.windowConfiguration != null) {
                this.windowConfiguration.writeToProto(protoOutputStream, 1146756268051L);
            }
        }
        protoOutputStream.write(0x10D0000000DL, this.orientation);
        protoOutputStream.write(1155346202639L, this.screenWidthDp);
        protoOutputStream.write(0x10D00000010L, this.screenHeightDp);
        protoOutputStream.end(token);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long fieldId) {
        this.writeToProto(protoOutputStream, fieldId, false, false);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long fieldId, boolean critical) {
        this.writeToProto(protoOutputStream, fieldId, false, critical);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void readFromProto(ProtoInputStream protoInputStream, long fieldId) throws IOException {
        long token = protoInputStream.start(fieldId);
        ArrayList<Locale> list = new ArrayList<Locale>();
        try {
            while (protoInputStream.nextField() != -1) {
                switch (protoInputStream.getFieldNumber()) {
                    case 1: {
                        this.fontScale = protoInputStream.readFloat(0x10200000001L);
                        break;
                    }
                    case 2: {
                        this.mcc = protoInputStream.readInt(1155346202626L);
                        break;
                    }
                    case 3: {
                        this.mnc = protoInputStream.readInt(1155346202627L);
                        break;
                    }
                    case 4: {
                        long localeToken = protoInputStream.start(2246267895812L);
                        String language = "";
                        String country = "";
                        String variant = "";
                        String script = "";
                        while (protoInputStream.nextField() != -1) {
                            switch (protoInputStream.getFieldNumber()) {
                                case 1: {
                                    language = protoInputStream.readString(0x10900000001L);
                                    break;
                                }
                                case 2: {
                                    country = protoInputStream.readString(1138166333442L);
                                    break;
                                }
                                case 3: {
                                    variant = protoInputStream.readString(1138166333443L);
                                    break;
                                }
                                case 4: {
                                    script = protoInputStream.readString(1138166333444L);
                                }
                            }
                        }
                        protoInputStream.end(localeToken);
                        try {
                            Locale locale = new Locale.Builder().setLanguage(language).setRegion(country).setVariant(variant).setScript(script).build();
                            int inListIndex = list.indexOf(locale);
                            if (inListIndex != -1) {
                                Slog.wtf(TAG, "Repeated locale (" + list.get(inListIndex) + ") found when trying to add: " + locale.toString());
                                break;
                            }
                            list.add(locale);
                        }
                        catch (IllformedLocaleException e) {
                            Slog.e(TAG, "readFromProto error building locale with: language-" + language + ";country-" + country + ";variant-" + variant + ";script-" + script);
                        }
                        break;
                        catch (WireTypeMismatchException wtme) {
                            try {
                                throw wtme;
                            }
                            catch (Throwable throwable) {
                                protoInputStream.end(localeToken);
                                try {
                                    Locale locale = new Locale.Builder().setLanguage(language).setRegion(country).setVariant(variant).setScript(script).build();
                                    int inListIndex = list.indexOf(locale);
                                    if (inListIndex != -1) {
                                        Slog.wtf(TAG, "Repeated locale (" + list.get(inListIndex) + ") found when trying to add: " + locale.toString());
                                    } else {
                                        list.add(locale);
                                    }
                                }
                                catch (IllformedLocaleException e) {
                                    Slog.e(TAG, "readFromProto error building locale with: language-" + language + ";country-" + country + ";variant-" + variant + ";script-" + script);
                                }
                                throw throwable;
                            }
                        }
                    }
                    case 5: {
                        this.screenLayout = protoInputStream.readInt(1155346202629L);
                        break;
                    }
                    case 6: {
                        this.colorMode = protoInputStream.readInt(1155346202630L);
                        break;
                    }
                    case 7: {
                        this.touchscreen = protoInputStream.readInt(1155346202631L);
                        break;
                    }
                    case 8: {
                        this.keyboard = protoInputStream.readInt(1155346202632L);
                        break;
                    }
                    case 9: {
                        this.keyboardHidden = protoInputStream.readInt(1155346202633L);
                        break;
                    }
                    case 10: {
                        this.hardKeyboardHidden = protoInputStream.readInt(1155346202634L);
                        break;
                    }
                    case 11: {
                        this.navigation = protoInputStream.readInt(1155346202635L);
                        break;
                    }
                    case 12: {
                        this.navigationHidden = protoInputStream.readInt(1155346202636L);
                        break;
                    }
                    case 13: {
                        this.orientation = protoInputStream.readInt(0x10D0000000DL);
                        break;
                    }
                    case 14: {
                        this.uiMode = protoInputStream.readInt(1155346202638L);
                        break;
                    }
                    case 15: {
                        this.screenWidthDp = protoInputStream.readInt(1155346202639L);
                        break;
                    }
                    case 16: {
                        this.screenHeightDp = protoInputStream.readInt(0x10D00000010L);
                        break;
                    }
                    case 17: {
                        this.smallestScreenWidthDp = protoInputStream.readInt(0x10D00000011L);
                        break;
                    }
                    case 18: {
                        this.densityDpi = protoInputStream.readInt(1155346202642L);
                        break;
                    }
                    case 19: {
                        this.windowConfiguration.readFromProto(protoInputStream, 1146756268051L);
                        break;
                    }
                    case 20: {
                        try {
                            this.setLocales(LocaleList.forLanguageTags(protoInputStream.readString(1138166333460L)));
                            break;
                        }
                        catch (Exception e) {
                            Slog.e(TAG, "error parsing locale list in configuration.", e);
                        }
                    }
                }
            }
        }
        finally {
            if (list.size() > 0) {
                this.setLocales(new LocaleList(list.toArray(new Locale[list.size()])));
            }
            protoInputStream.end(token);
        }
    }

    public void writeResConfigToProto(ProtoOutputStream protoOutputStream, long fieldId, DisplayMetrics metrics) {
        int height;
        int width;
        if (metrics.widthPixels >= metrics.heightPixels) {
            width = metrics.widthPixels;
            height = metrics.heightPixels;
        } else {
            width = metrics.heightPixels;
            height = metrics.widthPixels;
        }
        long token = protoOutputStream.start(fieldId);
        this.writeToProto(protoOutputStream, 0x10B00000001L);
        protoOutputStream.write(1155346202626L, _Original_Build.VERSION.RESOURCES_SDK_INT);
        protoOutputStream.write(1155346202627L, width);
        protoOutputStream.write(1155346202628L, height);
        protoOutputStream.end(token);
    }

    public static String uiModeToString(int uiMode) {
        switch (uiMode) {
            case 0: {
                return "UI_MODE_TYPE_UNDEFINED";
            }
            case 1: {
                return "UI_MODE_TYPE_NORMAL";
            }
            case 2: {
                return "UI_MODE_TYPE_DESK";
            }
            case 3: {
                return "UI_MODE_TYPE_CAR";
            }
            case 4: {
                return "UI_MODE_TYPE_TELEVISION";
            }
            case 5: {
                return "UI_MODE_TYPE_APPLIANCE";
            }
            case 6: {
                return "UI_MODE_TYPE_WATCH";
            }
            case 7: {
                return "UI_MODE_TYPE_VR_HEADSET";
            }
        }
        return Integer.toString(uiMode);
    }

    public void setToDefaults() {
        this.fontScale = 1.0f;
        this.mnc = 0;
        this.mcc = 0;
        this.mLocaleList = LocaleList.getEmptyLocaleList();
        this.locale = null;
        this.userSetLocale = false;
        this.touchscreen = 0;
        this.keyboard = 0;
        this.keyboardHidden = 0;
        this.hardKeyboardHidden = 0;
        this.navigation = 0;
        this.navigationHidden = 0;
        this.orientation = 0;
        this.screenLayout = 0;
        this.colorMode = 0;
        this.uiMode = 0;
        this.compatScreenWidthDp = 0;
        this.screenWidthDp = 0;
        this.compatScreenHeightDp = 0;
        this.screenHeightDp = 0;
        this.compatSmallestScreenWidthDp = 0;
        this.smallestScreenWidthDp = 0;
        this.densityDpi = 0;
        this.assetsSeq = 0;
        this.seq = 0;
        this.windowConfiguration.setToDefaults();
    }

    public void unset() {
        this.setToDefaults();
        this.fontScale = 0.0f;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void makeDefault() {
        this.setToDefaults();
    }

    public int updateFrom(Configuration delta) {
        int deltaScreenLayoutDir;
        int changed = 0;
        if (delta.fontScale > 0.0f && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
            this.fontScale = delta.fontScale;
        }
        if (delta.mcc != 0 && this.mcc != delta.mcc) {
            changed |= 1;
            this.mcc = delta.mcc;
        }
        if (delta.mnc != 0 && this.mnc != delta.mnc) {
            changed |= 2;
            this.mnc = delta.mnc;
        }
        this.fixUpLocaleList();
        delta.fixUpLocaleList();
        if (!delta.mLocaleList.isEmpty() && !this.mLocaleList.equals(delta.mLocaleList)) {
            changed |= 4;
            this.mLocaleList = delta.mLocaleList;
            if (!delta.locale.equals(this.locale)) {
                this.locale = (Locale)delta.locale.clone();
                changed |= 0x2000;
                this.setLayoutDirection(this.locale);
            }
        }
        if ((deltaScreenLayoutDir = delta.screenLayout & 0xC0) != 0 && deltaScreenLayoutDir != (this.screenLayout & 0xC0)) {
            this.screenLayout = this.screenLayout & 0xFFFFFF3F | deltaScreenLayoutDir;
            changed |= 0x2000;
        }
        if (delta.userSetLocale && (!this.userSetLocale || (changed & 4) != 0)) {
            changed |= 4;
            this.userSetLocale = true;
        }
        if (delta.touchscreen != 0 && this.touchscreen != delta.touchscreen) {
            changed |= 8;
            this.touchscreen = delta.touchscreen;
        }
        if (delta.keyboard != 0 && this.keyboard != delta.keyboard) {
            changed |= 0x10;
            this.keyboard = delta.keyboard;
        }
        if (delta.keyboardHidden != 0 && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
            this.keyboardHidden = delta.keyboardHidden;
        }
        if (delta.hardKeyboardHidden != 0 && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
            this.hardKeyboardHidden = delta.hardKeyboardHidden;
        }
        if (delta.navigation != 0 && this.navigation != delta.navigation) {
            changed |= 0x40;
            this.navigation = delta.navigation;
        }
        if (delta.navigationHidden != 0 && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
            this.navigationHidden = delta.navigationHidden;
        }
        if (delta.orientation != 0 && this.orientation != delta.orientation) {
            changed |= 0x80;
            this.orientation = delta.orientation;
        }
        if ((delta.screenLayout & 0xF) != 0 && (delta.screenLayout & 0xF) != (this.screenLayout & 0xF)) {
            changed |= 0x100;
            this.screenLayout = this.screenLayout & 0xFFFFFFF0 | delta.screenLayout & 0xF;
        }
        if ((delta.screenLayout & 0x30) != 0 && (delta.screenLayout & 0x30) != (this.screenLayout & 0x30)) {
            changed |= 0x100;
            this.screenLayout = this.screenLayout & 0xFFFFFFCF | delta.screenLayout & 0x30;
        }
        if ((delta.screenLayout & 0x300) != 0 && (delta.screenLayout & 0x300) != (this.screenLayout & 0x300)) {
            changed |= 0x100;
            this.screenLayout = this.screenLayout & 0xFFFFFCFF | delta.screenLayout & 0x300;
        }
        if ((delta.screenLayout & 0x10000000) != (this.screenLayout & 0x10000000) && delta.screenLayout != 0) {
            changed |= 0x100;
            this.screenLayout = this.screenLayout & 0xEFFFFFFF | delta.screenLayout & 0x10000000;
        }
        if ((delta.colorMode & 3) != 0 && (delta.colorMode & 3) != (this.colorMode & 3)) {
            changed |= 0x4000;
            this.colorMode = this.colorMode & 0xFFFFFFFC | delta.colorMode & 3;
        }
        if ((delta.colorMode & 0xC) != 0 && (delta.colorMode & 0xC) != (this.colorMode & 0xC)) {
            changed |= 0x4000;
            this.colorMode = this.colorMode & 0xFFFFFFF3 | delta.colorMode & 0xC;
        }
        if (delta.uiMode != 0 && this.uiMode != delta.uiMode) {
            changed |= 0x200;
            if ((delta.uiMode & 0xF) != 0) {
                this.uiMode = this.uiMode & 0xFFFFFFF0 | delta.uiMode & 0xF;
            }
            if ((delta.uiMode & 0x30) != 0) {
                this.uiMode = this.uiMode & 0xFFFFFFCF | delta.uiMode & 0x30;
            }
        }
        if (delta.screenWidthDp != 0 && this.screenWidthDp != delta.screenWidthDp) {
            changed |= 0x400;
            this.screenWidthDp = delta.screenWidthDp;
        }
        if (delta.screenHeightDp != 0 && this.screenHeightDp != delta.screenHeightDp) {
            changed |= 0x400;
            this.screenHeightDp = delta.screenHeightDp;
        }
        if (delta.smallestScreenWidthDp != 0 && this.smallestScreenWidthDp != delta.smallestScreenWidthDp) {
            changed |= 0x800;
            this.smallestScreenWidthDp = delta.smallestScreenWidthDp;
        }
        if (delta.densityDpi != 0 && this.densityDpi != delta.densityDpi) {
            changed |= 0x1000;
            this.densityDpi = delta.densityDpi;
        }
        if (delta.compatScreenWidthDp != 0) {
            this.compatScreenWidthDp = delta.compatScreenWidthDp;
        }
        if (delta.compatScreenHeightDp != 0) {
            this.compatScreenHeightDp = delta.compatScreenHeightDp;
        }
        if (delta.compatSmallestScreenWidthDp != 0) {
            this.compatSmallestScreenWidthDp = delta.compatSmallestScreenWidthDp;
        }
        if (delta.assetsSeq != 0 && delta.assetsSeq != this.assetsSeq) {
            changed |= Integer.MIN_VALUE;
            this.assetsSeq = delta.assetsSeq;
        }
        if (delta.seq != 0) {
            this.seq = delta.seq;
        }
        if (this.windowConfiguration.updateFrom(delta.windowConfiguration) != 0) {
            changed |= 0x20000000;
        }
        return changed;
    }

    public int diff(Configuration delta) {
        return this.diff(delta, false, false);
    }

    public int diffPublicOnly(Configuration delta) {
        return this.diff(delta, false, true);
    }

    public int diff(Configuration delta, boolean compareUndefined, boolean publicOnly) {
        int changed = 0;
        if ((compareUndefined || delta.fontScale > 0.0f) && this.fontScale != delta.fontScale) {
            changed |= 0x40000000;
        }
        if ((compareUndefined || delta.mcc != 0) && this.mcc != delta.mcc) {
            changed |= 1;
        }
        if ((compareUndefined || delta.mnc != 0) && this.mnc != delta.mnc) {
            changed |= 2;
        }
        this.fixUpLocaleList();
        delta.fixUpLocaleList();
        if (!(!compareUndefined && delta.mLocaleList.isEmpty() || this.mLocaleList.equals(delta.mLocaleList))) {
            changed |= 4;
            changed |= 0x2000;
        }
        int deltaScreenLayoutDir = delta.screenLayout & 0xC0;
        if ((compareUndefined || deltaScreenLayoutDir != 0) && deltaScreenLayoutDir != (this.screenLayout & 0xC0)) {
            changed |= 0x2000;
        }
        if ((compareUndefined || delta.touchscreen != 0) && this.touchscreen != delta.touchscreen) {
            changed |= 8;
        }
        if ((compareUndefined || delta.keyboard != 0) && this.keyboard != delta.keyboard) {
            changed |= 0x10;
        }
        if ((compareUndefined || delta.keyboardHidden != 0) && this.keyboardHidden != delta.keyboardHidden) {
            changed |= 0x20;
        }
        if ((compareUndefined || delta.hardKeyboardHidden != 0) && this.hardKeyboardHidden != delta.hardKeyboardHidden) {
            changed |= 0x20;
        }
        if ((compareUndefined || delta.navigation != 0) && this.navigation != delta.navigation) {
            changed |= 0x40;
        }
        if ((compareUndefined || delta.navigationHidden != 0) && this.navigationHidden != delta.navigationHidden) {
            changed |= 0x20;
        }
        if ((compareUndefined || delta.orientation != 0) && this.orientation != delta.orientation) {
            changed |= 0x80;
        }
        if ((compareUndefined || Configuration.getScreenLayoutNoDirection(delta.screenLayout) != 0) && Configuration.getScreenLayoutNoDirection(this.screenLayout) != Configuration.getScreenLayoutNoDirection(delta.screenLayout)) {
            changed |= 0x100;
        }
        if ((compareUndefined || (delta.colorMode & 0xC) != 0) && (this.colorMode & 0xC) != (delta.colorMode & 0xC)) {
            changed |= 0x4000;
        }
        if ((compareUndefined || (delta.colorMode & 3) != 0) && (this.colorMode & 3) != (delta.colorMode & 3)) {
            changed |= 0x4000;
        }
        if ((compareUndefined || delta.uiMode != 0) && this.uiMode != delta.uiMode) {
            changed |= 0x200;
        }
        if ((compareUndefined || delta.screenWidthDp != 0) && this.screenWidthDp != delta.screenWidthDp) {
            changed |= 0x400;
        }
        if ((compareUndefined || delta.screenHeightDp != 0) && this.screenHeightDp != delta.screenHeightDp) {
            changed |= 0x400;
        }
        if ((compareUndefined || delta.smallestScreenWidthDp != 0) && this.smallestScreenWidthDp != delta.smallestScreenWidthDp) {
            changed |= 0x800;
        }
        if ((compareUndefined || delta.densityDpi != 0) && this.densityDpi != delta.densityDpi) {
            changed |= 0x1000;
        }
        if ((compareUndefined || delta.assetsSeq != 0) && this.assetsSeq != delta.assetsSeq) {
            changed |= Integer.MIN_VALUE;
        }
        if (!publicOnly && this.windowConfiguration.diff(delta.windowConfiguration, compareUndefined) != 0L) {
            changed |= 0x20000000;
        }
        return changed;
    }

    public static boolean needNewResources(int configChanges, int interestingChanges) {
        return (configChanges & (interestingChanges = interestingChanges | Integer.MIN_VALUE | 0x40000000)) != 0;
    }

    public boolean isOtherSeqNewer(Configuration other) {
        if (other == null) {
            return false;
        }
        if (other.seq == 0) {
            return true;
        }
        if (this.seq == 0) {
            return true;
        }
        int diff = other.seq - this.seq;
        if (diff > 65536) {
            return false;
        }
        return diff > 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.fontScale);
        dest.writeInt(this.mcc);
        dest.writeInt(this.mnc);
        this.fixUpLocaleList();
        dest.writeParcelable(this.mLocaleList, flags);
        if (this.userSetLocale) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.touchscreen);
        dest.writeInt(this.keyboard);
        dest.writeInt(this.keyboardHidden);
        dest.writeInt(this.hardKeyboardHidden);
        dest.writeInt(this.navigation);
        dest.writeInt(this.navigationHidden);
        dest.writeInt(this.orientation);
        dest.writeInt(this.screenLayout);
        dest.writeInt(this.colorMode);
        dest.writeInt(this.uiMode);
        dest.writeInt(this.screenWidthDp);
        dest.writeInt(this.screenHeightDp);
        dest.writeInt(this.smallestScreenWidthDp);
        dest.writeInt(this.densityDpi);
        dest.writeInt(this.compatScreenWidthDp);
        dest.writeInt(this.compatScreenHeightDp);
        dest.writeInt(this.compatSmallestScreenWidthDp);
        dest.writeValue(this.windowConfiguration);
        dest.writeInt(this.assetsSeq);
        dest.writeInt(this.seq);
    }

    public void readFromParcel(Parcel source) {
        this.fontScale = source.readFloat();
        this.mcc = source.readInt();
        this.mnc = source.readInt();
        this.mLocaleList = (LocaleList)source.readParcelable(LocaleList.class.getClassLoader());
        this.locale = this.mLocaleList.get(0);
        this.userSetLocale = source.readInt() == 1;
        this.touchscreen = source.readInt();
        this.keyboard = source.readInt();
        this.keyboardHidden = source.readInt();
        this.hardKeyboardHidden = source.readInt();
        this.navigation = source.readInt();
        this.navigationHidden = source.readInt();
        this.orientation = source.readInt();
        this.screenLayout = source.readInt();
        this.colorMode = source.readInt();
        this.uiMode = source.readInt();
        this.screenWidthDp = source.readInt();
        this.screenHeightDp = source.readInt();
        this.smallestScreenWidthDp = source.readInt();
        this.densityDpi = source.readInt();
        this.compatScreenWidthDp = source.readInt();
        this.compatScreenHeightDp = source.readInt();
        this.compatSmallestScreenWidthDp = source.readInt();
        this.windowConfiguration.setTo((WindowConfiguration)source.readValue(null));
        this.assetsSeq = source.readInt();
        this.seq = source.readInt();
    }

    private Configuration(Parcel source) {
        this.readFromParcel(source);
    }

    @Override
    public int compareTo(Configuration that) {
        float a = this.fontScale;
        float b = that.fontScale;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        int n = this.mcc - that.mcc;
        if (n != 0) {
            return n;
        }
        n = this.mnc - that.mnc;
        if (n != 0) {
            return n;
        }
        this.fixUpLocaleList();
        that.fixUpLocaleList();
        if (this.mLocaleList.isEmpty()) {
            if (!that.mLocaleList.isEmpty()) {
                return 1;
            }
        } else {
            if (that.mLocaleList.isEmpty()) {
                return -1;
            }
            int minSize = Math.min(this.mLocaleList.size(), that.mLocaleList.size());
            for (int i = 0; i < minSize; ++i) {
                Locale thisLocale = this.mLocaleList.get(i);
                Locale thatLocale = that.mLocaleList.get(i);
                n = thisLocale.getLanguage().compareTo(thatLocale.getLanguage());
                if (n != 0) {
                    return n;
                }
                n = thisLocale.getCountry().compareTo(thatLocale.getCountry());
                if (n != 0) {
                    return n;
                }
                n = thisLocale.getVariant().compareTo(thatLocale.getVariant());
                if (n != 0) {
                    return n;
                }
                n = thisLocale.toLanguageTag().compareTo(thatLocale.toLanguageTag());
                if (n == 0) continue;
                return n;
            }
            n = this.mLocaleList.size() - that.mLocaleList.size();
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.touchscreen - that.touchscreen) != 0) {
            return n;
        }
        n = this.keyboard - that.keyboard;
        if (n != 0) {
            return n;
        }
        n = this.keyboardHidden - that.keyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.hardKeyboardHidden - that.hardKeyboardHidden;
        if (n != 0) {
            return n;
        }
        n = this.navigation - that.navigation;
        if (n != 0) {
            return n;
        }
        n = this.navigationHidden - that.navigationHidden;
        if (n != 0) {
            return n;
        }
        n = this.orientation - that.orientation;
        if (n != 0) {
            return n;
        }
        n = this.colorMode - that.colorMode;
        if (n != 0) {
            return n;
        }
        n = this.screenLayout - that.screenLayout;
        if (n != 0) {
            return n;
        }
        n = this.uiMode - that.uiMode;
        if (n != 0) {
            return n;
        }
        n = this.screenWidthDp - that.screenWidthDp;
        if (n != 0) {
            return n;
        }
        n = this.screenHeightDp - that.screenHeightDp;
        if (n != 0) {
            return n;
        }
        n = this.smallestScreenWidthDp - that.smallestScreenWidthDp;
        if (n != 0) {
            return n;
        }
        n = this.densityDpi - that.densityDpi;
        if (n != 0) {
            return n;
        }
        n = this.assetsSeq - that.assetsSeq;
        if (n != 0) {
            return n;
        }
        n = this.windowConfiguration.compareTo(that.windowConfiguration);
        if (n != 0) {
            return n;
        }
        return n;
    }

    public boolean equals(Configuration that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        return this.compareTo(that) == 0;
    }

    public boolean equals(Object that) {
        try {
            return this.equals((Configuration)that);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Float.floatToIntBits(this.fontScale);
        result = 31 * result + this.mcc;
        result = 31 * result + this.mnc;
        result = 31 * result + this.mLocaleList.hashCode();
        result = 31 * result + this.touchscreen;
        result = 31 * result + this.keyboard;
        result = 31 * result + this.keyboardHidden;
        result = 31 * result + this.hardKeyboardHidden;
        result = 31 * result + this.navigation;
        result = 31 * result + this.navigationHidden;
        result = 31 * result + this.orientation;
        result = 31 * result + this.screenLayout;
        result = 31 * result + this.colorMode;
        result = 31 * result + this.uiMode;
        result = 31 * result + this.screenWidthDp;
        result = 31 * result + this.screenHeightDp;
        result = 31 * result + this.smallestScreenWidthDp;
        result = 31 * result + this.densityDpi;
        result = 31 * result + this.assetsSeq;
        return result;
    }

    public LocaleList getLocales() {
        this.fixUpLocaleList();
        return this.mLocaleList;
    }

    public void setLocales(LocaleList locales) {
        this.mLocaleList = locales == null ? LocaleList.getEmptyLocaleList() : locales;
        this.locale = this.mLocaleList.get(0);
        this.setLayoutDirection(this.locale);
    }

    public void setLocale(Locale loc) {
        this.setLocales(loc == null ? LocaleList.getEmptyLocaleList() : new LocaleList(loc));
    }

    public void clearLocales() {
        this.mLocaleList = LocaleList.getEmptyLocaleList();
        this.locale = null;
    }

    public int getLayoutDirection() {
        return (this.screenLayout & 0xC0) == 128 ? 1 : 0;
    }

    public void setLayoutDirection(Locale loc) {
        int layoutDirection = 1 + TextUtils.getLayoutDirectionFromLocale(loc);
        this.screenLayout = this.screenLayout & 0xFFFFFF3F | layoutDirection << 6;
    }

    private static int getScreenLayoutNoDirection(int screenLayout) {
        return screenLayout & 0xFFFFFF3F;
    }

    public boolean isScreenRound() {
        return (this.screenLayout & 0x300) == 512;
    }

    public boolean isScreenWideColorGamut() {
        return (this.colorMode & 3) == 2;
    }

    public boolean isScreenHdr() {
        return (this.colorMode & 0xC) == 8;
    }

    public static String localesToResourceQualifier(LocaleList locs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < locs.size(); ++i) {
            Locale loc = locs.get(i);
            int l = loc.getLanguage().length();
            if (l == 0) continue;
            int s = loc.getScript().length();
            int c = loc.getCountry().length();
            int v = loc.getVariant().length();
            if (sb.length() != 0) {
                sb.append(",");
            }
            if (l == 2 && s == 0 && (c == 0 || c == 2) && v == 0) {
                sb.append(loc.getLanguage());
                if (c != 2) continue;
                sb.append("-r").append(loc.getCountry());
                continue;
            }
            sb.append("b+");
            sb.append(loc.getLanguage());
            if (s != 0) {
                sb.append("+");
                sb.append(loc.getScript());
            }
            if (c != 0) {
                sb.append("+");
                sb.append(loc.getCountry());
            }
            if (v == 0) continue;
            sb.append("+");
            sb.append(loc.getVariant());
        }
        return sb.toString();
    }

    @UnsupportedAppUsage
    public static String resourceQualifierString(Configuration config) {
        return Configuration.resourceQualifierString(config, null);
    }

    public static String resourceQualifierString(Configuration config, DisplayMetrics metrics) {
        String resourceQualifier;
        ArrayList<String> parts = new ArrayList<String>();
        if (config.mcc != 0) {
            parts.add(XML_ATTR_MCC + config.mcc);
            if (config.mnc != 0) {
                parts.add(XML_ATTR_MNC + config.mnc);
            }
        }
        if (!config.mLocaleList.isEmpty() && !(resourceQualifier = Configuration.localesToResourceQualifier(config.mLocaleList)).isEmpty()) {
            parts.add(resourceQualifier);
        }
        switch (config.screenLayout & 0xC0) {
            case 64: {
                parts.add("ldltr");
                break;
            }
            case 128: {
                parts.add("ldrtl");
                break;
            }
        }
        if (config.smallestScreenWidthDp != 0) {
            parts.add(XML_ATTR_SMALLEST_WIDTH + config.smallestScreenWidthDp + "dp");
        }
        if (config.screenWidthDp != 0) {
            parts.add("w" + config.screenWidthDp + "dp");
        }
        if (config.screenHeightDp != 0) {
            parts.add("h" + config.screenHeightDp + "dp");
        }
        switch (config.screenLayout & 0xF) {
            case 1: {
                parts.add("small");
                break;
            }
            case 2: {
                parts.add("normal");
                break;
            }
            case 3: {
                parts.add("large");
                break;
            }
            case 4: {
                parts.add("xlarge");
                break;
            }
        }
        switch (config.screenLayout & 0x30) {
            case 32: {
                parts.add("long");
                break;
            }
            case 16: {
                parts.add("notlong");
                break;
            }
        }
        switch (config.screenLayout & 0x300) {
            case 512: {
                parts.add("round");
                break;
            }
            case 256: {
                parts.add("notround");
                break;
            }
        }
        switch (config.colorMode & 3) {
            case 2: {
                parts.add("widecg");
                break;
            }
            case 1: {
                parts.add("nowidecg");
                break;
            }
        }
        switch (config.colorMode & 0xC) {
            case 8: {
                parts.add("highdr");
                break;
            }
            case 4: {
                parts.add("lowdr");
                break;
            }
        }
        switch (config.orientation) {
            case 2: {
                parts.add("land");
                break;
            }
            case 1: {
                parts.add("port");
                break;
            }
        }
        switch (config.uiMode & 0xF) {
            case 5: {
                parts.add("appliance");
                break;
            }
            case 2: {
                parts.add("desk");
                break;
            }
            case 4: {
                parts.add("television");
                break;
            }
            case 3: {
                parts.add("car");
                break;
            }
            case 6: {
                parts.add("watch");
                break;
            }
            case 7: {
                parts.add("vrheadset");
                break;
            }
        }
        switch (config.uiMode & 0x30) {
            case 32: {
                parts.add("night");
                break;
            }
            case 16: {
                parts.add("notnight");
                break;
            }
        }
        switch (config.densityDpi) {
            case 0: {
                break;
            }
            case 120: {
                parts.add("ldpi");
                break;
            }
            case 160: {
                parts.add("mdpi");
                break;
            }
            case 213: {
                parts.add("tvdpi");
                break;
            }
            case 240: {
                parts.add("hdpi");
                break;
            }
            case 320: {
                parts.add("xhdpi");
                break;
            }
            case 480: {
                parts.add("xxhdpi");
                break;
            }
            case 640: {
                parts.add("xxxhdpi");
                break;
            }
            case 65534: {
                parts.add("anydpi");
                break;
            }
            case 65535: {
                parts.add("nodpi");
                break;
            }
            default: {
                parts.add(config.densityDpi + "dpi");
            }
        }
        switch (config.touchscreen) {
            case 1: {
                parts.add("notouch");
                break;
            }
            case 3: {
                parts.add("finger");
                break;
            }
        }
        switch (config.keyboardHidden) {
            case 1: {
                parts.add("keysexposed");
                break;
            }
            case 2: {
                parts.add("keyshidden");
                break;
            }
            case 3: {
                parts.add("keyssoft");
                break;
            }
        }
        switch (config.keyboard) {
            case 1: {
                parts.add("nokeys");
                break;
            }
            case 2: {
                parts.add("qwerty");
                break;
            }
            case 3: {
                parts.add("12key");
                break;
            }
        }
        switch (config.navigationHidden) {
            case 1: {
                parts.add("navexposed");
                break;
            }
            case 2: {
                parts.add("navhidden");
                break;
            }
        }
        switch (config.navigation) {
            case 1: {
                parts.add("nonav");
                break;
            }
            case 2: {
                parts.add("dpad");
                break;
            }
            case 3: {
                parts.add("trackball");
                break;
            }
            case 4: {
                parts.add("wheel");
                break;
            }
        }
        if (metrics != null) {
            int height;
            int width;
            if (metrics.widthPixels >= metrics.heightPixels) {
                width = metrics.widthPixels;
                height = metrics.heightPixels;
            } else {
                width = metrics.heightPixels;
                height = metrics.widthPixels;
            }
            parts.add(width + "x" + height);
        }
        parts.add("v" + _Original_Build.VERSION.RESOURCES_SDK_INT);
        return TextUtils.join((CharSequence)"-", parts);
    }

    @UnsupportedAppUsage
    public static Configuration generateDelta(Configuration base, Configuration change) {
        Configuration delta = new Configuration();
        if (base.fontScale != change.fontScale) {
            delta.fontScale = change.fontScale;
        }
        if (base.mcc != change.mcc) {
            delta.mcc = change.mcc;
        }
        if (base.mnc != change.mnc) {
            delta.mnc = change.mnc;
        }
        base.fixUpLocaleList();
        change.fixUpLocaleList();
        if (!base.mLocaleList.equals(change.mLocaleList)) {
            delta.mLocaleList = change.mLocaleList;
            delta.locale = change.locale;
        }
        if (base.touchscreen != change.touchscreen) {
            delta.touchscreen = change.touchscreen;
        }
        if (base.keyboard != change.keyboard) {
            delta.keyboard = change.keyboard;
        }
        if (base.keyboardHidden != change.keyboardHidden) {
            delta.keyboardHidden = change.keyboardHidden;
        }
        if (base.navigation != change.navigation) {
            delta.navigation = change.navigation;
        }
        if (base.navigationHidden != change.navigationHidden) {
            delta.navigationHidden = change.navigationHidden;
        }
        if (base.orientation != change.orientation) {
            delta.orientation = change.orientation;
        }
        if ((base.screenLayout & 0xF) != (change.screenLayout & 0xF)) {
            delta.screenLayout |= change.screenLayout & 0xF;
        }
        if ((base.screenLayout & 0xC0) != (change.screenLayout & 0xC0)) {
            delta.screenLayout |= change.screenLayout & 0xC0;
        }
        if ((base.screenLayout & 0x30) != (change.screenLayout & 0x30)) {
            delta.screenLayout |= change.screenLayout & 0x30;
        }
        if ((base.screenLayout & 0x300) != (change.screenLayout & 0x300)) {
            delta.screenLayout |= change.screenLayout & 0x300;
        }
        if ((base.colorMode & 3) != (change.colorMode & 3)) {
            delta.colorMode |= change.colorMode & 3;
        }
        if ((base.colorMode & 0xC) != (change.colorMode & 0xC)) {
            delta.colorMode |= change.colorMode & 0xC;
        }
        if ((base.uiMode & 0xF) != (change.uiMode & 0xF)) {
            delta.uiMode |= change.uiMode & 0xF;
        }
        if ((base.uiMode & 0x30) != (change.uiMode & 0x30)) {
            delta.uiMode |= change.uiMode & 0x30;
        }
        if (base.screenWidthDp != change.screenWidthDp) {
            delta.screenWidthDp = change.screenWidthDp;
        }
        if (base.screenHeightDp != change.screenHeightDp) {
            delta.screenHeightDp = change.screenHeightDp;
        }
        if (base.smallestScreenWidthDp != change.smallestScreenWidthDp) {
            delta.smallestScreenWidthDp = change.smallestScreenWidthDp;
        }
        if (base.densityDpi != change.densityDpi) {
            delta.densityDpi = change.densityDpi;
        }
        if (base.assetsSeq != change.assetsSeq) {
            delta.assetsSeq = change.assetsSeq;
        }
        if (!base.windowConfiguration.equals(change.windowConfiguration)) {
            delta.windowConfiguration.setTo(change.windowConfiguration);
        }
        return delta;
    }

    public static void readXmlAttrs(XmlPullParser parser, Configuration configOut) throws XmlPullParserException, IOException {
        configOut.fontScale = Float.intBitsToFloat(XmlUtils.readIntAttribute(parser, XML_ATTR_FONT_SCALE, 0));
        configOut.mcc = XmlUtils.readIntAttribute(parser, XML_ATTR_MCC, 0);
        configOut.mnc = XmlUtils.readIntAttribute(parser, XML_ATTR_MNC, 0);
        String localesStr = XmlUtils.readStringAttribute(parser, XML_ATTR_LOCALES);
        configOut.mLocaleList = LocaleList.forLanguageTags(localesStr);
        configOut.locale = configOut.mLocaleList.get(0);
        configOut.touchscreen = XmlUtils.readIntAttribute(parser, XML_ATTR_TOUCHSCREEN, 0);
        configOut.keyboard = XmlUtils.readIntAttribute(parser, XML_ATTR_KEYBOARD, 0);
        configOut.keyboardHidden = XmlUtils.readIntAttribute(parser, XML_ATTR_KEYBOARD_HIDDEN, 0);
        configOut.hardKeyboardHidden = XmlUtils.readIntAttribute(parser, XML_ATTR_HARD_KEYBOARD_HIDDEN, 0);
        configOut.navigation = XmlUtils.readIntAttribute(parser, XML_ATTR_NAVIGATION, 0);
        configOut.navigationHidden = XmlUtils.readIntAttribute(parser, XML_ATTR_NAVIGATION_HIDDEN, 0);
        configOut.orientation = XmlUtils.readIntAttribute(parser, XML_ATTR_ORIENTATION, 0);
        configOut.screenLayout = XmlUtils.readIntAttribute(parser, XML_ATTR_SCREEN_LAYOUT, 0);
        configOut.colorMode = XmlUtils.readIntAttribute(parser, XML_ATTR_COLOR_MODE, 0);
        configOut.uiMode = XmlUtils.readIntAttribute(parser, XML_ATTR_UI_MODE, 0);
        configOut.screenWidthDp = XmlUtils.readIntAttribute(parser, XML_ATTR_SCREEN_WIDTH, 0);
        configOut.screenHeightDp = XmlUtils.readIntAttribute(parser, XML_ATTR_SCREEN_HEIGHT, 0);
        configOut.smallestScreenWidthDp = XmlUtils.readIntAttribute(parser, XML_ATTR_SMALLEST_WIDTH, 0);
        configOut.densityDpi = XmlUtils.readIntAttribute(parser, XML_ATTR_DENSITY, 0);
    }

    public static void writeXmlAttrs(XmlSerializer xml2, Configuration config) throws IOException {
        XmlUtils.writeIntAttribute(xml2, XML_ATTR_FONT_SCALE, Float.floatToIntBits(config.fontScale));
        if (config.mcc != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_MCC, config.mcc);
        }
        if (config.mnc != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_MNC, config.mnc);
        }
        config.fixUpLocaleList();
        if (!config.mLocaleList.isEmpty()) {
            XmlUtils.writeStringAttribute(xml2, XML_ATTR_LOCALES, config.mLocaleList.toLanguageTags());
        }
        if (config.touchscreen != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_TOUCHSCREEN, config.touchscreen);
        }
        if (config.keyboard != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_KEYBOARD, config.keyboard);
        }
        if (config.keyboardHidden != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_KEYBOARD_HIDDEN, config.keyboardHidden);
        }
        if (config.hardKeyboardHidden != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_HARD_KEYBOARD_HIDDEN, config.hardKeyboardHidden);
        }
        if (config.navigation != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_NAVIGATION, config.navigation);
        }
        if (config.navigationHidden != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_NAVIGATION_HIDDEN, config.navigationHidden);
        }
        if (config.orientation != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_ORIENTATION, config.orientation);
        }
        if (config.screenLayout != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_SCREEN_LAYOUT, config.screenLayout);
        }
        if (config.colorMode != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_COLOR_MODE, config.colorMode);
        }
        if (config.uiMode != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_UI_MODE, config.uiMode);
        }
        if (config.screenWidthDp != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_SCREEN_WIDTH, config.screenWidthDp);
        }
        if (config.screenHeightDp != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_SCREEN_HEIGHT, config.screenHeightDp);
        }
        if (config.smallestScreenWidthDp != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_SMALLEST_WIDTH, config.smallestScreenWidthDp);
        }
        if (config.densityDpi != 0) {
            XmlUtils.writeIntAttribute(xml2, XML_ATTR_DENSITY, config.densityDpi);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NativeConfig {
    }
}

