/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.UnsupportedAppUsage;
import android.content.pm.ActivityInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager_Delegate;
import android.content.res.Configuration;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import libcore.io.IoUtils;

public class AssetManager
implements AutoCloseable {
    private static final String TAG = "AssetManager";
    private static final boolean DEBUG_REFS = false;
    private static final boolean FEATURE_FLAG_IDMAP2 = true;
    private static final String FRAMEWORK_APK_PATH = "/system/framework/framework-res.apk";
    private static final Object sSync = new Object();
    private static final ApkAssets[] sEmptyApkAssets = new ApkAssets[0];
    @UnsupportedAppUsage
    @GuardedBy(value={"sSync"})
    static AssetManager sSystem = null;
    @GuardedBy(value={"sSync"})
    private static ApkAssets[] sSystemApkAssets = new ApkAssets[0];
    @GuardedBy(value={"sSync"})
    private static ArraySet<ApkAssets> sSystemApkAssetsSet;
    public static final int ACCESS_UNKNOWN = 0;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_BUFFER = 3;
    @GuardedBy(value={"this"})
    private final TypedValue mValue = new TypedValue();
    @GuardedBy(value={"this"})
    private final long[] mOffsets = new long[2];
    @UnsupportedAppUsage
    @GuardedBy(value={"this"})
    private long mObject;
    @GuardedBy(value={"this"})
    private ApkAssets[] mApkAssets;
    @GuardedBy(value={"this"})
    private boolean mOpen = true;
    @GuardedBy(value={"this"})
    private int mNumRefs = 1;
    @GuardedBy(value={"this"})
    private HashMap<Long, RuntimeException> mRefStacks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public AssetManager() {
        ApkAssets[] assets;
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked();
            assets = sSystemApkAssets;
        }
        this.mObject = AssetManager.nativeCreate();
        this.setApkAssets(assets, false);
    }

    private AssetManager(boolean sentinel) {
        this.mObject = AssetManager.nativeCreate();
    }

    @GuardedBy(value={"sSync"})
    private static void createSystemAssetsInZygoteLocked() {
        if (sSystem != null) {
            return;
        }
        try {
            ArrayList<ApkAssets> apkAssets = new ArrayList<ApkAssets>();
            apkAssets.add(ApkAssets.loadFromPath(FRAMEWORK_APK_PATH, true));
            String[] systemIdmapPaths = AssetManager.nativeCreateIdmapsForStaticOverlaysTargetingAndroid();
            if (systemIdmapPaths != null) {
                for (String idmapPath : systemIdmapPaths) {
                    apkAssets.add(ApkAssets.loadOverlayFromPath(idmapPath, true));
                }
            } else {
                Log.w(TAG, "'idmap2 --scan' failed: no static=\"true\" overlays targeting \"android\" will be loaded");
            }
            sSystemApkAssetsSet = new ArraySet(apkAssets);
            sSystemApkAssets = apkAssets.toArray(new ApkAssets[apkAssets.size()]);
            sSystem = new AssetManager(true);
            sSystem.setApkAssets(sSystemApkAssets, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create system AssetManager", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadStaticRuntimeOverlays(ArrayList<ApkAssets> outApkAssets) throws IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream("/data/resource-cache/overlays.list");
        }
        catch (FileNotFoundException e) {
            Log.i(TAG, "no overlays.list file found");
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));
             FileLock flock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);){
            String line;
            while ((line = br.readLine()) != null) {
                String idmapPath = line.split(" ")[1];
                outApkAssets.add(ApkAssets.loadOverlayFromPath(idmapPath, true));
            }
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static AssetManager getSystem() {
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked();
            return sSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return;
            }
            this.mOpen = false;
            this.decRefsLocked(this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApkAssets(ApkAssets[] apkAssets, boolean invalidateCaches) {
        Preconditions.checkNotNull(apkAssets, "apkAssets");
        ApkAssets[] newApkAssets = new ApkAssets[sSystemApkAssets.length + apkAssets.length];
        System.arraycopy(sSystemApkAssets, 0, newApkAssets, 0, sSystemApkAssets.length);
        int newLength = sSystemApkAssets.length;
        for (ApkAssets apkAsset : apkAssets) {
            if (sSystemApkAssetsSet.contains(apkAsset)) continue;
            newApkAssets[newLength++] = apkAsset;
        }
        if (newLength != newApkAssets.length) {
            newApkAssets = Arrays.copyOf(newApkAssets, newLength);
        }
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            this.mApkAssets = newApkAssets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, invalidateCaches);
            if (invalidateCaches) {
                this.invalidateCachesLocked(-1);
            }
        }
    }

    private void invalidateCachesLocked(int diff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public ApkAssets[] getApkAssets() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                return this.mApkAssets;
            }
        }
        return sEmptyApkAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getApkPaths() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                String[] paths = new String[this.mApkAssets.length];
                int count = this.mApkAssets.length;
                for (int i = 0; i < count; ++i) {
                    paths[i] = this.mApkAssets[i].getAssetPath();
                }
                return paths;
            }
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findCookieForPath(String path) {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!path.equals(this.mApkAssets[i].getAssetPath())) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addAssetPath(String path) {
        return this.addAssetPathInternal(path, false, false);
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addAssetPathAsSharedLibrary(String path) {
        return this.addAssetPathInternal(path, false, true);
    }

    @Deprecated
    @UnsupportedAppUsage
    public int addOverlayPath(String path) {
        return this.addAssetPathInternal(path, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addAssetPathInternal(String path, boolean overlay, boolean appAsLib) {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            ApkAssets assets;
            this.ensureOpenLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!this.mApkAssets[i].getAssetPath().equals(path)) continue;
                return i + 1;
            }
            try {
                if (overlay) {
                    String idmapPath = "/data/resource-cache/" + path.substring(1).replace('/', '@') + "@idmap";
                    assets = ApkAssets.loadOverlayFromPath(idmapPath, false);
                } else {
                    assets = ApkAssets.loadFromPath(path, false, appAsLib);
                }
            }
            catch (IOException e) {
                return 0;
            }
            this.mApkAssets = Arrays.copyOf(this.mApkAssets, count + 1);
            this.mApkAssets[count] = assets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, true);
            this.invalidateCachesLocked(-1);
            return count + 1;
        }
    }

    @GuardedBy(value={"this"})
    private void ensureValidLocked() {
        if (this.mObject == 0L) {
            throw new RuntimeException("AssetManager has been destroyed");
        }
    }

    @GuardedBy(value={"this"})
    private void ensureOpenLocked() {
        if (!this.mOpen) {
            throw new RuntimeException("AssetManager has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean getResourceValue(int resId, int densityDpi, TypedValue outValue, boolean resolveRefs) {
        Preconditions.checkNotNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeGetResourceValue(this.mObject, resId, (short)densityDpi, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                outValue.string = this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    CharSequence getResourceText(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue outValue = this.mValue;
            if (this.getResourceValue(resId, 0, outValue, true)) {
                return outValue.coerceToString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    CharSequence getResourceBagText(int resId, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            TypedValue outValue = this.mValue;
            int cookie = AssetManager.nativeGetResourceBagValue(this.mObject, resId, bagEntryId, outValue);
            if (cookie <= 0) {
                return null;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                return this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return outValue.coerceToString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResourceArraySize(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArraySize(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getResourceArray(int resId, int[] outData) {
        Preconditions.checkNotNull(outData, "outData");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArray(this.mObject, resId, outData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getResourceStringArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceStringArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence[] getResourceTextArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int[] rawInfoArray = AssetManager.nativeGetResourceStringArrayInfo(this.mObject, resId);
            if (rawInfoArray == null) {
                return null;
            }
            int rawInfoArrayLen = rawInfoArray.length;
            int infoArrayLen = rawInfoArrayLen / 2;
            CharSequence[] retArray = new CharSequence[infoArrayLen];
            int i = 0;
            int j = 0;
            while (i < rawInfoArrayLen) {
                int cookie = rawInfoArray[i];
                int index = rawInfoArray[i + 1];
                retArray[j] = index >= 0 && cookie > 0 ? this.mApkAssets[cookie - 1].getStringFromPool(index) : null;
                i += 2;
                ++j;
            }
            return retArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getResourceIntArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIntArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getStyleAttributes(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetStyleAttributes(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getThemeValue(long theme, int resId, TypedValue outValue, boolean resolveRefs) {
        Preconditions.checkNotNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeThemeGetAttributeValue(this.mObject, theme, resId, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                outValue.string = this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpTheme(long theme, int priority, String tag, String prefix) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeDump(this.mObject, theme, priority, tag, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourceName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourcePackageName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourcePackageName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourceTypeName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceTypeName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    String getResourceEntryName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceEntryName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    int getResourceIdentifier(String name, String defType, String defPackage) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIdentifier(this.mObject, name, defType, defPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceResolutionLoggingEnabled(boolean enabled) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetResourceResolutionLoggingEnabled(this.mObject, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastResourceResolution() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLastResourceResolution(this.mObject);
        }
    }

    CharSequence getPooledStringForCookie(int cookie, int id2) {
        return this.getApkAssets()[cookie - 1].getStringFromPool(id2);
    }

    public InputStream open_Original(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    @LayoutlibDelegate
    public InputStream open(String string2) throws IOException {
        return AssetManager_Delegate.open(this, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream open_Original(String fileName, int accessMode) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenAsset(this.mObject, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(asset);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    @LayoutlibDelegate
    public InputStream open(String string2, int n) throws IOException {
        return AssetManager_Delegate.open(this, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openFd(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenAssetFd(this.mObject, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list(String path) throws IOException {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeList(this.mObject, path);
        }
    }

    @UnsupportedAppUsage
    public InputStream openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    @UnsupportedAppUsage
    public InputStream openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    @UnsupportedAppUsage
    public InputStream openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenNonAsset(this.mObject, cookie, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(asset);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    public AssetFileDescriptor openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenNonAssetFd(this.mObject, cookie, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    public XmlResourceParser openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    public XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        try (XmlBlock block = this.openXmlBlockAsset(cookie, fileName);){
            XmlResourceParser parser = block.newParser();
            if (parser == null) {
                throw new AssertionError((Object)"block.newParser() returned a null parser");
            }
            XmlResourceParser xmlResourceParser = parser;
            return xmlResourceParser;
        }
    }

    XmlBlock openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlBlock openXmlBlockAsset(int cookie, String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long xmlBlock = AssetManager.nativeOpenXmlAsset(this.mObject, cookie, fileName);
            if (xmlBlock == 0L) {
                throw new FileNotFoundException("Asset XML file: " + fileName);
            }
            XmlBlock block = new XmlBlock(this, xmlBlock);
            this.incRefsLocked(block.hashCode());
            return block;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void applyStyle(long themePtr, int defStyleAttr, int defStyleRes, XmlBlock.Parser parser, int[] inAttrs, long outValuesAddress, long outIndicesAddress) {
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeApplyStyle(this.mObject, themePtr, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, inAttrs, outValuesAddress, outIndicesAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getAttributeResolutionStack(long themePtr, int defStyleAttr, int defStyleRes, int xmlStyle) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            return AssetManager.nativeAttributeResolutionStack(this.mObject, themePtr, xmlStyle, defStyleAttr, defStyleRes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean resolveAttrs(long themePtr, int defStyleAttr, int defStyleRes, int[] inValues, int[] inAttrs, int[] outValues, int[] outIndices) {
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        Preconditions.checkNotNull(outValues, "outValues");
        Preconditions.checkNotNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeResolveAttrs(this.mObject, themePtr, defStyleAttr, defStyleRes, inValues, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    boolean retrieveAttributes(XmlBlock.Parser parser, int[] inAttrs, int[] outValues, int[] outIndices) {
        Preconditions.checkNotNull(parser, "parser");
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        Preconditions.checkNotNull(outValues, "outValues");
        Preconditions.checkNotNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeRetrieveAttributes(this.mObject, parser.mParseState, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    long createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            long themePtr = AssetManager.nativeThemeCreate(this.mObject);
            this.incRefsLocked(themePtr);
            return themePtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseTheme(long themePtr) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            AssetManager.nativeThemeDestroy(themePtr);
            this.decRefsLocked(themePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyStyleToTheme(long themePtr, int resId, boolean force) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeApplyStyle(this.mObject, themePtr, resId, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void setThemeTo(long dstThemePtr, AssetManager srcAssetManager, long srcThemePtr) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager assetManager2 = srcAssetManager;
            synchronized (assetManager2) {
                srcAssetManager.ensureValidLocked();
                AssetManager.nativeThemeCopy(this.mObject, dstThemePtr, srcAssetManager.mObject, srcThemePtr);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mObject != 0L) {
            AssetManager.nativeDestroy(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean isUpToDate() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return false;
            }
            for (ApkAssets apkAssets : this.mApkAssets) {
                if (apkAssets.isUpToDate()) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNonSystemLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration[] getSizeConfigurations() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetSizeConfigurations(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int majorVersion) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetConfiguration(this.mObject, mcc, mnc, locale, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, colorMode, majorVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public SparseArray<String> getAssignedPackageIdentifiers_Original() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetAssignedPackageIdentifiers(this.mObject);
        }
    }

    @LayoutlibDelegate
    public SparseArray<String> getAssignedPackageIdentifiers() {
        return AssetManager_Delegate.getAssignedPackageIdentifiers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"this"})
    public Map<String, String> getOverlayableMap(String packageName) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetOverlayableMap(this.mObject, packageName);
        }
    }

    @GuardedBy(value={"this"})
    private void incRefsLocked(long id2) {
        ++this.mNumRefs;
    }

    @GuardedBy(value={"this"})
    private void decRefsLocked(long id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0 && this.mObject != 0L) {
            AssetManager.nativeDestroy(this.mObject);
            this.mObject = 0L;
            this.mApkAssets = sEmptyApkAssets;
        }
    }

    @LayoutlibDelegate
    private static long nativeCreate() {
        return AssetManager_Delegate.nativeCreate();
    }

    @LayoutlibDelegate
    private static void nativeDestroy(long l) {
        AssetManager_Delegate.nativeDestroy(l);
    }

    private static void nativeSetApkAssets(long l, ApkAssets[] apkAssetsArray, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetApkAssets(J[Landroid/content/res/ApkAssets;Z)V", true, null);
    }

    private static void nativeSetConfiguration(long l, int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetConfiguration(JIILjava/lang/String;IIIIIIIIIIIIIII)V", true, null);
    }

    private static SparseArray<String> nativeGetAssignedPackageIdentifiers(long l) {
        return (SparseArray)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetAssignedPackageIdentifiers(J)Landroid/util/SparseArray;", true, null);
    }

    private static String[] nativeList(long l, String string2) throws IOException {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeList(JLjava/lang/String;)[Ljava/lang/String;", true, null);
    }

    private static long nativeOpenAsset(long l, String string2, int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenAsset(JLjava/lang/String;I)J", true, null);
    }

    private static ParcelFileDescriptor nativeOpenAssetFd(long l, String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#nativeOpenAssetFd(JLjava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, null);
    }

    private static long nativeOpenNonAsset(long l, int n, String string2, int n2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenNonAsset(JILjava/lang/String;I)J", true, null);
    }

    private static ParcelFileDescriptor nativeOpenNonAssetFd(long l, int n, String string2, long[] lArray) throws IOException {
        return (ParcelFileDescriptor)OverrideMethod.invokeA("android.content.res.AssetManager#nativeOpenNonAssetFd(JILjava/lang/String;[J)Landroid/os/ParcelFileDescriptor;", true, null);
    }

    private static long nativeOpenXmlAsset(long l, int n, String string2) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeOpenXmlAsset(JILjava/lang/String;)J", true, null);
    }

    private static int nativeGetResourceValue(long l, int n, short s, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceValue(JISLandroid/util/TypedValue;Z)I", true, null);
    }

    private static int nativeGetResourceBagValue(long l, int n, int n2, TypedValue typedValue) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceBagValue(JIILandroid/util/TypedValue;)I", true, null);
    }

    private static int[] nativeGetStyleAttributes(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetStyleAttributes(JI)[I", true, null);
    }

    private static String[] nativeGetResourceStringArray(long l, int n) {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceStringArray(JI)[Ljava/lang/String;", true, null);
    }

    private static int[] nativeGetResourceStringArrayInfo(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceStringArrayInfo(JI)[I", true, null);
    }

    private static int[] nativeGetResourceIntArray(long l, int n) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceIntArray(JI)[I", true, null);
    }

    private static int nativeGetResourceArraySize(long l, int n) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceArraySize(JI)I", true, null);
    }

    private static int nativeGetResourceArray(long l, int n, int[] nArray) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceArray(JI[I)I", true, null);
    }

    private static int nativeGetResourceIdentifier(long l, String string2, String string3, String string4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeGetResourceIdentifier(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)I", true, null);
    }

    private static String nativeGetResourceName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceName(JI)Ljava/lang/String;", true, null);
    }

    private static String nativeGetResourcePackageName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourcePackageName(JI)Ljava/lang/String;", true, null);
    }

    private static String nativeGetResourceTypeName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceTypeName(JI)Ljava/lang/String;", true, null);
    }

    private static String nativeGetResourceEntryName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetResourceEntryName(JI)Ljava/lang/String;", true, null);
    }

    private static String[] nativeGetLocales(long l, boolean bl) {
        return (String[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetLocales(JZ)[Ljava/lang/String;", true, null);
    }

    private static Configuration[] nativeGetSizeConfigurations(long l) {
        return (Configuration[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetSizeConfigurations(J)[Landroid/content/res/Configuration;", true, null);
    }

    private static void nativeSetResourceResolutionLoggingEnabled(long l, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeSetResourceResolutionLoggingEnabled(JZ)V", true, null);
    }

    private static String nativeGetLastResourceResolution(long l) {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetLastResourceResolution(J)Ljava/lang/String;", true, null);
    }

    private static int[] nativeAttributeResolutionStack(long l, long l2, int n, int n2, int n3) {
        return (int[])OverrideMethod.invokeA("android.content.res.AssetManager#nativeAttributeResolutionStack(JJIII)[I", true, null);
    }

    private static void nativeApplyStyle(long l, long l2, int n, int n2, long l3, int[] nArray, long l4, long l5) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeApplyStyle(JJIIJ[IJJ)V", true, null);
    }

    private static boolean nativeResolveAttrs(long l, long l2, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeResolveAttrs(JJII[I[I[I[I)Z", true, null) != 0;
    }

    private static boolean nativeRetrieveAttributes(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeRetrieveAttributes(JJ[I[I[I)Z", true, null) != 0;
    }

    @LayoutlibDelegate
    private static long nativeThemeCreate(long l) {
        return AssetManager_Delegate.nativeThemeCreate(l);
    }

    @LayoutlibDelegate
    private static void nativeThemeDestroy(long l) {
        AssetManager_Delegate.nativeThemeDestroy(l);
    }

    private static void nativeThemeApplyStyle(long l, long l2, int n, boolean bl) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeApplyStyle(JJIZ)V", true, null);
    }

    private static void nativeThemeCopy(long l, long l2, long l3, long l4) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeCopy(JJJJ)V", true, null);
    }

    static void nativeThemeClear(long l) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeClear(J)V", true, null);
    }

    private static int nativeThemeGetAttributeValue(long l, long l2, int n, TypedValue typedValue, boolean bl) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeThemeGetAttributeValue(JJILandroid/util/TypedValue;Z)I", true, null);
    }

    private static void nativeThemeDump(long l, long l2, int n, String string2, String string3) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeThemeDump(JJILjava/lang/String;Ljava/lang/String;)V", true, null);
    }

    static int nativeThemeGetChangingConfigurations(long l) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeThemeGetChangingConfigurations(J)I", true, null);
    }

    private static void nativeAssetDestroy(long l) {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeAssetDestroy(J)V", true, null);
    }

    private static int nativeAssetReadChar(long l) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeAssetReadChar(J)I", true, null);
    }

    private static int nativeAssetRead(long l, byte[] byArray, int n, int n2) {
        return OverrideMethod.invokeI("android.content.res.AssetManager#nativeAssetRead(J[BII)I", true, null);
    }

    private static long nativeAssetSeek(long l, long l2, int n) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeAssetSeek(JJI)J", true, null);
    }

    private static long nativeAssetGetLength(long l) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeAssetGetLength(J)J", true, null);
    }

    private static long nativeAssetGetRemainingLength(long l) {
        return OverrideMethod.invokeL("android.content.res.AssetManager#nativeAssetGetRemainingLength(J)J", true, null);
    }

    private static void nativeVerifySystemIdmaps() {
        OverrideMethod.invokeV("android.content.res.AssetManager#nativeVerifySystemIdmaps()V", true, null);
    }

    @LayoutlibDelegate
    private static String[] nativeCreateIdmapsForStaticOverlaysTargetingAndroid() {
        return AssetManager_Delegate.nativeCreateIdmapsForStaticOverlaysTargetingAndroid();
    }

    private static Map nativeGetOverlayableMap(long l, String string2) {
        return (Map)OverrideMethod.invokeA("android.content.res.AssetManager#nativeGetOverlayableMap(JLjava/lang/String;)Ljava/util/Map;", true, null);
    }

    @UnsupportedAppUsage
    public static int getGlobalAssetCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetCount()I", true, null);
    }

    public static String getAssetAllocations() {
        return (String)OverrideMethod.invokeA("android.content.res.AssetManager#getAssetAllocations()Ljava/lang/String;", true, null);
    }

    @UnsupportedAppUsage
    public static int getGlobalAssetManagerCount() {
        return OverrideMethod.invokeI("android.content.res.AssetManager#getGlobalAssetManagerCount()I", true, null);
    }

    static /* synthetic */ ApkAssets[] access$102(AssetManager x0, ApkAssets[] x1) {
        x0.mApkAssets = x1;
        return x1;
    }

    public class AssetInputStream
    extends InputStream {
        private long mAssetNativePtr;
        private long mLength;
        private long mMarkPos;

        @UnsupportedAppUsage
        public int getAssetInt() {
            throw new UnsupportedOperationException();
        }

        @UnsupportedAppUsage
        public long getNativeAsset() {
            return this.mAssetNativePtr;
        }

        private AssetInputStream(long assetNativePtr) {
            this.mAssetNativePtr = assetNativePtr;
            this.mLength = AssetManager.nativeAssetGetLength(assetNativePtr);
        }

        @Override
        public int read() throws IOException {
            this.ensureOpen();
            return AssetManager.nativeAssetReadChar(this.mAssetNativePtr);
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.ensureOpen();
            Preconditions.checkNotNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            Preconditions.checkNotNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.ensureOpen();
            long pos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.nativeAssetSeek(this.mAssetNativePtr, n, 0);
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            this.ensureOpen();
            long len = AssetManager.nativeAssetGetRemainingLength(this.mAssetNativePtr);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readlimit) {
            this.ensureOpen();
            this.mMarkPos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
        }

        @Override
        public void reset() throws IOException {
            this.ensureOpen();
            AssetManager.nativeAssetSeek(this.mAssetNativePtr, this.mMarkPos, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.mAssetNativePtr != 0L) {
                AssetManager.nativeAssetDestroy(this.mAssetNativePtr);
                this.mAssetNativePtr = 0L;
                AssetManager assetManager = AssetManager.this;
                synchronized (assetManager) {
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        private void ensureOpen() {
            if (this.mAssetNativePtr == 0L) {
                throw new IllegalStateException("AssetInputStream is closed");
            }
        }
    }

    public static class Builder {
        private ArrayList<ApkAssets> mUserApkAssets = new ArrayList();

        public Builder addApkAssets(ApkAssets apkAssets) {
            this.mUserApkAssets.add(apkAssets);
            return this;
        }

        public AssetManager build() {
            ApkAssets[] systemApkAssets = AssetManager.getSystem().getApkAssets();
            int totalApkAssetCount = systemApkAssets.length + this.mUserApkAssets.size();
            ApkAssets[] apkAssets = new ApkAssets[totalApkAssetCount];
            System.arraycopy(systemApkAssets, 0, apkAssets, 0, systemApkAssets.length);
            int userApkAssetCount = this.mUserApkAssets.size();
            for (int i = 0; i < userApkAssetCount; ++i) {
                apkAssets[i + systemApkAssets.length] = this.mUserApkAssets.get(i);
            }
            AssetManager assetManager = new AssetManager(false);
            AssetManager.access$102(assetManager, apkAssets);
            AssetManager.nativeSetApkAssets(assetManager.mObject, apkAssets, false);
            return assetManager;
        }
    }
}

